/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance(GotoFileItemProvider.class);
    public static final int EXACT_MATCH_DEGREE = 5000;
    private static final int DIRECTORY_MATCH_DEGREE = 0;
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project2, @Nullable PsiElement context2, @NotNull GotoFileModel model2) {
        if (project2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(1);
        }
        super(context2);
        this.myProject = project2;
        this.myModel = model2;
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(2);
        }
        if (parameters2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(4);
        }
        if (consumer2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(5);
        }
        return ProgressManager.getInstance().computePrioritized(() -> this.doFilterElements(base, parameters2, indicator, consumer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterElements(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(9);
        }
        long start = System.currentTimeMillis();
        try {
            String pattern = parameters2.getCompletePattern();
            PsiFileSystemItem absolute = this.getFileByAbsolutePath(pattern);
            if (absolute != null && !consumer2.process(new FoundItemDescriptor<PsiFileSystemItem>(absolute, 5000))) {
                boolean bl = true;
                return bl;
            }
            if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
                parameters2 = parameters2.withCompletePattern(pattern.substring(1));
            }
            if (!this.processItemsForPattern(base, parameters2, consumer2, indicator)) {
                boolean bl = false;
                return bl;
            }
            String fixedPattern = FixingLayoutMatcher.fixLayout((String)pattern);
            boolean bl = fixedPattern == null || this.processItemsForPattern(base, parameters2.withCompletePattern(fixedPattern), consumer2, indicator);
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Goto File \"" + parameters2.getCompletePattern() + "\" took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2, @NotNull ProgressIndicator indicator) {
        int index2;
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(10);
        }
        if (parameters2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(11);
        }
        if (consumer2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(13);
        }
        String sanitized = GotoFileItemProvider.getSanitizedPattern(parameters2.getCompletePattern(), this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.processNames(parameters2, name -> grouper.processName((String)name));
        Ref<Boolean> hasSuggestions = Ref.create(false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index2))) {
            index2 = grouper.index;
            SuffixMatches group2 = grouper.nextGroup(base);
            if (group2 == null) break;
            if (group2.processFiles(parameters2.withLocalPattern(dirMatcher.dirPattern), consumer2, hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    private void processNames(@NotNull FindSymbolParameters parameters2, @NotNull Processor<? super String> nameProcessor) {
        if (parameters2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(14);
        }
        if (nameProcessor == null) {
            GotoFileItemProvider.$$$reportNull$$$0(15);
        }
        List<ChooseByNameContributor> contributors = DumbService.getDumbAwareExtensions(this.myProject, ChooseByNameContributor.FILE_EP_NAME);
        for (ChooseByNameContributor contributor : contributors) {
            if (contributor instanceof DefaultFileNavigationContributor) {
                FilenameIndex.processAllFileNames(nameProcessor, (GlobalSearchScope)parameters2.getSearchScope(), (IdFilter)parameters2.getIdFilter());
                continue;
            }
            this.myModel.processContributorNames(contributor, parameters2, nameProcessor);
        }
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, @NotNull GotoFileModel model2) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(16);
        }
        if (model2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(17);
        }
        return GotoFileItemProvider.removeSlashes(StringUtil.replace(ChooseByNamePopup.getTransformedPattern(pattern, model2), "\\", "/"));
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(18);
        }
        pattern = "*" + StringUtil.replace(StringUtil.replace((String)pattern, "\\", "*\\*"), "/", "*/*");
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
        if (minusculeMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(19);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String removeSlashes(@NotNull String s) {
        if (s == null) {
            GotoFileItemProvider.$$$reportNull$$$0(20);
        }
        String string2 = UriUtil.trimLeadingSlashes((String)UriUtil.trimTrailingSlashes((String)s));
        if (string2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(22);
        }
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index2;
            String path2 = FileUtil.toSystemIndependentName(ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path2);
            if (vFile != null && ((index2 = ProjectFileIndex.getInstance(this.myProject)).isInContent(vFile) || index2.isInLibrary(vFile))) {
                return PsiUtilCore.findFileSystemItem(this.myProject, vFile);
            }
        }
        return null;
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> matchQualifiers(@NotNull MinusculeMatcher qualifierMatcher, JBIterable<? extends FoundItemDescriptor<PsiFileSystemItem>> iterable, @NotNull String completePattern) {
        if (qualifierMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(23);
        }
        if (completePattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(24);
        }
        ArrayList<FoundItemDescriptor<PsiFileSystemItem>> matching2 = new ArrayList<FoundItemDescriptor<PsiFileSystemItem>>();
        for (FoundItemDescriptor foundItemDescriptor : iterable) {
            PsiFileSystemItem item = (PsiFileSystemItem)foundItemDescriptor.getItem();
            ProgressManager.checkCanceled();
            String qualifier = Objects.requireNonNull(this.getParentPath(item));
            FList fragments = qualifierMatcher.matchingFragments(qualifier);
            if (fragments != null) {
                int gapPenalty = fragments.isEmpty() ? 0 : qualifier.length() - ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset();
                int exactMatchScore = this.isExactMatch(item, completePattern) ? 5000 : 0;
                int qualifierDegree = qualifierMatcher.matchingDegree(qualifier, false, fragments) - gapPenalty + exactMatchScore;
                matching2.add(new FoundItemDescriptor<PsiFileSystemItem>(item, qualifierDegree));
                continue;
            }
            if (!this.isExactMatch(item, completePattern)) continue;
            matching2.add(new FoundItemDescriptor<PsiFileSystemItem>(item, 5000));
        }
        if (matching2.size() > 1) {
            Comparator<FoundItemDescriptor> comparator = Comparator.comparing(res -> res.getWeight()).reversed();
            matching2.sort(comparator);
        }
        ArrayList<FoundItemDescriptor<PsiFileSystemItem>> arrayList = matching2;
        if (arrayList == null) {
            GotoFileItemProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private boolean isExactMatch(@NotNull PsiFileSystemItem item, @NotNull String completePattern) {
        String fullName;
        if (item == null) {
            GotoFileItemProvider.$$$reportNull$$$0(26);
        }
        if (completePattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(27);
        }
        return (fullName = this.myModel.getFullName(item)) != null && this.isSubpath(fullName, completePattern);
    }

    private boolean isSubpath(@NotNull String path2, String subpath) {
        if (path2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(28);
        }
        subpath = ChooseByNamePopup.getTransformedPattern(subpath, this.myModel).stripTrailing();
        path2 = FileUtilRt.toSystemIndependentName(path2);
        subpath = FileUtilRt.toSystemIndependentName(subpath);
        return path2.endsWith(subpath);
    }

    @Nullable
    private String getParentPath(@NotNull PsiFileSystemItem item) {
        String fullName;
        if (item == null) {
            GotoFileItemProvider.$$$reportNull$$$0(29);
        }
        return (fullName = this.myModel.getFullName(item)) == null ? null : StringUtil.getPackageName(FileUtilRt.toSystemIndependentName(fullName), '/') + "/";
    }

    @NotNull
    private static JBIterable<FoundItemDescriptor<PsiFileSystemItem>> moveDirectoriesToEnd(@NotNull Iterable<? extends FoundItemDescriptor<PsiFileSystemItem>> iterable) {
        if (iterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(30);
        }
        ArrayList dirs = new ArrayList();
        JBIterable jBIterable = JBIterable.from(iterable).filter(res -> {
            if (res.getItem() instanceof PsiDirectory) {
                dirs.add(new FoundItemDescriptor<PsiFileSystemItem>((PsiFileSystemItem)res.getItem(), 0));
                return false;
            }
            return true;
        }).append((FoundItemDescriptor)((Object)dirs));
        if (jBIterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> getItemsForNames(@NotNull GlobalSearchScope scope, @NotNull List<? extends MatchResult> matchResults, @NotNull Function<? super String, Object[]> indexResult) {
        if (scope == null) {
            GotoFileItemProvider.$$$reportNull$$$0(32);
        }
        if (matchResults == null) {
            GotoFileItemProvider.$$$reportNull$$$0(33);
        }
        if (indexResult == null) {
            GotoFileItemProvider.$$$reportNull$$$0(34);
        }
        ArrayList<Object> group2 = new ArrayList<Object>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> matchDegrees = new HashMap<PsiFileSystemItem, Integer>();
        for (MatchResult matchResult : matchResults) {
            Object[] items2 = indexResult.apply(matchResult.elementName);
            ProgressManager.checkCanceled();
            for (Object item2 : items2) {
                String qualifier;
                PsiFileSystemItem psiItem;
                if (!(item2 instanceof PsiFileSystemItem) || !scope.contains((psiItem = (PsiFileSystemItem)item2).getVirtualFile()) || (qualifier = this.getParentPath(psiItem)) == null) continue;
                group2.add(psiItem);
                nesting.put(psiItem, StringUtil.countChars(qualifier, '/'));
                matchDegrees.put(psiItem, matchResult.matchingDegree);
            }
        }
        if (group2.size() > 1) {
            group2.sort(this.getPathProximityComparator().thenComparing(nesting::get).thenComparing(this.myModel::getFullName));
        }
        List<FoundItemDescriptor<PsiFileSystemItem>> list2 = ContainerUtil.map(group2, item -> new FoundItemDescriptor<PsiFileSystemItem>((PsiFileSystemItem)item, (Integer)matchDegrees.get(item)));
        if (list2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(35);
        }
        return list2;
    }

    private static int findMatchStartingPosition(@NotNull String candidateName, char @NotNull [] name_pattern, char @NotNull [] NAME_PATTERN) {
        int pos;
        if (candidateName == null) {
            GotoFileItemProvider.$$$reportNull$$$0(36);
        }
        if (name_pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(37);
        }
        if (NAME_PATTERN == null) {
            GotoFileItemProvider.$$$reportNull$$$0(38);
        }
        int candidatePos = candidateName.length();
        for (pos = name_pattern.length; pos > 0; --pos) {
            char candidateC;
            char c2 = name_pattern[pos - 1];
            if (!Character.isLetterOrDigit(c2)) continue;
            char C = NAME_PATTERN[pos - 1];
            --candidatePos;
            while (candidatePos >= 0 && (candidateC = candidateName.charAt(candidatePos)) != c2 && candidateC != C) {
                --candidatePos;
            }
            if (candidatePos < 0) break;
        }
        return pos;
    }

    @NotNull
    private static <T> List<List<T>> group(@NotNull List<T> items2, @NotNull Comparator<? super T> comparator) {
        if (items2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(39);
        }
        if (comparator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(40);
        }
        List list2 = StreamEx.of(items2).groupRuns((n1, n2) -> comparator.compare(n1, n2) == 0).toList();
        if (list2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(41);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 21, 25, 31, 35, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProcessor";
                break;
            }
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 31: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierMatcher";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completePattern";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexResult";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name_pattern";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "NAME_PATTERN";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameMatcher";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSlashes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "matchQualifiers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDirectoriesToEnd";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForNames";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFilterElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processItemsForPattern";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSanitizedPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatcher";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 31: 
            case 35: 
            case 41: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeSlashes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFileByAbsolutePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifiers";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExactMatch";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSubpath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "moveDirectoriesToEnd";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getItemsForNames";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findMatchStartingPosition";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 19, 21, 25, 31, 35, 41 -> new IllegalStateException(string2);
        };
    }

    private class NameGrouper {
        private final String namePattern;
        private final char[] NAME_PATTERN;
        private final char[] name_pattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            if (namePattern == null) {
                NameGrouper.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                NameGrouper.$$$reportNull$$$0(1);
            }
            this.namePattern = namePattern;
            this.name_pattern = new char[namePattern.length()];
            this.NAME_PATTERN = new char[namePattern.length()];
            this.candidateNames = new ArrayList<List<String>>(namePattern.length());
            for (int i2 = 0; i2 < namePattern.length(); ++i2) {
                this.candidateNames.add(new ArrayList());
                char c2 = namePattern.charAt(i2);
                this.name_pattern[i2] = Character.toLowerCase(c2);
                this.NAME_PATTERN[i2] = Character.toUpperCase(c2);
            }
            this.indicator = indicator;
        }

        boolean processName(@NotNull String name) {
            if (name == null) {
                NameGrouper.$$$reportNull$$$0(2);
            }
            this.indicator.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name, this.name_pattern, this.NAME_PATTERN);
            if (position < this.namePattern.length()) {
                this.candidateNames.get(position).add(name);
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(@NotNull ChooseByNameViewModel base) {
            if (base == null) {
                NameGrouper.$$$reportNull$$$0(3);
            }
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches = new SuffixMatches(this.namePattern, this.index, this.indicator);
            for (String name : this.candidateNames.get(this.index)) {
                if (matches.matchName(base, name) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namePattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$NameGrouper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames;
        final ProgressIndicator indicator;

        SuffixMatches(String pattern, @NotNull int from, ProgressIndicator indicator) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                SuffixMatches.$$$reportNull$$$0(1);
            }
            this.matchingNames = new ArrayList<MatchResult>();
            this.patternSuffix = pattern.substring(from);
            boolean preferStartMatches = from == 0 && !this.patternSuffix.startsWith("*");
            String matchPattern = (from > 0 ? " " : "*") + this.patternSuffix;
            NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)matchPattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
            if (preferStartMatches) {
                builder2.preferringStartMatches();
            }
            this.matcher = builder2.build();
            this.indicator = indicator;
        }

        @NonNls
        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + "', matchingNames=" + this.matchingNames + "}";
        }

        boolean matchName(@NotNull ChooseByNameViewModel base, String name) {
            MatchResult result2;
            if (base == null) {
                SuffixMatches.$$$reportNull$$$0(2);
            }
            if ((result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name)) != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull FindSymbolParameters parameters2, @NotNull Processor<? super FoundItemDescriptor<?>> processor, @NotNull Ref<Boolean> hasSuggestions, @NotNull DirectoryPathMatcher dirMatcher) {
            Set<String> existingNames;
            if (parameters2 == null) {
                SuffixMatches.$$$reportNull$$$0(3);
            }
            if (processor == null) {
                SuffixMatches.$$$reportNull$$$0(4);
            }
            if (hasSuggestions == null) {
                SuffixMatches.$$$reportNull$$$0(5);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(6);
            }
            List<MatchResult> matchingNames = this.matchingNames;
            if (this.patternSuffix.length() <= 3 && !dirMatcher.dirPattern.isEmpty() && (existingNames = dirMatcher.findFileNamesMatchingIfCheap(this.patternSuffix.charAt(0), this.matcher)) != null) {
                matchingNames = ContainerUtil.filter(matchingNames, mr -> existingNames.contains(mr.elementName));
            }
            MinusculeMatcher qualifierMatcher = GotoFileItemProvider.getQualifiedNameMatcher(parameters2.getLocalPatternName());
            final Comparator<MatchResult> byNameWithoutExtension = Comparator.comparing(mr -> StringUtil.toLowerCase(FileUtilRt.getNameWithoutExtension(mr.elementName)));
            Comparator<MatchResult> matchingDegreeComparator = this.matchingDegreeComparator();
            matchingNames = ContainerUtil.sorted(matchingNames, matchingDegreeComparator);
            Function<List<MatchResult>, List<MatchResult>> sortGroup = new Function<List<MatchResult>, List<MatchResult>>(){
                final Set<Object> sortedGroups = CollectionFactory.createCustomHashingStrategySet(HashingStrategy.identity());

                @Override
                public List<MatchResult> apply(List<MatchResult> results) {
                    if (this.sortedGroups.add(results)) {
                        results.sort(byNameWithoutExtension);
                    }
                    return results;
                }
            };
            GlobalSearchScope scope = dirMatcher.narrowDown(parameters2.getSearchScope());
            FindSymbolParameters parametersAdjusted = parameters2.withScope(scope);
            List<List<MatchResult>> groups2 = GotoFileItemProvider.group(matchingNames, matchingDegreeComparator);
            Function<String, Object[]> indexResult = key -> GotoFileItemProvider.this.myModel.getElementsByName((String)key, parametersAdjusted, this.indicator);
            for (List<MatchResult> group2 : groups2) {
                Processor<FoundItemDescriptor> trackingProcessor;
                JBIterable<Object> matchedFiles;
                List<List<MatchResult>> sortedNames = GotoFileItemProvider.group((List)sortGroup.apply(group2), byNameWithoutExtension);
                JBIterable filesMatchingPath = JBIterable.from(sortedNames).flatMap(nameGroup -> GotoFileItemProvider.this.getItemsForNames(scope, (List<? extends MatchResult>)nameGroup, (Function<? super String, Object[]>)indexResult));
                Iterable<Object> iterable = matchedFiles = parameters2.getLocalPatternName().isEmpty() ? filesMatchingPath : GotoFileItemProvider.this.matchQualifiers(qualifierMatcher, filesMatchingPath, parameters2.getCompletePattern());
                if (ContainerUtil.process(matchedFiles = GotoFileItemProvider.moveDirectoriesToEnd(matchedFiles), trackingProcessor = res -> {
                    hasSuggestions.set(true);
                    return processor.process((FoundItemDescriptor<?>)res);
                })) continue;
                return false;
            }
            return hasSuggestions.get() != false || parameters2.isSearchInLibraries() || !this.hasSuggestionsOutsideProject(parameters2.getCompletePattern(), matchingNames, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, @NotNull List<? extends MatchResult> group2, @NotNull DirectoryPathMatcher dirMatcher) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(7);
            }
            if (group2 == null) {
                SuffixMatches.$$$reportNull$$$0(8);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(9);
            }
            FindSymbolParameters parameters2 = FindSymbolParameters.wrap(pattern, GotoFileItemProvider.this.myProject, true);
            GlobalSearchScope scope = dirMatcher.narrowDown(parameters2.getSearchScope());
            FindSymbolParameters adjusted = parameters2.withScope(scope);
            for (MatchResult matchResult : group2) {
                for (Object o : GotoFileItemProvider.this.myModel.getElementsByName(matchResult.elementName, adjusted, this.indicator)) {
                    PsiFileSystemItem psiItem;
                    String qualifier;
                    ProgressManager.checkCanceled();
                    if (!(o instanceof PsiFileSystemItem) || (qualifier = GotoFileItemProvider.this.getParentPath(psiItem = (PsiFileSystemItem)o)) == null) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private Comparator<MatchResult> matchingDegreeComparator() {
            Comparator comparator = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith(mr1.elementName, this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith(mr2.elementName, this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2);
            };
            if (comparator == null) {
                SuffixMatches.$$$reportNull$$$0(10);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasSuggestions";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirMatcher";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matchingDegreeComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "matchName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processFiles";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSuggestionsOutsideProject";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 10 -> new IllegalStateException(string2);
            };
        }
    }
}

