/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteReferenceProvider
implements PasteProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PasteReferenceProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void performPaste(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            PasteReferenceProvider.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (project2 == null || editor2 == null) {
            return;
        }
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext2);
        if (fqn == null) {
            return;
        }
        QualifiedNameProvider theProvider = null;
        PsiElement element = null;
        for (QualifiedNameProvider provider2 : QualifiedNameProvider.EP_NAME.getExtensionList()) {
            element = provider2.qualifiedNameToElement(fqn, project2);
            if (element == null) continue;
            theProvider = provider2;
            break;
        }
        if (theProvider != null) {
            PasteReferenceProvider.insert(fqn, element, editor2, theProvider);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            PasteReferenceProvider.$$$reportNull$$$0(2);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        return project2 != null && editor2 != null && PasteReferenceProvider.getCopiedFqn(dataContext2) != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            PasteReferenceProvider.$$$reportNull$$$0(3);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext2);
        return project2 != null && fqn != null && QualifiedNameProviderUtil.qualifiedNameToElement((String)fqn, (Project)project2) != null;
    }

    private static void insert(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor2, @NotNull QualifiedNameProvider provider2) {
        Project project2;
        if (fqn == null) {
            PasteReferenceProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PasteReferenceProvider.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            PasteReferenceProvider.$$$reportNull$$$0(6);
        }
        if (provider2 == null) {
            PasteReferenceProvider.$$$reportNull$$$0(7);
        }
        if ((project2 = editor2.getProject()) == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        documentManager.commitDocument(editor2.getDocument());
        PsiFile file2 = documentManager.getPsiFile(editor2.getDocument());
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = editor2.getDocument();
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            documentManager.commitDocument(document);
            EditorModificationUtil.deleteSelectedText((Editor)editor2);
            provider2.insertQualifiedName(fqn, element, editor2, project2);
        }), IdeBundle.message((String)"command.pasting.reference", (Object[])new Object[0]), null);
    }

    @Nullable
    private static String getCopiedFqn(DataContext context2) {
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(context2);
        if (producer != null) {
            Transferable transferable = (Transferable)producer.produce();
            if (transferable != null) {
                try {
                    return (String)transferable.getTransferData(CopyReferenceAction.ourFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return (String)CopyPasteManager.getInstance().getContents(CopyReferenceAction.ourFlavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/PasteReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/PasteReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

