/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/PowerSaveModeNotifier;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.lang.impl"})
public final class PowerSaveModeNotifier
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String IGNORE_POWER_SAVE_MODE = "ignore.power.save.mode";

    @Override
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        if (PowerSaveMode.isEnabled()) {
            Companion.notifyOnPowerSaveMode(project2);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/PowerSaveModeNotifier$Companion;", "", "()V", "IGNORE_POWER_SAVE_MODE", "", "notifyOnPowerSaveMode", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void notifyOnPowerSaveMode(@Nullable Project project2) {
            if (PropertiesComponent.getInstance().getBoolean(PowerSaveModeNotifier.IGNORE_POWER_SAVE_MODE)) {
                return;
            }
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Power Save Mode");
            String string2 = IdeBundle.message((String)"power.save.mode.on.notification.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"power.save.mode.on.notification.title\")");
            String string3 = IdeBundle.message((String)"power.save.mode.on.notification.content", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"power.save.mode.on.notification.content\")");
            Notification notification = notificationGroup.createNotification(string2, string3, NotificationType.WARNING);
            String string4 = IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0]);
            notification.addAction((AnAction)new NotificationAction(string4){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    PropertiesComponent.getInstance().setValue("ignore.power.save.mode", true);
                    notification.expire();
                }
            });
            string4 = IdeBundle.message((String)"power.save.mode.disable.action.title", (Object[])new Object[0]);
            notification.addAction((AnAction)new NotificationAction(string4){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    PowerSaveMode.setEnabled(false);
                    notification.expire();
                }
            });
            notification.notify(project2);
            Balloon balloon = notification.getBalloon();
            if (balloon == null) {
                return;
            }
            Balloon balloon2 = balloon;
            Disposable disposable = project2;
            if (disposable == null || (disposable = disposable.getMessageBus()) == null) {
                disposable = ApplicationManager.getApplication().getMessageBus();
            }
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"project?.messageBus ?: A\u2026tApplication().messageBus");
            Disposable bus = disposable;
            MessageBusConnection connection = bus.connect();
            Disposer.register((Disposable)balloon2, connection);
            Topic<PowerSaveMode.Listener> topic = PowerSaveMode.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            connection.subscribe(topic, () -> ((Notification)notification).expire());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

