/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    private EditorColorsScheme scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();

    public SearchEverywherePsiRenderer(Disposable parent2) {
        this.setLayout(new SELayout());
        ApplicationManager.getApplication().getMessageBus().connect(parent2).subscribe(LafManagerListener.TOPIC, __ -> {
            this.scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        });
    }

    @Override
    @NotNull
    protected SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes schemeAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)this.scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES));
        return new SimpleTextAttributes(schemeAttributes.getBgColor(), NamedColorUtil.getInactiveTextColor(), schemeAttributes.getWaveColor(), schemeAttributes.getStyle() | 0x2000);
    }

    @Override
    protected ColoredListCellRenderer<Object> createLeftRenderer(JList list2, Object value) {
        ColoredListCellRenderer<Object> renderer = super.createLeftRenderer(list2, value);
        renderer.setIpad(new Insets(0, 0, 0, renderer.getIpad().right));
        return renderer;
    }

    @Override
    public String getElementText(PsiElement element) {
        String name;
        VirtualFile file2;
        VirtualFile virtualFile2 = element instanceof PsiFile ? PsiUtilCore.getVirtualFile(element) : (file2 = element instanceof VirtualFile ? (VirtualFile)((Object)element) : null);
        if (file2 != null) {
            return VfsPresentationUtil.getPresentableNameForUI((Project)element.getProject(), (VirtualFile)file2);
        }
        if (element instanceof NavigationItem && (name = (String)Optional.ofNullable(((NavigationItem)((Object)element)).getPresentation()).map(presentation2 -> presentation2.getPresentableText()).orElse(null)) != null) {
            return name;
        }
        name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        return StringUtil.notNullize(name, "<unnamed>");
    }

    @Override
    @Nullable
    protected String getContainerText(PsiElement element, String name) {
        return this.getContainerTextForLeftComponent(element, name, -1, (FontMetrics)null);
    }

    @Override
    @Nullable
    protected String getContainerTextForLeftComponent(PsiElement element, String name, int maxWidth, FontMetrics fm) {
        boolean in;
        String presentablePath = SearchEverywherePsiRenderer.extractPresentablePath(element);
        String text2 = ObjectUtils.chooseNotNull(presentablePath, SymbolPresentationUtil.getSymbolContainerText(element));
        if (text2 == null || text2.equals(name)) {
            return null;
        }
        if (text2.startsWith("(") && text2.endsWith(")")) {
            text2 = text2.substring(1, text2.length() - 1);
        }
        if (presentablePath == null && (text2.contains("/") || text2.contains(File.separator)) && element instanceof PsiFileSystemItem) {
            Project project2 = element.getProject();
            String basePath = Optional.ofNullable(project2.getBasePath()).map(FileUtil::toSystemDependentName).orElse(null);
            VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
            if (file2 != null) {
                text2 = FileUtil.toSystemDependentName(text2);
                String filePath = FileUtil.toSystemDependentName(file2.getPath());
                if (basePath != null && FileUtil.isAncestor(basePath, filePath, true)) {
                    text2 = ObjectUtils.notNull(FileUtil.getRelativePath(basePath, text2, File.separatorChar), text2);
                } else {
                    String rootPath = Optional.ofNullable(GotoFileCellRenderer.getAnyRoot(file2, project2)).map(root -> FileUtil.toSystemDependentName(root.getPath())).filter(root -> basePath != null && FileUtil.isAncestor(basePath, root, true)).orElse(null);
                    String string2 = text2 = rootPath != null ? ObjectUtils.notNull(FileUtil.getRelativePath(rootPath, text2, File.separatorChar), text2) : FileUtil.getLocationRelativeToUserHome(text2);
                }
            }
        }
        if (in = text2.startsWith("in ")) {
            text2 = text2.substring(3);
        }
        String left = in ? "in " : "";
        String adjustedText = left + text2;
        if (maxWidth < 0) {
            return adjustedText;
        }
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text2.contains("/") ? "/" : (SystemInfo.isWindows && text2.contains("\\") ? "\\" : (text2.contains(".") ? "." : (text2.contains("-") ? "-" : " ")));
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split(text2, separator));
        while (parts.size() > 1) {
            int index2 = parts.size() / 2 - 1;
            parts.remove(index2);
            if (fm.stringWidth(left + StringUtil.join(parts, separator) + "...") >= maxWidth) continue;
            parts.add(index2, "...");
            return left + StringUtil.join(parts, separator);
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + 3);
        return StringUtil.trimMiddle(adjustedText, adjustedWidth);
    }

    @Nullable
    private static String extractPresentablePath(@Nullable PsiElement element) {
        VirtualFile virtualFile2;
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 != null && (virtualFile2 = file2.getVirtualFile()) instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)((Object)virtualFile2)).getPresentablePath();
        }
        return null;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index2, boolean selected, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer, list2, value, this.getNavigationItemAttributes(value));
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }

    public static class SELayout
    extends BorderLayout {
        @Override
        public void layoutContainer(Container target2) {
            super.layoutContainer(target2);
            Component right = this.getLayoutComponent("East");
            Component left = this.getLayoutComponent("West");
            if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                Rectangle bounds = right.getBounds();
                int newX = left.getBounds().x + left.getBounds().width;
                right.setBounds(newX, bounds.y, bounds.width - (newX - bounds.x), bounds.height);
            }
        }
    }
}

