/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/actions/SelectInTargetActionImpl;", "T", "Lcom/intellij/ide/SelectInTarget;", "", "target", "selectInContext", "Lcom/intellij/ide/SelectInContext;", "(Lcom/intellij/ide/SelectInTarget;Lcom/intellij/ide/SelectInContext;)V", "getSelectInContext", "()Lcom/intellij/ide/SelectInContext;", "getTarget", "()Lcom/intellij/ide/SelectInTarget;", "Lcom/intellij/ide/SelectInTarget;", "doPerform", "", "doUpdate", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getIcon", "Ljavax/swing/Icon;", "getText", "", "isSelectable", "", "intellij.platform.lang.impl"})
final class SelectInTargetActionImpl<T extends SelectInTarget> {
    @NotNull
    private final T target;
    @NotNull
    private final SelectInContext selectInContext;

    public SelectInTargetActionImpl(@NotNull T target2, @NotNull SelectInContext selectInContext) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)selectInContext, (String)"selectInContext");
        this.target = target2;
        this.selectInContext = selectInContext;
    }

    @NotNull
    public final T getTarget() {
        return this.target;
    }

    @NotNull
    public final SelectInContext getSelectInContext() {
        return this.selectInContext;
    }

    public final void doUpdate(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(this.getText());
        e.getPresentation().setIcon(this.getIcon());
        e.getPresentation().setEnabled(this.isSelectable());
    }

    public final void doPerform() {
        PsiDocumentManager.getInstance(this.selectInContext.getProject()).commitAllDocuments();
        this.target.selectIn(this.selectInContext, true);
    }

    @Nls
    private final String getText() {
        ToolWindow toolWindow;
        String id;
        String text2 = this.target.toString();
        String string2 = id = this.target.getMinorViewId() == null ? this.target.getToolWindowId() : null;
        if (id == null) {
            toolWindow = null;
        } else {
            Project project2 = this.selectInContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"selectInContext.project");
            toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow(id);
        }
        ToolWindow toolWindow2 = toolWindow;
        String toolWindowId = this.target.getToolWindowId();
        if (toolWindow2 != null && toolWindowId != null) {
            String string3 = toolWindow2.getStripeTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toolWindow.stripeTitle");
            text2 = StringsKt.replace$default((String)text2, (String)toolWindowId, (String)string3, (boolean)false, (int)4, null);
        }
        return text2;
    }

    private final Icon getIcon() {
        ToolWindow toolWindow;
        String id;
        Project project2 = this.selectInContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"selectInContext.project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        String string2 = id = this.target.getMinorViewId() == null ? this.target.getToolWindowId() : null;
        ToolWindow toolWindow2 = toolWindow = string2 == null ? null : toolWindowManager.getToolWindow(string2);
        return toolWindow2 != null ? toolWindow2.getIcon() : EmptyIcon.ICON_13;
    }

    private final boolean isSelectable() {
        return DumbService.isDumb(this.selectInContext.getProject()) && !DumbService.isDumbAware(this.target) ? false : this.target.canSelect(this.selectInContext);
    }
}

