/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SynchronizeCurrentFileAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && SynchronizeCurrentFileAction.supportedFiles(e).findAny().isPresent());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        List files2 = SynchronizeCurrentFileAction.supportedFiles(e).collect(Collectors.toList());
        SynchronizeCurrentFileAction.synchronizeFiles(files2, project2, true);
    }

    public static void synchronizeFiles(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project2, boolean async) {
        if (files2 == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(4);
        }
        if (files2.isEmpty()) {
            return;
        }
        for (VirtualFile virtualFile2 : files2) {
            VirtualFileSystem fs = virtualFile2.getFileSystem();
            if (fs instanceof ArchiveFileSystem) {
                ((ArchiveFileSystem)fs).clearArchiveCache(virtualFile2);
            }
            if (virtualFile2.isDirectory()) {
                virtualFile2.getChildren();
            }
            if (!(virtualFile2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)virtualFile2).markClean();
            ((NewVirtualFile)virtualFile2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(async, true, () -> SynchronizeCurrentFileAction.postRefresh(project2, files2), files2);
    }

    private static void postRefresh(Project project2, Collection<? extends VirtualFile> files2) {
        StatusBar statusBar;
        List<VirtualFile> localFiles = ContainerUtil.filter(files2, f -> f.isInLocalFileSystem());
        if (!localFiles.isEmpty()) {
            VcsFacade.getInstance().markFilesDirty(project2, localFiles);
        }
        if ((statusBar = WindowManager.getInstance().getStatusBar(project2)) != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[0]));
        }
    }

    private static Stream<VirtualFile> supportedFiles(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return files2 == null ? Stream.empty() : Stream.of(files2).filter(f -> f.isValid() && (f.getFileSystem() instanceof LocalFileSystem || f.getFileSystem() instanceof ArchiveFileSystem));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeFiles";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

