/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SpeedSearchComparator;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateKindCombo
extends ComboboxWithBrowseButton {
    public TemplateKindCombo() {
        this.getComboBox().setRenderer(SimpleListCellRenderer.create((label2, value, index2) -> {
            if (value != null) {
                label2.setText((String)value.first);
                label2.setIcon((Icon)value.second);
            }
        }));
        new ComboboxSpeedSearch(this.getComboBox()){

            protected String getElementText(Object element) {
                if (element instanceof Trinity) {
                    return (String)((Trinity)element).first;
                }
                return null;
            }
        }.setComparator(new SpeedSearchComparator(true));
        this.setButtonListener(null);
    }

    public void addItem(@NlsContexts.ListItem @NotNull String presentableName, @Nullable Icon icon2, @NotNull String templateName) {
        if (presentableName == null) {
            TemplateKindCombo.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            TemplateKindCombo.$$$reportNull$$$0(1);
        }
        this.getComboBox().addItem(new Trinity<String, Icon, String>(presentableName, icon2, templateName));
    }

    @NotNull
    @NlsSafe
    public String getSelectedName() {
        Trinity trinity = (Trinity)this.getComboBox().getSelectedItem();
        if (trinity == null) {
            return "yet_unknown";
        }
        String string2 = (String)trinity.third;
        if (string2 == null) {
            TemplateKindCombo.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void setSelectedName(@Nullable String name) {
        if (name == null) {
            return;
        }
        ComboBoxModel model2 = this.getComboBox().getModel();
        int n = model2.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            Trinity trinity = (Trinity)model2.getElementAt(i2);
            if (!name.equals(trinity.third)) continue;
            this.getComboBox().setSelectedItem(trinity);
            return;
        }
    }

    public void registerUpDownHint(JComponent component2) {
        DumbAwareAction.create(e -> {
            if (e.getInputEvent() instanceof KeyEvent) {
                int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                this.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0));
            }
        }).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), component2);
    }

    private void scrollBy(int delta) {
        int size = this.getComboBox().getModel().getSize();
        if (delta == 0 || size == 0) {
            return;
        }
        int next2 = this.getComboBox().getSelectedIndex() + delta;
        if (next2 < 0 || next2 >= size) {
            if (!UISettings.getInstance().getCycleScrolling()) {
                return;
            }
            next2 = (next2 + size) % size;
        }
        this.getComboBox().setSelectedIndex(next2);
    }

    public void setButtonListener(@Nullable ActionListener listener2) {
        this.getButton().setVisible(listener2 != null);
        if (listener2 != null) {
            this.addActionListener(listener2);
        }
    }

    public void clear() {
        this.getComboBox().removeAllItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/TemplateKindCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/TemplateKindCombo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

