/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.FileStructurePopupListener;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PlaceHolder;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewStructureAction
extends DumbAwareAction {
    public ViewStructureAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileStructurePopup popup2;
        Editor editor2;
        Project project2;
        if (e == null) {
            ViewStructureAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        VirtualFile virtualFile2 = fileEditor.getFile();
        Editor editor3 = editor2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 != null) {
            PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
        }
        if ((popup2 = ViewStructureAction.createPopup(project2, fileEditor)) == null) {
            return;
        }
        String title = virtualFile2 == null ? fileEditor.getName() : virtualFile2.getName();
        popup2.setTitle(title);
        popup2.show();
    }

    @Nullable
    public static FileStructurePopup createPopup(@NotNull Project project2, @NotNull FileEditor fileEditor) {
        StructureViewModel treeModel;
        StructureView structureView;
        if (project2 == null) {
            ViewStructureAction.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ViewStructureAction.$$$reportNull$$$0(2);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        StructureViewBuilder builder2 = fileEditor.getStructureViewBuilder();
        if (builder2 == null) {
            return null;
        }
        project2.getMessageBus().syncPublisher(FileStructurePopupListener.TOPIC).stateChanged(true);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            structureView = null;
            treeModel = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel((Editor)EditorUtil.getEditorEx((FileEditor)fileEditor));
        } else {
            structureView = builder2.createStructureView(fileEditor, project2);
            treeModel = ViewStructureAction.createStructureViewModel(project2, fileEditor, structureView);
        }
        if (treeModel instanceof PlaceHolder) {
            ((PlaceHolder)treeModel).setPlace("StructureViewPopup");
        }
        FileStructurePopup popup2 = new FileStructurePopup(project2, fileEditor, treeModel);
        if (structureView != null) {
            Disposer.register(popup2, (Disposable)structureView);
        }
        return popup2;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ViewStructureAction.$$$reportNull$$$0(3);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        Editor editor2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled = fileEditor != null && !Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor2)) && fileEditor.getStructureViewBuilder() != null;
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ViewStructureAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    @NotNull
    public static StructureViewModel createStructureViewModel(@NotNull Project project2, @NotNull FileEditor fileEditor, @NotNull StructureView structureView) {
        Object treeModel;
        if (project2 == null) {
            ViewStructureAction.$$$reportNull$$$0(5);
        }
        if (fileEditor == null) {
            ViewStructureAction.$$$reportNull$$$0(6);
        }
        if (structureView == null) {
            ViewStructureAction.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile2 = fileEditor.getFile();
        if (structureView instanceof StructureViewComposite && virtualFile2 != null) {
            StructureViewComposite.StructureViewDescriptor[] views = ((StructureViewComposite)structureView).getStructureViews();
            PsiFile psiFile = Objects.requireNonNull(PsiManager.getInstance(project2).findFile(virtualFile2));
            treeModel = new StructureViewCompositeModel(psiFile, (Editor)EditorUtil.getEditorEx((FileEditor)fileEditor), Arrays.asList(views));
            Disposer.register((Disposable)structureView, (Disposable)treeModel);
        } else {
            treeModel = structureView.getTreeModel();
        }
        StructureViewModel structureViewModel = treeModel;
        if (structureViewModel == null) {
            ViewStructureAction.$$$reportNull$$$0(8);
        }
        return structureViewModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ViewStructureAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ViewStructureAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStructureViewModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8 -> new IllegalStateException(string2);
        };
    }
}

