/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingPopupUI;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingRecentGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RunAnythingCalcThread
implements Computable<RunAnythingSearchListModel> {
    @NotNull
    private final String myPattern;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final Project myProject;

    RunAnythingCalcThread(@NotNull Project project2, @NotNull DataContext context2, @NotNull String pattern) {
        if (project2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myPattern = pattern;
        this.myDataContext = context2;
    }

    @Override
    public RunAnythingSearchListModel compute() {
        RunAnythingSearchListModel model2;
        if (RunAnythingPopupUI.isHelpMode(this.myPattern)) {
            model2 = new RunAnythingSearchListModel.RunAnythingHelpListModel();
            List<RunAnythingItem> items2 = this.buildHelpGroups((RunAnythingSearchListModel.RunAnythingHelpListModel)model2);
            model2.addAll(0, items2);
        } else {
            model2 = new RunAnythingSearchListModel.RunAnythingMainListModel();
            List<RunAnythingItem> items3 = this.buildAllGroups(model2);
            model2.addAll(0, items3);
            this.loadEntireSingleMatchedGroup(model2, items3);
        }
        return model2;
    }

    private void loadEntireSingleMatchedGroup(@NotNull RunAnythingSearchListModel model2, @NotNull List<RunAnythingItem> items2) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(3);
        }
        if (items2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(4);
        }
        RunAnythingGroup titleGroup = null;
        RunAnythingGroup moreGroup = null;
        int index2 = 0;
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            RunAnythingGroup currentTitleGroup = model2.findGroupByTitleIndex(i2);
            if (currentTitleGroup instanceof RunAnythingRecentGroup) continue;
            if (currentTitleGroup != null) {
                if (titleGroup == null) {
                    titleGroup = currentTitleGroup;
                } else {
                    return;
                }
            }
            if ((moreGroup = model2.findGroupByMoreIndex(i2)) == null) continue;
            if (moreGroup instanceof RunAnythingRecentGroup) {
                moreGroup = null;
                continue;
            }
            index2 = i2;
        }
        if (moreGroup != null) {
            RunAnythingPopupUI.insert(moreGroup, model2, this.myDataContext, this.myPattern, index2, 100);
        }
    }

    @NotNull
    private List<RunAnythingItem> buildHelpGroups(@NotNull RunAnythingSearchListModel.RunAnythingHelpListModel model2) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(5);
        }
        ArrayList<RunAnythingItem> items2 = new ArrayList<RunAnythingItem>();
        model2.getGroups().forEach(group2 -> group2.collectItems(this.myDataContext, items2, RunAnythingPopupUI.trimHelpPattern(this.myPattern)));
        ArrayList<RunAnythingItem> arrayList = items2;
        if (arrayList == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private List<RunAnythingItem> buildAllGroups(@NotNull RunAnythingSearchListModel model2) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(7);
        }
        ArrayList<RunAnythingItem> items2 = new ArrayList<RunAnythingItem>();
        if (this.myPattern.trim().length() == 0) {
            RunAnythingGroup recentGroup = model2.getGroups().stream().filter(group2 -> group2 instanceof RunAnythingRecentGroup).findFirst().orElse(null);
            assert (recentGroup != null);
            recentGroup.collectItems(this.myDataContext, items2, this.myPattern);
        } else {
            this.buildCompletionGroups(this.myDataContext, items2, model2);
        }
        ArrayList<RunAnythingItem> arrayList = items2;
        if (arrayList == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void buildCompletionGroups(@NotNull DataContext dataContext2, @NotNull List<RunAnythingItem> items2, @NotNull RunAnythingSearchListModel model2) {
        if (dataContext2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(9);
        }
        if (items2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(10);
        }
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(11);
        }
        if (DumbService.getInstance(this.myProject).isDumb()) {
            return;
        }
        model2.getGroups().stream().filter(group2 -> group2 instanceof RunAnythingCompletionGroup || group2 instanceof RunAnythingGeneralGroup || group2 instanceof RunAnythingRecentGroup).filter(group2 -> RunAnythingCache.getInstance(this.myProject).isGroupVisible((RunAnythingGroup)group2)).forEach(group2 -> group2.collectItems(dataContext2, items2, this.myPattern));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingCalcThread";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingCalcThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHelpGroups";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadEntireSingleMatchedGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildHelpGroups";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildAllGroups";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildCompletionGroups";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 8 -> new IllegalStateException(string2);
        };
    }
}

