/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunAnythingUtil {
    public static final Logger LOG = Logger.getInstance(RunAnythingUtil.class);
    public static final String SHIFT_SHORTCUT_TEXT = KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"SHIFT"));
    private static final Key<Collection<Pair<String, String>>> RUN_ANYTHING_WRAPPED_COMMANDS = Key.create("RUN_ANYTHING_WRAPPED_COMMANDS");

    static Font getTitleFont() {
        return StartupUiUtil.getLabelFont().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
    }

    static JComponent createTitle(@NlsContexts.PopupTitle @NotNull String titleText, @NotNull Color background) {
        if (titleText == null) {
            RunAnythingUtil.$$$reportNull$$$0(0);
        }
        if (background == null) {
            RunAnythingUtil.$$$reportNull$$$0(1);
        }
        JLabel titleLabel = new JLabel(StringUtil.capitalizeWords(titleText, true));
        titleLabel.setFont(RunAnythingUtil.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, new JBColor(Gray._220, (Color)Gray._80), null);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)titleLabel, "West");
        panel2.add((Component)separatorComponent, "Center");
        panel2.setBorder(JBUI.Borders.empty(3));
        titleLabel.setBorder(JBUI.Borders.emptyRight(3));
        panel2.setBackground(background);
        return panel2;
    }

    static void jumpNextGroup(boolean forward, JBList list2) {
        int index2 = list2.getSelectedIndex();
        RunAnythingSearchListModel model2 = RunAnythingUtil.getSearchingModel(list2);
        if (model2 != null && index2 >= 0) {
            int newIndex = forward ? model2.next(index2) : model2.prev(index2);
            list2.setSelectedIndex(newIndex);
            int more = model2.next(newIndex) - 1;
            if (more < newIndex) {
                more = list2.getItemsCount() - 1;
            }
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)more, (int)(forward ? 1 : -1));
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    @NotNull
    public static Collection<Pair<String, String>> getOrCreateWrappedCommands(@NotNull Project project2) {
        Collection<Pair<String, String>> list2;
        if (project2 == null) {
            RunAnythingUtil.$$$reportNull$$$0(2);
        }
        if ((list2 = project2.getUserData(RUN_ANYTHING_WRAPPED_COMMANDS)) == null) {
            list2 = new ArrayList<Pair<String, String>>();
            project2.putUserData(RUN_ANYTHING_WRAPPED_COMMANDS, list2);
        }
        Collection<Pair<String, String>> collection = list2;
        if (collection == null) {
            RunAnythingUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Project fetchProject(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            RunAnythingUtil.$$$reportNull$$$0(4);
        }
        Project project2 = Objects.requireNonNull((Project)CommonDataKeys.PROJECT.getData(dataContext2));
        if (project2 == null) {
            RunAnythingUtil.$$$reportNull$$$0(5);
        }
        return project2;
    }

    public static void executeMatched(@NotNull DataContext dataContext2, @NotNull String pattern) {
        if (dataContext2 == null) {
            RunAnythingUtil.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            RunAnythingUtil.$$$reportNull$$$0(7);
        }
        List<String> commands = RunAnythingCache.getInstance(RunAnythingUtil.fetchProject(dataContext2)).getState().getCommands();
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext2);
        if (module2 == null) {
            LOG.info("RunAnything: module hasn't been found, command will be executed in context of 'null' module.");
        }
        for (RunAnythingProvider provider2 : RunAnythingProvider.EP_NAME.getExtensions()) {
            Object value = provider2.findMatchingValue(dataContext2, pattern);
            if (value == null) continue;
            provider2.execute(dataContext2, value);
            commands.remove(pattern);
            commands.add(pattern);
            break;
        }
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model2;
        if (list2 == null) {
            RunAnythingUtil.$$$reportNull$$$0(8);
        }
        return (model2 = list2.getModel()) instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)model2 : null;
    }

    @Nls
    public static String getAdDebugText() {
        return IdeBundle.message((String)"run.anything.ad.run.with.debug", (Object[])new Object[]{SHIFT_SHORTCUT_TEXT});
    }

    @Nls
    public static String getAdDeleteCommandText() {
        return IdeBundle.message((String)"run.anything.ad.command.delete", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"shift BACK_SPACE"))});
    }

    @Nls
    public static String getAdContextText() {
        return IdeBundle.message((String)"run.anything.ad.run.in.context", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"pressed ALT"))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateWrappedCommands";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWrappedCommands";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeMatched";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSearchingModel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5 -> new IllegalStateException(string2);
        };
    }
}

