/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.items;

import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RendererPanelsUtils;
import com.intellij.ui.render.RendererPanelsUtilsKt;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingItemBase
extends RunAnythingItem {
    @NotNull
    @NlsSafe
    private final String myCommand;
    @Nullable
    protected final Icon myIcon;

    public RunAnythingItemBase(@NotNull @NlsSafe String command2, @Nullable Icon icon2) {
        if (command2 == null) {
            RunAnythingItemBase.$$$reportNull$$$0(0);
        }
        this.myCommand = command2;
        this.myIcon = icon2;
    }

    @Override
    @NotNull
    public String getCommand() {
        String string2 = this.myCommand;
        if (string2 == null) {
            RunAnythingItemBase.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    @Nls
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public Component createComponent(@Nullable String pattern, boolean isSelected, boolean hasFocus) {
        JPanel component2 = new JPanel(new BorderLayout());
        Color background = UIUtil.getListBackground(isSelected, true);
        component2.setBackground(background);
        SimpleColoredComponent textComponent = new SimpleColoredComponent();
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)StringUtil.notNullize(this.getCommand()), (SimpleColoredComponent)textComponent, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)RunAnythingGroup.RUN_ANYTHING_MATCHER_BUILDER.fun(pattern).build(), (Color)background, (boolean)isSelected);
        component2.add((Component)textComponent, "West");
        textComponent.appendTextPadding(20);
        this.setupIcon(textComponent, this.myIcon);
        this.addDescription(component2, isSelected);
        JPanel jPanel = component2;
        if (jPanel == null) {
            RunAnythingItemBase.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void addDescription(@NotNull JPanel panel2, boolean isSelected) {
        String description;
        if (panel2 == null) {
            RunAnythingItemBase.$$$reportNull$$$0(3);
        }
        if ((description = this.getDescription()) == null) {
            return;
        }
        SimpleColoredComponent descriptionComponent = new SimpleColoredComponent();
        descriptionComponent.append(description, RunAnythingItemBase.getDescriptionAttributes(isSelected));
        descriptionComponent.setTextAlign(4);
        panel2.add((Component)descriptionComponent, "Center");
    }

    public void setupIcon(@NotNull SimpleColoredComponent component2, @Nullable Icon icon2) {
        if (component2 == null) {
            RunAnythingItemBase.$$$reportNull$$$0(4);
        }
        component2.setIcon(ObjectUtils.notNull(icon2, EmptyIcon.ICON_16));
        if (ExperimentalUI.isNewUI()) {
            component2.setIconTextGap(RendererPanelsUtils.getIconTextGap());
            RendererPanelsUtilsKt.resetHorizontalInsets((JComponent[])new JComponent[]{component2});
        } else {
            component2.setIpad((Insets)JBUI.insets(0, 10, 0, 0));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunAnythingItemBase base = (RunAnythingItemBase)o;
        return this.myCommand.equals(base.myCommand);
    }

    public int hashCode() {
        return this.myCommand.hashCode();
    }

    protected static void appendDescription(@NotNull SimpleColoredComponent component2, @NlsContexts.DetailedDescription @Nullable String description, @NotNull Color foreground) {
        if (component2 == null) {
            RunAnythingItemBase.$$$reportNull$$$0(5);
        }
        if (foreground == null) {
            RunAnythingItemBase.$$$reportNull$$$0(6);
        }
        if (description != null) {
            SimpleTextAttributes smallAttributes = new SimpleTextAttributes(128, foreground);
            component2.append(StringUtil.shortenTextWithEllipsis(description, 40, 0), smallAttributes);
            component2.appendTextPadding(660, 4);
        }
    }

    @NotNull
    private static SimpleTextAttributes getDescriptionAttributes(boolean isSelected) {
        return new SimpleTextAttributes(0, isSelected ? NamedColorUtil.getListSelectionForeground(true) : NamedColorUtil.getInactiveTextColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/items/RunAnythingItemBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/items/RunAnythingItemBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendDescription";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

