/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.ScopeChooserAction;
import com.intellij.ide.actions.searcheverywhere.ScopeSupporting;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeModel;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor
implements WeightedSearchEverywhereContributor<Object>,
ScopeSupporting {
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);
    private static final Key<Map<String, String>> SE_SELECTED_SCOPES = Key.create("SE_SELECTED_SCOPES");
    private static final Pattern ourPatternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected final Project myProject;
    protected ScopeDescriptor myScopeDescriptor;
    private final GlobalSearchScope myEverywhereScope;
    private final GlobalSearchScope myProjectScope;
    protected final SmartPsiElementPointer<PsiElement> myPsiContext;

    protected AbstractGotoSEContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        this.myProject = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        PsiElement context2 = GotoActionBase.getPsiContext(event);
        this.myPsiContext = context2 != null ? SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(context2) : null;
        GlobalSearchScope everywhereScope = SearchEverywhereClassifier.EP_Manager.getEverywhereScope(this.myProject);
        if (everywhereScope == null) {
            everywhereScope = GlobalSearchScope.everythingScope(this.myProject);
        }
        this.myEverywhereScope = everywhereScope;
        List<ScopeDescriptor> scopeDescriptors = this.createScopes();
        GlobalSearchScope projectScope = SearchEverywhereClassifier.EP_Manager.getProjectScope(this.myProject);
        if (projectScope == null && this.myEverywhereScope.equals(projectScope = GlobalSearchScope.projectScope(this.myProject))) {
            ScopeDescriptor secondScope2 = JBIterable.from(scopeDescriptors).filter(o -> !o.scopeEquals(this.myEverywhereScope) && !o.scopeEquals(null)).first();
            projectScope = secondScope2 != null ? (GlobalSearchScope)secondScope2.getScope() : this.myEverywhereScope;
        }
        this.myProjectScope = projectScope;
        this.myScopeDescriptor = this.getInitialSelectedScope(scopeDescriptors);
        this.myProject.getMessageBus().connect(this).subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractGotoSEContributor.this.myScopeDescriptor = AbstractGotoSEContributor.this.getInitialSelectedScope(AbstractGotoSEContributor.this.createScopes());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$1", "pluginUnloaded"));
            }
        });
    }

    protected List<ScopeDescriptor> createScopes() {
        DataContext context2 = AbstractGotoSEContributor.createContext(this.myProject, this.myPsiContext);
        return ScopeModel.getScopeDescriptors(this.myProject, context2, EnumSet.of(ScopeModel.Option.LIBRARIES, ScopeModel.Option.EMPTY_SCOPES));
    }

    @NotNull
    public static DataContext createContext(Project project2, @Nullable SmartPsiElementPointer<PsiElement> psiContext) {
        DataContext parentContext = project2 == null ? null : SimpleDataContext.getProjectContext((Project)project2);
        PsiElement context2 = psiContext != null ? psiContext.getElement() : null;
        PsiFile file2 = context2 == null ? null : context2.getContainingFile();
        DataContext dataContext2 = SimpleDataContext.builder().setParent(parentContext).add(CommonDataKeys.PSI_ELEMENT, (Object)context2).add(CommonDataKeys.PSI_FILE, (Object)file2).build();
        if (dataContext2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(1);
        }
        return dataContext2;
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string2 = this.getClass().getSimpleName();
        if (string2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return true;
    }

    @NotNull
    protected <T> List<AnAction> doGetActions(@Nullable PersistentSearchEverywhereContributorFilter<T> filter2, @Nullable ElementsChooser.StatisticsCollector<T> statisticsCollector, final @NotNull Runnable onChanged2) {
        if (onChanged2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(3);
        }
        if (this.myProject == null || filter2 == null) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new ScopeChooserAction(){
            final boolean canToggleEverywhere;
            {
                this.canToggleEverywhere = !AbstractGotoSEContributor.this.myEverywhereScope.equals(AbstractGotoSEContributor.this.myProjectScope);
            }

            @Override
            protected void onScopeSelected(@NotNull ScopeDescriptor o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                AbstractGotoSEContributor.this.setSelectedScope(o);
                onChanged2.run();
            }

            @Override
            @NotNull
            protected ScopeDescriptor getSelectedScope() {
                ScopeDescriptor scopeDescriptor = AbstractGotoSEContributor.this.myScopeDescriptor;
                if (scopeDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                return scopeDescriptor;
            }

            @Override
            protected void onProjectScopeToggled() {
                this.setEverywhere(!AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope));
            }

            @Override
            protected boolean processScopes(@NotNull Processor<? super ScopeDescriptor> processor) {
                if (processor == null) {
                    2.$$$reportNull$$$0(2);
                }
                return ContainerUtil.process(AbstractGotoSEContributor.this.createScopes(), processor);
            }

            @Override
            public boolean isEverywhere() {
                return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope);
            }

            @Override
            public void setEverywhere(boolean everywhere) {
                AbstractGotoSEContributor.this.setSelectedScope(new ScopeDescriptor(everywhere ? AbstractGotoSEContributor.this.myEverywhereScope : AbstractGotoSEContributor.this.myProjectScope));
                onChanged2.run();
            }

            @Override
            public boolean canToggleEverywhere() {
                if (!this.canToggleEverywhere) {
                    return false;
                }
                return AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myEverywhereScope) || AbstractGotoSEContributor.this.myScopeDescriptor.scopeEquals(AbstractGotoSEContributor.this.myProjectScope);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onScopeSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "processScopes";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        result2.add((AnAction)new SearchEverywhereFiltersAction<T>(filter2, onChanged2, statisticsCollector));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private ScopeDescriptor getInitialSelectedScope(List<? extends ScopeDescriptor> scopeDescriptors) {
        String selectedScope;
        String string2 = selectedScope = this.myProject == null ? null : AbstractGotoSEContributor.getSelectedScopes(this.myProject).get(this.getClass().getSimpleName());
        if (StringUtil.isNotEmpty(selectedScope)) {
            for (ScopeDescriptor scopeDescriptor : scopeDescriptors) {
                if (!selectedScope.equals(scopeDescriptor.getDisplayName()) || scopeDescriptor.scopeEquals(null)) continue;
                ScopeDescriptor scopeDescriptor2 = scopeDescriptor;
                if (scopeDescriptor2 == null) {
                    AbstractGotoSEContributor.$$$reportNull$$$0(6);
                }
                return scopeDescriptor2;
            }
        }
        return new ScopeDescriptor(this.myProjectScope);
    }

    private void setSelectedScope(@NotNull ScopeDescriptor o) {
        if (o == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(7);
        }
        this.myScopeDescriptor = o;
        AbstractGotoSEContributor.getSelectedScopes(this.myProject).put(this.getClass().getSimpleName(), o.scopeEquals(this.myEverywhereScope) || o.scopeEquals(this.myProjectScope) ? null : o.getDisplayName());
    }

    @NotNull
    private static Map<String, String> getSelectedScopes(@NotNull Project project2) {
        Map<String, String> map2;
        if (project2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(8);
        }
        if ((map2 = SE_SELECTED_SCOPES.get(project2)) == null) {
            map2 = new HashMap<String, String>(3);
            SE_SELECTED_SCOPES.set(project2, map2);
        }
        Map<String, String> map3 = map2;
        if (map3 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(9);
        }
        return map3;
    }

    @Override
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(10);
        }
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(11);
        }
        if (consumer2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(12);
        }
        if (this.myProject == null) {
            return;
        }
        if (!this.isEmptyPatternSupported() && pattern.isEmpty()) {
            return;
        }
        Runnable fetchRunnable = () -> {
            if (!this.isDumbAware() && DumbService.isDumb(this.myProject)) {
                return;
            }
            FilteringGotoByModel<?> model2 = this.createModel(this.myProject);
            if (progressIndicator.isCanceled()) {
                return;
            }
            PsiElement context2 = this.myPsiContext != null ? this.myPsiContext.getElement() : null;
            ChooseByNameItemProvider provider2 = ChooseByNameModelEx.getItemProvider(model2, context2);
            GlobalSearchScope scope = (GlobalSearchScope)Objects.requireNonNull(this.myScopeDescriptor.getScope());
            boolean everywhere = scope.isSearchInLibraries();
            MyViewModel viewModel = new MyViewModel(this.myProject, model2);
            if (provider2 instanceof ChooseByNameInScopeItemProvider) {
                FindSymbolParameters parameters2 = FindSymbolParameters.wrap(pattern, scope);
                ((ChooseByNameInScopeItemProvider)provider2).filterElementsWithWeights(viewModel, parameters2, progressIndicator, item -> this.processElement(progressIndicator, consumer2, model2, item.getItem(), item.getWeight()));
            } else if (provider2 instanceof ChooseByNameWeightedItemProvider) {
                ((ChooseByNameWeightedItemProvider)provider2).filterElementsWithWeights(viewModel, pattern, everywhere, progressIndicator, item -> this.processElement(progressIndicator, consumer2, model2, item.getItem(), item.getWeight()));
            } else {
                provider2.filterElements(viewModel, pattern, everywhere, progressIndicator, element -> this.processElement(progressIndicator, consumer2, model2, element, this.getElementPriority(element, pattern)));
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && application.isDispatchThread()) {
            fetchRunnable.run();
        } else {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)fetchRunnable, (ProgressIndicator)progressIndicator);
        }
    }

    protected boolean processElement(@NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2, FilteringGotoByModel<?> model2, Object element, int degree) {
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(13);
        }
        if (consumer2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(14);
        }
        if (progressIndicator.isCanceled()) {
            return false;
        }
        if (element == null) {
            LOG.error("Null returned from " + model2 + " in " + this);
            return true;
        }
        return consumer2.process(new FoundItemDescriptor<Object>(element, degree));
    }

    @Override
    public ScopeDescriptor getScope() {
        return this.myScopeDescriptor;
    }

    @Override
    public void setScope(ScopeDescriptor scope) {
        this.setSelectedScope(scope);
    }

    @Override
    public List<ScopeDescriptor> getSupportedScopes() {
        return this.createScopes();
    }

    @Override
    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        List<SearchEverywhereCommandInfo> list2 = WeightedSearchEverywhereContributor.super.getSupportedCommands();
        if (list2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    protected abstract FilteringGotoByModel<?> createModel(@NotNull Project var1);

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(16);
        }
        if (StringUtil.containsAnyChar(pattern, ":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            String string2 = AbstractGotoSEContributor.applyPatternFilter(pattern, ourPatternToDetectLinesAndColumns);
            if (string2 == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(17);
            }
            return string2;
        }
        String string3 = pattern;
        if (string3 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(18);
        }
        return string3;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    @Override
    public boolean showInFindResults() {
        return true;
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        if (selected == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(19);
        }
        if (searchText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(20);
        }
        if (selected instanceof PsiElement) {
            if (!((PsiElement)selected).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            ReadAction.nonBlocking(() -> {
                PsiElement psiElement = this.preparePsi((PsiElement)selected, modifiers, searchText);
                Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
                return new Pair<PsiElement, Navigatable>(psiElement, extNavigatable);
            }).finishOnUiThread(ModalityState.NON_MODAL, pair -> {
                Navigatable extNavigatable = (Navigatable)pair.second;
                PsiElement psiElement = (PsiElement)pair.first;
                if (extNavigatable != null && extNavigatable.canNavigate()) {
                    extNavigatable.navigate(true);
                } else {
                    NavigationUtil.activateFileWithPsiElement(psiElement, true);
                }
            }).submit(AppExecutorUtil.getAppExecutorService());
        } else {
            EditSourceUtil.navigate((NavigationItem)selected, true, false);
        }
        return true;
    }

    @Override
    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(21);
        }
        if (dataId == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(22);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element instanceof PsiElement) {
                return element;
            }
            if (element instanceof DataProvider) {
                return ((DataProvider)element).getData(dataId);
            }
            if (element instanceof PsiElementNavigationItem) {
                return ((PsiElementNavigationItem)element).getTargetElement();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getItemDescription(@NotNull Object element) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(23);
        }
        return element instanceof PsiElement && ((PsiElement)element).isValid() ? QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)element)) : null;
    }

    @Override
    public boolean isMultiSelectionSupported() {
        return true;
    }

    @Override
    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.createModel(this.myProject));
    }

    @Override
    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        return new SearchEverywherePsiRenderer(this);
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(24);
        }
        if (searchPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(25);
        }
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile(psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            return new OpenFileDescriptor(psi.getProject(), file2, (Integer)position.first, (Integer)position.second);
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text2) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text2, 3);
        if (line == -1 && column != -1) {
            line = 0;
        }
        return new Pair<Integer, Integer>(line, column);
    }

    private static int getLineAndColumnRegexpGroup(String text2, int groupNumber) {
        Matcher matcher = ourPatternToDetectLinesAndColumns.matcher(text2);
        if (matcher.matches()) {
            try {
                String group2;
                if (groupNumber <= matcher.groupCount() && (group2 = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group2) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 9, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSelectedScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScopes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedScopes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fetchWeightedElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getItemDescription";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4, 5, 6, 9, 15, 17, 18 -> new IllegalStateException(string2);
        };
    }

    private static final class MyViewModel
    implements ChooseByNameViewModel {
        private final Project myProject;
        private final ChooseByNameModel myModel;

        private MyViewModel(Project project2, ChooseByNameModel model2) {
            this.myProject = project2;
            this.myModel = model2;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        @Override
        @NotNull
        public ChooseByNameModel getModel() {
            ChooseByNameModel chooseByNameModel = this.myModel;
            if (chooseByNameModel == null) {
                MyViewModel.$$$reportNull$$$0(0);
            }
            return chooseByNameModel;
        }

        @Override
        public boolean isSearchInAnyPlace() {
            return this.myModel.useMiddleMatching();
        }

        @Override
        @NotNull
        public String transformPattern(@NotNull String pattern) {
            if (pattern == null) {
                MyViewModel.$$$reportNull$$$0(1);
            }
            String string2 = ChooseByNamePopup.getTransformedPattern(pattern, this.myModel);
            if (string2 == null) {
                MyViewModel.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        public boolean canShowListForEmptyPattern() {
            return false;
        }

        @Override
        public int getMaximumListSizeLimit() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$MyViewModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor$MyViewModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "transformPattern";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1 -> new IllegalArgumentException(string2);
            };
        }
    }
}

