/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.AutoCompletionCommand;
import com.intellij.ide.actions.searcheverywhere.AutoCompletionContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AutoCompletionProvider {
    AutoCompletionProvider() {
    }

    public static List<SearchEverywhereFoundElementInfo> getCompletionElements(Collection<SearchEverywhereContributor<?>> contributors, JTextComponent textComponent) {
        StubContributor stubContributor = new StubContributor(textComponent);
        return ContainerUtil.map(AutoCompletionProvider.getCompletions(contributors, textComponent), command2 -> new SearchEverywhereFoundElementInfo(command2, 0, stubContributor));
    }

    private static List<AutoCompletionCommand> getCompletions(Collection<SearchEverywhereContributor<?>> contributors, JTextComponent textComponent) {
        return contributors.stream().filter(c2 -> c2 instanceof AutoCompletionContributor).map(c2 -> (AutoCompletionContributor)((Object)c2)).flatMap(c2 -> c2.getAutocompleteItems(textComponent.getText(), textComponent.getCaretPosition()).stream()).collect(Collectors.toList());
    }

    private static class StubContributor
    implements SearchEverywhereContributor<AutoCompletionCommand> {
        private final JTextComponent myTextComponent;

        private StubContributor(JTextComponent component2) {
            this.myTextComponent = component2;
        }

        @Override
        @NotNull
        public String getSearchProviderId() {
            return "AutocompletionContributor";
        }

        @Override
        @Nls
        @NotNull
        public String getGroupName() {
            String string2 = IdeBundle.message((String)"searcheverywhere.autocompletion.tab.name", (Object[])new Object[0]);
            if (string2 == null) {
                StubContributor.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public int getSortWeight() {
            return 0;
        }

        @Override
        public boolean showInFindResults() {
            return false;
        }

        @Override
        public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super AutoCompletionCommand> consumer2) {
            if (pattern == null) {
                StubContributor.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                StubContributor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                StubContributor.$$$reportNull$$$0(3);
            }
        }

        @Override
        public boolean processSelectedItem(@NotNull AutoCompletionCommand selected, int modifiers, @NotNull String searchText) {
            if (selected == null) {
                StubContributor.$$$reportNull$$$0(4);
            }
            if (searchText == null) {
                StubContributor.$$$reportNull$$$0(5);
            }
            selected.completeQuery(this.myTextComponent);
            return false;
        }

        @Override
        @NotNull
        public ListCellRenderer<? super AutoCompletionCommand> getElementsRenderer() {
            return new CommandRenderer();
        }

        @Override
        @Nullable
        public Object getDataForItem(@NotNull AutoCompletionCommand element, @NotNull String dataId) {
            if (element == null) {
                StubContributor.$$$reportNull$$$0(6);
            }
            if (dataId == null) {
                StubContributor.$$$reportNull$$$0(7);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AutoCompletionProvider$StubContributor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchText";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AutoCompletionProvider$StubContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchElements";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processSelectedItem";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForItem";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static class CommandRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer<AutoCompletionCommand> {
        protected boolean mySelected;
        protected Color myForeground;
        protected Color mySelectionForeground;

        private CommandRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionCommand> list2, AutoCompletionCommand value, int index2, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            this.getIpad().right = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale(UIUtil.getListCellHPadding());
            this.getIpad().left = this.getIpad().right;
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setFont(list2.getFont());
            this.setIcon(EmptyIcon.ICON_16);
            this.mySelected = isSelected;
            this.myForeground = this.isEnabled() ? list2.getForeground() : UIUtil.getLabelDisabledForeground();
            this.mySelectionForeground = list2.getSelectionForeground();
            if (UIUtil.isUnderWin10LookAndFeel()) {
                this.setBackground(isSelected ? list2.getSelectionBackground() : list2.getBackground());
            } else {
                this.setBackground(isSelected ? list2.getSelectionBackground() : null);
            }
            SimpleTextAttributes baseStyle = new SimpleTextAttributes(0, list2.getForeground());
            this.appendHTML(value.getPresentationString(), baseStyle);
            return this;
        }

        public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
            if (fragment == null) {
                CommandRenderer.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                CommandRenderer.$$$reportNull$$$0(1);
            }
            if (this.mySelected) {
                super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), this.mySelectionForeground), isMainText);
            } else if (attributes.getFgColor() == null) {
                super.append(fragment, attributes.derive(-1, this.myForeground, null, null), isMainText);
            } else {
                super.append(fragment, attributes, isMainText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/searcheverywhere/AutoCompletionProvider$CommandRenderer";
            objectArray[2] = "append";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

