/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.CalculatorSEContributorKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"minExponentialNotationValue", "", "precision", "", "doEvaluate", "", "str", "", "evaluate", "input", "format", "doubleValue", "round", "value", "intellij.platform.lang.impl"})
public final class CalculatorSEContributorKt {
    private static final int precision = 9;
    private static final long minExponentialNotationValue = 1000000000L;

    @NotNull
    public static final String evaluate(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return CalculatorSEContributorKt.format(CalculatorSEContributorKt.round(CalculatorSEContributorKt.doEvaluate(input)));
    }

    private static final double doEvaluate(String str) {
        return new Object(str){
            private int pos;
            private char ch;
            final /* synthetic */ String $str;
            {
                this.$str = $str;
                this.pos = -1;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final char getCh() {
                return this.ch;
            }

            public final void setCh(char c2) {
                this.ch = c2;
            }

            public final void nextChar() {
                char c2;
                doEvaluate.1 v0 = this;
                CharSequence charSequence = this.$str;
                ++this.pos;
                int n = this.pos;
                if (n >= 0 && n <= StringsKt.getLastIndex((CharSequence)charSequence)) {
                    c2 = charSequence.charAt(n);
                } else {
                    int n2 = n;
                    doEvaluate.1 var5_4 = v0;
                    boolean bl = false;
                    char c3 = '\u0000';
                    v0 = var5_4;
                    c2 = c3;
                }
                v0.ch = c2;
            }

            public final boolean eat(char charToEat) {
                while (this.ch == ' ') {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            public final double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat('+')) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat('-')) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            public final double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat('*')) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat('/')) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            public final double parseFactor() {
                return this.eat('+') ? this.parseFactor() : (this.eat('-') ? -this.parseFactor() : this.parsePrimary());
            }

            public final double parsePrimary() {
                double x;
                block20: {
                    block23: {
                        char c2;
                        int startPos;
                        block22: {
                            block21: {
                                block19: {
                                    x = 0.0;
                                    if (!this.eat('(')) break block19;
                                    x = this.parseExpression();
                                    this.eat(')');
                                    break block20;
                                }
                                if (!this.eat('0')) break block21;
                                x = this.eat('x') || this.eat('X') ? this.parseHex() : (this.eat('b') || this.eat('B') ? this.parseBinary() : this.parseDecimalOrOctal());
                                break block20;
                            }
                            startPos = this.pos;
                            c2 = this.ch;
                            boolean bl = '1' <= c2 ? c2 < ':' : false;
                            if (!bl && this.ch != '.') break block22;
                            this.nextChar();
                            while (true) {
                                boolean bl2 = '0' <= (c2 = this.ch) ? c2 < ':' : false;
                                if (!bl2 && this.ch != '.') break;
                                this.nextChar();
                            }
                            String string2 = this.$str.substring(startPos, this.pos);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            x = Double.parseDouble(string2);
                            break block20;
                        }
                        c2 = this.ch;
                        boolean bl = 'a' <= c2 ? c2 < '{' : false;
                        if (!bl) break block23;
                        while (true) {
                            boolean bl3 = 'a' <= (c2 = this.ch) ? c2 < '{' : false;
                            if (!bl3) break;
                            this.nextChar();
                        }
                        String string3 = this.$str.substring(startPos, this.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String func = string3;
                        x = this.parseFactor();
                        x = switch (func) {
                            case "sqrt" -> Math.sqrt(x);
                            case "sin" -> Math.sin(Math.toRadians(x));
                            case "cos" -> Math.cos(Math.toRadians(x));
                            case "tan" -> Math.tan(Math.toRadians(x));
                            default -> throw new RuntimeException("Unknown function: " + func);
                        };
                        break block20;
                    }
                    throw new RuntimeException("Unexpected: " + this.ch);
                }
                if (this.eat('^')) {
                    x = Math.pow(x, this.parseFactor());
                }
                return x;
            }

            private final double parseHex() {
                int startPos = this.pos;
                while (true) {
                    char c2;
                    if (!('0' <= (c2 = this.ch) ? c2 < ':' : false)) {
                        c2 = this.ch;
                        if (!('a' <= c2 ? c2 < 'g' : false)) {
                            c2 = this.ch;
                            boolean bl = 'A' <= c2 ? c2 < 'G' : false;
                            if (!bl) break;
                        }
                    }
                    this.nextChar();
                }
                String string2 = this.$str.substring(startPos, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string2, 16);
            }

            private final double parseBinary() {
                int startPos = this.pos;
                while (this.ch == '0' || this.ch == '1') {
                    this.nextChar();
                }
                String string2 = this.$str.substring(startPos, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return Long.parseLong(string2, 2);
            }

            private final double parseDecimalOrOctal() {
                int startPos = this.pos;
                if (this.eat('.')) {
                    while (true) {
                        char c2;
                        boolean bl = '0' <= (c2 = this.ch) ? c2 < ':' : false;
                        if (!bl && this.ch != '.') break;
                        this.nextChar();
                    }
                    String string2 = this.$str.substring(startPos, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    return Double.parseDouble(string2);
                }
                char c3 = this.ch;
                boolean bl = '0' <= c3 ? c3 < '8' : false;
                if (bl) {
                    while (true) {
                        boolean bl2 = '0' <= (c3 = this.ch) ? c3 < '8' : false;
                        if (!bl2) break;
                        this.nextChar();
                    }
                    String string3 = this.$str.substring(startPos, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    return Long.parseLong(string3, 8);
                }
                return 0.0;
            }

            public final double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < this.$str.length()) {
                    throw new RuntimeException("Unexpected: " + this.ch);
                }
                return x;
            }
        }.parse();
    }

    private static final double round(double value) {
        if (Double.isFinite(value)) {
            return new BigDecimal(String.valueOf(value)).setScale(9, RoundingMode.HALF_UP).doubleValue();
        }
        return value;
    }

    private static final String format(double doubleValue) {
        String string2;
        DecimalFormat decimalFormat;
        long longValue = (long)doubleValue;
        String pattern = Math.abs(longValue) < 1000000000L ? "0" : "0E0";
        DecimalFormat $this$format_u24lambda_u240 = decimalFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        boolean bl = false;
        $this$format_u24lambda_u240.setMaximumFractionDigits(9);
        DecimalFormat df = decimalFormat;
        if ((double)longValue == doubleValue) {
            String string3 = df.format(longValue);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n    df.format(longValue)\n  }");
        } else {
            String string4 = df.format(doubleValue);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n    df.format(doubleValue)\n  }");
        }
        return string2;
    }
}

