/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.GroupTitleRenderer;
import com.intellij.ide.actions.searcheverywhere.GroupedSearchListModel;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

class GroupedListFactory
extends SEResultsListFactory {
    private final GroupTitleRenderer myGroupTitleRenderer = new GroupTitleRenderer();

    GroupedListFactory() {
    }

    @Override
    public SearchListModel createModel() {
        return new GroupedSearchListModel();
    }

    @Override
    public JBList<Object> createList(SearchListModel model2) {
        return new JBList((ListModel)model2);
    }

    @Override
    ListCellRenderer<Object> createListRenderer(SearchListModel model2, final SearchEverywhereHeader header) {
        final GroupedSearchListModel groupedModel = (GroupedSearchListModel)model2;
        return new ListCellRenderer<Object>(){
            private final Map<String, ListCellRenderer<? super Object>> myRenderersCache = new HashMap<String, ListCellRenderer<? super Object>>();

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                if (value == SearchListModel.MORE_ELEMENT) {
                    return GroupedListFactory.this.getMoreElementRenderer(list2, index2, isSelected, cellHasFocus);
                }
                Object component2 = GroupedListFactory.this.getNonMoreElementRenderer(list2, value, index2, isSelected, cellHasFocus, groupedModel, this.myRenderersCache);
                if (!header.getSelectedTab().isSingleContributor() && groupedModel.isGroupFirstItem(index2)) {
                    SearchEverywhereContributor contributor = groupedModel.getContributorForIndex(index2);
                    component2 = GroupedListFactory.this.myGroupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), (Component)component2);
                }
                return component2;
            }
        };
    }
}

