/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMlService;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class GroupedResultsSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(GroupedResultsSearcher.class);
    @NotNull
    private final SearchListener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    GroupedResultsSearcher(@NotNull SearchListener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        if (listener2 == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(0);
        }
        if (notificationExecutor == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(1);
        }
        if (equalityProviders == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        ProgressIndicatorBase indicator;
        FullSearchResultsAccumulator accumulator;
        if (contributorsAndLimits == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(4);
        }
        LOG.debug("Search started for pattern [", pattern, "]");
        Collection<SearchEverywhereContributor<Object>> contributors = contributorsAndLimits.keySet();
        if (pattern.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            contributors = Collections.emptySet();
        }
        if (!(contributors = ContainerUtil.filter(contributors, contributor -> !contributor.filterControlSymbols(pattern).isEmpty() || contributor.isEmptyPatternSupported())).isEmpty()) {
            CountDownLatch latch = new CountDownLatch(contributors.size());
            ProgressIndicatorWithCancelListener indicatorWithCancelListener = new ProgressIndicatorWithCancelListener();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicatorWithCancelListener);
            accumulator.startSearch(pattern);
            for (SearchEverywhereContributor<Object> contributor2 : contributors) {
                Runnable task2 = GroupedResultsSearcher.createSearchTask(pattern, accumulator, indicatorWithCancelListener, contributor2, () -> latch.countDown());
                ApplicationManager.getApplication().executeOnPooledThread(task2);
            }
            Runnable finisherTask = GroupedResultsSearcher.createFinisherTask(latch, accumulator, indicatorWithCancelListener);
            Future<?> finisherFeature = ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
            indicatorWithCancelListener.setCancelCallback(() -> {
                accumulator.stop();
                finisherFeature.cancel(true);
            });
            indicator = indicatorWithCancelListener;
        } else {
            indicator = new ProgressIndicatorBase();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
            accumulator.startSearch(pattern);
        }
        indicator.start();
        if (contributors.isEmpty()) {
            indicator.stop();
            accumulator.searchFinished();
        }
        return indicator;
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        if (alreadyFound == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(5);
        }
        if (contributorsAndLimits == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(7);
        }
        if (contributorsAndLimits.size() > 1) {
            throw new IllegalArgumentException("Multiple contributors are not allowed for grouped list");
        }
        Map.Entry entry = (Map.Entry)contributorsAndLimits.entrySet().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Empty contributors map is not allowed"));
        SearchEverywhereContributor contributor = (SearchEverywhereContributor)entry.getKey();
        int newLimit = (Integer)entry.getValue();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        ShowMoreResultsAccumulator accumulator = new ShowMoreResultsAccumulator(alreadyFound, this.myEqualityProvider, contributor, newLimit, this.myListener, this.myNotificationExecutor, indicator);
        indicator.start();
        accumulator.startSearch(pattern);
        Runnable task2 = GroupedResultsSearcher.createSearchTask(pattern, accumulator, indicator, contributor, () -> indicator.stop());
        ApplicationManager.getApplication().executeOnPooledThread(task2);
        return indicator;
    }

    @NotNull
    private static Runnable createSearchTask(String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, SearchEverywhereContributor<?> contributor, Runnable finalCallback) {
        ContributorSearchTask task2 = new ContributorSearchTask(contributor, pattern, accumulator, indicator, finalCallback);
        Runnable runnable = ConcurrencyUtil.underThreadNameRunnable("SE-SearchTask-" + contributor.getSearchProviderId(), task2);
        if (runnable == null) {
            GroupedResultsSearcher.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    private static Runnable createFinisherTask(CountDownLatch latch, FullSearchResultsAccumulator accumulator, ProgressIndicator indicator) {
        return ConcurrencyUtil.underThreadNameRunnable("SE-FinisherTask", () -> {
            try {
                latch.await();
                if (!indicator.isCanceled()) {
                    accumulator.searchFinished();
                }
                indicator.stop();
            }
            catch (InterruptedException e) {
                LOG.debug("Finisher interrupted before search process is finished");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityProviders";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorsAndLimits";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFound";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/GroupedResultsSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/GroupedResultsSearcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMoreItems";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }

    private static class ProgressIndicatorWithCancelListener
    extends ProgressIndicatorBase {
        private volatile Runnable cancelCallback = () -> {};

        private ProgressIndicatorWithCancelListener() {
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        @Override
        protected void onRunningChange() {
            if (this.isCanceled()) {
                this.cancelCallback.run();
            }
        }
    }

    private static class FullSearchResultsAccumulator
    extends ResultsAccumulator {
        private final Map<? extends SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<? extends SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        FullSearchResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SearchListener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> new ArrayList((Integer)entry.getValue()))), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.sectionsLimits = contributorsAndLimits;
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c2 -> this.lock.newCondition()));
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) throws InterruptedException {
            SearchEverywhereMlService mlService = SearchEverywhereMlService.getInstance();
            SearchEverywhereFoundElementInfo newElementInfo = mlService == null ? new SearchEverywhereFoundElementInfo(element, priority, contributor) : mlService.createFoundElementInfo(contributor, element, priority);
            Condition condition = this.conditionsMap.get(contributor);
            Collection section = (Collection)this.sections.get(contributor);
            int limit2 = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                boolean isNotified = false;
                while (section.size() >= limit2 && !this.mySearchFinished) {
                    indicator.checkCanceled();
                    ProgressManager.checkCanceled();
                    if (!isNotified) {
                        this.runInNotificationExecutor(() -> this.myListener.contributorWaits(contributor));
                        isNotified = true;
                    }
                    condition.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                List alreadyFoundItems = this.sections.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                SEResultsEqualityProvider.SEEqualElementsActionType type = this.myEqualityProvider.compareItems(newElementInfo, alreadyFoundItems);
                if (type == SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                    boolean bl = true;
                    return bl;
                }
                section.add(newElementInfo);
                this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                List<SearchEverywhereFoundElementInfo> toRemove2 = type instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace ? ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)type).getToBeReplaced() : Collections.emptyList();
                toRemove2.forEach(info2 -> {
                    Collection list2 = (Collection)this.sections.get(info2.getContributor());
                    Condition listCondition = this.conditionsMap.get(info2.getContributor());
                    list2.remove(info2);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info2.getElement().toString(), info2.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit2) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                this.runInNotificationExecutor(() -> this.myListener.contributorFinished(contributor, Optional.ofNullable(this.hasMoreMap.get(contributor)).orElse(false)));
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.sections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            return ((Collection)this.sections.get(contributor)).size() >= this.sectionsLimits.get(contributor);
        }
    }

    private static abstract class ResultsAccumulator {
        protected final Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections;
        protected final SearchListener myListener;
        protected final Executor myNotificationExecutor;
        protected final SEResultsEqualityProvider myEqualityProvider;
        protected final ProgressIndicator myProgressIndicator;

        ResultsAccumulator(Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections, SEResultsEqualityProvider equalityProvider, SearchListener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            this.sections = sections;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
            this.myProgressIndicator = progressIndicator;
        }

        protected void runInNotificationExecutor(Runnable runnable) {
            this.myNotificationExecutor.execute(() -> {
                if (!this.myProgressIndicator.isCanceled()) {
                    runnable.run();
                }
            });
        }

        public abstract boolean addElement(Object var1, SearchEverywhereContributor<?> var2, int var3, ProgressIndicator var4) throws InterruptedException;

        public abstract void contributorFinished(SearchEverywhereContributor<?> var1);

        public abstract void setContributorHasMore(SearchEverywhereContributor<?> var1, boolean var2);

        public void startSearch(@NotNull String pattern) {
            if (pattern == null) {
                ResultsAccumulator.$$$reportNull$$$0(0);
            }
            this.runInNotificationExecutor(() -> this.myListener.searchStarted(pattern, this.sections.keySet()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/actions/searcheverywhere/GroupedResultsSearcher$ResultsAccumulator", "startSearch"));
        }
    }

    private static class ShowMoreResultsAccumulator
    extends ResultsAccumulator {
        private final SearchEverywhereContributor<?> myExpandedContributor;
        private final int myNewLimit;
        private volatile boolean hasMore;

        ShowMoreResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, SEResultsEqualityProvider equalityProvider, SearchEverywhereContributor<?> contributor, int newLimit, SearchListener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(new ConcurrentHashMap(alreadyFound), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.myExpandedContributor = contributor;
            this.myNewLimit = newLimit;
        }

        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) {
            assert (contributor == this.myExpandedContributor);
            Collection section = (Collection)this.sections.get(contributor);
            SearchEverywhereMlService mlService = SearchEverywhereMlService.getInstance();
            SearchEverywhereFoundElementInfo newElementInfo = mlService == null ? new SearchEverywhereFoundElementInfo(element, priority, contributor) : mlService.createFoundElementInfo(contributor, element, priority);
            if (section.size() >= this.myNewLimit) {
                return false;
            }
            List alreadyFoundItems = this.sections.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            SEResultsEqualityProvider.SEEqualElementsActionType action2 = this.myEqualityProvider.compareItems(newElementInfo, alreadyFoundItems);
            if (action2 == SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE) {
                LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                return true;
            }
            section.add(newElementInfo);
            this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
            List<SearchEverywhereFoundElementInfo> toRemove2 = action2 instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace ? ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)action2).getToBeReplaced() : Collections.emptyList();
            toRemove2.forEach(info2 -> {
                Collection list2 = (Collection)this.sections.get(info2.getContributor());
                if (list2 != null) {
                    list2.remove(info2);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info2.getElement().toString(), info2.getContributor().getSearchProviderId()));
                }
            });
            this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
            return true;
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            assert (contributor == this.myExpandedContributor);
            this.hasMore = hasMore;
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.runInNotificationExecutor(() -> {
                this.myListener.contributorFinished(contributor, this.hasMore);
                this.myListener.searchFinished(Collections.singletonMap(contributor, this.hasMore));
            });
        }
    }

    private static final class ContributorSearchTask<Item>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<Item> myContributor;
        private final String myPattern;
        private final ProgressIndicator myIndicator;

        private ContributorSearchTask(SearchEverywhereContributor<Item> contributor, String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, Runnable callback) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator;
            this.finishCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", this.myContributor);
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        if (this.myContributor instanceof WeightedSearchEverywhereContributor) {
                            ((WeightedSearchEverywhereContributor)this.myContributor).fetchWeightedElements(this.myPattern, wrapperIndicator, descriptor2 -> this.processFoundItem(descriptor2.getItem(), descriptor2.getWeight(), wrapperIndicator));
                            continue;
                        }
                        this.myContributor.fetchElements(this.myPattern, wrapperIndicator, element -> {
                            int priority = this.myContributor.getElementPriority(Objects.requireNonNull(element), this.myPattern);
                            return this.processFoundItem(element, priority, wrapperIndicator);
                        });
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", this.myContributor);
        }

        private boolean processFoundItem(Item element, int priority, ProgressIndicator wrapperIndicator) {
            try {
                if (element == null) {
                    LOG.debug("Skip null element");
                    return true;
                }
                boolean added = this.myAccumulator.addElement(element, this.myContributor, priority, wrapperIndicator);
                if (!added) {
                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                }
                return added;
            }
            catch (InterruptedException e) {
                LOG.warn("Search task was interrupted");
                return false;
            }
        }
    }
}

