/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMlService;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchingProcessStatisticsCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MixedResultsSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(MixedResultsSearcher.class);
    @NotNull
    private final SearchListener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    MixedResultsSearcher(@NotNull SearchListener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        if (listener2 == null) {
            MixedResultsSearcher.$$$reportNull$$$0(0);
        }
        if (notificationExecutor == null) {
            MixedResultsSearcher.$$$reportNull$$$0(1);
        }
        if (equalityProviders == null) {
            MixedResultsSearcher.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        if (contributorsAndLimits == null) {
            MixedResultsSearcher.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            MixedResultsSearcher.$$$reportNull$$$0(4);
        }
        LOG.debug("Search started for pattern [", pattern, "]");
        if (pattern.isEmpty()) {
            contributorsAndLimits = ApplicationManager.getApplication().isUnitTestMode() ? Collections.emptyMap() : ContainerUtil.filter(contributorsAndLimits, c2 -> c2.isEmptyPatternSupported());
        }
        Map<? extends SearchEverywhereContributor<?>, Integer> map2 = contributorsAndLimits;
        Function<ProgressIndicator, ResultsAccumulator> accumulatorSupplier = indicator -> new ResultsAccumulator(map2, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
        return MixedResultsSearcher.performSearch(contributorsAndLimits.keySet(), pattern, accumulatorSupplier);
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern) {
        if (alreadyFound == null) {
            MixedResultsSearcher.$$$reportNull$$$0(5);
        }
        if (contributorsAndLimits == null) {
            MixedResultsSearcher.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            MixedResultsSearcher.$$$reportNull$$$0(7);
        }
        Function<ProgressIndicator, ResultsAccumulator> accumulatorSupplier = indicator -> new ResultsAccumulator(alreadyFound, (Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
        return MixedResultsSearcher.performSearch(contributorsAndLimits.keySet(), pattern, accumulatorSupplier);
    }

    @NotNull
    private static ProgressIndicator performSearch(@NotNull Collection<? extends SearchEverywhereContributor<?>> contributors, @NotNull String pattern, @NotNull Function<? super ProgressIndicator, ? extends ResultsAccumulator> accumulatorSupplier) {
        ProgressIndicatorBase indicator;
        ResultsAccumulator accumulator;
        if (contributors == null) {
            MixedResultsSearcher.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            MixedResultsSearcher.$$$reportNull$$$0(9);
        }
        if (accumulatorSupplier == null) {
            MixedResultsSearcher.$$$reportNull$$$0(10);
        }
        if (!contributors.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(contributors.size());
            ProgressIndicatorWithCancelListener indicatorWithCancelListener = new ProgressIndicatorWithCancelListener();
            accumulator = accumulatorSupplier.apply(indicatorWithCancelListener);
            accumulator.searchStarted(pattern);
            for (SearchEverywhereContributor<?> contributor : contributors) {
                Runnable task2 = MixedResultsSearcher.createSearchTask(pattern, accumulator, indicatorWithCancelListener, contributor, () -> latch.countDown());
                ApplicationManager.getApplication().executeOnPooledThread(task2);
            }
            Runnable finisherTask = MixedResultsSearcher.createFinisherTask(latch, accumulator, indicatorWithCancelListener);
            Future<?> finisherFeature = ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
            indicatorWithCancelListener.setCancelCallback(() -> {
                accumulator.stop();
                finisherFeature.cancel(true);
            });
            indicator = indicatorWithCancelListener;
        } else {
            indicator = new ProgressIndicatorBase();
            accumulator = accumulatorSupplier.apply(indicator);
            accumulator.searchStarted(pattern);
        }
        indicator.start();
        if (contributors.isEmpty()) {
            indicator.stop();
            accumulator.searchFinished();
        }
        ProgressIndicatorBase progressIndicatorBase = indicator;
        if (progressIndicatorBase == null) {
            MixedResultsSearcher.$$$reportNull$$$0(11);
        }
        return progressIndicatorBase;
    }

    @NotNull
    private static Runnable createSearchTask(String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, SearchEverywhereContributor<?> contributor, Runnable finalCallback) {
        ContributorSearchTask task2 = new ContributorSearchTask(contributor, pattern, accumulator, indicator, finalCallback);
        Runnable runnable = ConcurrencyUtil.underThreadNameRunnable("SE-SearchTask-" + contributor.getSearchProviderId(), task2);
        if (runnable == null) {
            MixedResultsSearcher.$$$reportNull$$$0(12);
        }
        return runnable;
    }

    private static Runnable createFinisherTask(CountDownLatch latch, ResultsAccumulator accumulator, ProgressIndicator indicator) {
        return ConcurrencyUtil.underThreadNameRunnable("SE-FinisherTask", () -> {
            try {
                latch.await();
                if (!indicator.isCanceled()) {
                    accumulator.searchFinished();
                }
                indicator.stop();
            }
            catch (InterruptedException e) {
                LOG.debug("Finisher interrupted before search process is finished");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityProviders";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorsAndLimits";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyFound";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulatorSupplier";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/MixedResultsSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/MixedResultsSearcher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performSearch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMoreItems";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performSearch";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11, 12 -> new IllegalStateException(string2);
        };
    }

    private static class ProgressIndicatorWithCancelListener
    extends ProgressIndicatorBase {
        private volatile Runnable cancelCallback = () -> {};

        private ProgressIndicatorWithCancelListener() {
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        @Override
        protected void onRunningChange() {
            if (this.isCanceled()) {
                this.cancelCallback.run();
            }
        }
    }

    private static class ResultsAccumulator {
        private final Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> mySections;
        private final SearchListener myListener;
        private final Executor myNotificationExecutor;
        private final SEResultsEqualityProvider myEqualityProvider;
        private final ProgressIndicator myProgressIndicator;
        private final Map<? extends SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<? extends SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        ResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SearchListener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            this(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> new ArrayList((Integer)entry.getValue()))), contributorsAndLimits, equalityProvider, listener2, notificationExecutor, progressIndicator);
        }

        public void searchStarted(@NotNull String pattern) {
            if (pattern == null) {
                ResultsAccumulator.$$$reportNull$$$0(0);
            }
            this.runInNotificationExecutor(() -> this.myListener.searchStarted(pattern, this.sectionsLimits.keySet()));
        }

        ResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SearchListener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            this.mySections = alreadyFound;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
            this.myProgressIndicator = progressIndicator;
            this.sectionsLimits = new HashMap(contributorsAndLimits);
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c2 -> this.lock.newCondition()));
        }

        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) throws InterruptedException {
            SearchEverywhereMlService mlService = SearchEverywhereMlService.getInstance();
            SearchEverywhereFoundElementInfo newElementInfo = mlService == null ? new SearchEverywhereFoundElementInfo(element, priority, contributor) : mlService.createFoundElementInfo(contributor, element, priority);
            Condition condition = this.conditionsMap.get(contributor);
            Collection<SearchEverywhereFoundElementInfo> section = this.mySections.get(contributor);
            int limit2 = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                boolean isNotified = false;
                while (section.size() >= limit2 && !this.mySearchFinished) {
                    indicator.checkCanceled();
                    ProgressManager.checkCanceled();
                    if (!isNotified) {
                        this.runInNotificationExecutor(() -> this.myListener.contributorWaits(contributor));
                        isNotified = true;
                    }
                    condition.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                List alreadyFoundItems = this.mySections.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                SEResultsEqualityProvider.SEEqualElementsActionType action2 = this.myEqualityProvider.compareItems(newElementInfo, alreadyFoundItems);
                if (Registry.is("search.everywhere.recent.at.top") && action2 instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace) {
                    SEResultsEqualityProvider.SEEqualElementsActionType.Replace replaceAction = (SEResultsEqualityProvider.SEEqualElementsActionType.Replace)action2;
                    action2 = ResultsAccumulator.fixReplaceAction(replaceAction);
                }
                if (action2 == SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                    boolean replaceAction = true;
                    return replaceAction;
                }
                section.add(newElementInfo);
                this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                List<SearchEverywhereFoundElementInfo> toRemove2 = action2 instanceof SEResultsEqualityProvider.SEEqualElementsActionType.Replace ? ((SEResultsEqualityProvider.SEEqualElementsActionType.Replace)action2).getToBeReplaced() : Collections.emptyList();
                toRemove2.forEach(info2 -> {
                    Collection<SearchEverywhereFoundElementInfo> list2 = this.mySections.get(info2.getContributor());
                    Condition listCondition = this.conditionsMap.get(info2.getContributor());
                    list2.remove(info2);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info2.getElement().toString(), info2.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit2) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private static SEResultsEqualityProvider.SEEqualElementsActionType fixReplaceAction(SEResultsEqualityProvider.SEEqualElementsActionType.Replace action2) {
            String recentContributorID = RecentFilesSEContributor.class.getSimpleName();
            List<SearchEverywhereFoundElementInfo> updatedList = ContainerUtil.filter(action2.getToBeReplaced(), info2 -> !recentContributorID.equals(info2.getContributor().getSearchProviderId()));
            return updatedList.isEmpty() ? SEResultsEqualityProvider.SEEqualElementsActionType.Skip.INSTANCE : new SEResultsEqualityProvider.SEEqualElementsActionType.Replace(updatedList);
        }

        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                Boolean hasMore = this.hasMoreMap.get(contributor);
                this.runInNotificationExecutor(() -> this.myListener.contributorFinished(contributor, hasMore != null && hasMore != false));
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.mySections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            Integer limit2 = this.sectionsLimits.get(contributor);
            return limit2 == null || this.mySections.get(contributor).size() >= limit2;
        }

        private void runInNotificationExecutor(Runnable runnable) {
            this.myNotificationExecutor.execute(() -> {
                if (!this.myProgressIndicator.isCanceled()) {
                    runnable.run();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/actions/searcheverywhere/MixedResultsSearcher$ResultsAccumulator", "searchStarted"));
        }
    }

    private static final class ContributorSearchTask<Item>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<Item> myContributor;
        private final String myPattern;
        private final ProgressIndicator myIndicator;
        private boolean firstElementReported;

        private ContributorSearchTask(SearchEverywhereContributor<Item> contributor, String pattern, ResultsAccumulator accumulator, ProgressIndicator indicator, Runnable callback) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator;
            this.finishCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", this.myContributor);
            SearchingProcessStatisticsCollector.searchStarted(this.myContributor);
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        if (this.myContributor instanceof WeightedSearchEverywhereContributor) {
                            ((WeightedSearchEverywhereContributor)this.myContributor).fetchWeightedElements(this.myPattern, wrapperIndicator, descriptor2 -> this.processFoundItem(descriptor2.getItem(), descriptor2.getWeight(), wrapperIndicator));
                            continue;
                        }
                        this.myContributor.fetchElements(this.myPattern, wrapperIndicator, element -> {
                            int priority = this.myContributor.getElementPriority(Objects.requireNonNull(element), this.myPattern);
                            return this.processFoundItem(element, priority, wrapperIndicator);
                        });
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", this.myContributor);
        }

        private boolean processFoundItem(Item element, int priority, ProgressIndicator wrapperIndicator) {
            try {
                if (element == null) {
                    LOG.debug("Skip null element");
                    return true;
                }
                this.reportElementOnce();
                boolean added = this.myAccumulator.addElement(element, this.myContributor, priority, wrapperIndicator);
                if (!added) {
                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                }
                return added;
            }
            catch (InterruptedException e) {
                LOG.warn("Search task was interrupted");
                return false;
            }
        }

        private void reportElementOnce() {
            if (this.firstElementReported) {
                return;
            }
            this.firstElementReported = true;
            SearchingProcessStatisticsCollector.elementFound(this.myContributor);
        }
    }
}

