/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MixedSearchListModel
extends SearchListModel {
    private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors = new HashMap();
    private Comparator<? super SearchEverywhereFoundElementInfo> myElementsComparator = SearchEverywhereFoundElementInfo.COMPARATOR.reversed();
    private int myMaxFrozenIndex = -1;

    MixedSearchListModel() {
    }

    public void setElementsComparator(Comparator<? super SearchEverywhereFoundElementInfo> elementsComparator) {
        this.myElementsComparator = elementsComparator;
    }

    @Override
    public boolean hasMoreElements(SearchEverywhereContributor<?> contributor) {
        return Boolean.TRUE.equals(this.hasMoreContributors.get(contributor));
    }

    @Override
    public int getIndexToScroll(int currentIndex, boolean scrollDown) {
        return scrollDown ? this.getSize() - 1 : 0;
    }

    @Override
    public void addElements(List<? extends SearchEverywhereFoundElementInfo> items2) {
        if (items2.isEmpty()) {
            return;
        }
        items2 = items2.stream().sorted(this.myElementsComparator).collect(Collectors.toList());
        if (this.resultsExpired) {
            int lastIndex = this.listElements.size() - 1;
            this.listElements.clear();
            if (lastIndex >= 0) {
                this.fireIntervalRemoved(this, 0, lastIndex);
            }
            this.listElements.addAll(items2);
            if (!this.listElements.isEmpty()) {
                this.fireIntervalAdded(this, 0, this.listElements.size() - 1);
            }
            this.resultsExpired = false;
        } else {
            int startIndex = this.listElements.size();
            this.listElements.addAll(items2);
            int endIndex = this.listElements.size() - 1;
            this.fireIntervalAdded(this, startIndex, endIndex);
            if (this.myMaxFrozenIndex >= startIndex) {
                this.myMaxFrozenIndex = startIndex - 1;
            }
            if (startIndex > 0) {
                List<? super SearchEverywhereFoundElementInfo> lst = this.myMaxFrozenIndex >= 0 ? this.listElements.subList(this.myMaxFrozenIndex + 1, this.listElements.size()) : this.listElements;
                lst.sort(this.myElementsComparator);
                int begin = this.myMaxFrozenIndex >= 0 ? this.myMaxFrozenIndex + 1 : 0;
                this.fireContentsChanged(this, begin, endIndex);
            }
        }
    }

    @Override
    public void clearMoreItems() {
        if (this.listElements.isEmpty()) {
            return;
        }
        int lastItemIndex = this.listElements.size() - 1;
        SearchEverywhereFoundElementInfo lastItem = (SearchEverywhereFoundElementInfo)this.listElements.get(lastItemIndex);
        if (lastItem.getElement() == MORE_ELEMENT) {
            this.listElements.remove(lastItemIndex);
            this.fireIntervalRemoved(this, lastItemIndex, lastItemIndex);
        }
    }

    @Override
    public void removeElement(@NotNull Object item, SearchEverywhereContributor<?> contributor) {
        if (item == null) {
            MixedSearchListModel.$$$reportNull$$$0(0);
        }
        if (this.listElements.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.listElements.size(); ++i2) {
            SearchEverywhereFoundElementInfo info2 = (SearchEverywhereFoundElementInfo)this.listElements.get(i2);
            if (info2.getContributor() != contributor || !info2.getElement().equals(item)) continue;
            this.listElements.remove(i2);
            int newSize = this.getSize();
            if (this.myMaxFrozenIndex >= newSize) {
                this.myMaxFrozenIndex = newSize - 1;
            }
            this.fireIntervalRemoved(this, i2, i2);
            return;
        }
    }

    @Override
    public void setHasMore(SearchEverywhereContributor<?> contributor, boolean contributorHasMore) {
        this.hasMoreContributors.put(contributor, contributorHasMore);
        int lasItemIndex = this.listElements.size() - 1;
        if (lasItemIndex < 0) {
            return;
        }
        boolean hasMore = ContainerUtil.exists(this.hasMoreContributors.values(), Conditions.is(true));
        boolean alreadyHas = this.isMoreElement(lasItemIndex);
        if (alreadyHas && !hasMore) {
            this.listElements.remove(lasItemIndex);
            this.fireIntervalRemoved(this, lasItemIndex, lasItemIndex);
        }
        if (!alreadyHas && hasMore) {
            this.listElements.add(new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, null));
            this.fireIntervalAdded(this, ++lasItemIndex, lasItemIndex);
        }
    }

    @Override
    public void freezeElements() {
        if (this.listElements.isEmpty()) {
            return;
        }
        this.myMaxFrozenIndex = this.listElements.size() - 1;
        if (this.listElements.get(this.myMaxFrozenIndex) == MORE_ELEMENT) {
            --this.myMaxFrozenIndex;
        }
    }

    @Override
    public void clear() {
        this.hasMoreContributors.clear();
        this.myMaxFrozenIndex = -1;
        super.clear();
    }

    @Override
    public void expireResults() {
        super.expireResults();
        this.myMaxFrozenIndex = -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/actions/searcheverywhere/MixedSearchListModel", "removeElement"));
    }
}

