/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class RecentFilesSEContributor
extends FileSearchEverywhereContributor {
    public RecentFilesSEContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(0);
        }
        super(event);
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string2 = RecentFilesSEContributor.class.getSimpleName();
        if (string2 == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getGroupName() {
        String string2 = IdeBundle.message((String)"search.everywhere.group.name.recent.files", (Object[])new Object[0]);
        if (string2 == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public int getSortWeight() {
        return 70;
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(3);
        }
        if (searchPattern == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(4);
        }
        return super.getElementPriority(element, searchPattern) + 5;
    }

    @Override
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer2) {
        if (pattern == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(6);
        }
        if (consumer2 == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(7);
        }
        if (this.myProject == null) {
            return;
        }
        String searchString = this.filterControlSymbols(pattern);
        boolean preferStartMatches = !searchString.startsWith("*");
        MinusculeMatcher matcher = RecentFilesSEContributor.createMatcher(searchString, preferStartMatches);
        List<VirtualFile> opened = Arrays.asList(FileEditorManager.getInstance(this.myProject).getSelectedFiles());
        List history = Lists.reverse((List)EditorHistoryManager.getInstance((Project)this.myProject).getFileList());
        ArrayList res = new ArrayList();
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            PsiManager psiManager = PsiManager.getInstance(this.myProject);
            StreamEx stream = StreamEx.of((Collection)history);
            if (!StringUtil.isEmptyOrSpaces(searchString)) {
                stream = (StreamEx)stream.filter(file2 -> matcher.matches(file2.getName()));
            }
            ((StreamEx)((StreamEx)stream.filter(vf -> !opened.contains(vf) && vf.isValid())).distinct()).map(vf -> {
                PsiFile f = psiManager.findFile((VirtualFile)vf);
                String name = vf.getName();
                return f == null ? null : new FoundItemDescriptor<PsiFile>(f, matcher.matchingDegree(name));
            }).nonNull().into((Collection)res);
            ContainerUtil.process(res, consumer2);
        }, (ProgressIndicator)progressIndicator);
    }

    private static MinusculeMatcher createMatcher(String searchString, boolean preferStartMatches) {
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)("*" + searchString));
        if (preferStartMatches) {
            builder2 = builder2.preferringStartMatches();
        }
        return builder2.build();
    }

    @Override
    public boolean isEmptyPatternSupported() {
        return true;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/RecentFilesSEContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/RecentFilesSEContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchWeightedElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

