/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SENewUIHeaderView;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersStatisticsCollector;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.TabsCustomizationStrategy;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.util.gotoByName.SearchEverywhereConfiguration;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereHeader {
    @NotNull
    private final Runnable myScopeChangedCallback;
    private final Function<? super String, String> myShortcutSupplier;
    private final List<SETab> myTabs;
    private SETab mySelectedTab;
    @Nullable
    private final Project myProject;
    @NotNull
    private final JComponent header;
    @Nullable
    private SENewUIHeaderView newUIHeaderView;
    @NotNull
    private final ActionToolbar myToolbar;
    private boolean myEverywhereAutoSet;

    public SearchEverywhereHeader(@Nullable Project project2, List<SearchEverywhereContributor<?>> contributors, @NotNull Runnable scopeChangedCallback, Function<? super String, String> shortcutSupplier, @Nullable AnAction showInFindToolWindowAction, SearchEverywhereUI ui) {
        if (scopeChangedCallback == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(0);
        }
        this.myEverywhereAutoSet = true;
        this.myScopeChangedCallback = scopeChangedCallback;
        this.myProject = project2;
        this.myShortcutSupplier = shortcutSupplier;
        this.myTabs = this.createTabs(contributors);
        this.mySelectedTab = this.myTabs.get(0);
        this.myToolbar = this.createToolbar(showInFindToolWindowAction);
        this.header = ExperimentalUI.isNewUI() ? this.createNewUITabs() : this.createHeader();
        MessageBusConnection busConnection = this.myProject != null ? this.myProject.getMessageBus().connect(ui) : ApplicationManager.getApplication().getMessageBus().connect(ui);
        busConnection.subscribe(AnActionListener.TOPIC, new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (action2 == SearchEverywhereHeader.this.mySelectedTab.everywhereAction && event.getInputEvent() != null) {
                    SearchEverywhereHeader.this.myEverywhereAutoSet = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$1";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        scopeChangedCallback.run();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.header;
        if (jComponent == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    public void toggleEverywhere() {
        this.myEverywhereAutoSet = false;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(!this.mySelectedTab.everywhereAction.isEverywhere());
        this.myToolbar.updateActionsImmediately();
    }

    @NotNull
    private ActionToolbar createToolbar(@Nullable AnAction showInFindToolWindowAction) {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.addAction((AnAction)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (e == null || SearchEverywhereHeader.this.mySelectedTab == null) {
                    if (EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }
                AnAction[] anActionArray = SearchEverywhereHeader.this.mySelectedTab.actions.toArray(EMPTY_ARRAY);
                if (anActionArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$2", "getChildren"));
            }
        });
        if (showInFindToolWindowAction != null) {
            actionGroup2.addAction(showInFindToolWindowAction);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup2, true);
        toolbar.setLayoutPolicy(0);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder(JBUI.Borders.empty(2, 18, 2, 9));
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(2);
        }
        return actionToolbar;
    }

    @NotNull
    private JComponent createHeader() {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        for (final SETab tab : this.myTabs) {
            SETabLabel tabLabel = new SETabLabel(tab);
            @NlsSafe String shortcut = this.myShortcutSupplier.apply(tab.getID());
            if (shortcut != null) {
                tabLabel.setToolTipText(shortcut);
            }
            tabLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchEverywhereHeader.this.switchToTab(tab);
                    SearchEverywhereUsageTriggerCollector.TAB_SWITCHED.log(SearchEverywhereHeader.this.myProject, new EventPair[]{SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)tab.getReportableID()), EventFields.InputEventByMouseEvent.with((Object)e)});
                }
            });
            contributorsPanel.add(tabLabel);
        }
        this.myToolbar.setTargetComponent((JComponent)contributorsPanel);
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)contributorsPanel, "West");
        result2.add((Component)this.myToolbar.getComponent(), "East");
        JPanel jPanel = result2;
        if (jPanel == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    private JComponent createNewUITabs() {
        this.newUIHeaderView = new SENewUIHeaderView(this.myTabs, this.myShortcutSupplier, this.myToolbar.getComponent());
        this.newUIHeaderView.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SETab selectedTab = SearchEverywhereHeader.this.myTabs.get(SearchEverywhereHeader.this.newUIHeaderView.tabbedPane.getSelectedIndex());
                SearchEverywhereHeader.this.switchToTab(selectedTab);
                SearchEverywhereUsageTriggerCollector.TAB_SWITCHED.log(SearchEverywhereHeader.this.myProject, new EventPair[]{SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)selectedTab.getReportableID())});
            }
        });
        this.myToolbar.setTargetComponent((JComponent)this.newUIHeaderView.panel);
        DialogPanel dialogPanel = this.newUIHeaderView.panel;
        if (dialogPanel == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(4);
        }
        return dialogPanel;
    }

    private List<SETab> createTabs(List<? extends SearchEverywhereContributor<?>> contributors) {
        ArrayList<SETab> res = new ArrayList<SETab>();
        contributors = contributors.stream().sorted(Comparator.comparingInt(SearchEverywhereContributor::getSortWeight)).collect(Collectors.toList());
        Runnable onChanged2 = () -> {
            this.myToolbar.updateActionsImmediately();
            this.myScopeChangedCallback.run();
        };
        if (contributors.size() > 1) {
            SETab allTab = this.createAllTab(contributors, onChanged2);
            res.add(allTab);
        }
        TabsCustomizationStrategy.getInstance().getSeparateTabContributors(contributors).forEach(contributor -> {
            SETab tab = SearchEverywhereHeader.createTab(contributor, onChanged2);
            res.add(tab);
        });
        return res;
    }

    private static PersistentSearchEverywhereContributorFilter<String> createContributorsFilter(List<? extends SearchEverywhereContributor<?>> contributors) {
        Map<K, @Nls V> namesMap = ContainerUtil.map2Map(contributors, c2 -> Pair.create(c2.getSearchProviderId(), c2.getFullGroupName()));
        return new PersistentSearchEverywhereContributorFilter<String>(ContainerUtil.map(contributors, c2 -> c2.getSearchProviderId()), SearchEverywhereConfiguration.getInstance(), namesMap::get, c2 -> null);
    }

    public List<SETab> getTabs() {
        return this.myTabs;
    }

    @NotNull
    public SETab getSelectedTab() {
        SETab sETab = this.mySelectedTab;
        if (sETab == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(5);
        }
        return sETab;
    }

    public void switchToTab(SETab tab) {
        if (!this.myTabs.contains(tab)) {
            throw new IllegalArgumentException(String.format("Tab %s is not found in tabs list", tab.toString()));
        }
        this.mySelectedTab.setSelected(false);
        this.mySelectedTab = tab;
        this.mySelectedTab.setSelected(true);
        if (this.newUIHeaderView != null) {
            this.newUIHeaderView.tabbedPane.setSelectedIndex(this.myTabs.indexOf(tab));
        }
        if (this.myEverywhereAutoSet && this.isEverywhere() && this.canToggleEverywhere()) {
            this.autoSetEverywhere(false);
        }
        this.myToolbar.updateActionsImmediately();
        this.header.repaint();
        this.myScopeChangedCallback.run();
    }

    public void switchToNextTab() {
        int index2 = this.myTabs.indexOf(this.mySelectedTab);
        if (++index2 >= this.myTabs.size()) {
            index2 = 0;
        }
        this.switchToTab(this.myTabs.get(index2));
    }

    public void switchToPrevTab() {
        int index2 = this.myTabs.indexOf(this.mySelectedTab);
        if (--index2 < 0) {
            index2 = this.myTabs.size() - 1;
        }
        this.switchToTab(this.myTabs.get(index2));
    }

    public void autoSetEverywhere(boolean everywhere) {
        if (everywhere == this.isEverywhere()) {
            return;
        }
        this.myEverywhereAutoSet = true;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(everywhere);
        this.myToolbar.updateActionsImmediately();
    }

    public boolean canSetEverywhere() {
        return this.myEverywhereAutoSet && this.canToggleEverywhere();
    }

    public boolean canResetScope() {
        return Boolean.TRUE.equals(ObjectUtils.doIfNotNull(this.mySelectedTab.everywhereAction, action2 -> !action2.isEverywhere()));
    }

    public void resetScope() {
        ObjectUtils.consumeIfNotNull(this.mySelectedTab.everywhereAction, action2 -> action2.setEverywhere(true));
    }

    public boolean isEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return true;
        }
        return this.mySelectedTab.everywhereAction.isEverywhere();
    }

    private boolean canToggleEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return false;
        }
        return this.mySelectedTab.everywhereAction.canToggleEverywhere();
    }

    private static SETab createTab(@NotNull SearchEverywhereContributor<?> contributor, Runnable onChanged2) {
        if (contributor == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(6);
        }
        return new SETab(contributor.getSearchProviderId(), contributor.getGroupName(), Collections.singletonList(contributor), contributor.getActions(onChanged2), null);
    }

    @NotNull
    private SETab createAllTab(List<? extends SearchEverywhereContributor<?>> contributors, final @NotNull Runnable onChanged2) {
        if (onChanged2 == null) {
            SearchEverywhereHeader.$$$reportNull$$$0(7);
        }
        String actionText = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
        PersistentSearchEverywhereContributorFilter<String> filter2 = SearchEverywhereHeader.createContributorsFilter(contributors);
        List<AnAction> actions = Arrays.asList(new CheckBoxSearchEverywhereToggleAction(actionText){
            final SearchEverywhereManagerImpl seManager;
            {
                super(text2);
                this.seManager = (SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereHeader.this.myProject);
            }

            @Override
            public boolean isEverywhere() {
                return this.seManager.isEverywhere();
            }

            @Override
            public void setEverywhere(boolean state) {
                if (this.isEverywhere() == state) {
                    return;
                }
                this.seManager.setEverywhere(state);
                SearchEverywhereHeader.this.myTabs.forEach(tab -> {
                    if (tab.everywhereAction != null) {
                        tab.everywhereAction.setEverywhere(state);
                    }
                });
                onChanged2.run();
            }
        }, new SearchEverywhereFiltersAction<String>(filter2, onChanged2, new SearchEverywhereFiltersStatisticsCollector.ContributorFilterCollector()));
        return new SETab("SearchEverywhereContributor.All", IdeBundle.message((String)"searcheverywhere.allelements.tab.name", (Object[])new Object[0]), contributors, actions, filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeChangedCallback";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewUITabs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAllTab";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }

    public static class SETab {
        @NotNull
        @NonNls
        private final String id;
        private final @NlsContexts.Label @NotNull String name;
        @NotNull
        private final List<SearchEverywhereContributor<?>> contributors;
        private final List<AnAction> actions;
        @Nullable
        private final SearchEverywhereToggleAction everywhereAction;
        @Nullable
        private final PersistentSearchEverywhereContributorFilter<String> myContributorsFilter;
        @Nullable
        private final PersistentSearchEverywhereContributorFilter<?> myFilterToReset;
        private boolean isSelected;

        public SETab(@NonNls @NotNull String id, @NlsContexts.Label @NotNull String name, @NotNull List<? extends SearchEverywhereContributor<?>> contributors, List<AnAction> actions, @Nullable PersistentSearchEverywhereContributorFilter<String> filter2) {
            if (id == null) {
                SETab.$$$reportNull$$$0(0);
            }
            if (name == null) {
                SETab.$$$reportNull$$$0(1);
            }
            if (contributors == null) {
                SETab.$$$reportNull$$$0(2);
            }
            this.isSelected = false;
            this.name = name;
            this.myContributorsFilter = filter2;
            assert (contributors.size() > 0) : "Contributors list cannot be empty";
            this.id = id;
            this.contributors = new ArrayList(contributors);
            this.actions = actions;
            this.everywhereAction = (SearchEverywhereToggleAction)((Object)ContainerUtil.find(actions, o -> o instanceof SearchEverywhereToggleAction));
            this.myFilterToReset = actions.stream().filter(a -> a instanceof SearchEverywhereFiltersAction).findAny().map(a -> ((SearchEverywhereFiltersAction)a).getFilter()).orElse(null);
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        @NotNull
        @NonNls
        public String getID() {
            String string2 = this.id;
            if (string2 == null) {
                SETab.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @NlsContexts.Label
        @NotNull
        public String getName() {
            String string2 = this.name;
            if (string2 == null) {
                SETab.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public String getReportableID() {
            if (!this.isSingleContributor()) {
                return this.getID();
            }
            return SearchEverywhereUsageTriggerCollector.getReportableContributorID(this.contributors.get(0));
        }

        public boolean isSingleContributor() {
            return this.contributors.size() == 1;
        }

        @NotNull
        public List<SearchEverywhereContributor<?>> getContributors() {
            if (this.myContributorsFilter == null) {
                List<SearchEverywhereContributor<?>> list2 = this.contributors;
                if (list2 == null) {
                    SETab.$$$reportNull$$$0(5);
                }
                return list2;
            }
            List<SearchEverywhereContributor<?>> list3 = ContainerUtil.filter(this.contributors, contributor -> this.myContributorsFilter.isSelected(contributor.getSearchProviderId()));
            if (list3 == null) {
                SETab.$$$reportNull$$$0(6);
            }
            return list3;
        }

        public boolean canClearFilter() {
            return this.myFilterToReset != null && SETab.canClearFilter(this.myFilterToReset);
        }

        private static <T> boolean canClearFilter(@NotNull PersistentSearchEverywhereContributorFilter<T> filter2) {
            if (filter2 == null) {
                SETab.$$$reportNull$$$0(7);
            }
            return ContainerUtil.exists(filter2.getAllElements(), o -> !filter2.isSelected(o));
        }

        public void clearFilter() {
            if (this.myFilterToReset != null) {
                SETab.doClearFilter(this.myFilterToReset);
            }
        }

        private static <T> void doClearFilter(@NotNull PersistentSearchEverywhereContributorFilter<T> filter2) {
            if (filter2 == null) {
                SETab.$$$reportNull$$$0(8);
            }
            filter2.getAllElements().forEach(s -> filter2.setSelected(s, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributors";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$SETab";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$SETab";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getID";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "canClearFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doClearFilter";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    private static class SETabLabel
    extends JLabel {
        private final SETab seTab;

        private SETabLabel(@NotNull SETab tab) {
            if (tab == null) {
                SETabLabel.$$$reportNull$$$0(0);
            }
            super(tab.getName());
            this.seTab = tab;
            Insets insets = JBUI.CurrentTheme.BigPopup.tabInsets();
            this.setBorder(JBUI.Borders.empty(insets.top, insets.left, insets.bottom, insets.right));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUIScale.scale(29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return this.seTab != null && this.seTab.isSelected;
        }

        @Override
        public Color getBackground() {
            return this.seTab != null && this.seTab.isSelected ? JBUI.CurrentTheme.BigPopup.selectedTabColor() : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.seTab != null && this.seTab.isSelected ? JBUI.CurrentTheme.BigPopup.selectedTabTextColor() : super.getForeground();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tab", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereHeader$SETabLabel", "<init>"));
        }
    }
}

