/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.RunConfigurationsSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorValidationRule;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.TopHitSEContributor;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchEverywhereManagerImpl
implements SearchEverywhereManager {
    public static final String ALL_CONTRIBUTORS_GROUP_ID = "SearchEverywhereContributor.All";
    public static final String LOCATION_SETTINGS_KEY = "search.everywhere.popup";
    public static final DataKey<Boolean> IS_SELECT_SEARCH_TEXT = DataKey.create((String)"search.everywhere.is.select.search.text");
    private final Map<String, String> myTabsShortcutsMap;
    private final Project myProject;
    private JBPopup myBalloon;
    private SearchEverywhereUI mySearchEverywhereUI;
    private Dimension myBalloonFullSize;
    private final SearchHistoryList myHistoryList = new SearchHistoryList();
    private final Map<String, Object> myPrevSelections = new HashMap<String, Object>();
    private HistoryIterator myHistoryIterator;
    private boolean myEverywhere;

    public SearchEverywhereManagerImpl() {
        this.myProject = null;
        this.myTabsShortcutsMap = Collections.emptyMap();
    }

    public SearchEverywhereManagerImpl(Project project2) {
        this.myProject = project2;
        this.myTabsShortcutsMap = SearchEverywhereManagerImpl.createShortcutsMap();
    }

    @Override
    public void show(@NotNull String tabID, @Nullable String searchText, @NotNull AnActionEvent initEvent) {
        if (tabID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(0);
        }
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.isShown()) {
            throw new IllegalStateException("Method should cannot be called when popup is shown");
        }
        Project project2 = initEvent.getProject();
        Component contextComponent = (Component)initEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        List<SearchEverywhereContributor<?>> contributors = this.createContributors(initEvent, project2, contextComponent);
        SearchEverywhereContributorValidationRule.updateContributorsMap(contributors);
        this.mySearchEverywhereUI = this.createView(this.myProject, contributors);
        contributors.forEach(c2 -> Disposer.register(this.mySearchEverywhereUI, c2));
        this.mySearchEverywhereUI.switchToTab(tabID);
        this.myHistoryIterator = this.myHistoryList.getIterator(tabID);
        boolean suppressHistory = SystemProperties.getBooleanProperty("idea.searchEverywhere.noHistory", false);
        boolean bl = suppressHistory = suppressHistory || ALL_CONTRIBUTORS_GROUP_ID.equals(tabID) && Registry.is("search.everywhere.disable.history.for.all");
        if (searchText == null && !suppressHistory) {
            searchText = this.myHistoryIterator.prev();
        }
        this.myBalloon = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.mySearchEverywhereUI, (JComponent)this.mySearchEverywhereUI.getSearchField()).setProject(this.myProject).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).setCancelCallback(() -> {
            this.saveSearchText();
            SearchEverywhereUsageTriggerCollector.DIALOG_CLOSED.log(this.myProject);
            return true;
        }).setResizable(true).setMovable(true).setDimensionServiceKey(project2, LOCATION_SETTINGS_KEY, true).setLocateWithinScreenBounds(false).createPopup();
        Disposer.register((Disposable)this.myBalloon, this.mySearchEverywhereUI);
        OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick(this.myBalloon.getContent());
        if (project2 != null) {
            Disposer.register(project2, (Disposable)this.myBalloon);
        }
        Dimension size = this.mySearchEverywhereUI.getMinimumSize();
        JBInsets.addTo(size, this.myBalloon.getContent().getInsets());
        this.myBalloon.setMinimumSize(size);
        ComponentManager dataHolder = this.myProject != null ? project2 : ApplicationManager.getApplication();
        ConcurrentHashMap<ClientId, Object> map2 = dataHolder.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        if (map2 == null) {
            map2 = new ConcurrentHashMap();
            dataHolder.putUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP, map2);
        }
        map2.put(ClientId.getCurrent(), this.myBalloon);
        if (searchText != null && !searchText.isEmpty()) {
            this.mySearchEverywhereUI.getSearchField().setText(searchText);
            if (!Boolean.FALSE.equals(initEvent.getData(IS_SELECT_SEARCH_TEXT))) {
                this.mySearchEverywhereUI.getSearchField().selectAll();
            }
        }
        Disposer.register((Disposable)this.myBalloon, () -> {
            this.saveSize();
            Objects.requireNonNull(dataHolder.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP)).remove(ClientId.getCurrent());
            this.mySearchEverywhereUI = null;
            this.myBalloon = null;
            this.myBalloonFullSize = null;
        });
        this.myBalloonFullSize = this.getStateService().getSize(LOCATION_SETTINGS_KEY);
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            Dimension prefSize = this.mySearchEverywhereUI.getPreferredSize();
            this.myBalloon.setSize(prefSize);
        }
        this.calcPositionAndShow(initEvent, project2, this.myBalloon);
    }

    @Override
    @NotNull
    public SearchEverywhereUI getCurrentlyShownUI() {
        this.checkIsShown();
        SearchEverywhereUI searchEverywhereUI = this.mySearchEverywhereUI;
        if (searchEverywhereUI == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(2);
        }
        return searchEverywhereUI;
    }

    private WindowStateService getStateService() {
        return this.myProject != null ? WindowStateService.getInstance((Project)this.myProject) : WindowStateService.getInstance();
    }

    private List<SearchEverywhereContributor<?>> createContributors(@NotNull AnActionEvent initEvent, Project project2, Component contextComponent) {
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            ActionSearchEverywhereContributor.Factory factory2 = new ActionSearchEverywhereContributor.Factory();
            return Collections.singletonList(factory2.createContributor(initEvent));
        }
        ArrayList res = new ArrayList();
        res.add(new TopHitSEContributor(project2, contextComponent, s -> this.mySearchEverywhereUI.getSearchField().setText((String)s)));
        res.add(PSIPresentationBgRendererWrapper.wrapIfNecessary(new RecentFilesSEContributor(initEvent)));
        res.add(new RunConfigurationsSEContributor(project2, contextComponent, () -> this.mySearchEverywhereUI.getSearchField().getText()));
        for (SearchEverywhereContributorFactory<?> factory3 : SearchEverywhereContributor.EP_NAME.getExtensionList()) {
            if (!factory3.isAvailable(project2)) continue;
            SearchEverywhereContributor<?> contributor = factory3.createContributor(initEvent);
            res.add(contributor);
        }
        return res;
    }

    private void calcPositionAndShow(@NotNull AnActionEvent initEvent, Project project2, JBPopup balloon) {
        Window window;
        Component parent2;
        if (initEvent == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(4);
        }
        if (initEvent.getPlace().equals("RunToolbarLeftSide")) {
            Component component2 = (Component)initEvent.getInputEvent().getSource();
            balloon.setLocation(component2.getLocationOnScreen());
            ((AbstractPopup)balloon).show(component2, 0, 0, true);
            return;
        }
        Point savedLocation = this.getStateService().getLocation(LOCATION_SETTINGS_KEY);
        if (savedLocation == null && this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT && (parent2 = UIUtil.findUltimateParent(window = project2 != null ? WindowManager.getInstance().suggestParentWindow(project2) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) != null) {
            JComponent content2 = balloon.getContent();
            Dimension balloonSize = content2.getPreferredSize();
            Point screenPoint = new Point((parent2.getSize().width - balloonSize.width) / 2, parent2.getHeight() / 4 - balloonSize.height / 2);
            SwingUtilities.convertPointToScreen(screenPoint, parent2);
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle(screenPoint);
            Insets insets = content2.getInsets();
            int bottomEdge = screenPoint.y + this.mySearchEverywhereUI.getExpandedSize().height + insets.bottom + insets.top;
            int shift = bottomEdge - (int)screenRectangle.getMaxY();
            if (shift > 0) {
                screenPoint.y = Integer.max(screenPoint.y - shift, screenRectangle.y);
            }
            RelativePoint showPoint = new RelativePoint(screenPoint);
            balloon.show(showPoint);
            return;
        }
        if (project2 != null) {
            balloon.showCenteredInCurrentWindow(project2);
        } else {
            balloon.showInFocusCenter();
        }
    }

    @Override
    public boolean isShown() {
        return this.mySearchEverywhereUI != null && this.myBalloon != null && !this.myBalloon.isDisposed();
    }

    @Override
    @NotNull
    public String getSelectedTabID() {
        this.checkIsShown();
        String string2 = this.mySearchEverywhereUI.getSelectedTabID();
        if (string2 == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public void setSelectedTabID(@NotNull String contributorID) {
        if (contributorID == null) {
            SearchEverywhereManagerImpl.$$$reportNull$$$0(6);
        }
        this.checkIsShown();
        if (!contributorID.equals(this.getSelectedTabID())) {
            this.mySearchEverywhereUI.switchToTab(contributorID);
        }
    }

    @Override
    public void toggleEverywhereFilter() {
        this.checkIsShown();
        this.mySearchEverywhereUI.toggleEverywhereFilter();
    }

    @Override
    public boolean isEverywhere() {
        return this.myEverywhere;
    }

    public void setEverywhere(boolean everywhere) {
        this.myEverywhere = everywhere;
    }

    private SearchEverywhereUI createView(Project project2, List<SearchEverywhereContributor<?>> contributors) {
        if (LightEdit.owns((Project)project2)) {
            contributors = ContainerUtil.filter(contributors, contributor -> contributor instanceof LightEditCompatible);
        }
        SearchEverywhereUI view = new SearchEverywhereUI(project2, contributors, this.myTabsShortcutsMap::get);
        view.setSearchFinishedHandler(() -> {
            if (this.isShown()) {
                this.myBalloon.cancel();
            }
        });
        view.addViewTypeListener(viewType -> {
            if (!this.isShown()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myBalloon == null || this.myBalloon.isDisposed()) {
                    return;
                }
                Dimension minSize = view.getMinimumSize();
                JBInsets.addTo(minSize, this.myBalloon.getContent().getInsets());
                this.myBalloon.setMinimumSize(minSize);
                if (viewType == BigPopupUI.ViewType.SHORT) {
                    this.myBalloonFullSize = this.myBalloon.getSize();
                    JBInsets.removeFrom(this.myBalloonFullSize, this.myBalloon.getContent().getInsets());
                    this.myBalloon.pack(false, true);
                } else {
                    if (this.myBalloonFullSize == null) {
                        this.myBalloonFullSize = view.getPreferredSize();
                        JBInsets.addTo(this.myBalloonFullSize, this.myBalloon.getContent().getInsets());
                    }
                    this.myBalloonFullSize.height = Integer.max(this.myBalloonFullSize.height, minSize.height);
                    this.myBalloonFullSize.width = Integer.max(this.myBalloonFullSize.width, minSize.width);
                    this.myBalloon.setSize(this.myBalloonFullSize);
                }
            });
        });
        DumbAwareAction.create(__ -> this.showHistoryItem(true)).registerCustomShortcutSet((ShortcutSet)SearchTextField.SHOW_HISTORY_SHORTCUT, (JComponent)view);
        DumbAwareAction.create(__ -> this.showHistoryItem(false)).registerCustomShortcutSet((ShortcutSet)SearchTextField.ALT_SHOW_HISTORY_SHORTCUT, (JComponent)view);
        return view;
    }

    private void checkIsShown() {
        if (!this.isShown()) {
            throw new IllegalStateException("Method should be called only when search popup is shown");
        }
    }

    private void saveSearchText() {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        String searchText = this.mySearchEverywhereUI.getSearchField().getText();
        if (!searchText.isEmpty()) {
            this.myHistoryList.saveText(searchText, this.mySearchEverywhereUI.getSelectedTabID());
        }
        this.myPrevSelections.put(this.mySearchEverywhereUI.getSelectedTabID(), this.mySearchEverywhereUI.getSelectionIdentity());
    }

    @Nullable
    public Object getPrevSelection(String contributorID) {
        return this.myPrevSelections.remove(contributorID);
    }

    private void saveSize() {
        if (this.mySearchEverywhereUI.getViewType() == BigPopupUI.ViewType.SHORT) {
            this.getStateService().putSize(LOCATION_SETTINGS_KEY, this.myBalloonFullSize);
        }
    }

    private void showHistoryItem(boolean next2) {
        if (!this.isShown()) {
            return;
        }
        this.updateHistoryIterator();
        JTextField searchField = this.mySearchEverywhereUI.getSearchField();
        searchField.setText(next2 ? this.myHistoryIterator.next() : this.myHistoryIterator.prev());
        searchField.selectAll();
    }

    private void updateHistoryIterator() {
        if (!this.isShown()) {
            return;
        }
        String selectedContributorID = this.mySearchEverywhereUI.getSelectedTabID();
        if (this.myHistoryIterator == null || !this.myHistoryIterator.getContributorID().equals(selectedContributorID)) {
            this.myHistoryIterator = this.myHistoryList.getIterator(selectedContributorID);
        }
    }

    private static Map<String, String> createShortcutsMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(ALL_CONTRIBUTORS_GROUP_ID, "Double Shift");
        SearchEverywhereManagerImpl.addShortcut(res, "ClassSearchEverywhereContributor", "GotoClass");
        SearchEverywhereManagerImpl.addShortcut(res, "FileSearchEverywhereContributor", "GotoFile");
        SearchEverywhereManagerImpl.addShortcut(res, "SymbolSearchEverywhereContributor", "GotoSymbol");
        SearchEverywhereManagerImpl.addShortcut(res, "ActionSearchEverywhereContributor", "GotoAction");
        SearchEverywhereManagerImpl.addShortcut(res, "DbSETablesContributor", "GotoDatabaseObject");
        SearchEverywhereManagerImpl.addShortcut(res, "TextSearchContributor", "TextSearchAction");
        return res;
    }

    private static void addShortcut(Map<String, String> map2, String contributorID, String actionID) {
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(actionID);
        if (shortcut != null) {
            map2.put(contributorID, KeymapUtil.getShortcutText((Shortcut)shortcut));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabID";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initEvent";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentlyShownUI";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTabID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContributors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcPositionAndShow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTabID";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5 -> new IllegalStateException(string2);
        };
    }

    private static class SearchHistoryList {
        private static final int HISTORY_LIMIT = 50;
        private final List<HistoryItem> historyList = new ArrayList<HistoryItem>();
        private static final Collector<String, List<String>, List<String>> distinctCollector = Collector.of(() -> new ArrayList(), (lst, str) -> {
            lst.remove(str);
            lst.add(str);
        }, (lst1, lst2) -> {
            lst1.removeAll((Collection<?>)lst2);
            lst1.addAll(lst2);
            return lst1;
        }, new Collector.Characteristics[0]);

        private SearchHistoryList() {
        }

        public HistoryIterator getIterator(String contributorID) {
            List<String> list2 = this.getHistoryForContributor(contributorID);
            return new HistoryIterator(contributorID, list2);
        }

        public void saveText(@NotNull String text2, @NotNull String contributorID) {
            if (text2 == null) {
                SearchHistoryList.$$$reportNull$$$0(0);
            }
            if (contributorID == null) {
                SearchHistoryList.$$$reportNull$$$0(1);
            }
            this.historyList.stream().filter(item -> text2.equals(item.searchText()) && contributorID.equals(item.contributorID())).findFirst().ifPresent(this.historyList::remove);
            this.historyList.add(new HistoryItem(text2, contributorID));
            List<String> list2 = this.filteredHistory(item -> item.contributorID().equals(contributorID));
            if (list2.size() > 50) {
                this.historyList.stream().filter(item -> item.contributorID().equals(contributorID)).findFirst().ifPresent(this.historyList::remove);
            }
        }

        private List<String> getHistoryForContributor(String contributorID) {
            if (SearchEverywhereManagerImpl.ALL_CONTRIBUTORS_GROUP_ID.equals(contributorID)) {
                List<String> res = this.filteredHistory(item -> true);
                int size = res.size();
                return size > 50 ? res.subList(size - 50, size) : res;
            }
            return this.filteredHistory(item -> item.contributorID().equals(contributorID));
        }

        @NotNull
        private List<String> filteredHistory(Predicate<? super HistoryItem> predicate2) {
            List<String> list2 = this.historyList.stream().filter(predicate2).map(item -> item.searchText()).collect(distinctCollector);
            if (list2 == null) {
                SearchHistoryList.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributorID";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereManagerImpl$SearchHistoryList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filteredHistory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "saveText";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }

        private record HistoryItem(String searchText, String contributorID) {
        }
    }

    private static class HistoryIterator {
        private final String contributorID;
        private final List<String> list;
        private int index;

        HistoryIterator(String id, List<String> list2) {
            this.contributorID = id;
            this.list = list2;
            this.index = -1;
        }

        public String getContributorID() {
            return this.contributorID;
        }

        public String next() {
            if (this.list.isEmpty()) {
                return "";
            }
            ++this.index;
            if (this.index >= this.list.size()) {
                this.index = 0;
            }
            return this.list.get(this.index);
        }

        public String prev() {
            if (this.list.isEmpty()) {
                return "";
            }
            --this.index;
            if (this.index < 0) {
                this.index = this.list.size() - 1;
            }
            return this.list.get(this.index);
        }
    }
}

