/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.accessibility.TextFieldWithListAccessibleContext;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.SearchEverywhereItem;
import com.intellij.find.impl.TextSearchRightActionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.AutoCompletionProvider;
import com.intellij.ide.actions.searcheverywhere.GroupedListFactory;
import com.intellij.ide.actions.searcheverywhere.GroupedResultsSearcher;
import com.intellij.ide.actions.searcheverywhere.MixedListFactory;
import com.intellij.ide.actions.searcheverywhere.MixedResultsSearcher;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.SEListSelectionTracker;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchAdapter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMlService;
import com.intellij.ide.actions.searcheverywhere.SearchFieldActionsContributor;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.SearchListenerEx;
import com.intellij.ide.actions.searcheverywhere.SearchProcessLogger;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.actions.searcheverywhere.SlowContributorDetector;
import com.intellij.ide.actions.searcheverywhere.ThrottlingListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.WaitForContributorsListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchFieldStatisticsCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchPerformanceTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SearchEverywhereUI
extends BigPopupUI
implements DataProvider,
QuickSearchComponent {
    public static final String SEARCH_EVERYWHERE_SEARCH_FILED_KEY = "search-everywhere-textfield";
    static final DataKey<SearchEverywhereFoundElementInfo> SELECTED_ITEM_INFO = DataKey.create((String)"selectedItemInfo");
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    private static final Icon SHOW_IN_FIND_TOOL_WINDOW_ICON = ExperimentalUI.isNewUI() ? IconManager.getInstance().getIcon("expui/general/openInToolWindow.svg", AllIcons.class) : AllIcons.General.Pin_tab;
    private final SEResultsListFactory myListFactory;
    private SearchListModel myListModel;
    private final SearchEverywhereHeader myHeader;
    private String myNotFoundString;
    private final SESearcher mySearcher;
    private final MySearchListener mySearchListener;
    private final List<SearchListener> myExternalSearchListeners;
    private ProgressIndicator mySearchProgressIndicator;
    private final SEListSelectionTracker mySelectionTracker;
    private final SearchFieldTypingListener mySearchTypingListener;
    private final HintHelper myHintHelper;
    private final SearchEverywhereMlService myMlService;
    private static final long REBUILD_LIST_DELAY = 100L;
    private final Alarm rebuildListAlarm;
    private final ListCellRenderer<Object> myCommandRenderer;
    private final SearchEverywhereContributor<Object> myStubCommandContributor;

    public SearchEverywhereUI(@Nullable Project project2, List<SearchEverywhereContributor<?>> contributors) {
        this(project2, contributors, s -> null);
    }

    public SearchEverywhereUI(@Nullable Project project2, List<SearchEverywhereContributor<?>> contributors, @NotNull Function<? super String, String> shortcutSupplier) {
        if (shortcutSupplier == null) {
            SearchEverywhereUI.$$$reportNull$$$0(0);
        }
        super(project2);
        this.mySearchListener = new MySearchListener();
        this.myExternalSearchListeners = new ArrayList<SearchListener>();
        this.rebuildListAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myCommandRenderer = new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value, int index2, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                this.setPaintFocusBorder(false);
                this.setIcon(EmptyIcon.ICON_16);
                this.setFont(list2.getFont());
                SearchEverywhereCommandInfo command2 = (SearchEverywhereCommandInfo)value;
                this.append(command2.getCommandWithPrefix() + " ", new SimpleTextAttributes(0, list2.getForeground()));
                this.append(command2.getDefinition(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                this.setBackground(UIUtil.getListBackground(selected, hasFocus));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8", "customizeCellRenderer"));
            }
        };
        this.myStubCommandContributor = new SearchEverywhereContributor<Object>(){

            @Override
            @NotNull
            public String getSearchProviderId() {
                return "CommandsContributor";
            }

            @Override
            @NotNull
            public String getGroupName() {
                String string2 = IdeBundle.message((String)"searcheverywhere.commands.tab.name", (Object[])new Object[0]);
                if (string2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            public int getSortWeight() {
                return 10;
            }

            @Override
            public boolean showInFindResults() {
                return false;
            }

            @Override
            public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super Object> consumer2) {
                if (pattern == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (progressIndicator == null) {
                    9.$$$reportNull$$$0(2);
                }
                if (consumer2 == null) {
                    9.$$$reportNull$$$0(3);
                }
            }

            @Override
            public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
                if (selected == null) {
                    9.$$$reportNull$$$0(4);
                }
                if (searchText == null) {
                    9.$$$reportNull$$$0(5);
                }
                SearchEverywhereUI.this.mySearchField.setText(((SearchEverywhereCommandInfo)selected).getCommandWithPrefix() + " ");
                SearchEverywhereUsageTriggerCollector.COMMAND_COMPLETED.log(SearchEverywhereUI.this.myProject, new EventPair[0]);
                return false;
            }

            @Override
            @NotNull
            public ListCellRenderer<? super Object> getElementsRenderer() {
                ListCellRenderer<Object> listCellRenderer = SearchEverywhereUI.this.myCommandRenderer;
                if (listCellRenderer == null) {
                    9.$$$reportNull$$$0(6);
                }
                return listCellRenderer;
            }

            @Override
            @Nullable
            public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
                if (element == null) {
                    9.$$$reportNull$$$0(7);
                }
                if (dataId == null) {
                    9.$$$reportNull$$$0(8);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4, 5, 7, 8 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$9";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selected";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchText";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGroupName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$9";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementsRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "fetchElements";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "processSelectedItem";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getDataForItem";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string2);
                };
            }
        };
        this.myListFactory = Experiments.getInstance().isFeatureEnabled("search.everywhere.mixed.results") ? new MixedListFactory() : new GroupedListFactory();
        Runnable scopeChangedCallback = () -> {
            this.updateSearchFieldAdvertisement();
            this.scheduleRebuildList(SearchRestartReason.SCOPE_CHANGED);
        };
        this.myHeader = new SearchEverywhereHeader(project2, contributors, scopeChangedCallback, shortcutSupplier, (AnAction)(project2 == null ? null : new ShowInFindToolWindowAction()), this);
        this.init();
        this.myHintHelper = new HintHelper(this.mySearchField);
        List<SEResultsEqualityProvider> equalityProviders = SEResultsEqualityProvider.getProviders();
        SearchListener wrapperListener = this.createListenerWrapper();
        this.mySearcher = Experiments.getInstance().isFeatureEnabled("search.everywhere.mixed.results") ? new MixedResultsSearcher(wrapperListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders) : new GroupedResultsSearcher(wrapperListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
        this.addSearchListener(new SearchProcessLogger());
        this.initSearchActions();
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiSelection;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiSelection = Arrays.stream(selectedIndices).allMatch(i2 -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
                return contributor != null && contributor.isMultiSelectionSupported();
            }))) {
                int index2 = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index2);
            }
        });
        this.mySelectionTracker = new SEListSelectionTracker(this.myResultsList, this.myListModel);
        this.myResultsList.addListSelectionListener((ListSelectionListener)this.mySelectionTracker);
        this.mySearchTypingListener = new SearchFieldTypingListener();
        this.mySearchField.addKeyListener((KeyListener)this.mySearchTypingListener);
        this.myMlService = SearchEverywhereMlService.getInstance();
        if (this.myMlService != null) {
            this.myMlService.onSessionStarted(this.myProject, new SearchEverywhereMixedListInfo(this.myListFactory));
        }
        SearchPerformanceTracker performanceTracker = new SearchPerformanceTracker((Function0<String>)((Function0)() -> this.myHeader.getSelectedTab().getID()));
        this.addSearchListener(performanceTracker);
        Disposer.register(this, SearchFieldStatisticsCollector.createAndStart((JTextField)this.mySearchField, performanceTracker, this.myProject));
    }

    public void addSearchListener(SearchListener listener2) {
        this.myExternalSearchListeners.add(listener2);
    }

    public void removeSearchListener(SearchListener listener2) {
        this.myExternalSearchListeners.remove(listener2);
    }

    @NotNull
    private SearchListener createListenerWrapper() {
        SearchListener wrapper2 = AdvancedSettings.getBoolean((String)"search.everywhere.wait.for.contributors") ? new WaitForContributorsListenerWrapper(this.mySearchListener, this.myListModel, 3000L, 100L, () -> this.getSearchPattern()) : new ThrottlingListenerWrapper(this.mySearchListener);
        Disposer.register(this, wrapper2);
        if (Registry.is("search.everywhere.detect.slow.contributors")) {
            wrapper2 = SearchListener.combine(wrapper2, new SlowContributorDetector());
        }
        Disposable disposable = wrapper2;
        if (disposable == null) {
            SearchEverywhereUI.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    @Override
    @NotNull
    protected ListCellRenderer<Object> createCellRenderer() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ListCellRenderer<Object> listCellRenderer = (list2, value, index2, isSelected, cellHasFocus) -> new JPanel();
            if (listCellRenderer == null) {
                SearchEverywhereUI.$$$reportNull$$$0(2);
            }
            return listCellRenderer;
        }
        ListCellRenderer<Object> listCellRenderer = this.myListFactory.createListRenderer(this.myListModel, this.myHeader);
        if (listCellRenderer == null) {
            SearchEverywhereUI.$$$reportNull$$$0(3);
        }
        return listCellRenderer;
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = this.myListFactory.createModel();
        this.addListDataListener(this.myListModel);
        JBList<Object> jBList = this.myListFactory.createList(this.myListModel);
        if (jBList == null) {
            SearchEverywhereUI.$$$reportNull$$$0(4);
        }
        return jBList;
    }

    public void toggleEverywhereFilter() {
        this.myHeader.toggleEverywhere();
    }

    public void switchToTab(@NotNull String tabID) {
        if (tabID == null) {
            SearchEverywhereUI.$$$reportNull$$$0(5);
        }
        SearchEverywhereHeader.SETab selectedTab = this.myHeader.getTabs().stream().filter(tab -> tab.getID().equals(tabID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("There is no such tab - %s", tabID)));
        this.switchToTab(selectedTab);
    }

    private void switchToTab(SearchEverywhereHeader.SETab tab) {
        boolean prevTabIsSingleContributor = this.myHeader.getSelectedTab().isSingleContributor();
        this.myHeader.switchToTab(tab);
        boolean nextTabIsSingleContributor = this.myHeader.getSelectedTab().isSingleContributor();
        this.updateSearchFieldAdvertisement();
        if (prevTabIsSingleContributor != nextTabIsSingleContributor) {
            this.myResultsList.setCellRenderer(this.myResultsList.getCellRenderer());
        }
    }

    private void updateSearchFieldAdvertisement() {
        if (this.mySearchField == null) {
            return;
        }
        List<SearchEverywhereContributor<?>> contributors = this.myHeader.getSelectedTab().getContributors();
        String advertisementText = this.getWarning(contributors);
        if (advertisementText != null) {
            this.myHintHelper.setWarning(advertisementText);
            this.updateRightActions(contributors);
            return;
        }
        advertisementText = SearchEverywhereUI.getAdvertisement(contributors);
        this.myHintHelper.setHint(advertisementText);
        this.updateRightActions(contributors);
    }

    private void updateRightActions(@NotNull List<? extends SearchEverywhereContributor<?>> contributors) {
        if (contributors == null) {
            SearchEverywhereUI.$$$reportNull$$$0(6);
        }
        List<AnAction> actions = this.getRightActions(contributors);
        this.myHintHelper.removeRightExtensions();
        if (!actions.isEmpty()) {
            this.myHintHelper.setRightExtensions(actions);
        }
    }

    @NotNull
    private List<AnAction> getRightActions(@NotNull List<? extends SearchEverywhereContributor<?>> contributors) {
        if (contributors == null) {
            SearchEverywhereUI.$$$reportNull$$$0(7);
        }
        for (SearchEverywhereContributor<?> contributor : contributors) {
            if (!Objects.equals(this.getSelectedTabID(), contributor.getSearchProviderId()) || !(contributor instanceof SearchFieldActionsContributor)) continue;
            List<AnAction> list2 = ((SearchFieldActionsContributor)((Object)contributor)).createRightActions(() -> this.scheduleRebuildList(SearchRestartReason.TEXT_SEARCH_OPTION_CHANGED));
            if (list2 == null) {
                SearchEverywhereUI.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<AnAction> list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @Nls
    @Nullable
    private String getWarning(List<SearchEverywhereContributor<?>> contributors) {
        boolean containsPSIContributors;
        if (this.myProject != null && DumbService.isDumb(this.myProject) && (containsPSIContributors = ContainerUtil.exists(contributors, c2 -> c2 instanceof AbstractGotoSEContributor || c2 instanceof PSIPresentationBgRendererWrapper))) {
            return IdeBundle.message((String)"dumb.mode.results.might.be.incomplete", (Object[])new Object[0]);
        }
        return null;
    }

    @Nls
    @Nullable
    private static String getAdvertisement(List<? extends SearchEverywhereContributor<?>> contributors) {
        boolean commandsSupported = contributors.stream().anyMatch(contributor -> !contributor.getSupportedCommands().isEmpty());
        if (commandsSupported) {
            return IdeBundle.message((String)"searcheverywhere.textfield.hint", (Object[])new Object[]{SearchTopHitProvider.getTopHitAccelerator()});
        }
        List<String> advertisements = ContainerUtil.mapNotNull(contributors, c2 -> c2.getAdvertisement());
        return advertisements.isEmpty() ? null : advertisements.get(new Random().nextInt(advertisements.size()));
    }

    public String getSelectedTabID() {
        return this.myHeader.getSelectedTab().getID();
    }

    @Nullable
    public Object getSelectionIdentity() {
        Object value = this.myResultsList.getSelectedValue();
        return value == null ? null : Integer.valueOf(Objects.hashCode(value));
    }

    @Override
    public void dispose() {
        this.stopSearching();
        this.myListModel.clear();
        if (this.myMlService != null) {
            this.myMlService.onDialogClose();
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(10);
        }
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
            return this.getSearchPattern();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (SELECTED_ITEM_INFO.is(dataId)) {
            return ContainerUtil.getOnlyItem(this.getSelectedInfos());
        }
        if (PlatformCoreDataKeys.SELECTED_ITEM.is(dataId)) {
            SearchEverywhereFoundElementInfo info2 = ContainerUtil.getOnlyItem(this.getSelectedInfos());
            return info2 == null ? null : info2.getElement();
        }
        if (PlatformCoreDataKeys.SELECTED_ITEMS.is(dataId)) {
            List<SearchEverywhereFoundElementInfo> selection = this.getSelectedInfos();
            if (selection.isEmpty()) {
                return null;
            }
            return ContainerUtil.map2Array(selection, Object.class, SearchEverywhereFoundElementInfo::getElement);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            List<SearchEverywhereFoundElementInfo> selection = this.getSelectedInfos();
            return slowId -> SearchEverywhereUI.getSlowData(slowId, selection);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull List<? extends SearchEverywhereFoundElementInfo> selection) {
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            SearchEverywhereUI.$$$reportNull$$$0(12);
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List<PsiElement> list2 = ContainerUtil.mapNotNull(selection, o -> (PsiElement)SearchEverywhereUI.getDataFromElementInfo(CommonDataKeys.PSI_ELEMENT.getName(), o));
            return list2.isEmpty() ? null : list2.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            List<VirtualFile> list3 = ContainerUtil.mapNotNull(selection, o -> (VirtualFile)SearchEverywhereUI.getDataFromElementInfo(CommonDataKeys.VIRTUAL_FILE.getName(), o));
            return list3.isEmpty() ? null : list3.toArray(VirtualFile.EMPTY_ARRAY);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> list4 = ContainerUtil.mapNotNull(selection, o -> {
                Navigatable navigatable = (Navigatable)SearchEverywhereUI.getDataFromElementInfo(CommonDataKeys.NAVIGATABLE.getName(), o);
                if (navigatable != null) {
                    return navigatable;
                }
                Object psi = SearchEverywhereUI.getDataFromElementInfo(CommonDataKeys.PSI_ELEMENT.getName(), o);
                return psi instanceof Navigatable ? (Navigatable)psi : null;
            });
            return list4.isEmpty() ? null : list4.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        SearchEverywhereFoundElementInfo single2 = ContainerUtil.getOnlyItem(selection);
        return single2 == null ? null : SearchEverywhereUI.getDataFromElementInfo(dataId, single2);
    }

    @Nullable
    private static Object getDataFromElementInfo(@NotNull String dataId, SearchEverywhereFoundElementInfo info2) {
        SearchEverywhereContributor<?> contributor;
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(13);
        }
        if ((contributor = info2.getContributor()) == null) {
            return null;
        }
        return contributor.getDataForItem(info2.getElement(), dataId);
    }

    @NotNull
    private List<SearchEverywhereFoundElementInfo> getSelectedInfos() {
        List<SearchEverywhereFoundElementInfo> list2 = Arrays.stream(this.myResultsList.getSelectedIndices()).mapToObj(this.myListModel::getRawFoundElementAt).filter(o -> o.getElement() != SearchListModel.MORE_ELEMENT).collect(Collectors.toList());
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public List<SearchEverywhereFoundElementInfo> getFoundElementsInfo() {
        return this.myListModel.getFoundElementsInfo();
    }

    @Override
    public void registerHint(@NotNull JBPopup h) {
        if (h == null) {
            SearchEverywhereUI.$$$reportNull$$$0(15);
        }
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    @Override
    public void unregisterHint() {
        this.myHint = null;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessorBase updateProcessor = (PopupUpdateProcessorBase)this.myHint.getUserData(PopupUpdateProcessorBase.class);
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    @Override
    @NotNull
    protected JComponent createHeader() {
        JComponent jComponent = this.myHeader.getComponent();
        if (jComponent == null) {
            SearchEverywhereUI.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    @Override
    protected @NlsContexts.PopupAdvertisement String @NotNull [] getInitialHints() {
        String[] stringArray = new String[]{IdeBundle.message((String)"searcheverywhere.open.in.split.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"OpenInRightSplit")}), IdeBundle.message((String)"searcheverywhere.open.in.new.window.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"EditSourceInNewWindow")}), IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)})};
        if (stringArray == null) {
            SearchEverywhereUI.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @Override
    @NotNull
    @Nls
    protected String getAccessibleName() {
        String string2 = IdeBundle.message((String)"searcheverywhere.accessible.name", (Object[])new Object[0]);
        if (string2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        BigPopupUI.SearchField res = new BigPopupUI.SearchField(){

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new TextFieldWithListAccessibleContext((JTextComponent)((Object)this), SearchEverywhereUI.this.myResultsList.getAccessibleContext());
                }
                return this.accessibleContext;
            }
        };
        ExtendableTextComponent.Extension leftExt = new ExtendableTextComponent.Extension(){

            public Icon getIcon(boolean hovered2) {
                return AllIcons.Actions.Search;
            }

            public boolean isIconBeforeText() {
                return true;
            }

            public int getIconGap() {
                return JBUIScale.scale(ExperimentalUI.isNewUI() ? 6 : 10);
            }
        };
        res.addExtension(leftExt);
        res.putClientProperty(SEARCH_EVERYWHERE_SEARCH_FILED_KEY, true);
        res.setLayout(new BorderLayout());
        BigPopupUI.SearchField searchField = res;
        if (searchField == null) {
            SearchEverywhereUI.$$$reportNull$$$0(19);
        }
        return searchField;
    }

    @Override
    protected void installScrollingActions() {
        ScrollingUtil.installMoveUpAction((JList)this.myResultsList, (JComponent)this.getSearchField());
        ScrollingUtil.installMoveDownAction((JList)this.myResultsList, (JComponent)this.getSearchField());
    }

    private void scheduleRebuildList(SearchRestartReason reason) {
        if (!this.rebuildListAlarm.isDisposed() && this.rebuildListAlarm.getActiveRequestCount() == 0) {
            long delay = StringUtil.isEmpty(this.getSearchPattern()) ? 0L : 100L;
            this.rebuildListAlarm.addRequest(() -> this.rebuildList(reason), delay);
        }
    }

    private void rebuildList(SearchRestartReason reason) {
        String typedCommand;
        List<SearchEverywhereCommandInfo> commands;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopSearching();
        this.myResultsList.setEmptyText(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0]));
        String rawPattern = this.getSearchPattern();
        this.updateViewType(rawPattern.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
        String namePattern = this.myHeader.getSelectedTab().isSingleContributor() ? this.myHeader.getSelectedTab().getContributors().get(0).filterControlSymbols(rawPattern) : rawPattern;
        MinusculeMatcher matcher = NameUtil.buildMatcherWithFallback((String)("*" + rawPattern), (String)("*" + namePattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher((JComponent)this.myResultsList, (Matcher)matcher);
        HashMap contributorsMap = new HashMap();
        List<SearchEverywhereContributor<Object>> contributors = this.myHeader.getSelectedTab().getContributors();
        int limit2 = contributors.size() > 1 ? 15 : 30;
        contributors.forEach(c2 -> contributorsMap.put(c2, limit2));
        if (this.myProject != null) {
            contributors = DumbService.getInstance(this.myProject).filterByDumbAwareness(contributorsMap.keySet());
            if (contributors.isEmpty() && DumbService.isDumb(this.myProject)) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.mode.not.supported", (Object[])new Object[]{this.myHeader.getSelectedTab().getName(), ApplicationNamesInfo.getInstance().getFullProductName()}));
                this.myListModel.clear();
                return;
            }
            if (contributors.size() != contributorsMap.size()) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.incomplete.results", (Object[])new Object[]{this.myHeader.getSelectedTab().getName(), ApplicationNamesInfo.getInstance().getFullProductName()}));
            }
        }
        String tabId = this.myHeader.getSelectedTab().getID();
        if (this.myMlService != null) {
            this.myMlService.onSearchRestart(this.myProject, tabId, reason, this.mySearchTypingListener.mySymbolKeysTyped, this.mySearchTypingListener.myBackspacesTyped, namePattern, (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        }
        this.myListModel.expireResults();
        contributors.forEach(contributor -> this.myListModel.setHasMore((SearchEverywhereContributor<?>)contributor, false));
        List<SearchEverywhereFoundElementInfo> completionElements = AutoCompletionProvider.getCompletionElements(contributors, (JTextComponent)this.mySearchField);
        this.myListModel.addElements(completionElements);
        String commandPrefix = SearchTopHitProvider.getTopHitAccelerator();
        if (rawPattern.startsWith(commandPrefix) && !(commands = SearchEverywhereUI.getCommandsForCompletion(contributors, typedCommand = rawPattern.split(" ")[0].substring(commandPrefix.length()))).isEmpty()) {
            if (rawPattern.contains(" ")) {
                contributorsMap.keySet().retainAll(commands.stream().map(SearchEverywhereCommandInfo::getContributor).collect(Collectors.toSet()));
            } else {
                this.myListModel.clear();
                List<SearchEverywhereFoundElementInfo> lst = ContainerUtil.map(commands, command2 -> new SearchEverywhereFoundElementInfo(command2, 0, this.myStubCommandContributor));
                this.myListModel.addElements(lst);
                ScrollingUtil.ensureSelectionExists((JList)this.myResultsList);
            }
        }
        this.myHintHelper.setSearchInProgress(StringUtil.isNotEmpty(this.getSearchPattern()));
        this.mySearchProgressIndicator = this.mySearcher.search(contributorsMap, rawPattern);
    }

    private void initSearchActions() {
        MouseAdapter listMouseListener = new MouseAdapter(){
            private int currentDescriptionIndex = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchEverywhereUI.this.onMouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index2 = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                this.indexChanged(index2);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int index2 = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
                this.indexChanged(index2);
            }

            private void indexChanged(int index2) {
                if (index2 != this.currentDescriptionIndex) {
                    this.currentDescriptionIndex = index2;
                    SearchEverywhereUI.this.showDescriptionForIndex(index2);
                }
            }
        };
        this.myResultsList.addMouseMotionListener((MouseMotionListener)listMouseListener);
        this.myResultsList.addMouseListener((MouseListener)listMouseListener);
        ScrollingUtil.redirectExpandSelection((JList)this.myResultsList, (JComponent)this.mySearchField);
        Consumer<AnActionEvent> nextTabAction = e -> {
            this.myHeader.switchToNextTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        Consumer<AnActionEvent> prevTabAction = e -> {
            this.myHeader.switchToPrevTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        this.registerAction("SearchEverywhere.CompleteCommand", () -> new CompleteCommandAction());
        this.registerAction("SearchEverywhere.NextTab", nextTabAction);
        this.registerAction("SearchEverywhere.PrevTab", prevTabAction);
        this.registerAction("NextTab", nextTabAction);
        this.registerAction("PreviousTab", prevTabAction);
        this.registerAction("Switcher", (? super AnActionEvent e) -> {
            if (e.getInputEvent().isShiftDown()) {
                this.myHeader.switchToPrevTab();
            } else {
                this.myHeader.switchToNextTab();
            }
            this.triggerTabSwitched((AnActionEvent)e);
        });
        this.registerAction("SearchEverywhere.NavigateToNextGroup", (? super AnActionEvent e) -> {
            this.scrollList(true);
            SearchEverywhereUsageTriggerCollector.GROUP_NAVIGATE.log(this.myProject, e);
        });
        this.registerAction("SearchEverywhere.NavigateToPrevGroup", (? super AnActionEvent e) -> {
            this.scrollList(false);
            SearchEverywhereUsageTriggerCollector.GROUP_NAVIGATE.log(this.myProject, e);
        });
        this.registerSelectItemAction();
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> this.sendStatisticsAndClose()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)this);
        this.mySearchField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.myNotFoundString != null) {
                    boolean newPatternContainsPrevious;
                    boolean bl = newPatternContainsPrevious = SearchEverywhereUI.this.myNotFoundString.length() > 1 && newSearchString.contains(SearchEverywhereUI.this.myNotFoundString);
                    if (SearchEverywhereUI.this.myHeader.canSetEverywhere() && SearchEverywhereUI.this.myHeader.isEverywhere() && !newPatternContainsPrevious) {
                        SearchEverywhereUI.this.myNotFoundString = null;
                        SearchEverywhereUI.this.myHeader.autoSetEverywhere(false);
                        return;
                    }
                }
                SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.TEXT_CHANGED);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$4", "textChanged"));
            }
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
            this.showDescriptionForIndex(this.myResultsList.getSelectedIndex());
        });
        MessageBusConnection busConnection = this.myProject != null ? this.myProject.getMessageBus().connect(this) : ApplicationManager.getApplication().getMessageBus().connect(this);
        busConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            @Override
            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    SearchEverywhereUI.this.updateSearchFieldAdvertisement();
                    SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.EXIT_DUMB_MODE);
                });
            }
        });
        (this.myProject == null ? busConnection : ApplicationManager.getApplication().getMessageBus().connect(this)).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (!SearchEverywhereUI.this.isHintComponent(oppositeComponent) && !UIUtil.haveCommonOwner(SearchEverywhereUI.this, oppositeComponent)) {
                    SearchEverywhereUI.this.sendStatisticsAndClose();
                }
            }
        });
    }

    private void showDescriptionForIndex(int index2) {
        if (index2 < 0 || this.myListModel.isMoreElement(index2)) {
            return;
        }
        if (Registry.is("search.everywhere.show.weights")) {
            @NlsSafe String weight = Integer.toString(this.myListModel.getWeightAt(index2));
            ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)this.myResultsList, (String)weight);
            return;
        }
        if (UISettings.getInstance().getShowStatusBar()) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index2);
            Object element = this.myListModel.getElementAt(index2);
            ReadAction.nonBlocking(() -> contributor.getItemDescription(element)).expireWith(this).coalesceBy(this).finishOnUiThread(ModalityState.any(), data2 -> {
                if (data2 != null) {
                    ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)this.myResultsList, (String)data2);
                }
            }).submit(AppExecutorUtil.getAppExecutorService());
        }
    }

    private void registerAction(String actionID, Supplier<? extends AnAction> actionSupplier) {
        AnAction anAction = ActionManager.getInstance().getAction(actionID);
        if (anAction == null) {
            return;
        }
        ShortcutSet shortcuts = anAction.getShortcutSet();
        actionSupplier.get().registerCustomShortcutSet(shortcuts, (JComponent)this, (Disposable)this);
    }

    private void registerAction(String actionID, Consumer<? super AnActionEvent> action2) {
        this.registerAction(actionID, () -> DumbAwareAction.create((Consumer)action2));
    }

    private void registerSelectItemAction() {
        int[] allowedModifiers = new int[]{0, 1, 2, 4, 8};
        ShortcutSet selectShortcuts = ActionManager.getInstance().getAction("SearchEverywhere.SelectItem").getShortcutSet();
        List<KeyboardShortcut> keyboardShortcuts = ContainerUtil.filterIsInstance(selectShortcuts.getShortcuts(), KeyboardShortcut.class);
        for (int modifiers : allowedModifiers) {
            ArrayList<KeyboardShortcut> newShortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut : keyboardShortcuts) {
                KeyStroke originalStroke;
                boolean hasSecondStroke = shortcut.getSecondKeyStroke() != null;
                KeyStroke keyStroke = originalStroke = hasSecondStroke ? shortcut.getSecondKeyStroke() : shortcut.getFirstKeyStroke();
                if ((originalStroke.getModifiers() & modifiers) != 0) continue;
                KeyStroke newStroke = KeyStroke.getKeyStroke(originalStroke.getKeyCode(), originalStroke.getModifiers() | modifiers);
                newShortcuts.add(hasSecondStroke ? new KeyboardShortcut(shortcut.getFirstKeyStroke(), newStroke) : new KeyboardShortcut(newStroke, null));
            }
            if (newShortcuts.isEmpty()) continue;
            CustomShortcutSet newShortcutSet = new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY));
            DumbAwareAction.create(event -> {
                int[] indices = this.myResultsList.getSelectedIndices();
                this.elementsSelected(indices, modifiers);
            }).registerCustomShortcutSet((ShortcutSet)newShortcutSet, (JComponent)this, (Disposable)this);
        }
    }

    private void triggerTabSwitched(AnActionEvent e) {
        String id = this.myHeader.getSelectedTab().getReportableID();
        SearchEverywhereUsageTriggerCollector.TAB_SWITCHED.log(this.myProject, new EventPair[]{SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)id), EventFields.InputEventByAnAction.with((Object)e)});
    }

    private void scrollList(boolean down) {
        int currentIndex = this.myResultsList.getSelectedIndex();
        int newIndex = this.myListModel.getIndexToScroll(currentIndex, down);
        if (newIndex != currentIndex) {
            this.myResultsList.setSelectedIndex(newIndex);
            ScrollingUtil.ensureIndexIsVisible((JList)this.myResultsList, (int)newIndex, (int)0);
        }
    }

    private Optional<SearchEverywhereCommandInfo> getSelectedCommand(String typedCommand) {
        int index2 = this.myResultsList.getSelectedIndex();
        if (index2 < 0) {
            return Optional.empty();
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index2);
        if (contributor != this.myStubCommandContributor) {
            return Optional.empty();
        }
        SearchEverywhereCommandInfo selectedCommand = (SearchEverywhereCommandInfo)this.myListModel.getElementAt(index2);
        return selectedCommand.getCommand().contains(typedCommand) ? Optional.of(selectedCommand) : Optional.empty();
    }

    @NotNull
    private static List<SearchEverywhereCommandInfo> getCommandsForCompletion(Collection<? extends SearchEverywhereContributor<?>> contributors, String enteredCommandPart) {
        Comparator cmdComparator = (cmd1, cmd2) -> {
            String cmdName1 = cmd1.getCommand();
            String cmdName2 = cmd2.getCommand();
            if (!enteredCommandPart.isEmpty()) {
                if (cmdName1.startsWith(enteredCommandPart) && !cmdName2.startsWith(enteredCommandPart)) {
                    return -1;
                }
                if (!cmdName1.startsWith(enteredCommandPart) && cmdName2.startsWith(enteredCommandPart)) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(cmdName1, cmd2.getCommand());
        };
        List<SearchEverywhereCommandInfo> list2 = contributors.stream().flatMap(contributor -> contributor.getSupportedCommands().stream()).filter(command2 -> command2.getCommand().contains(enteredCommandPart)).sorted(cmdComparator).collect(Collectors.toList());
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        boolean multiSelectMode;
        if (e == null) {
            SearchEverywhereUI.$$$reportNull$$$0(21);
        }
        boolean bl = multiSelectMode = e.isShiftDown() || UIUtil.isControlKeyDown(e);
        if (e.getButton() == 1 && !multiSelectMode) {
            e.consume();
            int i2 = this.myResultsList.locationToIndex(e.getPoint());
            if (i2 > -1) {
                this.myResultsList.setSelectedIndex(i2);
                this.elementsSelected(new int[]{i2}, e.getModifiers());
            }
        }
    }

    private boolean isHintComponent(Component component2) {
        if (this.myHint != null && !this.myHint.isDisposed() && component2 != null) {
            return SwingUtilities.isDescendingFrom(component2, this.myHint.getContent());
        }
        return false;
    }

    @ApiStatus.Experimental
    public void selectFirst() {
        this.elementsSelected(new int[]{0}, 0);
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        this.stopSearching();
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i2 -> !this.myListModel.isMoreElement(i2)).toArray();
        String searchText = this.getSearchPattern();
        if (searchText.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && searchText.contains(" ")) {
            SearchEverywhereUsageTriggerCollector.COMMAND_USED.log(this.myProject);
        }
        boolean closePopup = false;
        ArrayList<Object> selectedItems2 = new ArrayList<Object>();
        for (int i3 : indexes) {
            SearchEverywhereContributor<Object> contributor = this.myListModel.getContributorForIndex(i3);
            Object value = this.myListModel.getElementAt(i3);
            selectedItems2.add(value);
            String selectedTabContributorID = this.myHeader.getSelectedTab().getReportableID();
            String reportableContributorID = SearchEverywhereUsageTriggerCollector.getReportableContributorID(contributor);
            ArrayList<EventPair> data2 = new ArrayList<EventPair>();
            data2.add(SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)reportableContributorID));
            if (selectedTabContributorID != null) {
                data2.add(SearchEverywhereUsageTriggerCollector.CURRENT_TAB_FIELD.with((Object)selectedTabContributorID));
            }
            data2.add(SearchEverywhereUsageTriggerCollector.SELECTED_ITEM_NUMBER.with((Object)i3));
            PsiElement psi = PSIPresentationBgRendererWrapper.toPsi(value);
            if (psi != null) {
                data2.add(EventFields.Language.with((Object)psi.getLanguage()));
            }
            SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ITEM_SELECTED.log(this.myProject, data2);
            closePopup |= contributor.processSelectedItem(value, modifiers, searchText);
        }
        if (this.myMlService != null) {
            this.myMlService.onItemSelected(this.myProject, indexes, selectedItems2, closePopup, (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        }
        if (closePopup) {
            this.closePopup();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.myResultsList.repaint());
        }
    }

    private void showMoreElements(SearchEverywhereContributor contributor) {
        SearchEverywhereUsageTriggerCollector.MORE_ITEM_SELECTED.log(this.myProject);
        this.myListModel.freezeElements();
        if (contributor != null) {
            this.myListModel.setHasMore(contributor, false);
        } else {
            this.myListModel.clearMoreItems();
        }
        Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> found2 = this.myListModel.getFoundElementsMap();
        int additionalItemsCount = this.myHeader.getSelectedTab().isSingleContributor() ? 30 : 15;
        Stream<Object> stream = found2.entrySet().stream();
        stream = contributor != null ? stream.filter(entry -> entry.getKey() == contributor) : stream.filter(entry -> this.myListModel.hasMoreElements((SearchEverywhereContributor)entry.getKey()));
        Map<SearchEverywhereContributor, Integer> contributorsAndLimits = stream.collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> ((Collection)entry.getValue()).size() + additionalItemsCount));
        this.myHintHelper.setSearchInProgress(StringUtil.isNotEmpty(this.getSearchPattern()));
        this.mySearchProgressIndicator = this.mySearcher.findMoreItems(found2, contributorsAndLimits, this.getSearchPattern());
    }

    private void stopSearching() {
        if (this.mySearchProgressIndicator != null && !this.mySearchProgressIndicator.isCanceled()) {
            this.mySearchProgressIndicator.cancel();
        }
    }

    private void sendStatisticsAndClose() {
        if (this.isShowing() && this.myMlService != null) {
            this.myMlService.onSearchFinished(this.myProject, (Function0<? extends List<? extends SearchEverywhereFoundElementInfo>>)((Function0)() -> this.myListModel.getFoundElementsInfo()));
        }
        this.closePopup();
    }

    public void closePopup() {
        ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)this.myResultsList, null);
        this.stopSearching();
        this.searchFinishedHandler.run();
    }

    @TestOnly
    public Future<List<Object>> findElementsForPattern(String pattern) {
        this.clearResults();
        final CompletableFuture<List<Object>> future = new CompletableFuture<List<Object>>();
        SearchAdapter listener2 = new SearchAdapter(){

            @Override
            public void searchFinished(@NotNull List<Object> items2) {
                if (items2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                future.complete(items2);
                SwingUtilities.invokeLater(() -> SearchEverywhereUI.this.removeSearchListener(this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$7", "searchFinished"));
            }
        };
        this.addSearchListener(listener2);
        this.mySearchField.setText(pattern);
        return future;
    }

    @TestOnly
    public void clearResults() {
        this.myListModel.clear();
        this.mySearchField.setText("");
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String getNotFoundText() {
        SearchEverywhereHeader.SETab selectedTab = this.myHeader.getSelectedTab();
        if (!selectedTab.isSingleContributor()) {
            return IdeBundle.message((String)"searcheverywhere.nothing.found.for.all.anywhere", (Object[])new Object[0]);
        }
        String groupName = selectedTab.getContributors().get(0).getFullGroupName();
        return IdeBundle.message((String)"searcheverywhere.nothing.found.for.contributor.anywhere", (Object[])new Object[]{groupName.toLowerCase(Locale.ROOT)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 8, 9, 14, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSupplier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabID";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createListenerWrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedInfos";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialHints";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsForCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "switchToTab";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRightActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRightActions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromElementInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerHint";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 8, 9, 14, 16, 17, 18, 19, 20 -> new IllegalStateException(string2);
        };
    }

    private class MySearchListener
    implements SearchListener {
        private MySearchListener() {
        }

        @Override
        public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            Object prevSelection;
            boolean wasEmpty;
            if (list2 == null) {
                MySearchListener.$$$reportNull$$$0(0);
            }
            if (SearchEverywhereUI.this.mySearchProgressIndicator == null || SearchEverywhereUI.this.mySearchProgressIndicator.isCanceled()) {
                return;
            }
            boolean bl = wasEmpty = SearchEverywhereUI.this.myListModel.getSize() == 0;
            if (SearchEverywhereUI.this.myMlService != null) {
                SearchEverywhereUI.this.myMlService.notifySearchResultsUpdated();
            }
            SearchEverywhereUI.this.mySelectionTracker.lock();
            SearchEverywhereUI.this.myListModel.addElements(list2);
            SearchEverywhereUI.this.mySelectionTracker.unlock();
            SearchEverywhereUI.this.mySelectionTracker.restoreSelection();
            if (wasEmpty && SearchEverywhereUI.this.myListModel.getSize() > 0 && (prevSelection = ((SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject)).getPrevSelection(SearchEverywhereUI.this.getSelectedTabID())) instanceof Integer) {
                for (Object item : SearchEverywhereUI.this.myListModel.getItems()) {
                    if (Objects.hashCode(item) != (Integer)prevSelection) continue;
                    SearchEverywhereUI.this.myResultsList.setSelectedValue(item, true);
                    break;
                }
            }
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> listener2.elementsAdded(list2));
        }

        @Override
        public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            if (list2 == null) {
                MySearchListener.$$$reportNull$$$0(1);
            }
            if (SearchEverywhereUI.this.mySearchProgressIndicator == null || SearchEverywhereUI.this.mySearchProgressIndicator.isCanceled()) {
                return;
            }
            list2.forEach(info2 -> SearchEverywhereUI.this.myListModel.removeElement(info2.getElement(), info2.getContributor()));
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> listener2.elementsRemoved(list2));
        }

        @Override
        public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
            if (pattern == null) {
                MySearchListener.$$$reportNull$$$0(2);
            }
            if (contributors == null) {
                MySearchListener.$$$reportNull$$$0(3);
            }
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> listener2.searchStarted(pattern, contributors));
        }

        @Override
        public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
            if (hasMoreContributors == null) {
                MySearchListener.$$$reportNull$$$0(4);
            }
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            pattern = pattern.replaceAll("^" + SearchTopHitProvider.getTopHitAccelerator() + "\\S+\\s*", "");
            if (SearchEverywhereUI.this.myResultsList.isEmpty() || SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                if (SearchEverywhereUI.this.myHeader.canSetEverywhere() && !SearchEverywhereUI.this.myHeader.isEverywhere() && !pattern.isEmpty()) {
                    SearchEverywhereUI.this.myHeader.autoSetEverywhere(true);
                    SearchEverywhereUI.this.myNotFoundString = pattern;
                    return;
                }
                SearchEverywhereUI.this.hideHint();
                if (SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                    SearchEverywhereUI.this.myListModel.clear();
                }
            }
            this.updateEmptyText(pattern);
            hasMoreContributors.forEach(SearchEverywhereUI.this.myListModel::setHasMore);
            SearchEverywhereUI.this.mySelectionTracker.resetSelectionIfNeeded();
            SearchEverywhereUI.this.myHintHelper.setSearchInProgress(false);
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> {
                listener2.searchFinished(hasMoreContributors);
                if (listener2 instanceof SearchListenerEx) {
                    SearchListenerEx listenerEx = (SearchListenerEx)listener2;
                    listenerEx.searchFinished(SearchEverywhereUI.this.myListModel.getItems());
                }
            });
        }

        @Override
        public void contributorWaits(@NotNull SearchEverywhereContributor<?> contributor) {
            if (contributor == null) {
                MySearchListener.$$$reportNull$$$0(5);
            }
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> listener2.contributorWaits(contributor));
        }

        @Override
        public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
            if (contributor == null) {
                MySearchListener.$$$reportNull$$$0(6);
            }
            SearchEverywhereUI.this.myExternalSearchListeners.forEach(listener2 -> listener2.contributorFinished(contributor, hasMore));
        }

        private void updateEmptyText(String pattern) {
            FindInProjectManager manager;
            boolean anyActionAllowed;
            StatusText emptyStatus = SearchEverywhereUI.this.myResultsList.getEmptyText();
            emptyStatus.clear();
            if (pattern.isEmpty()) {
                return;
            }
            emptyStatus.appendLine(SearchEverywhereUI.this.getNotFoundText());
            boolean showFindInFilesAction = SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors().stream().anyMatch(contributor -> contributor.showInFindResults());
            boolean showResetScope = SearchEverywhereUI.this.myHeader.canResetScope();
            boolean showResetFilter = SearchEverywhereUI.this.myHeader.getSelectedTab().canClearFilter();
            boolean bl = anyActionAllowed = showFindInFilesAction || showResetScope || showResetFilter;
            if (anyActionAllowed) {
                emptyStatus.appendText(".").appendLine("").appendLine("");
            }
            AtomicBoolean firstPartAdded = new AtomicBoolean();
            AtomicInteger actionsPrinted = new AtomicInteger(0);
            if (showResetScope) {
                ActionListener resetScopeListener = e -> SearchEverywhereUI.this.myHeader.resetScope();
                emptyStatus.appendText(IdeBundle.message((String)"searcheverywhere.try.to.reset.scope", (Object[])new Object[0]));
                emptyStatus.appendText(" " + StringUtil.toLowerCase(EverythingGlobalScope.getNameText()), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, resetScopeListener);
                firstPartAdded.set(true);
                actionsPrinted.incrementAndGet();
            }
            if (showResetFilter) {
                ActionListener clearFiltersAction = e -> {
                    SearchEverywhereUI.this.myHeader.getSelectedTab().clearFilter();
                    SearchEverywhereUI.this.scheduleRebuildList(SearchRestartReason.TAB_CHANGED);
                };
                if (firstPartAdded.get()) {
                    emptyStatus.appendText(", ");
                }
                String resetFilterMessage = IdeBundle.message((String)"searcheverywhere.reset.filters", (Object[])new Object[0]);
                emptyStatus.appendText(firstPartAdded.get() ? Strings.toLowerCase(resetFilterMessage) : resetFilterMessage, SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, clearFiltersAction);
                firstPartAdded.set(true);
                if (actionsPrinted.incrementAndGet() >= 2) {
                    emptyStatus.appendLine("");
                    actionsPrinted.set(0);
                }
            }
            if (showFindInFilesAction && SearchEverywhereUI.this.myProject != null && (manager = FindInProjectManager.getInstance(SearchEverywhereUI.this.myProject)) != null && manager.isEnabled()) {
                DataContext context2 = DataManager.getInstance().getDataContext((Component)SearchEverywhereUI.this);
                ActionListener findInFilesAction = e -> manager.findInProject(context2, null);
                emptyStatus.appendText((String)(firstPartAdded.get() ? " " + IdeBundle.message((String)"searcheverywhere.use.optional", (Object[])new Object[0]) : IdeBundle.message((String)"searcheverywhere.use.main", (Object[])new Object[0])) + " ");
                emptyStatus.appendText(IdeBundle.message((String)"searcheverywhere.try.to.find.in.files", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, findInFilesAction);
                String findInFilesShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"FindInPath");
                if (!StringUtil.isEmpty(findInFilesShortcut)) {
                    emptyStatus.appendText(" (" + findInFilesShortcut + ")");
                }
                if (actionsPrinted.incrementAndGet() >= 2) {
                    emptyStatus.appendLine("");
                    actionsPrinted.set(0);
                }
                emptyStatus.appendText(" " + IdeBundle.message((String)"searcheverywhere.to.perform.fulltext.search", (Object[])new Object[0]));
            }
            if (anyActionAllowed) {
                emptyStatus.appendText(".");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributors";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasMoreContributors";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$MySearchListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchStarted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchFinished";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contributorWaits";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contributorFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        ShowInFindToolWindowAction() {
            super(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), SHOW_IN_FIND_TOOL_WINDOW_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(0);
            }
            SearchEverywhereUI.this.stopSearching();
            List<SearchEverywhereContributor<?>> contributors = SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors();
            contributors = ContainerUtil.filter(contributors, SearchEverywhereContributor::showInFindResults);
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation2 = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message((String)"searcheverywhere.found.matches.title", (Object[])new Object[]{searchText, contributorsString});
            presentation2.setCodeUsagesString(tabCaptionText);
            presentation2.setTargetsNodeText(IdeBundle.message((String)"searcheverywhere.found.targets.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation2.setTabName(tabCaptionText);
            presentation2.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet targets2 = new LinkedHashSet();
            final Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toSet());
            this.fillUsages(cached, usages, targets2);
            final List<SearchEverywhereContributor> contributorsForAdditionalSearch = ContainerUtil.filter(contributors, contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor<?>)contributor));
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run(new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(arg0, arg1, arg2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.progressIndicator.start();
                        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(this.progressIndicator);
                        ArrayList<Object> foundElements = new ArrayList<Object>();
                        int alreadyFoundCount = cached.size();
                        for (SearchEverywhereContributor contributor : contributorsForAdditionalSearch) {
                            if (this.progressIndicator.isCanceled()) break;
                            try {
                                this.fetch(contributor, foundElements, alreadyFoundCount, tooManyUsagesStatus);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets2);
                    }

                    <Item> void fetch(SearchEverywhereContributor<Item> contributor, Collection<Object> foundElements, int alreadyFoundCount, TooManyUsagesStatus tooManyUsagesStatus) {
                        contributor.fetchElements(searchText, this.progressIndicator, o -> {
                            if (this.progressIndicator.isCanceled()) {
                                return false;
                            }
                            if (cached.contains(o)) {
                                return true;
                            }
                            foundElements.add(o);
                            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                            if (foundElements.size() + alreadyFoundCount >= 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)this.progressIndicator, null, () -> UsageViewBundle.message((String)"find.excessive.usage.count.prompt", (Object[])new Object[0]), null);
                                return !this.progressIndicator.isCanceled();
                            }
                            return true;
                        });
                    }

                    @Override
                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    @Override
                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets2, usages, presentation2);
                    }

                    @Override
                    public void onThrowable(@NotNull Throwable error2) {
                        if (error2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.onThrowable(error2);
                        this.progressIndicator.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.showInFindWindow(targets2, usages, presentation2);
            }
            SearchEverywhereUI.this.sendStatisticsAndClose();
        }

        private void fillUsages(Collection<Object> foundElements, Collection<? super Usage> usages, Collection<? super PsiElement> targets2) {
            for (Object element : foundElements) {
                if (element instanceof UsageInfo2UsageAdapter) {
                    usages.add((Usage)((UsageInfo2UsageAdapter)element));
                    continue;
                }
                if (!(element instanceof SearchEverywhereItem)) continue;
                usages.add((Usage)((SearchEverywhereItem)element).getUsage());
            }
            ReadAction.run(() -> foundElements.stream().map(o -> PSIPresentationBgRendererWrapper.toPsi(o)).filter(Objects::nonNull).forEach(element -> {
                if (element.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo((PsiElement)element);
                    usages.add((Usage)new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets2.add((PsiElement)element);
                }
            }));
        }

        private void showInFindWindow(Collection<? extends PsiElement> targets2, Collection<Usage> usages, UsageViewPresentation presentation2) {
            UsageTarget[] targetsArray = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert((PsiElement[])PsiUtilCore.toPsiElementArray(targets2));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance((Project)SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(1);
            }
            if (SearchEverywhereUI.this.myProject == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            SearchEverywhereHeader.SETab selectedTab = SearchEverywhereUI.this.myHeader != null ? SearchEverywhereUI.this.myHeader.getSelectedTab() : null;
            boolean enabled = selectedTab == null || selectedTab.getContributors().stream().anyMatch(c2 -> c2.showInFindResults());
            e.getPresentation().setEnabled(enabled);
            if (!ExperimentalUI.isNewUI()) {
                e.getPresentation().setIcon(ToolWindowManager.getInstance((Project)SearchEverywhereUI.this.myProject).getLocationIcon("Find", SHOW_IN_FIND_TOOL_WINDOW_ICON));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class HintHelper {
        private final ExtendableTextField myTextField;
        private final TextIcon myHintTextIcon = new TextIcon("", JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground(), Gray.TRANSPARENT, 0);
        private final RowIcon myWarnIcon = new RowIcon(2, RowIcon.Alignment.BOTTOM);
        private final ExtendableTextComponent.Extension myHintExtension = HintHelper.createExtension((Icon)this.myHintTextIcon);
        private final ExtendableTextComponent.Extension mySearchProcessExtension = HintHelper.createExtension((Icon)AnimatedIcon.Default.INSTANCE);
        private final ExtendableTextComponent.Extension myWarningExtension;
        private final List<ExtendableTextComponent.Extension> myRightExtensions = new ArrayList<ExtendableTextComponent.Extension>();

        private HintHelper(ExtendableTextField field) {
            this.myTextField = field;
            this.myHintTextIcon.setFont(this.myTextField.getFont());
            this.myHintTextIcon.setFontTransform(FontInfo.getFontRenderContext((Component)this.myTextField).getTransform());
            this.myHintTextIcon.setInsets(JBUIScale.scale(3), 0, 0, 0);
            this.myWarnIcon.setIcon(AllIcons.General.Warning, 0);
            this.myWarnIcon.setIcon((Icon)this.myHintTextIcon, 1);
            this.myWarningExtension = HintHelper.createExtension((Icon)this.myWarnIcon);
        }

        public void setHint(String hintText) {
            this.myTextField.removeExtension(this.myHintExtension);
            this.myTextField.removeExtension(this.myWarningExtension);
            if (StringUtil.isNotEmpty(hintText)) {
                this.myHintTextIcon.setText(hintText);
                this.addExtensionAsLast(this.myHintExtension);
            }
        }

        public void setWarning(String warnText) {
            this.myTextField.removeExtension(this.myHintExtension);
            this.myTextField.removeExtension(this.myWarningExtension);
            if (StringUtil.isNotEmpty(warnText)) {
                this.myHintTextIcon.setText(warnText);
                this.myWarnIcon.setIcon((Icon)this.myHintTextIcon, 1);
                this.addExtensionAsLast(this.myWarningExtension);
            }
        }

        public void setSearchInProgress(boolean inProgress) {
            this.myTextField.removeExtension(this.mySearchProcessExtension);
            if (inProgress) {
                this.myTextField.addExtension(this.mySearchProcessExtension);
            }
        }

        private void addExtensionAsLast(ExtendableTextComponent.Extension ext) {
            ArrayList<ExtendableTextComponent.Extension> extensions2 = new ArrayList<ExtendableTextComponent.Extension>(this.myTextField.getExtensions());
            extensions2.add(0, ext);
            this.myTextField.setExtensions(extensions2);
        }

        @NotNull
        private static ExtendableTextComponent.Extension createExtension(final Icon icon2) {
            return new ExtendableTextComponent.Extension(){

                public Icon getIcon(boolean hovered2) {
                    return icon2;
                }
            };
        }

        private void setRightExtensions(@NotNull List<? extends AnAction> actions) {
            if (actions == null) {
                HintHelper.$$$reportNull$$$0(0);
            }
            this.myTextField.removeExtension(this.myHintExtension);
            this.myTextField.removeExtension(this.myWarningExtension);
            actions.stream().map(HintHelper::createRightActionExtension).forEach(it -> {
                this.addExtensionAsLast((ExtendableTextComponent.Extension)it);
                this.myRightExtensions.add((ExtendableTextComponent.Extension)it);
            });
        }

        private void removeRightExtensions() {
            this.myRightExtensions.forEach(arg_0 -> ((ExtendableTextField)this.myTextField).removeExtension(arg_0));
        }

        @NotNull
        private static ExtendableTextComponent.Extension createRightActionExtension(final @NotNull AnAction action2) {
            if (action2 == null) {
                HintHelper.$$$reportNull$$$0(1);
            }
            return new ExtendableTextComponent.Extension(){

                public Icon getIcon(boolean hovered2) {
                    Presentation presentation2 = action2.getTemplatePresentation();
                    if (!(action2 instanceof TextSearchRightActionAction)) {
                        return presentation2.getIcon();
                    }
                    if (((TextSearchRightActionAction)action2).isSelected()) {
                        return presentation2.getSelectedIcon();
                    }
                    if (hovered2) {
                        return presentation2.getHoveredIcon();
                    }
                    return presentation2.getIcon();
                }

                public String getTooltip() {
                    if (!(action2 instanceof TextSearchRightActionAction)) {
                        return null;
                    }
                    return ((TextSearchRightActionAction)action2).getTooltipText();
                }

                public Runnable getActionOnClick(@NotNull InputEvent inputEvent) {
                    if (inputEvent == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return () -> {
                        AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)inputEvent, (String)"popup", (Presentation)action2.getTemplatePresentation().clone(), (DataContext)DataContext.EMPTY_CONTEXT);
                        ActionUtil.performDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event, () -> action2.actionPerformed(event));
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEvent", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$HintHelper$2", "getActionOnClick"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$HintHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRightExtensions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRightActionExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SearchFieldTypingListener
    extends KeyAdapter {
        private int mySymbolKeysTyped;
        private int myBackspacesTyped;

        private SearchFieldTypingListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            ++this.mySymbolKeysTyped;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 8 || code == 127) {
                ++this.myBackspacesTyped;
            }
        }
    }

    private class CompleteCommandAction
    extends DumbAwareAction {
        private CompleteCommandAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(0);
            }
            if (this.completeCommand()) {
                SearchEverywhereUsageTriggerCollector.COMMAND_COMPLETED.log(SearchEverywhereUI.this.myProject, new EventPair[]{EventFields.InputEventByAnAction.with((Object)e)});
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getCompleteCommand() != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CompleteCommandAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private boolean completeCommand() {
            SearchEverywhereCommandInfo suggestedCommand = this.getCompleteCommand();
            if (suggestedCommand != null) {
                SearchEverywhereUI.this.mySearchField.setText(suggestedCommand.getCommandWithPrefix() + " ");
                return true;
            }
            return false;
        }

        private SearchEverywhereCommandInfo getCompleteCommand() {
            String commandPrefix;
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            if (pattern.startsWith(commandPrefix = SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String typedCommand = pattern.substring(commandPrefix.length());
                return SearchEverywhereUI.this.getSelectedCommand(typedCommand).orElseGet(() -> {
                    List<SearchEverywhereCommandInfo> completions = SearchEverywhereUI.getCommandsForCompletion(SearchEverywhereUI.this.myHeader.getSelectedTab().getContributors(), typedCommand);
                    return completions.isEmpty() ? null : completions.get(0);
                });
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CompleteCommandAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CompleteCommandAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

