/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
abstract class SearchListModel
extends AbstractListModel<Object> {
    static final Object MORE_ELEMENT = new Object();
    protected final List<SearchEverywhereFoundElementInfo> listElements = new ArrayList<SearchEverywhereFoundElementInfo>();
    protected boolean resultsExpired = false;

    SearchListModel() {
    }

    public boolean isResultsExpired() {
        return this.resultsExpired;
    }

    public void expireResults() {
        this.resultsExpired = true;
    }

    @Override
    public int getSize() {
        return this.listElements.size();
    }

    @Override
    public Object getElementAt(int index2) {
        return this.listElements.get(index2).getElement();
    }

    @NotNull
    public SearchEverywhereFoundElementInfo getRawFoundElementAt(int index2) {
        SearchEverywhereFoundElementInfo searchEverywhereFoundElementInfo = this.listElements.get(index2);
        if (searchEverywhereFoundElementInfo == null) {
            SearchListModel.$$$reportNull$$$0(0);
        }
        return searchEverywhereFoundElementInfo;
    }

    public int getWeightAt(int index2) {
        return this.listElements.get(index2).getPriority();
    }

    public List<Object> getItems() {
        return new ArrayList<Object>(this.values());
    }

    public Collection<Object> getFoundItems(SearchEverywhereContributor contributor) {
        return this.listElements.stream().filter(info2 -> info2.getContributor() == contributor && info2.getElement() != MORE_ELEMENT).map(info2 -> info2.getElement()).collect(Collectors.toList());
    }

    @NotNull
    protected List<SearchEverywhereContributor> contributors() {
        List list2 = Lists.transform(this.listElements, info2 -> info2.getContributor());
        if (list2 == null) {
            SearchListModel.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    protected List<Object> values() {
        List list2 = Lists.transform(this.listElements, info2 -> info2.getElement());
        if (list2 == null) {
            SearchListModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public abstract boolean hasMoreElements(SearchEverywhereContributor<?> var1);

    public abstract void setHasMore(SearchEverywhereContributor<?> var1, boolean var2);

    public abstract void addElements(List<? extends SearchEverywhereFoundElementInfo> var1);

    public abstract void removeElement(@NotNull Object var1, SearchEverywhereContributor<?> var2);

    public abstract void clearMoreItems();

    public void freezeElements() {
    }

    public abstract int getIndexToScroll(int var1, boolean var2);

    public void clear() {
        int index2 = this.getSize() - 1;
        this.listElements.clear();
        if (index2 >= 0) {
            this.fireIntervalRemoved(this, 0, index2);
        }
    }

    public boolean contains(Object val) {
        return this.values().contains(val);
    }

    public boolean isMoreElement(int index2) {
        return this.getElementAt(index2) == MORE_ELEMENT;
    }

    @Nullable
    public <Item> SearchEverywhereContributor<Item> getContributorForIndex(int index2) {
        return this.listElements.get(index2).getContributor();
    }

    @NotNull
    public List<SearchEverywhereFoundElementInfo> getFoundElementsInfo() {
        List<SearchEverywhereFoundElementInfo> list2 = ContainerUtil.filter(this.listElements, info2 -> info2.element != MORE_ELEMENT);
        if (list2 == null) {
            SearchListModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> getFoundElementsMap() {
        return this.listElements.stream().filter(info2 -> info2.element != MORE_ELEMENT).collect(Collectors.groupingBy(o -> o.getContributor(), Collectors.toCollection(ArrayList::new)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/actions/searcheverywhere/SearchListModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawFoundElementAt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "contributors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoundElementsInfo";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

