/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.PossibleSlowContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.SlowContributorDetectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0016\u0010\u0017\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0016\u0010\u001f\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020 0\u0010H\u0016J\u0016\u0010!\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020 0\u0010H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0014\u0010$\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\tH\u0002J\b\u0010)\u001a\u00020\u0019H\u0002J \u0010*\u001a\u00020\u00192\u0016\u0010+\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001d0,H\u0016J\"\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00052\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0014H\u0016J\u0016\u00100\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u00061"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/SlowContributorDetector;", "Lcom/intellij/ide/actions/searcheverywhere/SearchListener;", "()V", "contributorsWithEvents", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "finishedContributors", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "startTimestamp", "Ljava/lang/Long;", "calcPercentile", "", "list", "", "percentile", "calcSigma", "delays", "", "calculatePercentileEdge", "calculateSigmaEdge", "calculateTwoSigmaEdge", "contributorFinished", "", "contributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "hasMore", "", "contributorWaits", "elementsAdded", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFoundElementInfo;", "elementsRemoved", "findSlow", "getFilteredDelays", "logContributorFinished", "printDebugInfo", "reportSlowContributor", "id", "delay", "restart", "searchFinished", "hasMoreContributors", "", "searchStarted", "pattern", "contributors", "updateContributorsWithEvents", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSlowContributorDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlowContributorDetector.kt\ncom/intellij/ide/actions/searcheverywhere/SlowContributorDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,124:1\n1603#2,9:125\n1855#2:134\n1856#2:136\n1612#2:137\n1#3:135\n1#3:138\n1#3:157\n1#3:160\n215#4,2:139\n125#4:141\n152#4,3:142\n215#4,2:145\n135#4,9:147\n215#4:156\n216#4:158\n144#4:159\n*S KotlinDebug\n*F\n+ 1 SlowContributorDetector.kt\ncom/intellij/ide/actions/searcheverywhere/SlowContributorDetector\n*L\n29#1:125,9\n29#1:134\n29#1:136\n29#1:137\n29#1:135\n78#1:157\n37#1:139,2\n44#1:141\n44#1:142,3\n75#1:145,2\n78#1:147,9\n78#1:156\n78#1:158\n78#1:159\n*E\n"})
public final class SlowContributorDetector
implements SearchListener {
    @Nullable
    private Long startTimestamp;
    @NotNull
    private final HashMap<String, Long> finishedContributors = new HashMap();
    @NotNull
    private final HashSet<String> contributorsWithEvents = new HashSet();

    @Override
    public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(contributors, (String)"contributors");
        this.restart();
    }

    @Override
    public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.updateContributorsWithEvents((Collection<? extends SearchEverywhereFoundElementInfo>)list2);
    }

    @Override
    public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.updateContributorsWithEvents((Collection<? extends SearchEverywhereFoundElementInfo>)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateContributorsWithEvents(Collection<? extends SearchEverywhereFoundElementInfo> list2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SearchEverywhereFoundElementInfo it = (SearchEverywhereFoundElementInfo)element$iv$iv;
            boolean bl2 = false;
            SearchEverywhereContributor<?> searchEverywhereContributor = it.contributor;
            if ((searchEverywhereContributor != null ? searchEverywhereContributor.getSearchProviderId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.contributorsWithEvents.addAll(it);
    }

    @Override
    public void contributorWaits(@NotNull SearchEverywhereContributor<?> contributor) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        this.logContributorFinished(contributor);
    }

    @Override
    public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
        this.logContributorFinished(contributor);
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        Intrinsics.checkNotNullParameter(hasMoreContributors, (String)"hasMoreContributors");
        Map<SearchEverywhereContributor<?>, Boolean> $this$forEach$iv = hasMoreContributors;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SearchEverywhereContributor<?>, Boolean>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SearchEverywhereContributor<?>, Boolean> element$iv;
            Map.Entry<SearchEverywhereContributor<?>, Boolean> entry = element$iv = iterator2.next();
            boolean bl = false;
            SearchEverywhereContributor<?> contributor = entry.getKey();
            this.logContributorFinished(contributor);
        }
        this.findSlow();
        if (SlowContributorDetectorKt.access$getLOG$p().isDebugEnabled()) {
            this.printDebugInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printDebugInfo() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List values2 = new ArrayList();
        Map map2 = this.finishedContributors;
        List list2 = values2;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(entry.getKey() + ": " + entry.getValue());
        }
        list2.addAll((List)destination$iv$iv);
        Collection<Long> delays = this.getFilteredDelays();
        long sigmaEdge = this.calculateSigmaEdge(delays);
        long twoSigmaEdge = this.calculateTwoSigmaEdge(delays);
        long percentileEdge = this.calculatePercentileEdge(delays);
        values2.add("Delays: " + delays);
        values2.add("Sigma edge: " + sigmaEdge);
        values2.add("2Sigma edge: " + twoSigmaEdge);
        values2.add("Percentile edge: " + percentileEdge);
        SlowContributorDetectorKt.access$getLOG$p().debugValues("Contributors performance stats", values2);
    }

    private final void logContributorFinished(SearchEverywhereContributor<?> contributor) {
        if (this.finishedContributors.containsKey(contributor.getSearchProviderId())) {
            return;
        }
        if (PossibleSlowContributor.checkSlow(contributor)) {
            return;
        }
        Map map2 = this.finishedContributors;
        String string2 = contributor.getSearchProviderId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contributor.searchProviderId");
        String string3 = string2;
        long l = System.currentTimeMillis();
        Long l2 = this.startTimestamp;
        Intrinsics.checkNotNull((Object)l2);
        Long l3 = l - l2;
        map2.put(string3, l3);
    }

    private final void restart() {
        this.startTimestamp = System.currentTimeMillis();
        this.finishedContributors.clear();
        this.contributorsWithEvents.clear();
    }

    private final void findSlow() {
        Collection<Long> delays = this.getFilteredDelays();
        if (delays.isEmpty()) {
            return;
        }
        long edge = this.calculateSigmaEdge(delays);
        Map $this$forEach$iv = this.finishedContributors;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String id = (String)entry.getKey();
            long delay = ((Number)entry.getValue()).longValue();
            if (delay < edge || delay < 2000L) continue;
            this.reportSlowContributor(id, delay);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Long> getFilteredDelays() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = this.finishedContributors;
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Long it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            long value = ((Number)entry.getValue()).longValue();
            if ((this.contributorsWithEvents.contains(key) || value >= 50L ? Long.valueOf(value) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void reportSlowContributor(String id, long delay) {
        SlowContributorDetectorKt.access$getLOG$p().warn("Contributor [" + id + "] is too slow (took " + delay + " ms to finish). Slow contributors should implement PossibleSlowContributor interface");
    }

    private final long calculatePercentileEdge(Collection<Long> delays) {
        List list2 = CollectionsKt.sorted((Iterable)delays);
        double q1 = this.calcPercentile(list2, 0.25);
        double q3 = this.calcPercentile(list2, 0.75);
        double qRange = (q3 - q1) * (double)3;
        return (long)(q3 + qRange);
    }

    private final long calculateTwoSigmaEdge(Collection<Long> delays) {
        return (long)CollectionsKt.averageOfLong((Iterable)delays) + (long)2 * this.calcSigma(delays);
    }

    private final long calculateSigmaEdge(Collection<Long> delays) {
        return (long)CollectionsKt.averageOfLong((Iterable)delays) + this.calcSigma(delays);
    }

    private final double calcPercentile(List<Long> list2, double percentile) {
        if (list2.isEmpty()) {
            return 0.0;
        }
        double num = (double)list2.size() * percentile;
        if (num == MathKt.truncate((double)num)) {
            int index2 = (int)num;
            return index2 == 0 ? 0.0 : (double)(((Number)list2.get(index2)).longValue() + ((Number)list2.get(index2 - 1)).longValue()) / 2.0;
        }
        int index3 = (int)Math.ceil(num);
        return index3 >= list2.size() ? ((Number)CollectionsKt.last(list2)).doubleValue() + 1.0 : (double)((Number)list2.get(index3)).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private final long calcSigma(Collection<Long> delays) {
        double avg = CollectionsKt.averageOfLong((Iterable)delays);
        Iterable iterable = delays;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            long l = ((Number)t).longValue();
            double d2 = d;
            boolean bl = false;
            double d3 = Math.pow((double)it - avg, 2);
            d = d2 + d3;
        }
        double sigma = Math.sqrt(d / (double)delays.size());
        return (long)sigma;
    }
}

