/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEventsBuffer;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Alarm;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ThrottlingListenerWrapper
implements SearchListener,
Disposable {
    private static final int DEFAULT_THROTTLING_TIMEOUT = 100;
    private final int myThrottlingDelay;
    private final Alarm flushAlarm = new Alarm();
    private boolean flushScheduled;
    private final SearchEventsBuffer buffer = new SearchEventsBuffer();
    private final SearchListener delegateListener;

    ThrottlingListenerWrapper(int throttlingDelay, SearchListener delegate2) {
        this.delegateListener = delegate2;
        this.myThrottlingDelay = throttlingDelay;
    }

    ThrottlingListenerWrapper(SearchListener delegateListener) {
        this(100, delegateListener);
    }

    @Override
    public void dispose() {
        this.cancelScheduledFlush();
    }

    @Override
    public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        if (list2 == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(0);
        }
        this.buffer.addElements(list2);
        this.scheduleFlushBuffer();
    }

    @Override
    public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        if (list2 == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(1);
        }
        this.buffer.removeElements(list2);
        this.scheduleFlushBuffer();
    }

    @Override
    public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
        if (pattern == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(2);
        }
        if (contributors == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(3);
        }
        this.buffer.clearBuffer();
        this.delegateListener.searchStarted(pattern, contributors);
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        if (hasMoreContributors == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(4);
        }
        this.cancelScheduledFlush();
        this.buffer.flushBuffer(this.delegateListener);
        this.delegateListener.searchFinished(hasMoreContributors);
    }

    @Override
    public void contributorWaits(@NotNull SearchEverywhereContributor<?> contributor) {
        if (contributor == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(5);
        }
        this.buffer.contributorWaits(contributor);
    }

    @Override
    public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
        if (contributor == null) {
            ThrottlingListenerWrapper.$$$reportNull$$$0(6);
        }
        this.buffer.contributorFinished(contributor, hasMore);
    }

    private void scheduleFlushBuffer() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Runnable flushTask = () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!this.flushScheduled) {
                return;
            }
            this.flushScheduled = false;
            this.buffer.flushBuffer(this.delegateListener);
        };
        if (!this.flushScheduled) {
            this.flushAlarm.addRequest(flushTask, this.myThrottlingDelay);
            this.flushScheduled = true;
        }
    }

    private void cancelScheduledFlush() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.flushAlarm.cancelAllRequests();
        this.flushScheduled = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasMoreContributors";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ThrottlingListenerWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsRemoved";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "searchStarted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "contributorWaits";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "contributorFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

