/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.PossibleSlowContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEventsBuffer;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class WaitForContributorsListenerWrapper
implements SearchListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(WaitForContributorsListenerWrapper.class);
    static final long DEFAULT_WAIT_TIMEOUT_MS = 3000L;
    static final long DEFAULT_THROTTLING_TIMEOUT_MS = 100L;
    private final Map<SearchEverywhereContributor<?>, Boolean> contributorsMap;
    private final ScheduledExecutorService executorService;
    private final SearchListModel listModel;
    private Future<?> flushFuture;
    private final long waitTimeoutMs;
    private final long throttlingTimeoutMs;
    private final Supplier<String> mySearchPattern;
    private final SearchListener delegateListener;
    private final SearchEventsBuffer buffer;

    /*
     * WARNING - void declaration
     */
    public WaitForContributorsListenerWrapper(@NotNull SearchListener delegate2, @NotNull SearchListModel model2, long waitTimeoutMs, long throttlingTimeoutMs, @NotNull Supplier<String> supplier2) {
        void searchPattern;
        if (delegate2 == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(1);
        }
        if (supplier2 == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(2);
        }
        this.contributorsMap = new HashMap();
        this.executorService = EdtExecutorService.getScheduledExecutorInstance();
        this.buffer = new SearchEventsBuffer();
        this.delegateListener = delegate2;
        this.listModel = model2;
        this.waitTimeoutMs = waitTimeoutMs;
        this.throttlingTimeoutMs = throttlingTimeoutMs;
        this.mySearchPattern = searchPattern;
    }

    @Override
    public void dispose() {
        this.cancelScheduledFlush();
    }

    @Override
    public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
        if (pattern == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(3);
        }
        if (contributors == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(4);
        }
        this.resetState(contributors);
        this.delegateListener.searchStarted(pattern, contributors);
        long timeout = contributors.size() > 1 ? this.waitTimeoutMs : this.throttlingTimeoutMs;
        this.scheduleFlush(timeout);
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        if (hasMoreContributors == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(5);
        }
        this.cancelScheduledFlush();
        this.buffer.flushBuffer(this.delegateListener);
        this.delegateListener.searchFinished(hasMoreContributors);
    }

    @Override
    public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        if (list2 == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(6);
        }
        this.buffer.addElements(list2);
        this.scheduleFlush(this.throttlingTimeoutMs);
    }

    @Override
    public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        if (list2 == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(7);
        }
        this.buffer.removeElements(list2);
        this.scheduleFlush(this.throttlingTimeoutMs);
    }

    @Override
    public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
        if (contributor == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(8);
        }
        this.buffer.contributorFinished(contributor, hasMore);
        this.markContributorAndCheckFlush(contributor);
    }

    @Override
    public void contributorWaits(@NotNull SearchEverywhereContributor<?> contributor) {
        if (contributor == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(9);
        }
        this.buffer.contributorWaits(contributor);
        this.markContributorAndCheckFlush(contributor);
    }

    private void markContributorAndCheckFlush(@NotNull SearchEverywhereContributor<?> contributor) {
        if (contributor == null) {
            WaitForContributorsListenerWrapper.$$$reportNull$$$0(10);
        }
        if (this.contributorsMap.get(contributor) != null) {
            this.contributorsMap.put(contributor, true);
            if (ContainerUtil.and(this.contributorsMap.values(), Boolean::booleanValue)) {
                this.cancelScheduledFlush();
                this.buffer.flushBuffer(this.delegateListener);
                this.listModel.freezeElements();
            }
        }
    }

    private void cancelScheduledFlush() {
        if (this.flushFuture != null) {
            this.flushFuture.cancel(false);
        }
    }

    private void scheduleFlush(long timeoutMs) {
        if (this.flushFuture != null && !this.flushFuture.isDone()) {
            return;
        }
        Runnable command2 = () -> {
            this.logNonFinished();
            this.buffer.flushBuffer(this.delegateListener);
            this.listModel.freezeElements();
        };
        this.flushFuture = this.executorService.schedule(command2, timeoutMs, TimeUnit.MILLISECONDS);
    }

    private void logNonFinished() {
        this.contributorsMap.forEach((contributor, finished) -> {
            if (!finished.booleanValue()) {
                LOG.warn("Contributor '" + contributor.getSearchProviderId() + "' did not finish search for '" + this.mySearchPattern.get() + "' in " + this.waitTimeoutMs + "ms. Maybe it should implement PossibleSlowContributor interface?");
            }
        });
    }

    private void resetState(Collection<? extends SearchEverywhereContributor<?>> contributors) {
        this.cancelScheduledFlush();
        this.buffer.clearBuffer();
        Map map2 = contributors.stream().filter(c2 -> !PossibleSlowContributor.checkSlow(c2)).collect(Collectors.toMap(Function.identity(), c2 -> false));
        this.contributorsMap.clear();
        this.contributorsMap.putAll(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasMoreContributors";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/WaitForContributorsListenerWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchStarted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFinished";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsAdded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "elementsRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "contributorFinished";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "contributorWaits";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "markContributorAndCheckFlush";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

