/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.setesting;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\nH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/setesting/ResultsGraph;", "Ljavax/swing/JComponent;", "contributorName", "", "resultTimings", "", "", "maxShownTime", "(Ljava/lang/String;Ljava/util/List;J)V", "groupingInterval", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "paint", "", "g", "Ljava/awt/Graphics;", "paintBackground", "paintContent", "rect", "Ljava/awt/Rectangle;", "paintCountAxis", "fontMetrics", "Ljava/awt/FontMetrics;", "paintGraph", "timings", "columnWidth", "paintName", "point", "Ljava/awt/Point;", "paintTimeAxis", "g2", "printNoData", "setGroupingInterval", "interval", "intellij.platform.lang.impl"})
public final class ResultsGraph
extends JComponent {
    @NotNull
    private final String contributorName;
    @NotNull
    private final List<Long> resultTimings;
    private final long maxShownTime;
    private int groupingInterval;

    public ResultsGraph(@NotNull String contributorName, @NotNull List<Long> resultTimings, long maxShownTime) {
        Intrinsics.checkNotNullParameter((Object)contributorName, (String)"contributorName");
        Intrinsics.checkNotNullParameter(resultTimings, (String)"resultTimings");
        this.contributorName = contributorName;
        this.resultTimings = resultTimings;
        this.maxShownTime = maxShownTime;
        this.groupingInterval = 100;
        this.setOpaque(true);
        this.setBackground(JBColor.white);
        this.setBorder(JBUI.Borders.customLine(JBColor.gray));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(300, 200);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public final void setGroupingInterval(int interval) {
        this.groupingInterval = interval;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.isOpaque()) {
            this.paintBackground(g);
        }
        this.paintBorder(g);
        Rectangle rect2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        JBInsets.removeFrom(rect2, this.getInsets());
        this.paintContent(g, rect2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintContent(Graphics g, Rectangle rect2) {
        Graphics g2 = g.create();
        try {
            FontMetrics fontMetrics = g2.getFontMetrics();
            int nameBaseLine = rect2.y + fontMetrics.getAscent() + fontMetrics.getLeading();
            Point point = new Point(0, nameBaseLine);
            Intrinsics.checkNotNullExpressionValue((Object)g2, (String)"g2");
            this.paintName(this.contributorName, point, g2);
            int nameHeight = fontMetrics.getLeading() + fontMetrics.getAscent() + fontMetrics.getDescent() + 10;
            int countAxisWith = fontMetrics.stringWidth("000") + 4;
            int timeAxisHeight = fontMetrics.getAscent() + 4;
            Rectangle countAxisRect = new Rectangle(rect2.x, rect2.y, countAxisWith, rect2.height);
            Rectangle timeAxisRect = new Rectangle(rect2.x, (int)rect2.getMaxY() - timeAxisHeight, rect2.width, timeAxisHeight);
            Rectangle graphRect = new Rectangle(rect2.x, rect2.y, rect2.width, rect2.height);
            JBInsets.removeFrom(countAxisRect, (Insets)JBUI.insets(nameHeight, 0, timeAxisHeight, 0));
            JBInsets.removeFrom(timeAxisRect, (Insets)JBUI.insetsLeft(countAxisWith));
            JBInsets.removeFrom(graphRect, (Insets)JBUI.insets(nameHeight, countAxisWith, timeAxisHeight, 0));
            int columnWidth = (int)((long)graphRect.width / (this.maxShownTime / (long)this.groupingInterval + 1L));
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fontMetrics");
            this.paintCountAxis(g2, fontMetrics, countAxisRect);
            this.paintTimeAxis(g2, fontMetrics, timeAxisRect, columnWidth);
            this.paintGraph(this.resultTimings, graphRect, g2, columnWidth);
        }
        finally {
            g2.dispose();
        }
    }

    private final void paintCountAxis(Graphics g, FontMetrics fontMetrics, Rectangle rect2) {
        g.setColor(JBColor.gray);
        g.drawLine((int)rect2.getMaxX(), (int)rect2.getMinY(), (int)rect2.getMaxX(), (int)rect2.getMaxY());
        Map<Long, Long> intervals2 = this.resultTimings.stream().collect(Collectors.groupingBy(arg_0 -> ResultsGraph.paintCountAxis$lambda$0((Function1)new Function1<Long, Long>(this){
            final /* synthetic */ ResultsGraph this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Long invoke(Long it) {
                return it / (long)ResultsGraph.access$getGroupingInterval$p(this.this$0);
            }
        }, arg_0), Collectors.counting()));
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)intervals2.values());
        if (l == null) {
            return;
        }
        long maxCount = l;
        long step2 = (long)Math.ceil((double)maxCount / (double)5);
        if (step2 <= 0L) {
            throw new IllegalArgumentException("Step must be positive, was: " + step2 + ".");
        }
        long i2 = step2;
        long l2 = ProgressionUtilKt.getProgressionLastElement((long)step2, (long)maxCount, (long)step2);
        if (i2 <= l2) {
            while (true) {
                String text2 = String.valueOf(i2);
                int stringWidth = fontMetrics.stringWidth(text2);
                int yPoint = (int)(rect2.getMaxY() - (double)i2 / (double)maxCount * (double)rect2.height) + fontMetrics.getAscent();
                int xPoint = (int)(rect2.getMaxX() - (double)4 - (double)stringWidth);
                g.drawString(text2, xPoint, yPoint);
                if (i2 == l2) break;
                i2 += step2;
            }
        }
    }

    private final void paintTimeAxis(Graphics g2, FontMetrics fontMetrics, Rectangle rect2, int columnWidth) {
        int axisStep;
        g2.setColor(JBColor.gray);
        g2.drawLine(rect2.x, rect2.y, (int)rect2.getMaxX(), rect2.y);
        int y = rect2.y + fontMetrics.getAscent() + 3;
        int columnCount = (int)Math.ceil((double)this.maxShownTime / (double)this.groupingInterval);
        int n = axisStep = (int)Math.ceil((double)columnCount / (double)4);
        if (n <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + n + ".");
        }
        int i2 = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)columnCount, (int)n);
        int n3 = n;
        if (i2 <= n2) {
            while (true) {
                int x = i2 * columnWidth + rect2.x;
                String text2 = String.valueOf(i2 * this.groupingInterval);
                g2.drawString(text2, x, y);
                if (i2 == n2) break;
                i2 += n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintName(String contributorName, Point point, Graphics g) {
        Graphics g2 = g.create();
        try {
            g2.setColor(this.getForeground());
            g2.drawString(contributorName, point.x, point.y);
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintBackground(Graphics g) {
        Graphics g2 = g.create();
        try {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintGraph(List<Long> timings, Rectangle rect2, Graphics g, int columnWidth) {
        Graphics g2 = g.create();
        try {
            if (timings.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)g2, (String)"g2");
                this.printNoData(g2, rect2);
                return;
            }
            g2.setColor(JBColor.blue);
            Map<Long, Long> intervals2 = timings.stream().collect(Collectors.groupingBy(arg_0 -> ResultsGraph.paintGraph$lambda$1((Function1)new Function1<Long, Long>(this){
                final /* synthetic */ ResultsGraph this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Long invoke(Long it) {
                    return it / (long)ResultsGraph.access$getGroupingInterval$p(this.this$0);
                }
            }, arg_0), Collectors.counting()));
            Long maxIntervalItems = (Long)CollectionsKt.maxOrThrow((Iterable)intervals2.values());
            int bottomLine = (int)rect2.getMaxY();
            Intrinsics.checkNotNullExpressionValue(intervals2, (String)"intervals");
            for (Map.Entry<Long, Long> intervalItems : intervals2.entrySet()) {
                double d = (double)rect2.height * 1.0;
                Long l = intervalItems.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"intervalItems.value");
                double d2 = d * ((Number)l).doubleValue();
                Intrinsics.checkNotNullExpressionValue((Object)maxIntervalItems, (String)"maxIntervalItems");
                int columnHeight = (int)(d2 / (double)maxIntervalItems.longValue());
                Point point = new Point(rect2.x + (int)(((Number)intervalItems.getKey()).longValue() * (long)columnWidth), bottomLine - columnHeight);
                g2.fillRect(point.x, point.y, columnWidth, columnHeight);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private final void printNoData(Graphics g, Rectangle rect2) {
        g.setColor(JBColor.gray);
        String str = "No elements";
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(str, g);
        g.drawString(str, rect2.x + (rect2.width - (int)stringBounds.getWidth()) / 2, rect2.y + (rect2.height - (int)stringBounds.getHeight()) / 2);
    }

    private static final Long paintCountAxis$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    private static final Long paintGraph$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$getGroupingInterval$p(ResultsGraph $this) {
        return $this.groupingInterval;
    }
}

