/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.statistics.FinishedSearchPerformanceInfo;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchPerformanceTracker;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchSessionPerformanceInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public final class SearchFieldStatisticsCollector
implements Disposable {
    private final Project myProject;
    private final JTextField myTextField;
    private final SearchPerformanceTracker myPerformanceTracker;
    private int mySymbolKeysTyped;
    private int myNavKeysTyped;

    private SearchFieldStatisticsCollector(JTextField field, SearchPerformanceTracker performanceTracker, Project project2) {
        this.myProject = project2;
        this.myPerformanceTracker = performanceTracker;
        this.myTextField = field;
    }

    public static SearchFieldStatisticsCollector createAndStart(JTextField field, SearchPerformanceTracker performanceTracker, Project project2) {
        SearchFieldStatisticsCollector res = new SearchFieldStatisticsCollector(field, performanceTracker, project2);
        res.initListeners();
        return res;
    }

    @Override
    public void dispose() {
        SearchSessionPerformanceInfo info2 = this.myPerformanceTracker.getPerformanceInfo();
        SearchEverywhereUsageTriggerCollector.SESSION_FINISHED.log(this.myProject, pairs -> {
            FinishedSearchPerformanceInfo lastSearch;
            FinishedSearchPerformanceInfo firstSearch = info2.getFirstSearch();
            if (firstSearch != null) {
                pairs.add(SearchEverywhereUsageTriggerCollector.FIRST_TAB_ID.with((Object)firstSearch.getTab()));
                pairs.add(SearchEverywhereUsageTriggerCollector.TIME_TO_FIRST_RESULT.with((Object)firstSearch.getTimeToFirstResult()));
            }
            if ((lastSearch = info2.getLastSearch()) != null) {
                pairs.add(SearchEverywhereUsageTriggerCollector.LAST_TAB_ID.with((Object)lastSearch.getTab()));
                pairs.add(SearchEverywhereUsageTriggerCollector.TIME_TO_FIRST_RESULT_LAST_QUERY.with((Object)lastSearch.getTimeToFirstResult()));
            }
            pairs.add(SearchEverywhereUsageTriggerCollector.TYPED_NAVIGATION_KEYS.with((Object)this.myNavKeysTyped));
            pairs.add(SearchEverywhereUsageTriggerCollector.TYPED_SYMBOL_KEYS.with((Object)this.mySymbolKeysTyped));
            pairs.add(SearchEverywhereUsageTriggerCollector.DURATION_MS.with((Object)info2.getDuration()));
        });
    }

    private void initListeners() {
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ++SearchFieldStatisticsCollector.this.mySymbolKeysTyped;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 38 || code == 224 || code == 33 || code == 40 || code == 225 || code == 34) {
                    ++SearchFieldStatisticsCollector.this.myNavKeysTyped;
                }
            }
        });
    }
}

