/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.statistics.FinishedSearchPerformanceInfo;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchPerformanceInfo;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchSessionPerformanceInfo;
import com.intellij.util.TimeoutUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u000f2\u0016\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00130\u001eH\u0016J$\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00042\u0012\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\"H\u0016J\b\u0010#\u001a\u00020\u000fH\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/statistics/SearchPerformanceTracker;", "Lcom/intellij/ide/actions/searcheverywhere/SearchListener;", "tabIdProvider", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "currentSearch", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ide/actions/searcheverywhere/statistics/SearchPerformanceInfo;", "firstSearch", "Lcom/intellij/ide/actions/searcheverywhere/statistics/FinishedSearchPerformanceInfo;", "initTime", "", "lastSearch", "contributorFinished", "", "contributor", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "hasMore", "", "contributorWaits", "elementsAdded", "list", "", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereFoundElementInfo;", "elementsRemoved", "getPerformanceInfo", "Lcom/intellij/ide/actions/searcheverywhere/statistics/SearchSessionPerformanceInfo;", "searchFinished", "hasMoreContributors", "", "searchStarted", "pattern", "contributors", "", "stop", "intellij.platform.lang.impl"})
public final class SearchPerformanceTracker
implements SearchListener {
    @NotNull
    private final Function0<String> tabIdProvider;
    private final long initTime;
    @NotNull
    private final AtomicReference<SearchPerformanceInfo> currentSearch;
    @Nullable
    private FinishedSearchPerformanceInfo firstSearch;
    @Nullable
    private FinishedSearchPerformanceInfo lastSearch;

    public SearchPerformanceTracker(@NotNull Function0<String> tabIdProvider) {
        Intrinsics.checkNotNullParameter(tabIdProvider, (String)"tabIdProvider");
        this.tabIdProvider = tabIdProvider;
        this.initTime = System.nanoTime();
        this.currentSearch = new AtomicReference();
    }

    @Override
    public void searchStarted(@NotNull String pattern, @NotNull Collection<? extends SearchEverywhereContributor<?>> contributors) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(contributors, (String)"contributors");
        String tab = (String)this.tabIdProvider.invoke();
        this.currentSearch.set(((CharSequence)pattern).length() > 0 ? new SearchPerformanceInfo(tab) : null);
    }

    @Override
    public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.stop();
    }

    @Override
    public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
    }

    @Override
    public void contributorWaits(@NotNull SearchEverywhereContributor<?> contributor) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
    }

    @Override
    public void contributorFinished(@NotNull SearchEverywhereContributor<?> contributor, boolean hasMore) {
        Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        Intrinsics.checkNotNullParameter(hasMoreContributors, (String)"hasMoreContributors");
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stop() {
        Object object = this.currentSearch.getAndUpdate(SearchPerformanceTracker::stop$lambda$0);
        if (object != null && (object = ((SearchPerformanceInfo)object).stop()) != null) {
            Object it = object;
            boolean bl = false;
            SearchPerformanceTracker searchPerformanceTracker = this;
            synchronized (searchPerformanceTracker) {
                boolean bl2 = false;
                if (this.firstSearch == null) {
                    this.firstSearch = it;
                }
                this.lastSearch = it;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SearchSessionPerformanceInfo getPerformanceInfo() {
        long totalDuration = TimeoutUtil.getDurationMillis(this.initTime);
        SearchPerformanceTracker searchPerformanceTracker = this;
        synchronized (searchPerformanceTracker) {
            boolean bl = false;
            SearchSessionPerformanceInfo searchSessionPerformanceInfo = new SearchSessionPerformanceInfo(this.firstSearch, this.lastSearch, totalDuration);
            return searchSessionPerformanceInfo;
        }
    }

    private static final SearchPerformanceInfo stop$lambda$0(SearchPerformanceInfo it) {
        return null;
    }
}

