/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00110\u0016J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "(Lcom/intellij/ide/bookmark/BookmarkGroup;Lcom/intellij/ide/bookmark/Bookmark;)V", "current", "", "snapshot", "", "(Lcom/intellij/ide/bookmark/BookmarkGroup;Lcom/intellij/ide/bookmark/Bookmark;ILjava/util/List;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "getGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "equals", "", "other", "hashCode", "next", "predicate", "Lkotlin/Function1;", "nextFileBookmark", "nextLineBookmark", "previous", "previousFileBookmark", "previousLineBookmark", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarkOccurrence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n378#2,7:70\n288#2,2:77\n350#2,7:79\n533#2,6:86\n*S KotlinDebug\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence\n*L\n21#1:70,7\n24#1:77,2\n36#1:79,7\n40#1:86,6\n*E\n"})
public final class BookmarkOccurrence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BookmarkGroup group;
    @NotNull
    private final Bookmark bookmark;
    private final int current;
    @Nullable
    private final List<BookmarkOccurrence> snapshot;

    public BookmarkOccurrence(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark, int current, @Nullable List<BookmarkOccurrence> snapshot) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.group = group2;
        this.bookmark = bookmark;
        this.current = current;
        this.snapshot = snapshot;
    }

    @NotNull
    public final BookmarkGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final Bookmark getBookmark() {
        return this.bookmark;
    }

    public BookmarkOccurrence(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this(group2, bookmark, -1, null);
    }

    @Nullable
    public final BookmarkOccurrence nextFileBookmark() {
        return this.next((Function1<? super BookmarkOccurrence, Boolean>)((Function1)nextFileBookmark.1.INSTANCE));
    }

    @Nullable
    public final BookmarkOccurrence nextLineBookmark() {
        return this.next((Function1<? super BookmarkOccurrence, Boolean>)((Function1)nextLineBookmark.1.INSTANCE));
    }

    @Nullable
    public final BookmarkOccurrence next(@NotNull Function1<? super BookmarkOccurrence, Boolean> predicate2) {
        BookmarkOccurrence occurrence;
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        List<BookmarkOccurrence> list2 = this.snapshot;
        if (list2 == null) {
            Project project2 = this.bookmark.getProvider().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"bookmark.provider.project");
            BookmarksManagerImpl bookmarksManagerImpl = BookmarkOccurrence.Companion.manager(project2);
            list2 = bookmarksManagerImpl != null ? bookmarksManagerImpl.getSnapshot$intellij_platform_lang_impl() : null;
            if (list2 == null) {
                return null;
            }
        }
        List<BookmarkOccurrence> list3 = list2;
        int index2 = this.current;
        if (index2 < 0) {
            int n;
            block8: {
                List<BookmarkOccurrence> $this$indexOfLast$iv = list3;
                boolean $i$f$indexOfLast = false;
                ListIterator<BookmarkOccurrence> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    BookmarkOccurrence it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.group, (Object)this.group) && Intrinsics.areEqual((Object)it.bookmark, (Object)this.bookmark))) continue;
                    n = iterator$iv.nextIndex();
                    break block8;
                }
                n = -1;
            }
            index2 = n;
        }
        do {
            BookmarkOccurrence bookmarkOccurrence;
            if ((BookmarkOccurrence)CollectionsKt.getOrNull(list3, (int)(++index2)) != null) continue;
            if (Companion.getCyclic()) {
                Object v4;
                block9: {
                    Iterable $this$firstOrNull$iv = list3;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                        v4 = element$iv;
                        break block9;
                    }
                    v4 = null;
                }
                bookmarkOccurrence = v4;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        } while (!((Boolean)predicate2.invoke((Object)occurrence)).booleanValue());
        return occurrence;
    }

    @Nullable
    public final BookmarkOccurrence previousFileBookmark() {
        return this.previous((Function1<? super BookmarkOccurrence, Boolean>)((Function1)previousFileBookmark.1.INSTANCE));
    }

    @Nullable
    public final BookmarkOccurrence previousLineBookmark() {
        return this.previous((Function1<? super BookmarkOccurrence, Boolean>)((Function1)previousLineBookmark.1.INSTANCE));
    }

    @Nullable
    public final BookmarkOccurrence previous(@NotNull Function1<? super BookmarkOccurrence, Boolean> predicate2) {
        BookmarkOccurrence occurrence;
        int index2;
        List<BookmarkOccurrence> list2;
        block10: {
            Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
            List<BookmarkOccurrence> list3 = this.snapshot;
            if (list3 == null) {
                Project project2 = this.bookmark.getProvider().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"bookmark.provider.project");
                BookmarksManagerImpl bookmarksManagerImpl = BookmarkOccurrence.Companion.manager(project2);
                list3 = bookmarksManagerImpl != null ? bookmarksManagerImpl.getSnapshot$intellij_platform_lang_impl() : null;
                if (list3 == null) {
                    return null;
                }
            }
            list2 = list3;
            index2 = this.current;
            if (index2 < 0) {
                int n;
                List<BookmarkOccurrence> $this$indexOfFirst$iv = list2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<BookmarkOccurrence> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    BookmarkOccurrence item$iv;
                    BookmarkOccurrence it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.group, (Object)this.group) && Intrinsics.areEqual((Object)it.bookmark, (Object)this.bookmark)) {
                        n = index$iv;
                        break block10;
                    }
                    ++index$iv;
                }
                n = index2 = -1;
            }
        }
        if (index2 < 0) {
            index2 = list2.size();
        }
        do {
            BookmarkOccurrence bookmarkOccurrence;
            if ((BookmarkOccurrence)CollectionsKt.getOrNull(list2, (int)(--index2)) != null) continue;
            if (Companion.getCyclic()) {
                BookmarkOccurrence bookmarkOccurrence2;
                block11: {
                    List<BookmarkOccurrence> $this$lastOrNull$iv = list2;
                    boolean $i$f$lastOrNull = false;
                    ListIterator<BookmarkOccurrence> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        BookmarkOccurrence element$iv = iterator$iv.previous();
                        if (!((Boolean)predicate2.invoke((Object)element$iv)).booleanValue()) continue;
                        bookmarkOccurrence2 = element$iv;
                        break block11;
                    }
                    bookmarkOccurrence2 = null;
                }
                bookmarkOccurrence = bookmarkOccurrence2;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        } while (!((Boolean)predicate2.invoke((Object)occurrence)).booleanValue());
        return occurrence;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.group, this.bookmark};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof BookmarkOccurrence && Intrinsics.areEqual((Object)((BookmarkOccurrence)other).group, (Object)this.group) && Intrinsics.areEqual((Object)((BookmarkOccurrence)other).bookmark, (Object)this.bookmark);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/bookmark/BookmarkOccurrence$Companion;", "", "()V", "cyclic", "", "getCyclic", "()Z", "first", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "project", "Lcom/intellij/openapi/project/Project;", "predicate", "Lkotlin/Function1;", "firstFileBookmark", "firstLineBookmark", "last", "lastFileBookmark", "lastLineBookmark", "manager", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nBookmarkOccurrence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n288#2,2:70\n533#2,6:72\n*S KotlinDebug\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence$Companion\n*L\n61#1:70,2\n66#1:72,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BookmarksManagerImpl manager(Project project2) {
            BookmarksManager bookmarksManager = BookmarksManager.getInstance(project2);
            return bookmarksManager instanceof BookmarksManagerImpl ? (BookmarksManagerImpl)bookmarksManager : null;
        }

        public final boolean getCyclic() {
            return Registry.is("ide.bookmark.occurrence.cyclic.iteration.allowed", false);
        }

        @Nullable
        public final BookmarkOccurrence firstFileBookmark(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.first(project2, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)firstFileBookmark.1.INSTANCE));
        }

        @Nullable
        public final BookmarkOccurrence firstLineBookmark(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.first(project2, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)firstLineBookmark.1.INSTANCE));
        }

        @Nullable
        public final BookmarkOccurrence first(@NotNull Project project2, @NotNull Function1<? super BookmarkOccurrence, Boolean> predicate2) {
            BookmarkOccurrence bookmarkOccurrence;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
            Object object = this.manager(project2);
            if (object != null && (object = ((BookmarksManagerImpl)object).getSnapshot$intellij_platform_lang_impl()) != null) {
                Object v1;
                block3: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                bookmarkOccurrence = v1;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        }

        @Nullable
        public final BookmarkOccurrence lastFileBookmark(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.last(project2, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)lastFileBookmark.1.INSTANCE));
        }

        @Nullable
        public final BookmarkOccurrence lastLineBookmark(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return this.last(project2, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)lastLineBookmark.1.INSTANCE));
        }

        @Nullable
        public final BookmarkOccurrence last(@NotNull Project project2, @NotNull Function1<? super BookmarkOccurrence, Boolean> predicate2) {
            BookmarkOccurrence bookmarkOccurrence;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
            Object object = this.manager(project2);
            if (object != null && (object = ((BookmarksManagerImpl)object).getSnapshot$intellij_platform_lang_impl()) != null) {
                Object v1;
                block3: {
                    Object $this$lastOrNull$iv = object;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                bookmarkOccurrence = v1;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

