/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarkState;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.BookmarksManagerImplKt;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.GroupState;
import com.intellij.ide.bookmark.GutterLineBookmarkRenderer;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.ManagerState;
import com.intellij.ide.bookmark.ModificationNotifier;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.GroupCreateDialog;
import com.intellij.ide.bookmark.ui.GroupSelectDialog;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TreeItem;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@State(name="BookmarksManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0006\u0084\u0001\u0085\u0001\u0086\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0013H\u0016J\u001c\u0010/\u001a\u00020&2\u0006\u00100\u001a\u0002012\n\u0010\u000e\u001a\u00060\rR\u00020\u0000H\u0002J%\u00102\u001a\u00060\rR\u00020\u00002\u0006\u0010,\u001a\u00020-2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\tH\u0002J$\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u00108\u001a\b\u0012\u0004\u0012\u00020+0\u001eJ$\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001c\u0010;\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001eJ\u0018\u0010>\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\u0006\u00109\u001a\u00020\u001fH\u0002J\u001c\u0010>\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0010\u0010?\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\tH\u0002J\u0018\u0010@\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010A\u001a\u00020\tH\u0002J\u0018\u0010B\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J \u0010C\u001a\b\u0018\u00010\rR\u00020\u00002\u0010\u00108\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\u001eH\u0002J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+H\u0002J\u0014\u0010D\u001a\u00020\u00132\n\u0010\u000e\u001a\u00060\rR\u00020\u0000H\u0002J\u0019\u0010E\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\bF2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010I\u001a\u00020-2\u0006\u0010'\u001a\u00020\tH\u0002J:\u0010J\u001a\u00020\u00132\n\u0010\u000e\u001a\u00060\rR\u00020\u00002\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0016\u0010K\u001a\u0012\u0012\b\u0012\u00060\rR\u00020\u0000\u0012\u0004\u0012\u0002010LH\u0002J$\u0010J\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u00108\u001a\b\u0012\u0004\u0012\u00020+0\u001eJ$\u0010J\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u001f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ:\u0010M\u001a\u00020\u00132\n\u0010\u000e\u001a\u00060\rR\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001e2\u0016\u0010K\u001a\u0012\u0012\b\u0012\u00060\rR\u00020\u0000\u0012\u0004\u0012\u0002010LH\u0002J$\u0010M\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u001f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001eJ\u001c\u0010N\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001eJ\u001c\u0010O\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ \u0010P\u001a\b\u0018\u00010\rR\u00020\u00002\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010Q\u001a\u000201H\u0002J\u001c\u0010R\u001a\u000e\u0012\b\u0012\u00060\rR\u00020\u0000\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020\tH\u0002J\u001c\u0010S\u001a\u000e\u0012\b\u0012\u00060\rR\u00020\u0000\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020\tH\u0002J\u0016\u0010T\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0002J\u0017\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010'\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bWJ\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020)0YH\u0016J\u0012\u0010Z\u001a\u0004\u0018\u00010\t2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010[\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0016J\n\u0010\\\u001a\u0004\u0018\u00010+H\u0016J\u0017\u0010]\u001a\t\u0018\u00010^\u00a2\u0006\u0002\b\u00182\u0006\u0010'\u001a\u00020\tH\u0002J\u0012\u0010_\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020+0\u001eH\u0016J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020+0\u001e2\u0006\u0010'\u001a\u00020\tH\u0016J\u0017\u0010a\u001a\t\u0018\u00010^\u00a2\u0006\u0002\b\u00182\u0006\u0010'\u001a\u00020\tH\u0002J\b\u0010b\u001a\u00020\u0003H\u0016J\b\u0010c\u001a\u00020dH\u0016J\u0012\u0010e\u001a\u0004\u0018\u00010)2\u0006\u0010'\u001a\u00020\tH\u0016J\u0018\u0010f\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\t2\u0006\u0010g\u001a\u00020^H\u0002J\u0010\u0010h\u001a\u00020&2\u0006\u0010i\u001a\u00020\u0003H\u0016J\u001e\u0010j\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020+2\u0006\u0010'\u001a\u00020\t2\u0006\u0010k\u001a\u00020\tJ\u0016\u0010j\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020+2\u0006\u0010k\u001a\u00020+J\u0018\u0010l\u001a\u00020&2\u0006\u0010m\u001a\u0002012\u0006\u0010n\u001a\u000201H\u0002J\b\u0010o\u001a\u00020&H\u0016J\u0010\u0010o\u001a\u00020&2\u0006\u0010p\u001a\u00020qH\u0002J\u0015\u0010r\u001a\u00020&2\u0006\u0010g\u001a\u00020^H\u0000\u00a2\u0006\u0002\bsJ\b\u0010t\u001a\u00020&H\u0016J\u0010\u0010t\u001a\u00020&2\u0006\u0010'\u001a\u00020\tH\u0016J\u0017\u0010u\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010vJ4\u0010w\u001a\u001a\u0012\b\u0012\u00060\nR\u00020\u0000\u0012\n\u0012\b\u0018\u00010yR\u00020\u0000\u0018\u00010x2\n\u0010\u000e\u001a\u00060\rR\u00020\u00002\u0006\u0010'\u001a\u00020\tH\u0002J\u0014\u0010z\u001a\u00060\rR\u00020\u00002\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010{\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010A\u001a\u00020\tH\u0002J\u0018\u0010|\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010}\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020+J\u0018\u0010~\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\u001f\u0010\u007f\u001a\u00020&2\u0015\u0010\u0080\u0001\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016J\u001b\u0010\u0081\u0001\u001a\u00020\u00132\u0007\u0010\u0082\u0001\u001a\u00020\t2\u0007\u0010\u0083\u0001\u001a\u00020\tH\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\b\u0018\u00010\rR\u00020\u00002\f\u0010\u000e\u001a\b\u0018\u00010\rR\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010!\u00a8\u0006\u0087\u0001"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "Lcom/intellij/ide/bookmark/BookmarksManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/ide/bookmark/ManagerState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allBookmarks", "", "Lcom/intellij/ide/bookmark/Bookmark;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "allGroups", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "group", "defaultGroup", "setDefaultGroup", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;)V", "groupLineBookmarks", "", "getGroupLineBookmarks", "()Z", "invoker", "Lcom/intellij/util/concurrency/Invoker;", "Lorg/jetbrains/annotations/NotNull;", "notifier", "Lcom/intellij/ide/bookmark/ModificationNotifier;", "getProject", "()Lcom/intellij/openapi/project/Project;", "snapshot", "", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getSnapshot$intellij_platform_lang_impl", "()Ljava/util/List;", "sortedProviders", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "getSortedProviders", "add", "", "bookmark", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "addGroup", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "name", "", "isDefault", "addGroupTo", "index", "", "addOrReuseGroup", "isDefaultState", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "canAdd", "canDrag", "above", "groups", "occurrence", "occurrences", "canDragAddInto", "files", "Ljava/io/File;", "canDragInto", "canRemove", "canRewriteType", "allowed", "canToggle", "chooseGroupToAdd", "contains", "createBookmark", "Lorg/jetbrains/annotations/Nullable;", "context", "", "createDescription", "drag", "indexSupplier", "Lkotlin/Function1;", "dragAdd", "dragAddInto", "dragInto", "findGroup", "hash", "findGroupsToAdd", "findGroupsToRemove", "findInfo", "findLineHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "findLineHighlighter$intellij_platform_lang_impl", "getAssignedTypes", "", "getBookmark", "getBookmarks", "getDefaultGroup", "getFileGrouping", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGroup", "getGroups", "getLineGrouping", "getState", "getStateModificationCount", "", "getType", "isLineGrouping", "file", "loadState", "state", "move", "anchor", "moveGroup", "fromIndex", "toIndex", "noStateLoaded", "manager", "Lcom/intellij/ide/favoritesTreeView/FavoritesManager;", "refreshRenderers", "refreshRenderers$intellij_platform_lang_impl", "remove", "removeFromAllGroups", "(Lcom/intellij/ide/bookmark/Bookmark;)Lkotlin/Unit;", "removeFromGroup", "Lkotlin/Pair;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "removeGroupFrom", "rewriteType", "setType", "sort", "toggle", "update", "map", "updateInAllGroups", "old", "new", "Group", "InGroupInfo", "InManagerInfo", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,655:1\n1054#2:656\n1620#2,3:658\n1855#2:661\n1855#2,2:662\n1856#2:664\n288#2,2:665\n766#2:667\n857#2,2:668\n1549#2:670\n1620#2,3:671\n857#2,2:674\n766#2:676\n857#2,2:677\n766#2:679\n857#2,2:680\n1855#2,2:682\n350#2,7:684\n350#2,7:691\n1726#2,3:698\n1726#2,3:701\n1726#2,3:704\n1726#2,3:707\n1726#2,3:710\n1726#2,3:713\n1620#2,3:716\n1855#2,2:719\n1855#2,2:721\n1620#2,3:723\n1747#2,3:726\n1603#2,9:729\n1855#2:738\n1856#2:740\n1612#2:741\n1855#2,2:742\n1855#2,2:744\n1855#2,2:746\n1855#2,2:748\n1855#2,2:750\n1#3:657\n1#3:739\n*S KotlinDebug\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl\n*L\n56#1:656\n74#1:658,3\n79#1:661\n81#1:662,2\n79#1:664\n114#1:665,2\n129#1:667\n129#1:668,2\n151#1:670\n151#1:671,3\n151#1:674,2\n191#1:676\n191#1:677,2\n215#1:679\n215#1:680,2\n219#1:682,2\n277#1:684,7\n279#1:691,7\n340#1:698,3\n349#1:701,3\n353#1:704,3\n356#1:707,3\n357#1:710,3\n368#1:713,3\n374#1:716,3\n377#1:719,2\n381#1:721,2\n387#1:723,3\n388#1:726,3\n404#1:729,9\n404#1:738\n404#1:740\n404#1:741\n406#1:742,2\n412#1:744,2\n414#1:746,2\n623#1:748,2\n95#1:750,2\n404#1:739\n*E\n"})
public final class BookmarksManagerImpl
implements BookmarksManager,
PersistentStateComponentWithModificationTracker<ManagerState> {
    @NotNull
    private final Project project;
    @NotNull
    private final Invoker invoker;
    @NotNull
    private final ModificationNotifier notifier;
    @NotNull
    private final Map<Bookmark, InManagerInfo> allBookmarks;
    @NotNull
    private final List<Group> allGroups;
    @Nullable
    private Group defaultGroup;

    public BookmarksManagerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Invoker invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"forBackgroundThreadWithReadAction(project)");
        this.invoker = invoker;
        this.notifier = new ModificationNotifier(this.project);
        this.allBookmarks = new LinkedHashMap();
        this.allGroups = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setDefaultGroup(Group group2) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            block6: {
                Group old;
                block7: {
                    boolean bl = false;
                    old = this.defaultGroup;
                    if (old == group2) break block6;
                    Group group3 = group2;
                    if (group3 == null) break block7;
                    Group it = group3;
                    boolean bl2 = false;
                    int index2 = this.allGroups.indexOf(it);
                    if (index2 < 0) break block6;
                    if (index2 > 0) {
                        this.moveGroup(index2, 0);
                    }
                }
                this.defaultGroup = group2;
                this.notifier.defaultGroupChanged(old, group2);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    private final boolean getGroupLineBookmarks() {
        return BookmarksViewState.Companion.getInstance(this.project).getGroupLineBookmarks();
    }

    private final List<BookmarkProvider> getSortedProviders() {
        List list2;
        if (this.project.isDisposed()) {
            list2 = CollectionsKt.emptyList();
        } else {
            Iterable $this$sortedByDescending$iv = BookmarkProvider.EP.getExtensions(this.project);
            boolean $i$f$sortedByDescending = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BookmarkProvider it = (BookmarkProvider)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getWeight());
                    it = (BookmarkProvider)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWeight()));
                }
            });
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BookmarkOccurrence> getSnapshot$intellij_platform_lang_impl() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            List list3 = this.notifier.getSnapshot$intellij_platform_lang_impl();
            if (list3 == null) {
                List list4;
                List it = list4 = (List)new ArrayList();
                boolean bl2 = false;
                this.notifier.setSnapshot$intellij_platform_lang_impl(it);
                for (Group group2 : this.allGroups) {
                    for (Bookmark bookmark : group2.getBookmarks()) {
                        it.add(new BookmarkOccurrence(group2, bookmark, it.size(), it));
                    }
                }
                list3 = list4;
            }
            list2 = list3;
        }
        return list2;
    }

    @Override
    public long getStateModificationCount() {
        return this.notifier.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ManagerState getState() {
        ManagerState managerState;
        ManagerState $this$getState_u24lambda_u247 = managerState = new ManagerState();
        boolean bl = false;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            void $this$mapTo$iv;
            boolean bl2 = false;
            Iterable iterable = this.allGroups;
            Collection destination$iv = $this$getState_u24lambda_u247.getGroups();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Group group2 = (Group)item$iv;
                Collection collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getState$intellij_platform_lang_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return managerState;
    }

    @Override
    public void loadState(@NotNull ManagerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.remove();
        Iterable $this$forEach$iv = state.getGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GroupState it = (GroupState)element$iv;
            boolean bl = false;
            Group group2 = this.addOrReuseGroup(it.getName(), it.isDefault());
            Iterable $this$forEach$iv2 = it.getBookmarks();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BookmarkState bookmark = (BookmarkState)element$iv2;
                boolean bl2 = false;
                group2.addLater$intellij_platform_lang_impl(bookmark, bookmark.getType(), bookmark.getDescription());
            }
        }
    }

    @Override
    public void noStateLoaded() {
        String string2 = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.name");
        Group group2 = BookmarksManagerImpl.addOrReuseGroup$default(this, string2, null, 2, null);
        BookmarksListener listener2 = new BookmarksListener(group2){
            final /* synthetic */ Group $group;
            {
                this.$group = $group;
            }

            public void bookmarkAdded(@NotNull com.intellij.ide.bookmarks.Bookmark old) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                BookmarkType bookmarkType = old.getType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)bookmarkType), (String)"old.type");
                this.$group.addLater$intellij_platform_lang_impl(old, bookmarkType, old.getDescription());
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<BookmarksListener> topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, listener2);
        StartupManager.getInstance(this.project).runAfterOpened(() -> BookmarksManagerImpl.noStateLoaded$lambda$12(this, listener2));
    }

    private final void noStateLoaded(FavoritesManager manager) {
        for (String name : manager.getAvailableFavoritesListNames()) {
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Group group2 = BookmarksManagerImpl.addOrReuseGroup$default(this, name, null, 2, null);
            for (TreeItem<com.intellij.openapi.util.Pair<AbstractUrl, String>> item : manager.getFavoritesListRootUrls(name)) {
                Object a = item.getData().first;
                Intrinsics.checkNotNullExpressionValue(a, (String)"item.data.first");
                group2.addLater$intellij_platform_lang_impl(a, BookmarkType.DEFAULT, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Group findGroup(String name, int hash) {
        Group group2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable iterable = this.allGroups;
                for (Object t : iterable) {
                    Group it = (Group)t;
                    boolean bl2 = false;
                    if (!(it.getHash$intellij_platform_lang_impl() == hash && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            group2 = v0;
        }
        return group2;
    }

    static /* synthetic */ Group findGroup$default(BookmarksManagerImpl bookmarksManagerImpl, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string2.hashCode();
        }
        return bookmarksManagerImpl.findGroup(string2, n);
    }

    @Override
    @Nullable
    public Bookmark createBookmark(@Nullable Object context2) {
        Bookmark bookmark;
        block5: {
            if (context2 instanceof BookmarkState) {
                Object v0;
                block4: {
                    Iterable $this$firstOrNull$iv = this.getSortedProviders();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BookmarkProvider it = (BookmarkProvider)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)((BookmarkState)context2).getProvider())) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                BookmarkProvider bookmarkProvider = v0;
                bookmark = bookmarkProvider != null ? bookmarkProvider.createBookmark(((BookmarkState)context2).getAttributes()) : null;
            } else {
                for (BookmarkProvider it : (Iterable)this.getSortedProviders()) {
                    boolean bl = false;
                    Bookmark bookmark2 = it.createBookmark(context2);
                    if (bookmark2 == null) continue;
                    bookmark = bookmark2;
                    break block5;
                }
                bookmark = null;
            }
        }
        return bookmark;
    }

    private final String createDescription(Bookmark bookmark) {
        String string2 = LineBookmarkProvider.Companion.readLineText(bookmark instanceof LineBookmark ? (LineBookmark)bookmark : null);
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Bookmark> getBookmarks() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.allBookmarks.keySet());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BookmarkGroup getDefaultGroup() {
        Group group2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            group2 = this.defaultGroup;
        }
        return group2;
    }

    @Override
    @Nullable
    public BookmarkGroup getGroup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<BookmarkGroup> getGroups() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.allGroups);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BookmarkGroup> getGroups(@NotNull Bookmark bookmark) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            List list3;
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            if (object != null && (object = ((InManagerInfo)object).getGroups()) != null) {
                void $this$filterTo$iv$iv;
                Object it = object;
                boolean bl2 = false;
                Iterable $this$filter$iv = this.allGroups;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Group p0 = (Group)element$iv$iv;
                    boolean bl3 = false;
                    if (!it.contains(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BookmarkGroup addGroup(@NotNull String name, boolean isDefault) {
        Group group2;
        Group group3;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.isBlank((CharSequence)name)) {
            group3 = null;
        } else {
            ModificationNotifier modificationNotifier = this.notifier;
            synchronized (modificationNotifier) {
                boolean $i$a$-synchronized-BookmarksManagerImpl$addGroup$22 = false;
                Group $i$a$-synchronized-BookmarksManagerImpl$addGroup$22 = BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null) != null ? null : new Group(this, name, isDefault, true);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var5_3
                group3 = $i$a$-synchronized-BookmarksManagerImpl$addGroup$22;
            }
        }
        Group group4 = group3;
        if (group4 != null) {
            Group group5;
            Group $this$addGroup_u24lambda_u2423 = group5 = group4;
            boolean bl = false;
            this.notifier.selectLater$intellij_platform_lang_impl((Function1<? super BookmarksView, Unit>)((Function1)new Function1<BookmarksView, Unit>($this$addGroup_u24lambda_u2423){
                final /* synthetic */ Group $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BookmarksView it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.select(this.$this_apply);
                }
            }));
            group2 = group5;
        } else {
            group2 = null;
        }
        return group2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Group addOrReuseGroup(String name, Boolean isDefaultState) {
        Group group2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Group group3;
            block8: {
                block7: {
                    Group group4;
                    boolean bl = false;
                    group3 = BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null);
                    if (group3 == null) break block7;
                    Group $this$addOrReuseGroup_u24lambda_u2426_u24lambda_u2425 = group4 = group3;
                    boolean bl2 = false;
                    Boolean bl3 = isDefaultState;
                    if (bl3 != null) {
                        boolean it = bl3;
                        boolean bl4 = false;
                        $this$addOrReuseGroup_u24lambda_u2426_u24lambda_u2425.setDefault(it);
                    }
                    if ((group3 = group4) != null) break block8;
                }
                Boolean bl = isDefaultState;
                group3 = new Group(this, name, bl != null ? bl : false, false);
            }
            group2 = group3;
        }
        return group2;
    }

    static /* synthetic */ Group addOrReuseGroup$default(BookmarksManagerImpl bookmarksManagerImpl, String string2, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return bookmarksManagerImpl.addOrReuseGroup(string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bookmark getBookmark(@NotNull BookmarkType type) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.findInfo(type);
            bookmark = inManagerInfo != null ? inManagerInfo.getBookmark() : null;
        }
        return bookmark;
    }

    private final InManagerInfo findInfo(BookmarkType type) {
        InManagerInfo inManagerInfo;
        if (WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1) {
            inManagerInfo = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable = this.allBookmarks.values();
                for (Object t : iterable) {
                    InManagerInfo it = (InManagerInfo)t;
                    boolean bl = false;
                    if (!(it.getType() == type)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            inManagerInfo = v1;
        }
        return inManagerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<BookmarkType> getAssignedTypes() {
        Set set2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            void destination$iv;
            void $this$filterTo$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.allBookmarks.values();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InManagerInfo inManagerInfo = (InManagerInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getType());
            }
            $this$map$iv = (List)destination$iv$iv;
            Collection $i$f$map22 = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                BookmarkType it = (BookmarkType)((Object)element$iv);
                boolean bl3 = false;
                if (!(it != BookmarkType.DEFAULT)) continue;
                destination$iv.add(element$iv);
            }
            set2 = (Set)destination$iv;
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BookmarkType getType(@NotNull Bookmark bookmark) {
        BookmarkType bookmarkType;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.allBookmarks.get(bookmark);
            bookmarkType = inManagerInfo != null ? inManagerInfo.getType() : null;
        }
        return bookmarkType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setType(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.canRewriteType(type, bookmark)) {
            return;
        }
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.allBookmarks.get(bookmark);
            if (inManagerInfo == null) {
                return;
            }
            InManagerInfo info2 = inManagerInfo;
            if (info2.getType() == type) {
                return;
            }
            this.rewriteType(type, bookmark);
            info2.changeType(type);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean canToggle(Bookmark bookmark, BookmarkType type) {
        boolean bl;
        BookmarkType bookmarkType = this.getType(bookmark);
        if (bookmarkType != null) {
            BookmarkType it = bookmarkType;
            boolean bl2 = false;
            bl = it != type || this.canRemove(bookmark);
        } else {
            bl = this.canAdd(bookmark);
        }
        return bl;
    }

    @Override
    public void toggle(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BookmarkType bookmarkType = this.getType(bookmark);
        if (bookmarkType != null) {
            BookmarkType it = bookmarkType;
            boolean bl = false;
            if (it != type) {
                this.setType(bookmark, type);
            } else {
                this.remove(bookmark);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this.add(bookmark, type);
        }
    }

    private final boolean canAdd(Bookmark bookmark) {
        return this.findGroupsToAdd(bookmark) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (this.allGroups.isEmpty()) {
                String string2 = this.project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.name");
                BookmarksManagerImpl.addOrReuseGroup$default(this, string2, null, 2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        List<Group> list2 = this.findGroupsToAdd(bookmark);
        if (list2 == null) {
            return;
        }
        List<Group> groups2 = list2;
        Group group2 = this.chooseGroupToAdd(groups2);
        if (group2 == null) {
            return;
        }
        Group group3 = group2;
        group3.add(bookmark, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Group> findGroupsToAdd(Bookmark bookmark) {
        Group group2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Object object;
            block10: {
                InManagerInfo info2;
                block8: {
                    block9: {
                        boolean bl = false;
                        info2 = this.allBookmarks.get(bookmark);
                        if (info2 != null) break block8;
                        object = this.defaultGroup;
                        if (object == null) break block9;
                        Group it = object;
                        boolean bl2 = false;
                        List list2 = CollectionsKt.listOf((Object)it);
                        object = list2;
                        if (list2 != null) break block10;
                    }
                    object = CollectionsKt.toList((Iterable)this.allGroups);
                    break block10;
                }
                if (bookmark instanceof LineBookmark) {
                    object = null;
                } else {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.allGroups;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Group it = (Group)element$iv$iv;
                        boolean bl = false;
                        if (!(!info2.getGroups().contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                }
            }
            group2 = object;
        }
        return group2;
    }

    private final Group chooseGroupToAdd(List<Group> groups2) {
        return switch (groups2.size()) {
            case 1 -> groups2.get(0);
            case 0 -> {
                BookmarkGroup var2_2 = new GroupCreateDialog(this.project, null, this).showAndGetGroup(true);
                if (var2_2 instanceof Group) {
                    yield (Group)var2_2;
                }
                yield null;
            }
            default -> {
                BookmarkGroup var2_3 = new GroupSelectDialog(this.project, null, this, groups2).showAndGetGroup(true);
                yield var2_3 instanceof Group ? (Group)var2_3 : null;
            }
        };
    }

    private final boolean canRemove(Bookmark bookmark) {
        Collection collection = this.findGroupsToRemove(bookmark);
        return !(collection == null || collection.isEmpty());
    }

    @Override
    public void remove(@NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        List<Group> groups2 = this.findGroupsToRemove(bookmark);
        Collection collection = groups2;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (groups2.size() == 1) {
            this.removeFromGroup(groups2.get(0), bookmark);
        } else if (!((Collection)groups2).isEmpty()) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Group> findGroupsToRemove(Bookmark bookmark) {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            List list3;
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            if (object != null && (object = ((InManagerInfo)object).getGroups()) != null) {
                void $this$filterTo$iv$iv;
                Object it = object;
                boolean bl2 = false;
                Iterable $this$filter$iv = this.allGroups;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Group p0 = (Group)element$iv$iv;
                    boolean bl3 = false;
                    if (!it.contains(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = null;
            }
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit removeFromAllGroups(Bookmark bookmark) {
        Unit unit;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Unit unit2;
            boolean bl = false;
            List<Group> list2 = this.findGroupsToRemove(bookmark);
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Group it = (Group)element$iv;
                    boolean bl2 = false;
                    this.removeFromGroup(it, bookmark);
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<InManagerInfo, InGroupInfo> removeFromGroup(Group group2, Bookmark bookmark) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            InManagerInfo info2;
            block7: {
                InManagerInfo inManagerInfo;
                block6: {
                    boolean bl = false;
                    if (this.allBookmarks.get(bookmark) != null) break block6;
                    Pair<InManagerInfo, InGroupInfo> pair = null;
                    return pair;
                }
                info2 = inManagerInfo;
                if (info2.getGroups().remove(group2)) break block7;
                Pair<InManagerInfo, InGroupInfo> pair = null;
                return pair;
            }
            boolean removed = info2.getGroups().isEmpty();
            if (removed) {
                this.allBookmarks.remove(bookmark);
            }
            Pair result2 = TuplesKt.to((Object)info2, (Object)group2.removeInfo$intellij_platform_lang_impl(bookmark));
            info2.bookmarkRemoved(group2, removed);
            Pair pair = result2;
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            while (!((Collection)this.allGroups).isEmpty()) {
                this.allGroups.get(0).remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean canRewriteType(BookmarkType type, Bookmark allowed) {
        String string2;
        if (BookmarksViewState.Companion.getInstance(this.project).getRewriteBookmarkType()) {
            return true;
        }
        Bookmark bookmark = this.getBookmark(type);
        if (bookmark == null) {
            return true;
        }
        Bookmark bookmark2 = bookmark;
        if (Intrinsics.areEqual((Object)bookmark2, (Object)allowed)) {
            return true;
        }
        String string3 = BookmarkBundle.message("bookmark.type.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"bookmark.type.confirmation.title\")");
        Bookmark bookmark3 = bookmark2;
        if (bookmark3 instanceof LineBookmark) {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic()), ((LineBookmark)bookmark2).getFile().getPresentableName(), ((LineBookmark)bookmark2).getLine() + 1};
            string2 = BookmarkBundle.message("bookmark.type.confirmation.line.bookmark", var6_5);
        } else if (bookmark3 instanceof FileBookmark) {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic()), ((FileBookmark)bookmark2).getFile().getPresentableName()};
            string2 = BookmarkBundle.message("bookmark.type.confirmation.file.bookmark", var6_5);
        } else {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic())};
            string2 = BookmarkBundle.message("bookmark.type.confirmation.bookmark", var6_5);
        }
        String string4 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"when (bookmark) {\n      \u2026\", type.mnemonic)\n      }");
        OkCancelDialogBuilder okCancelDialogBuilder = (OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string3, string4).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){
            final /* synthetic */ BookmarksManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                BookmarksViewState.Companion.getInstance(this.this$0.getProject()).setRewriteBookmarkType(isSelected);
            }
        });
        String string5 = BookmarkBundle.message("bookmark.type.confirmation.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"bookmark.type.confirmation.button\")");
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string5)).asWarning()).ask(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewriteType(BookmarkType type, Bookmark allowed) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Unit unit;
            boolean bl = false;
            InManagerInfo inManagerInfo = this.findInfo(type);
            if (inManagerInfo == null) {
                return;
            }
            InManagerInfo info2 = inManagerInfo;
            Bookmark bookmark = info2.getBookmark();
            if (Intrinsics.areEqual((Object)bookmark, (Object)allowed)) {
                return;
            }
            if (bookmark instanceof LineBookmark) {
                unit = this.removeFromAllGroups(info2.getBookmark());
            } else {
                info2.changeType(BookmarkType.DEFAULT);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
    }

    public final void sort(@NotNull BookmarkGroup group2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Group group3 = group2 instanceof Group ? (Group)group2 : null;
            if (group3 == null) break block0;
            group3.sortLater$intellij_platform_lang_impl();
        }
    }

    private final void addGroupTo(int index2, Group group2) {
        Unit unit;
        this.allGroups.add(index2, group2);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.notifier.groupAdded(group2);
    }

    private final Group removeGroupFrom(int index2) {
        Group group2;
        Group it = group2 = this.allGroups.remove(index2);
        boolean bl = false;
        this.notifier.groupRemoved(it);
        return group2;
    }

    private final void moveGroup(int fromIndex, int toIndex) {
        this.addGroupTo(toIndex, this.removeGroupFrom(fromIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void move(@NotNull BookmarkGroup group2, @NotNull BookmarkGroup anchor) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            int toIndex;
            int fromIndex;
            block11: {
                int n;
                block10: {
                    int n2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)group2, (Object)this.defaultGroup) || Intrinsics.areEqual((Object)anchor, (Object)this.defaultGroup)) {
                        return;
                    }
                    List<Group> $this$indexOfFirst$iv = this.allGroups;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<Group> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        Group item$iv;
                        Group it = item$iv = iterator2.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)group2)) {
                            n2 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n2 = fromIndex = -1;
                }
                if (fromIndex < 0) {
                    return;
                }
                List<Group> $this$indexOfFirst$iv = this.allGroups;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Group> iterator3 = $this$indexOfFirst$iv.iterator();
                while (iterator3.hasNext()) {
                    Group item$iv;
                    Group it = item$iv = iterator3.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)anchor)) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = toIndex = -1;
            }
            if (toIndex < 0 || toIndex == fromIndex) {
                return;
            }
            this.moveGroup(fromIndex, toIndex);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void move(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark, @NotNull Bookmark anchor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Group group3 = group2 instanceof Group ? (Group)group2 : null;
            if (group3 == null) break block0;
            Group $this$move_u24lambda_u2453 = group3;
            boolean bl = false;
            $this$move_u24lambda_u2453.move$intellij_platform_lang_impl(bookmark, anchor);
        }
    }

    @Override
    public void update(@NotNull Map<Bookmark, Bookmark> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        while (!map2.isEmpty()) {
            int size = map2.size();
            Iterator<Map.Entry<Bookmark, Bookmark>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Boolean updated;
                Map.Entry<Bookmark, Bookmark> entry = iterator2.next();
                if (entry.getValue() != null) {
                    Bookmark it;
                    boolean bl = false;
                    v0 = this.updateInAllGroups(entry.getKey(), it);
                } else {
                    v0 = updated = null;
                }
                if (updated == null) {
                    this.removeFromAllGroups(entry.getKey());
                }
                if (Intrinsics.areEqual(updated, (Object)false)) continue;
                iterator2.remove();
            }
            if (map2.size() != size) continue;
        }
        if (!map2.isEmpty()) {
            StringBuilder sb = new StringBuilder("cannot resolve");
            for (Map.Entry<Bookmark, Bookmark> entry : map2.entrySet()) {
                sb.append('\n').append(entry.getKey()).append(" -> ").append(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateInAllGroups(Bookmark old, Bookmark bookmark) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            InManagerInfo inManagerInfo;
            block10: {
                block9: {
                    boolean bl = false;
                    if (!this.allBookmarks.containsKey(bookmark)) break block9;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.allBookmarks.remove(old) != null) break block10;
                boolean bl = true;
                return bl;
            }
            InManagerInfo oldInfo = inManagerInfo;
            InManagerInfo newInfo = new InManagerInfo(bookmark, oldInfo.getType());
            Iterator<Group> oldIterator = oldInfo.getGroups().iterator();
            while (oldIterator.hasNext()) {
                Group group2 = oldIterator.next();
                if (group2.updateInfo$intellij_platform_lang_impl(old, bookmark)) {
                    newInfo.getGroups().add(group2);
                }
                oldIterator.remove();
                oldInfo.bookmarkRemoved(group2, !oldIterator.hasNext());
            }
            Iterator<Group> newIterator = newInfo.getGroups().iterator();
            if (newIterator.hasNext()) {
                this.allBookmarks.put(bookmark, newInfo);
                newInfo.bookmarkAdded(newIterator.next(), true);
                while (newIterator.hasNext()) {
                    newInfo.bookmarkAdded(newIterator.next(), false);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private final boolean contains(Group group2) {
        return this.allGroups.contains(group2);
    }

    private final boolean contains(BookmarkGroup group2) {
        return group2 instanceof Group && this.contains((Group)group2);
    }

    private final boolean canDragInto(BookmarkGroup group2, BookmarkOccurrence occurrence) {
        Group group3 = group2 instanceof Group ? (Group)group2 : null;
        if (group3 == null) {
            return false;
        }
        Group to = group3;
        BookmarkGroup bookmarkGroup = occurrence.getGroup();
        Group group4 = bookmarkGroup instanceof Group ? (Group)bookmarkGroup : null;
        if (group4 == null) {
            return false;
        }
        Group from = group4;
        InManagerInfo inManagerInfo = this.allBookmarks.get(occurrence.getBookmark());
        if (inManagerInfo == null) {
            return this.getGroupLineBookmarks();
        }
        InManagerInfo info2 = inManagerInfo;
        Set<Group> $this$canDragInto_u24lambda_u2456 = info2.getGroups();
        boolean bl = false;
        return $this$canDragInto_u24lambda_u2456.contains(from) && (Intrinsics.areEqual((Object)from, (Object)to) || !$this$canDragInto_u24lambda_u2456.contains(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canDragInto(@NotNull BookmarkGroup group2, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            BookmarkOccurrence it;
            boolean bl = false;
            if (!this.contains(group2)) return false;
            Iterable $this$all$iv = occurrences;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (BookmarkOccurrence)element$iv;
                boolean bl2 = false;
            } while (this.canDragInto(group2, it));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean dragInto(@NotNull BookmarkGroup group2, @NotNull List<BookmarkOccurrence> occurrences) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl2 = false;
            bl = this.canDragInto(group2, occurrences) && this.drag((Group)group2, occurrences, (Function1<? super Group, Integer>)((Function1)dragInto.1.1.INSTANCE));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canDrag(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            block28: {
                block26: {
                    boolean bl2;
                    block27: {
                        VirtualFile file2;
                        block24: {
                            boolean bl3;
                            block25: {
                                block23: {
                                    block22: {
                                        boolean bl4;
                                        block21: {
                                            block20: {
                                                boolean bl5 = false;
                                                if (this.contains(occurrence.getGroup())) break block20;
                                                boolean bl6 = false;
                                                return bl6;
                                            }
                                            Iterable $this$all$iv = occurrences;
                                            boolean $i$f$all = false;
                                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                                bl4 = true;
                                            } else {
                                                for (Object element$iv : $this$all$iv) {
                                                    BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                                    boolean bl7 = false;
                                                    if (!Intrinsics.areEqual((Object)it, (Object)occurrence) && this.canDragInto(occurrence.getGroup(), it)) continue;
                                                    bl4 = false;
                                                    break block21;
                                                }
                                                bl4 = true;
                                            }
                                        }
                                        if (bl4) break block22;
                                        boolean bl8 = false;
                                        return bl8;
                                    }
                                    if (this.getGroupLineBookmarks()) break block23;
                                    boolean bl9 = true;
                                    return bl9;
                                }
                                if (above || (file2 = this.getFileGrouping(occurrence.getBookmark())) == null) break block24;
                                Iterable $this$all$iv = occurrences;
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl3 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                        boolean bl10 = false;
                                        if (this.isLineGrouping(it.getBookmark(), file2)) continue;
                                        bl3 = false;
                                        break block25;
                                    }
                                    bl3 = true;
                                }
                            }
                            if (!bl3) break block24;
                            boolean bl11 = true;
                            return bl11;
                        }
                        file2 = this.getLineGrouping(occurrence.getBookmark());
                        if (file2 == null) break block26;
                        Iterable $this$all$iv = occurrences;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                boolean bl12 = false;
                                if (this.isLineGrouping(it.getBookmark(), file2)) continue;
                                bl2 = false;
                                break block27;
                            }
                            bl2 = true;
                        }
                    }
                    boolean bl13 = bl2;
                    return bl13;
                }
                Iterable $this$all$iv = occurrences;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                        boolean bl14 = false;
                        if (!(it.getBookmark() instanceof LineBookmarkImpl)) continue;
                        bl = false;
                        break block28;
                    }
                    bl = true;
                }
            }
            boolean bl15 = bl;
            return bl15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean drag(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (!this.canDrag(above, occurrence, occurrences)) return false;
            BookmarkGroup bookmarkGroup = occurrence.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            if (!this.drag((Group)bookmarkGroup, occurrences, (Function1<? super Group, Integer>)((Function1)new Function1<Group, Integer>(occurrence, above){
                final /* synthetic */ BookmarkOccurrence $occurrence;
                final /* synthetic */ boolean $above;
                {
                    this.$occurrence = $occurrence;
                    this.$above = $above;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Group it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int index2 = it.indexWithGrouping$intellij_platform_lang_impl(this.$occurrence.getBookmark());
                    return index2 < 0 || this.$above ? index2 : index2 + 1;
                }
            }))) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canDrag(boolean above, @NotNull BookmarkGroup group2, @NotNull List<? extends BookmarkGroup> groups2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            boolean bl2 = false;
            if (above) {
                if (Intrinsics.areEqual((Object)group2, (Object)this.defaultGroup)) return false;
            }
            if (!this.contains(group2)) return false;
            Iterable $this$all$iv = groups2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                BookmarkGroup it = (BookmarkGroup)element$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it, (Object)this.defaultGroup)) return false;
                if (Intrinsics.areEqual((Object)it, (Object)group2)) return false;
                if (!this.contains(it)) return false;
                bl = true;
            } while (bl);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean drag(boolean above, @NotNull BookmarkGroup group2, @NotNull List<? extends BookmarkGroup> groups2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Group it;
            Set set2;
            block10: {
                block9: {
                    boolean bl = false;
                    if (this.canDrag(above, group2, groups2)) break block9;
                    boolean bl2 = false;
                    return bl2;
                }
                set2 = new LinkedHashSet();
                Iterable $this$mapTo$iv = groups2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    BookmarkGroup bookmarkGroup = (BookmarkGroup)item$iv;
                    Collection collection = set2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
                    collection.add((Group)it);
                }
                if (groups2.size() == set2.size()) break block10;
                boolean bl = false;
                return bl;
            }
            this.allGroups.removeAll(set2);
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Group)element$iv;
                boolean bl = false;
                this.notifier.groupRemoved(it);
            }
            int index2 = RangesKt.coerceAtLeast((int)this.allGroups.indexOf((Group)group2), (int)0);
            if (!above) {
                ++index2;
            }
            this.allGroups.addAll(index2, set2);
            Iterable $this$forEach$iv2 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Group it2 = (Group)element$iv;
                boolean bl = false;
                this.notifier.groupAdded(it2);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean canDragAddInto(@NotNull BookmarkGroup group2, @NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            block9: {
                void destination$iv;
                void $this$mapTo$iv;
                block8: {
                    boolean bl2 = false;
                    if (this.contains(group2)) break block8;
                    boolean bl3 = false;
                    return bl3;
                }
                Iterable iterable = files2;
                Collection collection = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    File file2 = (File)item$iv;
                    void var11_16 = destination$iv;
                    boolean bl4 = false;
                    var11_16.add(FileUtilKt.getSystemIndependentPath((File)it));
                }
                Set set2 = (Set)destination$iv;
                Iterable $this$any$iv = group2.getBookmarks();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Bookmark it = (Bookmark)element$iv;
                        boolean bl5 = false;
                        if (!(it instanceof FileBookmarkImpl && set2.contains(((FileBookmarkImpl)it).getFile().getPath()))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            boolean bl6 = !bl;
            return bl6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean dragAddInto(@NotNull BookmarkGroup group2, @NotNull List<? extends File> files2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl2 = false;
            bl = this.canDragAddInto(group2, files2) && this.dragAdd((Group)group2, files2, (Function1<? super Group, Integer>)((Function1)dragAddInto.1.1.INSTANCE));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean dragAdd(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (!this.canDragAddInto(occurrence.getGroup(), files2)) return false;
            BookmarkGroup bookmarkGroup = occurrence.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            if (!this.dragAdd((Group)bookmarkGroup, files2, (Function1<? super Group, Integer>)((Function1)new Function1<Group, Integer>(occurrence, above){
                final /* synthetic */ BookmarkOccurrence $occurrence;
                final /* synthetic */ boolean $above;
                {
                    this.$occurrence = $occurrence;
                    this.$above = $above;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Group it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int index2 = it.indexWithGrouping$intellij_platform_lang_impl(this.$occurrence.getBookmark());
                    return index2 < 0 || this.$above ? index2 : index2 + 1;
                }
            }))) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean dragAdd(Group group2, List<? extends File> files2, Function1<? super Group, Integer> indexSupplier) {
        void $this$mapNotNullTo$iv$iv;
        LineBookmarkProvider lineBookmarkProvider = LineBookmarkProvider.Companion.find(this.project);
        if (lineBookmarkProvider == null) {
            return false;
        }
        LineBookmarkProvider provider2 = lineBookmarkProvider;
        Iterable $this$mapNotNull$iv = files2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Bookmark it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (provider2.createBookmark(VfsUtil.findFileByIoFile(it, true)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            return false;
        }
        List bookmarks = (List)$this$mapNotNull$iv;
        int index2 = RangesKt.coerceAtLeast((int)((Number)indexSupplier.invoke((Object)group2)).intValue(), (int)0);
        Iterable $this$forEach$iv = bookmarks;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            group2.add$intellij_platform_lang_impl(it, BookmarkType.DEFAULT, null, index2);
        }
        return true;
    }

    private final boolean drag(Group group2, List<BookmarkOccurrence> occurrences, Function1<? super Group, Integer> indexSupplier) {
        List pairs = new ArrayList();
        Iterable $this$forEach$iv = occurrences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
            boolean bl = false;
            BookmarkGroup bookmarkGroup = it.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            ((Group)bookmarkGroup).removeWithGrouping$intellij_platform_lang_impl(it.getBookmark(), (Function1<? super Pair<InManagerInfo, InGroupInfo>, Unit>)((Function1)new Function1<Pair<? extends InManagerInfo, ? extends InGroupInfo>, Unit>((List<Pair<InManagerInfo, InGroupInfo>>)pairs){
                final /* synthetic */ List<Pair<InManagerInfo, InGroupInfo>> $pairs;
                {
                    this.$pairs = $pairs;
                    super(1);
                }

                public final void invoke(@NotNull Pair<InManagerInfo, InGroupInfo> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"pair");
                    this.$pairs.add(0, pair);
                }
            }));
        }
        int index2 = RangesKt.coerceAtLeast((int)((Number)indexSupplier.invoke((Object)group2)).intValue(), (int)0);
        Iterable $this$forEach$iv2 = pairs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            InGroupInfo inGroupInfo = (InGroupInfo)it.getSecond();
            group2.add$intellij_platform_lang_impl(((InManagerInfo)it.getFirst()).getBookmark(), ((InManagerInfo)it.getFirst()).getType(), inGroupInfo != null ? inGroupInfo.getDescription() : null, index2);
        }
        return true;
    }

    private final VirtualFile getFileGrouping(Bookmark bookmark) {
        return bookmark instanceof FileBookmarkImpl ? ((FileBookmarkImpl)bookmark).getFile() : null;
    }

    private final VirtualFile getLineGrouping(Bookmark bookmark) {
        return bookmark instanceof LineBookmarkImpl ? ((LineBookmarkImpl)bookmark).getFile() : null;
    }

    private final boolean isLineGrouping(Bookmark bookmark, VirtualFile file2) {
        return bookmark instanceof LineBookmarkImpl && Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RangeHighlighter findLineHighlighter$intellij_platform_lang_impl(@NotNull Bookmark bookmark) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            rangeHighlighter = object != null && (object = ((InManagerInfo)object).getRenderer()) != null ? ((GutterLineBookmarkRenderer)object).getHighlighter$intellij_platform_lang_impl() : null;
        }
        return rangeHighlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshRenderers$intellij_platform_lang_impl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.allBookmarks.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InManagerInfo it = (InManagerInfo)element$iv;
                boolean bl2 = false;
                Object object = it.getRenderer();
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((GutterLineBookmarkRenderer)object).getBookmark()) != null ? object.getFile() : null), (Object)file2)) continue;
                it.refreshRenderer();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void noStateLoaded$lambda$12$lambda$11(BookmarksManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FavoritesManager favoritesManager = FavoritesManager.getInstance(this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)favoritesManager, (String)"getInstance(project)");
        this$0.noStateLoaded(favoritesManager);
    }

    private static final void noStateLoaded$lambda$12(BookmarksManagerImpl this$0, noStateLoaded.listener.1 $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        BookmarksManagerImplKt.access$getLOG$p().info("no state loaded for new bookmarks");
        Collection<com.intellij.ide.bookmarks.Bookmark> collection = BookmarkManager.getInstance(this$0.project).getAllBookmarks();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getInstance(project).allBookmarks");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.intellij.ide.bookmarks.Bookmark it = (com.intellij.ide.bookmarks.Bookmark)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $listener.bookmarkAdded(it);
        }
        this$0.invoker.invokeLater(() -> BookmarksManagerImpl.noStateLoaded$lambda$12$lambda$11(this$0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010!\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Lcom/intellij/ide/bookmark/Bookmark;Lcom/intellij/ide/bookmark/BookmarkType;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "groups", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "getGroups", "()Ljava/util/Set;", "renderer", "Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "getRenderer", "()Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "getType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "setType", "(Lcom/intellij/ide/bookmark/BookmarkType;)V", "bookmarkAdded", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "initial", "", "bookmarkChanged", "bookmarkRemoved", "completely", "changeType", "refreshRenderer", "()Lkotlin/Unit;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,655:1\n1#2:656\n*E\n"})
    public final class InManagerInfo {
        @NotNull
        private final Bookmark bookmark;
        @NotNull
        private BookmarkType type;
        @Nullable
        private final GutterLineBookmarkRenderer renderer;
        @NotNull
        private final Set<Group> groups;

        /*
         * WARNING - void declaration
         */
        public InManagerInfo(@NotNull Bookmark bookmark, BookmarkType type) {
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.bookmark = bookmark;
            this.type = type;
            InManagerInfo inManagerInfo = this;
            Bookmark bookmark2 = this.bookmark;
            LineBookmark lineBookmark = bookmark2 instanceof LineBookmark ? (LineBookmark)bookmark2 : null;
            if (lineBookmark != null) {
                void it;
                LineBookmark lineBookmark2 = lineBookmark;
                InManagerInfo inManagerInfo2 = inManagerInfo;
                boolean bl = false;
                gutterLineBookmarkRenderer = new GutterLineBookmarkRenderer((LineBookmark)it);
                inManagerInfo = inManagerInfo2;
            } else {
                gutterLineBookmarkRenderer = null;
            }
            inManagerInfo.renderer = gutterLineBookmarkRenderer;
            this.groups = new LinkedHashSet();
        }

        @NotNull
        public final Bookmark getBookmark() {
            return this.bookmark;
        }

        @NotNull
        public final BookmarkType getType() {
            return this.type;
        }

        public final void setType(@NotNull BookmarkType bookmarkType) {
            Intrinsics.checkNotNullParameter((Object)((Object)bookmarkType), (String)"<set-?>");
            this.type = bookmarkType;
        }

        @Nullable
        public final GutterLineBookmarkRenderer getRenderer() {
            return this.renderer;
        }

        @NotNull
        public final Set<Group> getGroups() {
            return this.groups;
        }

        @Nullable
        public final Unit refreshRenderer() {
            Unit unit;
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer = this.renderer;
            if (gutterLineBookmarkRenderer != null) {
                gutterLineBookmarkRenderer.refreshHighlighter((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ InManagerInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.this$0.getGroups().isEmpty();
                    }
                }));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public final void bookmarkAdded(@NotNull BookmarkGroup group2, boolean initial) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            BookmarksManagerImpl.this.notifier.bookmarkAdded(group2, this.bookmark);
            if (initial) {
                this.refreshRenderer();
            }
        }

        public final void bookmarkRemoved(@NotNull BookmarkGroup group2, boolean completely) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            BookmarksManagerImpl.this.notifier.bookmarkRemoved(group2, this.bookmark);
            if (completely) {
                this.refreshRenderer();
            }
        }

        public final void bookmarkChanged(@NotNull BookmarkGroup group2) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            BookmarksManagerImpl.this.notifier.bookmarkChanged(group2, this.bookmark);
            this.refreshRenderer();
        }

        public final void changeType(@NotNull BookmarkType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (this.type == type) {
                return;
            }
            this.type = type;
            BookmarksManagerImpl.this.notifier.bookmarkTypeChanged(this.bookmark);
            this.refreshRenderer();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0016J/\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\"J'\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010*\u001a\u00020\u000e2\n\u0010+\u001a\u00060\u000bR\u00020\f2\n\u0010,\u001a\u00060\u000bR\u00020\fH\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001d0.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u00100\u001a\b\u0018\u00010\u000bR\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\r\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020$H\u0016J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010<\u001a\b\u0018\u00010\u000bR\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b=J?\u0010>\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2(\u0010?\u001a$\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060BR\u00020\f\u0012\n\u0012\b\u0018\u00010\u000bR\u00020\f0A\u0012\u0004\u0012\u00020$0@H\u0000\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003H\u0016J\b\u0010E\u001a\u00020$H\u0002J\u0016\u0010F\u001a\u000b\u0012\u0002\b\u00030G\u00a2\u0006\u0002\bHH\u0000\u00a2\u0006\u0002\bIJ\u001d\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bMR\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006N"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "name", "", "isDefault", "", "asFirst", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Ljava/lang/String;ZZ)V", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Ljava/lang/String;)V", "groupBookmarks", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "hash", "", "getHash$intellij_platform_lang_impl", "()I", "setHash$intellij_platform_lang_impl", "(I)V", "value", "()Z", "setDefault", "(Z)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "add", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "description", "index", "add$intellij_platform_lang_impl", "addLater", "", "context", "", "addLater$intellij_platform_lang_impl", "canAdd", "canRemove", "compare", "info1", "info2", "getBookmarks", "", "getDescription", "getInfo", "getState", "Lcom/intellij/ide/bookmark/GroupState;", "getState$intellij_platform_lang_impl", "indexOf", "indexOf$intellij_platform_lang_impl", "indexWithGrouping", "indexWithGrouping$intellij_platform_lang_impl", "move", "anchor", "move$intellij_platform_lang_impl", "remove", "removeInfo", "removeInfo$intellij_platform_lang_impl", "removeWithGrouping", "process", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "removeWithGrouping$intellij_platform_lang_impl", "setDescription", "sort", "sortLater", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/annotations/NotNull;", "sortLater$intellij_platform_lang_impl", "updateInfo", "old", "new", "updateInfo$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$Group\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,655:1\n350#2,7:656\n350#2,7:663\n1603#2,9:671\n1855#2:680\n1856#2:682\n1612#2:683\n1855#2,2:684\n1549#2:686\n1620#2,3:687\n1#3:670\n1#3:681\n*S KotlinDebug\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$Group\n*L\n462#1:656,7\n471#1:663,7\n478#1:671,9\n478#1:680\n478#1:682\n478#1:683\n479#1:684,2\n494#1:686\n494#1:687,3\n478#1:681\n*E\n"})
    public final class Group
    implements BookmarkGroup {
        private int hash;
        @NotNull
        private String name;
        @NotNull
        private final List<InGroupInfo> groupBookmarks;
        final /* synthetic */ BookmarksManagerImpl this$0;

        public Group(@NotNull BookmarksManagerImpl this$0, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.hash = name.hashCode();
            this.name = name;
            this.groupBookmarks = new ArrayList();
        }

        public Group(@NotNull BookmarksManagerImpl this$0, String name, boolean isDefault, boolean asFirst) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(this$0, name);
            int index2 = isDefault ? 0 : (!asFirst ? this$0.allGroups.size() : (this$0.defaultGroup == null ? 0 : RangesKt.coerceAtMost((int)this$0.allGroups.size(), (int)1)));
            this$0.addGroupTo(index2, this);
            this.setDefault(isDefault);
        }

        public final int getHash$intellij_platform_lang_impl() {
            return this.hash;
        }

        public final void setHash$intellij_platform_lang_impl(int n) {
            this.hash = n;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)value) && BookmarksManagerImpl.findGroup$default(bookmarksManagerImpl, value, 0, 2, null) == null) {
                    this.name = value;
                    this.hash = value.hashCode();
                    if (bookmarksManagerImpl.contains(this)) {
                        bookmarksManagerImpl.notifier.groupRenamed(this);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @Override
        public boolean isDefault() {
            return this == this.this$0.defaultGroup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDefault(boolean value) {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (value) {
                    bookmarksManagerImpl.setDefaultGroup(this);
                } else if (this.isDefault()) {
                    bookmarksManagerImpl.setDefaultGroup(null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final int indexOf$intellij_platform_lang_impl(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            return switch (this.groupBookmarks.size()) {
                case 0 -> -1;
                case 1 -> {
                    if (Intrinsics.areEqual((Object)this.groupBookmarks.get(0).getBookmark(), (Object)bookmark)) {
                        yield 0;
                    }
                    yield -1;
                }
                default -> {
                    int hash = ((Object)bookmark).hashCode();
                    List<InGroupInfo> $this$indexOfFirst$iv = this.groupBookmarks;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<InGroupInfo> var6_6 = $this$indexOfFirst$iv.iterator();
                    while (var6_6.hasNext()) {
                        InGroupInfo item$iv;
                        InGroupInfo it = item$iv = var6_6.next();
                        boolean $i$a$-indexOfFirst-BookmarksManagerImpl$Group$indexOf$1 = false;
                        if (it.getHash() == hash && Intrinsics.areEqual((Object)it.getBookmark(), (Object)bookmark)) {
                            yield index$iv;
                        }
                        ++index$iv;
                    }
                    yield -1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public final int indexWithGrouping$intellij_platform_lang_impl(@NotNull Bookmark bookmark) {
            int n;
            block5: {
                void $this$indexOfFirst$iv;
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                int index2 = this.indexOf$intellij_platform_lang_impl(bookmark);
                if (index2 >= 0) {
                    return index2;
                }
                if (!this.this$0.getGroupLineBookmarks()) {
                    return -1;
                }
                VirtualFile virtualFile2 = this.this$0.getFileGrouping(bookmark);
                if (virtualFile2 == null) {
                    return -1;
                }
                VirtualFile file2 = virtualFile2;
                List<InGroupInfo> list2 = this.groupBookmarks;
                BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    InGroupInfo it = (InGroupInfo)item$iv;
                    boolean bl = false;
                    if (bookmarksManagerImpl.isLineGrouping(it.getBookmark(), file2)) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final void removeWithGrouping$intellij_platform_lang_impl(@NotNull Bookmark bookmark, @NotNull Function1<? super Pair<InManagerInfo, InGroupInfo>, Unit> process2) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object $this$removeWithGrouping_u24lambda_u244;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter(process2, (String)"process");
            Pair pair = this.this$0.removeFromGroup(this, bookmark);
            if (pair != null) {
                $this$removeWithGrouping_u24lambda_u244 = pair;
                boolean bl = false;
                process2.invoke($this$removeWithGrouping_u24lambda_u244);
            }
            if (!this.this$0.getGroupLineBookmarks()) {
                return;
            }
            VirtualFile virtualFile2 = this.this$0.getFileGrouping(bookmark);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile file2 = virtualFile2;
            $this$removeWithGrouping_u24lambda_u244 = this.groupBookmarks;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Bookmark it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                InGroupInfo it = (InGroupInfo)element$iv$iv;
                boolean bl2 = false;
                if ((bookmarksManagerImpl.isLineGrouping(it.getBookmark(), file2) ? it.getBookmark() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List bookmarks = (List)destination$iv$iv;
            $this$mapNotNull$iv = bookmarks;
            bookmarksManagerImpl = this.this$0;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $this$removeWithGrouping_u24lambda_u247_u24lambda_u246;
                Bookmark it = (Bookmark)element$iv;
                boolean bl = false;
                if (bookmarksManagerImpl.removeFromGroup(this, it) == null) continue;
                boolean bl4 = false;
                process2.invoke((Object)$this$removeWithGrouping_u24lambda_u247_u24lambda_u246);
            }
        }

        private final InGroupInfo getInfo(Bookmark bookmark) {
            int it = this.indexOf$intellij_platform_lang_impl(bookmark);
            boolean bl = false;
            return it < 0 ? null : this.groupBookmarks.get(it);
        }

        @Nullable
        public final InGroupInfo removeInfo$intellij_platform_lang_impl(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            int it = this.indexOf$intellij_platform_lang_impl(bookmark);
            boolean bl = false;
            return it < 0 ? null : this.groupBookmarks.remove(it);
        }

        public final boolean updateInfo$intellij_platform_lang_impl(@NotNull Bookmark old, @NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)old, (String)"old");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"new");
            int index2 = this.indexOf$intellij_platform_lang_impl(old);
            if (index2 < 0) {
                return false;
            }
            InGroupInfo info2 = this.groupBookmarks.get(index2);
            this.groupBookmarks.set(index2, this.this$0.new InGroupInfo(bookmark, info2.getDescription()));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Bookmark> getBookmarks() {
            List list2;
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            synchronized (modificationNotifier) {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = this.groupBookmarks;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    InGroupInfo inGroupInfo = (InGroupInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getBookmark());
                }
                list2 = (List)destination$iv$iv;
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String getDescription(@NotNull Bookmark bookmark) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                InGroupInfo inGroupInfo;
                block5: {
                    boolean bl = false;
                    if (this.getInfo(bookmark) != null) break block5;
                    String string3 = null;
                    return string3;
                }
                InGroupInfo info2 = inGroupInfo;
                if (info2.getDescription() == null) {
                    info2.setDescription(bookmarksManagerImpl.createDescription(bookmark));
                }
                string2 = info2.getDescription();
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDescription(@NotNull Bookmark bookmark, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                InGroupInfo inGroupInfo = this.getInfo(bookmark);
                if (inGroupInfo == null) {
                    return;
                }
                InGroupInfo info2 = inGroupInfo;
                if (Intrinsics.areEqual((Object)info2.getDescription(), (Object)description)) {
                    return;
                }
                info2.setDescription(description);
                bookmarksManagerImpl.notifier.bookmarkChanged(this, bookmark);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canAdd(@NotNull Bookmark bookmark) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl2 = false;
                bl = !(!bookmarksManagerImpl.contains(this) || this.indexOf$intellij_platform_lang_impl(bookmark) >= 0 || bookmark instanceof LineBookmark && bookmarksManagerImpl.allBookmarks.containsKey(bookmark));
            }
            return bl;
        }

        @Override
        public boolean add(@NotNull Bookmark bookmark, @NotNull BookmarkType type, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            if (!this.this$0.canRewriteType(type, bookmark)) {
                return false;
            }
            if (!this.add$intellij_platform_lang_impl(bookmark, type, description, 0)) {
                return false;
            }
            this.this$0.notifier.selectLater$intellij_platform_lang_impl((Function1<? super BookmarksView, Unit>)((Function1)new Function1<BookmarksView, Unit>(this, bookmark){
                final /* synthetic */ Group this$0;
                final /* synthetic */ Bookmark $bookmark;
                {
                    this.this$0 = $receiver;
                    this.$bookmark = $bookmark;
                    super(1);
                }

                public final void invoke(@NotNull BookmarksView it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.select(this.this$0, this.$bookmark);
                }
            }));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean add$intellij_platform_lang_impl(@NotNull Bookmark bookmark, @NotNull BookmarkType type, @Nullable String description, int index2) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                block4: {
                    boolean bl = false;
                    if (this.canAdd(bookmark)) break block4;
                    boolean bl2 = false;
                    return bl2;
                }
                bookmarksManagerImpl.rewriteType(type, bookmark);
                InManagerInfo inManagerInfo = bookmarksManagerImpl.allBookmarks.computeIfAbsent(bookmark, arg_0 -> Group.add$lambda$16$lambda$15((Function1)new Function1<Bookmark, InManagerInfo>(bookmarksManagerImpl, type){
                    final /* synthetic */ BookmarksManagerImpl this$0;
                    final /* synthetic */ BookmarkType $type;
                    {
                        this.this$0 = $receiver;
                        this.$type = $type;
                        super(1);
                    }

                    @NotNull
                    public final InManagerInfo invoke(@NotNull Bookmark it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.new InManagerInfo(it, this.$type);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)inManagerInfo, (String)"@State(name = \"Bookmarks\u2026eshRenderer()\n    }\n  }\n}");
                InManagerInfo info2 = inManagerInfo;
                this.groupBookmarks.add(index2 < 0 ? this.groupBookmarks.size() : index2, bookmarksManagerImpl.new InGroupInfo(info2.getBookmark(), description));
                boolean added = info2.getGroups().isEmpty();
                info2.getGroups().add(this);
                info2.bookmarkAdded(this, added);
                info2.changeType(type);
                boolean bl = true;
                return bl;
            }
        }

        public final void addLater$intellij_platform_lang_impl(@NotNull Object context2, @NotNull BookmarkType type, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.this$0.invoker.invokeLater(() -> Group.addLater$lambda$18(this.this$0, context2, this, type, description));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRemove(@NotNull Bookmark bookmark) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl2 = false;
                Object object = (InManagerInfo)bookmarksManagerImpl.allBookmarks.get(bookmark);
                bl = object != null && (object = ((InManagerInfo)object).getGroups()) != null ? object.contains(this) : false;
            }
            return bl;
        }

        @Override
        public boolean remove(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            return this.this$0.removeFromGroup(this, bookmark) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                int index2 = bookmarksManagerImpl.allGroups.indexOf(this);
                if (index2 >= 0) {
                    if (this.isDefault()) {
                        bookmarksManagerImpl.setDefaultGroup(null);
                    }
                    for (Bookmark bookmark : this.getBookmarks()) {
                        bookmarksManagerImpl.removeFromGroup(this, bookmark);
                    }
                    bookmarksManagerImpl.removeGroupFrom(index2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final CancellablePromise<?> sortLater$intellij_platform_lang_impl() {
            CancellablePromise cancellablePromise = this.this$0.invoker.invokeLater(() -> Group.sortLater$lambda$21(this));
            Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"invoker.invokeLater { sort() }");
            return cancellablePromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sort() {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (this.groupBookmarks.isEmpty()) {
                    return;
                }
                if (!bookmarksManagerImpl.contains(this)) {
                    return;
                }
                List list2 = CollectionsKt.sortedWith((Iterable)this.groupBookmarks, (arg_0, arg_1) -> Group.sort$lambda$23$lambda$22((Function2)new Function2<InGroupInfo, InGroupInfo, Integer>((Object)this){

                    @NotNull
                    public final Integer invoke(@NotNull InGroupInfo p0, @NotNull InGroupInfo p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return Group.access$compare((Group)this.receiver, p0, p1);
                    }
                }, arg_0, arg_1));
                if (Intrinsics.areEqual((Object)list2, this.groupBookmarks)) {
                    return;
                }
                this.groupBookmarks.clear();
                this.groupBookmarks.addAll(list2);
                bookmarksManagerImpl.notifier.bookmarksSorted(this);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final int compare(InGroupInfo info1, InGroupInfo info2) {
            int weight2;
            int weight1 = info1.getBookmark().getProvider().getWeight();
            if (weight1 > (weight2 = info2.getBookmark().getProvider().getWeight())) {
                return -1;
            }
            if (weight1 < weight2) {
                return 1;
            }
            return info1.getBookmark().getProvider().compare(info1.getBookmark(), info2.getBookmark());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void move$intellij_platform_lang_impl(@NotNull Bookmark bookmark, @NotNull Bookmark anchor) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                int fromIndex = this.indexWithGrouping$intellij_platform_lang_impl(bookmark);
                if (fromIndex < 0) {
                    return;
                }
                int toIndex = this.indexWithGrouping$intellij_platform_lang_impl(anchor);
                if (toIndex < 0 || toIndex == fromIndex) {
                    return;
                }
                InGroupInfo info2 = this.groupBookmarks.remove(RangesKt.coerceAtLeast((int)fromIndex, (int)toIndex));
                bookmarksManagerImpl.notifier.bookmarkRemoved(this, info2.getBookmark());
                this.groupBookmarks.add(RangesKt.coerceAtMost((int)toIndex, (int)fromIndex), info2);
                bookmarksManagerImpl.notifier.bookmarkAdded(this, info2.getBookmark());
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final GroupState getState$intellij_platform_lang_impl() {
            GroupState groupState;
            GroupState it = groupState = new GroupState();
            boolean bl = false;
            it.setName(this.getName());
            it.setDefault(this.isDefault());
            for (InGroupInfo info2 : this.groupBookmarks) {
                it.getBookmarks().add(info2.getState());
            }
            return groupState;
        }

        private static final InManagerInfo add$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (InManagerInfo)$tmp0.invoke(p0);
        }

        private static final void addLater$lambda$18(BookmarksManagerImpl this$0, Object $context, Group this$1, BookmarkType $type, String $description) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
            Bookmark bookmark = this$0.createBookmark($context);
            if (bookmark != null) {
                Bookmark it = bookmark;
                boolean bl2 = false;
                v1 = this$1.add$intellij_platform_lang_impl(it, $type, $description, -1);
            } else {
                v1 = bl = null;
            }
            if (bl == null) {
                BookmarksManagerImplKt.access$getLOG$p().info("cannot create bookmark for " + $context);
            } else if (Intrinsics.areEqual(bl, (Object)false)) {
                BookmarksManagerImplKt.access$getLOG$p().info("cannot add bookmark for " + $context);
            }
        }

        private static final void sortLater$lambda$21(Group this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.sort();
        }

        private static final int sort$lambda$23$lambda$22(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public static final /* synthetic */ int access$compare(Group $this, InGroupInfo info1, InGroupInfo info2) {
            return $this.compare(info1, info2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookmarkType.values().length];
            try {
                nArray[BookmarkType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "description", "", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Lcom/intellij/ide/bookmark/Bookmark;Ljava/lang/String;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "hash", "", "getHash", "()I", "getState", "Lcom/intellij/ide/bookmark/BookmarkState;", "intellij.platform.lang.impl"})
    public final class InGroupInfo {
        @NotNull
        private final Bookmark bookmark;
        @Nullable
        private String description;
        private final int hash;

        public InGroupInfo(@Nullable Bookmark bookmark, String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            this.bookmark = bookmark;
            this.description = description;
            this.hash = ((Object)this.bookmark).hashCode();
        }

        @NotNull
        public final Bookmark getBookmark() {
            return this.bookmark;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string2) {
            this.description = string2;
        }

        public final int getHash() {
            return this.hash;
        }

        @NotNull
        public final BookmarkState getState() {
            BookmarkState bookmarkState = new BookmarkState();
            BookmarksManagerImpl bookmarksManagerImpl = BookmarksManagerImpl.this;
            BookmarkState it = bookmarkState;
            boolean bl = false;
            it.setProvider(this.bookmark.getProvider().getClass().getName());
            it.setDescription(this.description);
            Object object = (InManagerInfo)bookmarksManagerImpl.allBookmarks.get(this.bookmark);
            if (object == null || (object = object.getType()) == null) {
                object = BookmarkType.DEFAULT;
            }
            it.setType((BookmarkType)((Object)object));
            it.getAttributes().putAll(this.bookmark.getAttributes());
            return bookmarkState;
        }
    }
}

