/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\b\u0010%\u001a\u00020&H\u0002J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\u0012\u0010+\u001a\f0,\u00a2\u0006\u0002\b-\u00a2\u0006\u0002\b.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u000f\u00101\u001a\t\u0018\u000102\u00a2\u0006\u0002\b\nH\u0016J\b\u00103\u001a\u000204H\u0016J\u000f\u00105\u001a\t\u0018\u000102\u00a2\u0006\u0002\b\nH\u0016J\u000f\u00106\u001a\t\u0018\u000107\u00a2\u0006\u0002\b\nH\u0016J\n\u00108\u001a\u0004\u0018\u00010,H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010,2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020,H\u0016J\t\u0010<\u001a\u00020\u0012H\u00d6\u0001J\u0014\u0010=\u001a\u00020&2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020(0?J\b\u0010@\u001a\u00020&H\u0002J\t\u0010A\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006B"}, d2={"Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "(Lcom/intellij/ide/bookmark/LineBookmark;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/LineBookmark;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/Nullable;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighter$intellij_platform_lang_impl", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "layer", "", "getLayer", "()I", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "getMarkup", "()Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "reference", "Ljava/lang/ref/WeakReference;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "getType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "component1", "copy", "createHighlighter", "", "equals", "", "other", "", "getAccessibleName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "Ljavax/swing/Icon;", "getMiddleButtonClickAction", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getShortcut", "mnemonic", "", "getTooltipText", "hashCode", "refreshHighlighter", "release", "Lkotlin/Function0;", "releaseHighlighter", "toString", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nGutterLineBookmarkRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GutterLineBookmarkRenderer.kt\ncom/intellij/ide/bookmark/GutterLineBookmarkRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1#2:124\n1603#3,9:114\n1855#3:123\n1856#3:125\n1612#3:126\n*S KotlinDebug\n*F\n+ 1 GutterLineBookmarkRenderer.kt\ncom/intellij/ide/bookmark/GutterLineBookmarkRenderer\n*L\n58#1:124\n58#1:114,9\n58#1:123\n58#1:125\n58#1:126\n*E\n"})
public final class GutterLineBookmarkRenderer
extends GutterIconRenderer
implements DumbAware {
    @NotNull
    private final LineBookmark bookmark;
    @Nullable
    private WeakReference<RangeHighlighter> reference;

    public GutterLineBookmarkRenderer(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmark = bookmark;
    }

    @NotNull
    public final LineBookmark getBookmark() {
        return this.bookmark;
    }

    private final BookmarksManager getManager() {
        return BookmarksManager.getInstance(this.bookmark.getProvider().getProject());
    }

    private final BookmarkType getType() {
        Object object = this.getManager();
        if (object == null || (object = object.getType(this.bookmark)) == null) {
            object = BookmarkType.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manager?.getType(bookmark) ?: BookmarkType.DEFAULT");
        return object;
    }

    private final int getLayer() {
        return 5001;
    }

    private final Document getDocument() {
        return this.bookmark.getLine() < 0 ? null : FileDocumentManager.getInstance().getCachedDocument(this.bookmark.getFile());
    }

    private final MarkupModelEx getMarkup() {
        MarkupModelEx markupModelEx;
        Document document = this.getDocument();
        if (document != null) {
            Document it = document;
            boolean bl = false;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)it, (Project)this.bookmark.getProvider().getProject(), (boolean)false);
            markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        } else {
            markupModelEx = null;
        }
        return markupModelEx;
    }

    @Nullable
    public final RangeHighlighter getHighlighter$intellij_platform_lang_impl() {
        RangeHighlighter rangeHighlighter;
        block4: {
            rangeHighlighter = this.reference;
            if (rangeHighlighter == null || (rangeHighlighter = (RangeHighlighter)rangeHighlighter.get()) == null) {
                RangeHighlighter[] rangeHighlighterArray = this.getMarkup();
                if (rangeHighlighterArray != null && (rangeHighlighterArray = rangeHighlighterArray.getAllHighlighters()) != null) {
                    RangeHighlighter[] rangeHighlighterArray2 = rangeHighlighterArray;
                    int n = rangeHighlighterArray2.length;
                    for (int j = 0; j < n; ++j) {
                        RangeHighlighter rangeHighlighter2;
                        RangeHighlighter it = rangeHighlighter2 = rangeHighlighterArray2[j];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getGutterIconRenderer(), (Object)this)) continue;
                        rangeHighlighter = rangeHighlighter2;
                        break block4;
                    }
                    rangeHighlighter = null;
                } else {
                    rangeHighlighter = null;
                }
            }
        }
        return rangeHighlighter;
    }

    @NotNull
    public Icon getIcon() {
        return this.getType().getGutterIcon();
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.RIGHT;
    }

    @Nullable
    public AnAction getClickAction() {
        return ActionUtil.getAction((String)"ToggleBookmark");
    }

    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return ActionUtil.getAction((String)"EditBookmark");
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        return ActionUtil.getActionGroup((String)"popup@BookmarkContextMenu");
    }

    @NotNull
    public String getAccessibleName() {
        Object[] objectArray = new Object[]{this.getType()};
        String string2 = BookmarkBundle.message("accessible.name.icon.bookmark.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"accessible.name.icon.bookmark.0\", type)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getTooltipText() {
        Object shortcut;
        Object object;
        StringBuilder result2;
        block14: {
            block13: {
                String description;
                String string2;
                Object object2;
                Character mnemonic;
                result2 = new StringBuilder(BookmarkBundle.message("bookmark.text", new Object[0]));
                BookmarkType it = this.getType();
                boolean bl = false;
                Character c2 = mnemonic = it == BookmarkType.DEFAULT ? null : Character.valueOf(it.getMnemonic());
                if (c2 != null) {
                    char it2 = c2.charValue();
                    boolean bl2 = false;
                    result2.append(" ").append(it2);
                }
                if ((object2 = this.getManager()) != null && (object2 = object2.getGroups(this.bookmark)) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl3 = false;
                        BookmarkGroup group2 = (BookmarkGroup)element$iv$iv;
                        boolean bl4 = false;
                        if (group2.getDescription(this.bookmark) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    string2 = (String)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                } else {
                    string2 = null;
                }
                String string3 = description = string2;
                if (string3 != null) {
                    String it3 = string3;
                    boolean bl6 = false;
                    if (((CharSequence)it3).length() > 0) {
                        result2.append(": ").append(StringUtil.escapeXmlEntities(it3));
                    }
                }
                if ((object = mnemonic) == null) break block13;
                char it4 = ((Character)object).charValue();
                boolean bl7 = false;
                String string4 = this.getShortcut(it4);
                object = string4;
                if (string4 != null) break block14;
            }
            object = this.getShortcut();
        }
        Object object3 = shortcut = object;
        if (object3 != null) {
            Object it = object3;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                result2.append(" (").append((String)it).append(")");
            }
        }
        String string5 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"result.toString()");
        return string5;
    }

    private final String getShortcut() {
        String string2;
        String string3 = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFirstKeyboardShortcutText(\"ToggleBookmark\")");
        String toggle = string3;
        if (((CharSequence)toggle).length() > 0) {
            Object[] objectArray = new Object[]{toggle};
            string2 = BookmarkBundle.message("bookmark.shortcut.to.toggle", objectArray);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final String getShortcut(char mnemonic) {
        String string2;
        String string3 = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFirstKeyboardShortcut\u2026ToggleBookmark$mnemonic\")");
        String toggle = string3;
        String string4 = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFirstKeyboardShortcut\u2026(\"GotoBookmark$mnemonic\")");
        String jump = string4;
        if (((CharSequence)toggle).length() > 0 && ((CharSequence)jump).length() > 0) {
            Object[] objectArray = new Object[]{toggle, jump};
            string2 = BookmarkBundle.message("bookmark.shortcut.to.toggle.and.jump", objectArray);
        } else if (((CharSequence)toggle).length() > 0) {
            Object[] objectArray = new Object[]{toggle};
            string2 = BookmarkBundle.message("bookmark.shortcut.to.toggle", objectArray);
        } else if (((CharSequence)jump).length() > 0) {
            Object[] objectArray = new Object[]{jump};
            string2 = BookmarkBundle.message("bookmark.shortcut.to.jump", objectArray);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final void createHighlighter() {
        WeakReference<MarkupModelEx> weakReference;
        GutterLineBookmarkRenderer gutterLineBookmarkRenderer = this;
        MarkupModelEx markupModelEx = this.getMarkup();
        if (markupModelEx != null && (markupModelEx = markupModelEx.addPersistentLineHighlighter(CodeInsightColors.BOOKMARKS_ATTRIBUTES, this.bookmark.getLine(), this.getLayer())) != null) {
            MarkupModelEx it = markupModelEx;
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer2 = gutterLineBookmarkRenderer;
            boolean bl = false;
            it.setGutterIconRenderer((GutterIconRenderer)this);
            it.setErrorStripeTooltip((Object)this.getTooltipText());
            weakReference = new WeakReference<MarkupModelEx>(it);
            gutterLineBookmarkRenderer = gutterLineBookmarkRenderer2;
        } else {
            weakReference = null;
        }
        gutterLineBookmarkRenderer.reference = weakReference;
    }

    private final void releaseHighlighter() {
        RangeHighlighter rangeHighlighter = this.getHighlighter$intellij_platform_lang_impl();
        if (rangeHighlighter != null) {
            rangeHighlighter.dispose();
        }
        this.reference = null;
    }

    public final void refreshHighlighter(@NotNull Function0<Boolean> release) {
        Intrinsics.checkNotNullParameter(release, (String)"release");
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.bookmark.getProvider().getProject(), () -> GutterLineBookmarkRenderer.refreshHighlighter$lambda$10(release, this));
    }

    @NotNull
    public final LineBookmark component1() {
        return this.bookmark;
    }

    @NotNull
    public final GutterLineBookmarkRenderer copy(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return new GutterLineBookmarkRenderer(bookmark);
    }

    public static /* synthetic */ GutterLineBookmarkRenderer copy$default(GutterLineBookmarkRenderer gutterLineBookmarkRenderer, LineBookmark lineBookmark, int n, Object object) {
        if ((n & 1) != 0) {
            lineBookmark = gutterLineBookmarkRenderer.bookmark;
        }
        return gutterLineBookmarkRenderer.copy(lineBookmark);
    }

    @NotNull
    public String toString() {
        return "GutterLineBookmarkRenderer(bookmark=" + this.bookmark + ")";
    }

    public int hashCode() {
        return this.bookmark.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GutterLineBookmarkRenderer)) {
            return false;
        }
        GutterLineBookmarkRenderer gutterLineBookmarkRenderer = (GutterLineBookmarkRenderer)other;
        return Intrinsics.areEqual((Object)this.bookmark, (Object)gutterLineBookmarkRenderer.bookmark);
    }

    private static final void refreshHighlighter$lambda$10(Function0 $release, GutterLineBookmarkRenderer this$0) {
        Intrinsics.checkNotNullParameter((Object)$release, (String)"$release");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (((Boolean)$release.invoke()).booleanValue()) {
            this$0.releaseHighlighter();
        } else {
            RangeHighlighter rangeHighlighter = this$0.getHighlighter$intellij_platform_lang_impl();
            if (rangeHighlighter != null) {
                RangeHighlighter rangeHighlighter2;
                RangeHighlighter it = rangeHighlighter2 = rangeHighlighter;
                boolean bl = false;
                it.setGutterIconRenderer(null);
                it.setGutterIconRenderer((GutterIconRenderer)this$0);
            } else {
                this$0.createHighlighter();
            }
        }
    }
}

