/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.ModificationNotifier;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0016H\u0016J\u001c\u0010&\u001a\u00020\u00162\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160(H\u0002J!\u0010)\u001a\u00020\u00162\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00160(H\u0000\u00a2\u0006\u0002\b,R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/ide/bookmark/ModificationNotifier;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "count", "", "getCount", "()J", "modification", "Ljava/util/concurrent/atomic/AtomicLong;", "publisher", "getPublisher", "()Lcom/intellij/ide/bookmark/BookmarksListener;", "snapshot", "", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getSnapshot$intellij_platform_lang_impl", "()Ljava/util/List;", "setSnapshot$intellij_platform_lang_impl", "(Ljava/util/List;)V", "bookmarkAdded", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkChanged", "bookmarkRemoved", "bookmarkTypeChanged", "bookmarksSorted", "defaultGroupChanged", "old", "new", "groupAdded", "groupRemoved", "groupRenamed", "groupsSorted", "notifyLater", "notify", "Lkotlin/Function1;", "selectLater", "select", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "selectLater$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
public final class ModificationNotifier
implements BookmarksListener {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicLong modification;
    @Nullable
    private List<BookmarkOccurrence> snapshot;

    public ModificationNotifier(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.modification = new AtomicLong();
    }

    public final long getCount() {
        return this.modification.get();
    }

    private final BookmarksListener getPublisher() {
        BookmarksListener bookmarksListener;
        if (!this.project.isOpen() || this.project.isDisposed()) {
            bookmarksListener = null;
        } else {
            MessageBus messageBus = this.project.getMessageBus();
            Topic<BookmarksListener> topic = BookmarksListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            bookmarksListener = messageBus.syncPublisher(topic);
        }
        return bookmarksListener;
    }

    public final void selectLater$intellij_platform_lang_impl(@NotNull Function1<? super BookmarksView, Unit> select2) {
        Intrinsics.checkNotNullParameter(select2, (String)"select");
        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this, select2){
            final /* synthetic */ ModificationNotifier this$0;
            final /* synthetic */ Function1<BookmarksView, Unit> $select;
            {
                this.this$0 = $receiver;
                this.$select = $select;
                super(0);
            }

            public final void invoke() {
                block1: {
                    BookmarksView view;
                    ToolWindow window = ModificationNotifier.access$getProject$p(this.this$0).isDisposed() ? null : ToolWindowManager.Companion.getInstance(ModificationNotifier.access$getProject$p(this.this$0)).getToolWindow("Bookmarks");
                    ToolWindow toolWindow = window;
                    Object object = toolWindow != null && (toolWindow = toolWindow.getContentManagerIfCreated()) != null && (toolWindow = toolWindow.getSelectedContent()) != null ? toolWindow.getComponent() : null;
                    BookmarksView bookmarksView = view = object instanceof BookmarksView ? (BookmarksView)object : null;
                    if (bookmarksView == null) break block1;
                    object = bookmarksView;
                    Function1<BookmarksView, Unit> function1 = this.$select;
                    Object it = object;
                    boolean bl = false;
                    if (it.isShowing()) {
                        function1.invoke(it);
                    }
                }
            }
        }, 1, null);
    }

    @Nullable
    public final List<BookmarkOccurrence> getSnapshot$intellij_platform_lang_impl() {
        return this.snapshot;
    }

    public final void setSnapshot$intellij_platform_lang_impl(@Nullable List<BookmarkOccurrence> list2) {
        this.snapshot = list2;
    }

    private final void notifyLater(Function1<? super BookmarksListener, Unit> notify) {
        this.snapshot = null;
        this.modification.incrementAndGet();
        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this, notify){
            final /* synthetic */ ModificationNotifier this$0;
            final /* synthetic */ Function1<BookmarksListener, Unit> $notify;
            {
                this.this$0 = $receiver;
                this.$notify = $notify;
                super(0);
            }

            public final void invoke() {
                block0: {
                    BookmarksListener bookmarksListener = ModificationNotifier.access$getPublisher(this.this$0);
                    if (bookmarksListener == null) break block0;
                    BookmarksListener bookmarksListener2 = bookmarksListener;
                    this.$notify.invoke((Object)bookmarksListener2);
                }
            }
        }, 1, null);
    }

    @Override
    public void groupsSorted() {
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)groupsSorted.1.INSTANCE));
    }

    @Override
    public void groupAdded(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2){
            final /* synthetic */ BookmarkGroup $group;
            {
                this.$group = $group;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.groupAdded(this.$group);
            }
        }));
    }

    @Override
    public void groupRemoved(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2){
            final /* synthetic */ BookmarkGroup $group;
            {
                this.$group = $group;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.groupRemoved(this.$group);
            }
        }));
    }

    @Override
    public void groupRenamed(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2){
            final /* synthetic */ BookmarkGroup $group;
            {
                this.$group = $group;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.groupRenamed(this.$group);
            }
        }));
    }

    @Override
    public void bookmarksSorted(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2){
            final /* synthetic */ BookmarkGroup $group;
            {
                this.$group = $group;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.bookmarksSorted(this.$group);
            }
        }));
    }

    @Override
    public void bookmarkAdded(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2, bookmark){
            final /* synthetic */ BookmarkGroup $group;
            final /* synthetic */ Bookmark $bookmark;
            {
                this.$group = $group;
                this.$bookmark = $bookmark;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.bookmarkAdded(this.$group, this.$bookmark);
            }
        }));
    }

    @Override
    public void bookmarkRemoved(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2, bookmark){
            final /* synthetic */ BookmarkGroup $group;
            final /* synthetic */ Bookmark $bookmark;
            {
                this.$group = $group;
                this.$bookmark = $bookmark;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.bookmarkRemoved(this.$group, this.$bookmark);
            }
        }));
    }

    @Override
    public void bookmarkChanged(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(group2, bookmark){
            final /* synthetic */ BookmarkGroup $group;
            final /* synthetic */ Bookmark $bookmark;
            {
                this.$group = $group;
                this.$bookmark = $bookmark;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.bookmarkChanged(this.$group, this.$bookmark);
            }
        }));
    }

    @Override
    public void bookmarkTypeChanged(@NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(bookmark){
            final /* synthetic */ Bookmark $bookmark;
            {
                this.$bookmark = $bookmark;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.bookmarkTypeChanged(this.$bookmark);
            }
        }));
    }

    @Override
    public void defaultGroupChanged(@Nullable BookmarkGroup old, @Nullable BookmarkGroup bookmarkGroup) {
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)new Function1<BookmarksListener, Unit>(old, bookmarkGroup){
            final /* synthetic */ BookmarkGroup $old;
            final /* synthetic */ BookmarkGroup $new;
            {
                this.$old = $old;
                this.$new = $new;
                super(1);
            }

            public final void invoke(@NotNull BookmarksListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.defaultGroupChanged(this.$old, this.$new);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(ModificationNotifier $this) {
        return $this.project;
    }

    public static final /* synthetic */ BookmarksListener access$getPublisher(ModificationNotifier $this) {
        return $this.getPublisher();
    }
}

