/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.actions.BookmarkTypeChooserKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B?\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Ljava/awt/event/KeyListener;", "current", "Lcom/intellij/ide/bookmark/BookmarkType;", "assigned", "", "onChosen", "Lkotlin/Function1;", "", "save", "Lkotlin/Function0;", "(Lcom/intellij/ide/bookmark/BookmarkType;Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "buttons", "Lcom/intellij/util/containers/JBIterable;", "Ljavax/swing/JButton;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createButton", "type", "keyPressed", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "next", "Ljava/awt/Component;", "source", "dx", "", "dy", "point", "Ljava/awt/Point;", "offset", "delta", "size", "updateButtons", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarkTypeChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkTypeChooser.kt\ncom/intellij/ide/bookmark/actions/BookmarkLayoutGrid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n3792#2:267\n4307#2,2:268\n3792#2:272\n4307#2,2:273\n1855#3,2:270\n1855#3,2:275\n1855#3,2:277\n*S KotlinDebug\n*F\n+ 1 BookmarkTypeChooser.kt\ncom/intellij/ide/bookmark/actions/BookmarkLayoutGrid\n*L\n156#1:267\n156#1:268,2\n166#1:272\n166#1:273,2\n157#1:270,2\n167#1:275,2\n193#1:277,2\n*E\n"})
final class BookmarkLayoutGrid
extends BorderLayoutPanel
implements KeyListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BookmarkType> assigned;
    @NotNull
    private final Function1<BookmarkType, Unit> onChosen;
    @NotNull
    private final Function0<Unit> save;
    @NotNull
    public static final String TYPE_KEY = "BookmarkLayoutGrid.Type";

    /*
     * WARNING - void declaration
     */
    public BookmarkLayoutGrid(@Nullable BookmarkType current, @NotNull Set<? extends BookmarkType> assigned, @NotNull Function1<? super BookmarkType, Unit> onChosen2, @NotNull Function0<Unit> save) {
        void $this$_init__u24lambda_u245;
        int n;
        BookmarkType[] $this$forEach$iv;
        Object it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JPanel $this$_init__u24lambda_u242;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(assigned, (String)"assigned");
        Intrinsics.checkNotNullParameter(onChosen2, (String)"onChosen");
        Intrinsics.checkNotNullParameter(save, (String)"save");
        this.assigned = assigned;
        this.onChosen = onChosen2;
        this.save = save;
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT()));
        BookmarkLayoutGrid bookmarkLayoutGrid2 = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.setBorder(ExperimentalUI.isNewUI() ? (Border)JBUI.Borders.emptyRight(14) : JBUI.Borders.empty(5));
        $this$_init__u24lambda_u242.setOpaque(false);
        BookmarkType[] bookmarkTypeArray = BookmarkType.values();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n2; ++j) {
            it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl2 = false;
            if (!Character.isDigit(((BookmarkType)((Object)it)).getMnemonic())) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it2 = (BookmarkType)((Object)t);
            n = 0;
            $this$_init__u24lambda_u242.add(this.createButton(it2));
        }
        bookmarkLayoutGrid2.addToLeft(jPanel);
        $this$_init__u24lambda_u242 = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT()));
        bookmarkLayoutGrid2 = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u245.setBorder(ExperimentalUI.isNewUI() ? (Border)JBUI.Borders.empty() : JBUI.Borders.empty(5));
        $this$_init__u24lambda_u245.setOpaque(false);
        $this$forEach$iv = BookmarkType.values();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterTo = false;
        n2 = ((Object)$this$filterTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            it = element$iv$iv = $this$filterTo$iv$iv[n];
            boolean bl4 = false;
            if (!Character.isLetter(((BookmarkType)((Object)it)).getMnemonic())) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it3 = (BookmarkType)((Object)t);
            boolean bl5 = false;
            $this$_init__u24lambda_u245.add(this.createButton(it3));
        }
        bookmarkLayoutGrid2.addToRight(jPanel);
        this.setOpaque(false);
        this.updateButtons(current);
    }

    @NotNull
    public final JBIterable<JButton> buttons() {
        JBIterable<JButton> jBIterable = UIUtil.uiTraverser(this).traverse().filter(JButton.class);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"uiTraverser(this).traver\u2026lter(JButton::class.java)");
        return jBIterable;
    }

    @NotNull
    public final JButton createButton(@NotNull BookmarkType type) {
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        JButton $this$createButton_u24lambda_u248 = jButton = new JButton(String.valueOf(type.getMnemonic()));
        boolean bl = false;
        $this$createButton_u24lambda_u248.setMnemonic(type.getMnemonic());
        $this$createButton_u24lambda_u248.setOpaque(false);
        $this$createButton_u24lambda_u248.putClientProperty("ActionToolbar.smallVariant", true);
        $this$createButton_u24lambda_u248.putClientProperty(TYPE_KEY, (Object)type);
        $this$createButton_u24lambda_u248.addPropertyChangeListener(arg_0 -> BookmarkLayoutGrid.createButton$lambda$8$lambda$6($this$createButton_u24lambda_u248, arg_0));
        $this$createButton_u24lambda_u248.addActionListener(arg_0 -> BookmarkLayoutGrid.createButton$lambda$8$lambda$7(this, type, arg_0));
        $this$createButton_u24lambda_u248.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "released");
        $this$createButton_u24lambda_u248.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        $this$createButton_u24lambda_u248.setCursor(BookmarkTypeChooserKt.access$getSHARED_CURSOR());
        $this$createButton_u24lambda_u248.addKeyListener(this);
        return jButton;
    }

    public final void updateButtons(@Nullable BookmarkType current) {
        Iterable $this$forEach$iv = this.buttons();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            Object object = it.getClientProperty(TYPE_KEY);
            BookmarkType type = object instanceof BookmarkType ? (BookmarkType)((Object)object) : null;
            if (type == current) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getCURRENT_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getCURRENT_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getCURRENT_BACKGROUND$p());
                continue;
            }
            if (CollectionsKt.contains((Iterable)this.assigned, (Object)((Object)type))) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getASSIGNED_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getASSIGNED_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getASSIGNED_BACKGROUND$p());
                continue;
            }
            it.putClientProperty("JButton.textColor", UIManager.getColor("Bookmark.MnemonicAvailable.foreground"));
            it.putClientProperty("JButton.backgroundColor", JBUI.CurrentTheme.Popup.BACKGROUND);
            it.putClientProperty("JButton.borderColor", UIManager.getColor("Bookmark.MnemonicAvailable.borderColor"));
        }
    }

    private final int offset(int delta, int size) {
        return delta < 0 ? delta : (delta > 0 ? delta + size : size / 2);
    }

    private final Component next(Component source, int dx, int dy) {
        Point point = SwingUtilities.convertPoint(source, this.offset(dx, source.getWidth()), this.offset(dy, source.getHeight()), this);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"point");
        Component component2 = this.next(source, dx, dy, point);
        if (component2 != null || !Registry.is("ide.bookmark.mnemonic.chooser.cyclic.scrolling.allowed")) {
            return component2;
        }
        if (dx > 0) {
            point.x = 0;
        }
        if (dx < 0) {
            point.x = dx + this.getWidth();
        }
        if (dy > 0) {
            point.y = 0;
        }
        if (dy < 0) {
            point.y = dy + this.getHeight();
        }
        return this.next(source, dx, dy, point);
    }

    private final Component next(Component source, int dx, int dy, Point point) {
        while (this.contains(point)) {
            Component component2 = SwingUtilities.getDeepestComponentAt(this, point.x, point.y);
            if (component2 instanceof JButton) {
                return component2;
            }
            point.translate(dx * source.getWidth() / 2, dy * source.getHeight() / 2);
        }
        return null;
    }

    @Override
    public void keyTyped(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyReleased(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyPressed(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getModifiersEx() == 0) {
            switch (event.getKeyCode()) {
                case 38: 
                case 224: {
                    Component component2 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"event.component");
                    Component component3 = this.next(component2, 0, -1);
                    if (component3 != null) {
                        component3.requestFocus();
                    }
                    break;
                }
                case 40: 
                case 225: {
                    Component component4 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"event.component");
                    Component component5 = this.next(component4, 0, 1);
                    if (component5 != null) {
                        component5.requestFocus();
                    }
                    break;
                }
                case 37: 
                case 226: {
                    Component component6 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component6, (String)"event.component");
                    Component component7 = this.next(component6, -1, 0);
                    if (component7 != null) {
                        component7.requestFocus();
                    }
                    break;
                }
                case 39: 
                case 227: {
                    Component component8 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component8, (String)"event.component");
                    Component component9 = this.next(component8, 1, 0);
                    if (component9 != null) {
                        component9.requestFocus();
                    }
                    break;
                }
                case 10: {
                    JButton button2;
                    Component component10 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component10, (String)"event.component");
                    Component component11 = this.next(component10, 0, 0);
                    JButton jButton = button2 = component11 instanceof JButton ? (JButton)component11 : null;
                    if (jButton != null) {
                        jButton.doClick();
                    }
                    this.save.invoke();
                    break;
                }
                default: {
                    BookmarkType type = BookmarkType.Companion.get((char)event.getKeyCode());
                    if (type == BookmarkType.DEFAULT) break;
                    this.onChosen.invoke((Object)type);
                    this.save.invoke();
                }
            }
        }
    }

    private static final void createButton$lambda$8$lambda$6(JButton $this_apply, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        $this_apply.repaint();
    }

    private static final void createButton$lambda$8$lambda$7(BookmarkLayoutGrid this$0, BookmarkType $type, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        this$0.onChosen.invoke((Object)$type);
        this$0.updateButtons($type);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid$Companion;", "", "()V", "TYPE_KEY", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

