/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/actions/GotoBookmarkTypeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "checkSpeedSearch", "", "(Lcom/intellij/ide/bookmark/BookmarkType;Z)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canNavigate", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
public class GotoBookmarkTypeAction
extends DumbAwareAction {
    @NotNull
    private final BookmarkType type;
    private final boolean checkSpeedSearch;

    public GotoBookmarkTypeAction(@NotNull BookmarkType type, boolean checkSpeedSearch) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Object[] objectArray = new Object[]{Character.valueOf(type.getMnemonic())};
        super(BookmarkBundle.messagePointer("goto.bookmark.type.action.text", objectArray));
        this.type = type;
        this.checkSpeedSearch = checkSpeedSearch;
        this.setEnabledInModalContext(true);
    }

    public /* synthetic */ GotoBookmarkTypeAction(BookmarkType bookmarkType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(bookmarkType, bl);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean canNavigate(AnActionEvent event) {
        Object object = ExtensionsKt.getBookmarksManager(event);
        return object != null && (object = object.getBookmark(this.type)) != null ? object.canNavigate() : false;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabledAndVisible((!this.checkSpeedSearch || event.getData(PlatformDataKeys.SPEED_SEARCH_TEXT) == null) && this.canNavigate(event));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = ExtensionsKt.getBookmarksManager(event);
            if (object == null || (object = object.getBookmark(this.type)) == null) break block0;
            object.navigate(true);
        }
    }
}

