/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.bookmark.actions.NextBookmarkService;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/actions/IterateBookmarksAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "forward", "", "dynamicText", "Ljava/util/function/Supplier;", "", "(ZLjava/util/function/Supplier;)V", "getForward", "()Z", "nextBookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getNextBookmark", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/ide/bookmark/LineBookmark;", "actionPerformed", "", "event", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nNextBookmarkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextBookmarkService.kt\ncom/intellij/ide/bookmark/actions/IterateBookmarksAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n29#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 NextBookmarkService.kt\ncom/intellij/ide/bookmark/actions/IterateBookmarksAction\n*L\n18#1:79,3\n*E\n"})
public abstract class IterateBookmarksAction
extends DumbAwareAction {
    private final boolean forward;

    public IterateBookmarksAction(boolean forward, @NotNull Supplier<String> dynamicText) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        super(dynamicText);
        this.forward = forward;
    }

    public final boolean getForward() {
        return this.forward;
    }

    private final LineBookmark getNextBookmark(AnActionEvent $this$nextBookmark) {
        LineBookmark lineBookmark;
        Project project2 = $this$nextBookmark.getProject();
        if (project2 != null) {
            ComponentManager $this$service$iv = project2;
            boolean $i$f$service = false;
            Class<NextBookmarkService> serviceClass$iv = NextBookmarkService.class;
            NextBookmarkService nextBookmarkService = $this$service$iv.getService(serviceClass$iv);
            if (nextBookmarkService == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            Bookmark bookmark = ExtensionsKt.getContextBookmark($this$nextBookmark);
            lineBookmark = nextBookmarkService.next(this.forward, bookmark instanceof LineBookmark ? (LineBookmark)bookmark : null);
        } else {
            lineBookmark = null;
        }
        return lineBookmark;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksView view = ExtensionsKt.getBookmarksView(event);
        event.getPresentation().setEnabled(view == null ? this.getNextBookmark(event) != null : (this.forward ? view.hasNextOccurence() : view.hasPreviousOccurence()));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksView view = ExtensionsKt.getBookmarksView(event);
        if (view == null) {
            LineBookmark lineBookmark = this.getNextBookmark(event);
            if (lineBookmark != null) {
                LineBookmark $this$actionPerformed_u24lambda_u240 = lineBookmark;
                boolean bl = false;
                if ($this$actionPerformed_u24lambda_u240.canNavigate()) {
                    $this$actionPerformed_u24lambda_u240.navigate(true);
                }
            }
        } else if (this.forward) {
            view.goNextOccurence();
        } else {
            view.goPreviousOccurence();
        }
    }
}

