/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/bookmark/actions/NextBookmarkInEditor;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "forward", "", "(Z)V", "getForward", "()Z", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getNextBookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "isEnabledForCaret", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nNextBookmarkInEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextBookmarkInEditor.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkInEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n1#2:71\n1611#3:69\n1855#3:70\n1856#3:72\n1612#3:73\n1002#3,2:74\n1011#3,2:76\n*S KotlinDebug\n*F\n+ 1 NextBookmarkInEditor.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkInEditor\n*L\n42#1:71\n42#1:69\n42#1:70\n42#1:72\n42#1:73\n47#1:74,2\n54#1:76,2\n*E\n"})
final class NextBookmarkInEditor
extends EditorActionHandler {
    private final boolean forward;

    public NextBookmarkInEditor(boolean forward) {
        this.forward = forward;
    }

    public final boolean getForward() {
        return this.forward;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getNextBookmark(editor2, context2) != null;
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LineBookmark lineBookmark = this.getNextBookmark(editor2, context2);
        if (lineBookmark == null) {
            return;
        }
        LineBookmark bookmark = lineBookmark;
        int it = bookmark.getLine();
        boolean bl = false;
        if (0 > it || it >= editor2.getDocument().getLineCount()) {
            return;
        }
        LogicalPosition pos = new LogicalPosition(it, 0);
        editor2.getSelectionModel().removeSelection();
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().moveToLogicalPosition(pos);
        editor2.getScrollingModel().scrollTo(pos, ScrollType.CENTER);
    }

    /*
     * WARNING - void declaration
     */
    private final LineBookmark getNextBookmark(Editor editor2, DataContext context2) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        if (editor2.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        Project project2 = editor2.getProject();
        if (project2 == null) {
            project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(project2);
        if (bookmarksManager == null) {
            return null;
        }
        BookmarksManager manager = bookmarksManager;
        List<Bookmark> list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.bookmarks");
        Iterable iterable = list2;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LineBookmark it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Bookmark it = (Bookmark)element$iv;
            boolean bl2 = false;
            if ((it instanceof LineBookmark && Intrinsics.areEqual((Object)((LineBookmark)it).getFile(), (Object)file2) ? (LineBookmark)it : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        List bookmarks = (List)destination$iv;
        if (!((Collection)bookmarks).isEmpty()) {
            LineBookmark bookmark;
            int line = editor2.getCaretModel().getLogicalPosition().line;
            if (this.forward) {
                List $this$sortBy$iv = bookmarks;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            LineBookmark it = (LineBookmark)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getLine());
                            it = (LineBookmark)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
                        }
                    });
                }
                for (LineBookmark bookmark2 : bookmarks) {
                    if (bookmark2.getLine() <= line) continue;
                    return bookmark2;
                }
            } else {
                List $this$sortByDescending$iv = bookmarks;
                boolean $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            LineBookmark it = (LineBookmark)b;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getLine());
                            it = (LineBookmark)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
                        }
                    });
                }
                for (LineBookmark bookmark3 : bookmarks) {
                    if (bookmark3.getLine() >= line) continue;
                    return bookmark3;
                }
            }
            if (BookmarkOccurrence.Companion.getCyclic() && (bookmark = (LineBookmark)bookmarks.get(0)).getLine() != line) {
                return bookmark;
            }
        }
        return null;
    }
}

