/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.bookmark.ui.GroupSelectDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/bookmark/actions/ToggleBookmarkAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "isUnexpected", "", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addMultipleBookmarks", "bookmarks", "", "Lcom/intellij/ide/bookmark/Bookmark;", "addSingleBookmark", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nToggleBookmarkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleBookmarkAction.kt\ncom/intellij/ide/bookmark/actions/ToggleBookmarkAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1855#3,2:96\n1855#3,2:98\n*S KotlinDebug\n*F\n+ 1 ToggleBookmarkAction.kt\ncom/intellij/ide/bookmark/actions/ToggleBookmarkAction\n*L\n75#1:96,2\n84#1:98,2\n*E\n"})
public final class ToggleBookmarkAction
extends DumbAwareAction
implements Toggleable {
    public ToggleBookmarkAction() {
        super(BookmarkBundle.messagePointer("bookmark.toggle.action.text", new Object[0]));
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2;
        BookmarkType bookmarkType;
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ExtensionsKt.getContextBookmarks(event) != null) {
            Presentation presentation3;
            Presentation $this$update_u24lambda_u240 = presentation3 = event.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u240.setEnabledAndVisible(true);
            $this$update_u24lambda_u240.setText(BookmarkBundle.message("bookmark.add.multiple.action.text", new Object[0]));
            return;
        }
        BookmarksManager manager = ExtensionsKt.getBookmarksManager(event);
        Bookmark bookmark2 = bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark2 != null) {
            Bookmark it = bookmark2;
            boolean bl = false;
            BookmarksManager bookmarksManager = manager;
            bookmarkType = bookmarksManager != null ? bookmarksManager.getType(it) : null;
        } else {
            bookmarkType = null;
        }
        BookmarkType type = bookmarkType;
        Presentation $this$update_u24lambda_u242 = presentation2 = event.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u242.setEnabledAndVisible(bookmark != null);
        String string2 = event.getPlace();
        $this$update_u24lambda_u242.setIcon(switch (string2.hashCode()) {
            case -1388598828 -> {
                if (string2.equals("TouchBarGeneral")) {
                    Toggleable.setSelected((Presentation)$this$update_u24lambda_u242, (type != null ? 1 : 0) != 0);
                    yield AllIcons.Actions.Checked;
                }
            }
            default -> null;
        });
        $this$update_u24lambda_u242.setText(!ActionPlaces.isPopupPlace((String)event.getPlace()) ? BookmarkBundle.message("bookmark.toggle.action.text", new Object[0]) : (type != null ? BookmarkBundle.message("bookmark.delete.action.text", new Object[0]) : BookmarkBundle.message("bookmark.add.action.text", new Object[0])));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Boolean unexpectedGutterClick;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputEvent inputEvent = event.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent != null) {
            MouseEvent $this$actionPerformed_u24lambda_u243 = mouseEvent;
            boolean bl = false;
            v1 = $this$actionPerformed_u24lambda_u243.getSource() instanceof EditorGutter && this.isUnexpected($this$actionPerformed_u24lambda_u243);
        } else {
            v1 = unexpectedGutterClick = null;
        }
        if (Intrinsics.areEqual(unexpectedGutterClick, (Object)true)) {
            return;
        }
        List<Bookmark> bookmarks = ExtensionsKt.getContextBookmarks(event);
        if (bookmarks != null) {
            this.addMultipleBookmarks(event, bookmarks);
        } else {
            this.addSingleBookmark(event);
        }
    }

    private final void addSingleBookmark(AnActionEvent event) {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bookmarkType), (String)"manager.getType(bookmark) ?: BookmarkType.DEFAULT");
        BookmarkType type = bookmarkType;
        manager.toggle(bookmark2, type);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        String selectedText = editor2 != null && (editor2 = editor2.getSelectionModel()) != null ? editor2.getSelectedText() : null;
        CharSequence charSequence = selectedText;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List<BookmarkGroup> list2 = manager.getGroups(bookmark2);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.getGroups(bookmark)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookmarkGroup group2 = (BookmarkGroup)element$iv;
                boolean bl = false;
                group2.setDescription(bookmark2, selectedText);
            }
        }
    }

    private final void addMultipleBookmarks(AnActionEvent event, List<? extends Bookmark> bookmarks) {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Project project2 = event.getProject();
        List<BookmarkGroup> list2 = manager.getGroups();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.groups");
        BookmarkGroup bookmarkGroup = new GroupSelectDialog(project2, null, manager, list2).showAndGetGroup(false);
        if (bookmarkGroup == null) {
            return;
        }
        BookmarkGroup group2 = bookmarkGroup;
        Iterable $this$forEach$iv = bookmarks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            BookmarkGroup.add$default(group2, it, BookmarkType.DEFAULT, null, 4, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }
}

