/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.InvalidBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 H2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001HB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J!\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010)J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010*\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020 J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\"2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u001a\u0010$\u001a\u00020\"2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u0004\u0018\u00010\"2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020103H\u0016J\u001a\u00104\u001a\u0002052\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\u001c\u00106\u001a\u0004\u0018\u00010%2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010(\u001a\u00020 H\u0002J\b\u00107\u001a\u00020\u0006H\u0016J\b\u00108\u001a\u00020 H\u0016J\u0014\u00109\u001a\u00020\u00162\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0017H\u0016J\u0018\u0010>\u001a\u0004\u0018\u00010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0016J$\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0A2\u0010\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0AH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\"2\u0006\u0010F\u001a\u00020\"H\u0002J\b\u0010G\u001a\u00020\u001cH\u0002R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u001a\u00a8\u0006I"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener$Simple;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "VFM", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Lorg/jetbrains/annotations/NotNull;", "getVFM", "()Lcom/intellij/openapi/vfs/VirtualFileManager;", "validateAlarm", "Lcom/intellij/util/SingleAlarm;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "Ljavax/swing/tree/TreePath;", "getAsVirtualFile", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/openapi/vfs/VirtualFile;", "isUnexpected", "", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "(Lcom/intellij/openapi/editor/event/EditorMouseEvent;)Z", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "afterDocumentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "compare", "", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "Lcom/intellij/ide/bookmark/FileBookmark;", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/ide/bookmark/FileBookmark;", "file", "element", "Lcom/intellij/psi/PsiElement;", "path", "context", "", "url", "", "map", "", "createInvalidBookmark", "Lcom/intellij/ide/bookmark/providers/InvalidBookmark;", "createValidBookmark", "getProject", "getWeight", "isNodeVisible", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "mouseClicked", "event", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareGroup", "nodes", "validate", "bookmark", "validateAndUpdate", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nLineBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n1855#2,2:251\n766#2:254\n857#2,2:255\n766#2:257\n857#2,2:258\n1855#2,2:260\n1855#2,2:275\n1603#2,9:277\n1855#2:286\n1856#2:288\n1612#2:289\n1747#2,3:292\n1855#2,2:295\n1#3:253\n1#3:272\n1#3:287\n135#4,9:262\n215#4:271\n216#4:273\n144#4:274\n215#4,2:290\n*S KotlinDebug\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider\n*L\n68#1:251,2\n69#1:254\n69#1:255,2\n70#1:257\n70#1:258,2\n73#1:260,2\n80#1:275,2\n86#1:277,9\n86#1:286\n86#1:288\n86#1:289\n195#1:292,3\n205#1:295,2\n80#1:272\n86#1:287\n80#1:262,9\n80#1:271\n80#1:273\n80#1:274\n182#1:290,2\n*E\n"})
public final class LineBookmarkProvider
implements BookmarkProvider,
EditorMouseListener,
BulkAwareDocumentListener.Simple,
AsyncFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SingleAlarm validateAlarm;

    public LineBookmarkProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.validateAlarm = new SingleAlarm(this::validateAndUpdate, 100, (Disposable)this.project, Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);
        if (!this.project.isDefault()) {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getInstance().eventMulticaster");
            EditorEventMulticaster multicaster = editorEventMulticaster;
            multicaster.addDocumentListener((DocumentListener)this, (Disposable)this.project);
            multicaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this.project);
            this.getVFM().addAsyncFileListener(this, this.project);
        }
    }

    @Override
    public int getWeight() {
        return Integer.MIN_VALUE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        VirtualFile file2;
        FileBookmark fileBookmark2;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        FileBookmark fileBookmark1 = bookmark1 instanceof FileBookmark ? (FileBookmark)bookmark1 : null;
        FileBookmark fileBookmark = fileBookmark2 = bookmark2 instanceof FileBookmark ? (FileBookmark)bookmark2 : null;
        if (fileBookmark1 == null && fileBookmark2 == null) {
            return 0;
        }
        if (fileBookmark1 == null) {
            return -1;
        }
        if (fileBookmark2 == null) {
            return 1;
        }
        VirtualFile file1 = fileBookmark1.getFile();
        if (Intrinsics.areEqual((Object)file1, (Object)(file2 = fileBookmark2.getFile()))) {
            LineBookmark lineBookmark2;
            LineBookmark lineBookmark1 = bookmark1 instanceof LineBookmark ? (LineBookmark)bookmark1 : null;
            LineBookmark lineBookmark = lineBookmark2 = bookmark2 instanceof LineBookmark ? (LineBookmark)bookmark2 : null;
            if (lineBookmark1 == null && lineBookmark2 == null) {
                return 0;
            }
            if (lineBookmark1 == null) {
                return -1;
            }
            if (lineBookmark2 == null) {
                return 1;
            }
            return Intrinsics.compare((int)lineBookmark1.getLine(), (int)lineBookmark2.getLine());
        }
        if (file1.isDirectory() && !file2.isDirectory()) {
            return -1;
        }
        if (!file1.isDirectory() && file2.isDirectory()) {
            return 1;
        }
        return StringUtil.naturalCompare(file1.getPresentableName(), file2.getPresentableName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> prepareGroup(@NotNull List<? extends AbstractTreeNode<?>> nodes2) {
        VirtualFile it$iv$iv;
        AbstractTreeNode it;
        Object element$iv$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Object destination$iv$iv;
        BookmarkNode bookmarkNode;
        Object it22;
        block15: {
            Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
            Iterable $this$forEach$iv = nodes2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it22 = (AbstractTreeNode)element$iv;
                boolean bl = false;
                FileNode fileNode = it22 instanceof FileNode ? (FileNode)it22 : null;
                if (fileNode == null) continue;
                fileNode.ungroup();
            }
            for (Object it22 : (Iterable)nodes2) {
                boolean bl = false;
                if ((it22 = it22 instanceof LineNode ? (LineNode)it22 : null) == null) continue;
                bookmarkNode = it22;
                break block15;
            }
            bookmarkNode = null;
        }
        if (bookmarkNode == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = nodes2;
            boolean $i$f$filter2 = false;
            it22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbstractTreeNode p0 = (AbstractTreeNode)element$iv$iv;
                boolean bl = false;
                if (!this.isNodeVisible(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            return (List)destination$iv$iv2;
        }
        BookmarkNode node2 = bookmarkNode;
        BookmarksView bookmarksView = node2.getBookmarksView();
        if (!(bookmarksView != null && (bookmarksView = bookmarksView.getGroupLineBookmarks()) != null ? bookmarksView.isSelected() : false)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = nodes2;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbstractTreeNode p0 = (AbstractTreeNode)element$iv$iv;
                boolean bl = false;
                if (!this.isNodeVisible(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Map map2 = new LinkedHashMap();
        Iterable $this$forEach$iv = nodes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTreeNode it3 = (AbstractTreeNode)element$iv;
            boolean bl = false;
            AbstractTreeNode p0 = it3;
            if (p0 instanceof LineNode) {
                map2.putIfAbsent(((LineNode)it3).getVirtualFile(), null);
                continue;
            }
            if (!(p0 instanceof FileNode)) continue;
            map2.put(((FileNode)it3).getVirtualFile(), it3);
        }
        Object $this$mapNotNull$iv = map2;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            AbstractTreeNode element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            it = element$iv$iv;
            boolean bl2 = false;
            if ((it.getValue() == null ? (VirtualFile)it.getKey() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it4 = (VirtualFile)element$iv;
            boolean bl = false;
            Map $i$f$forEach22 = map2;
            Iterator $this$prepareGroup_u24lambda_u246_u24lambda_u245 = iterator2 = new FileNode(this.project, new FileBookmarkImpl(this, it4));
            boolean bl4 = false;
            ((BookmarkNode)((Object)$this$prepareGroup_u24lambda_u246_u24lambda_u245)).setBookmarkGroup(node2.getBookmarkGroup());
            $this$prepareGroup_u24lambda_u246_u24lambda_u245.setParent(node2.getParent());
            $i$f$forEach22.put(it4, iterator2);
        }
        $this$mapNotNull$iv = nodes2;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            AbstractTreeNode abstractTreeNode;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            it = element$iv$iv;
            boolean bl5 = false;
            if (!this.isNodeVisible(it)) {
                abstractTreeNode = null;
            } else if (it instanceof LineNode) {
                Object v = map2.get(((LineNode)it).getVirtualFile());
                Intrinsics.checkNotNull(v);
                abstractTreeNode = ((FileNode)v).grouped(it);
            } else {
                abstractTreeNode = it instanceof FileNode ? (AbstractTreeNode)((FileNode)it).grouped() : it;
            }
            if (abstractTreeNode == null) continue;
            it$iv$iv = abstractTreeNode;
            boolean bl6 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    @Override
    @Nullable
    public Bookmark createBookmark(@NotNull Map<String, String> map2) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        String string2 = map2.get("url");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            bookmark = this.createBookmark(it, StringUtil.parseInt(map2.get("line"), -1));
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    @Override
    @Nullable
    public Bookmark createBookmark(@Nullable Object context2) {
        Bookmark bookmark;
        Object object = context2;
        if (object instanceof com.intellij.ide.bookmarks.Bookmark) {
            VirtualFile virtualFile2 = ((com.intellij.ide.bookmarks.Bookmark)context2).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"context.file");
            bookmark = this.createBookmark(virtualFile2, ((com.intellij.ide.bookmarks.Bookmark)context2).getLine());
        } else if (object instanceof DirectoryUrl) {
            String string2 = ((DirectoryUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.url");
            bookmark = LineBookmarkProvider.createBookmark$default(this, string2, 0, 2, null);
        } else if (object instanceof PsiFileUrl) {
            String string3 = ((PsiFileUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.url");
            bookmark = LineBookmarkProvider.createBookmark$default(this, string3, 0, 2, null);
        } else if (object instanceof PsiElement) {
            bookmark = this.createBookmark((PsiElement)context2);
        } else if (object instanceof VirtualFile) {
            bookmark = this.createBookmark((VirtualFile)context2, -1);
        } else if (object instanceof ProjectFileNode) {
            VirtualFile virtualFile3 = ((ProjectFileNode)context2).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"context.virtualFile");
            bookmark = LineBookmarkProvider.createBookmark$default(this, virtualFile3, 0, 2, null);
        } else {
            bookmark = object instanceof TreePath ? (Bookmark)this.createBookmark((TreePath)context2) : null;
        }
        return bookmark;
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !file2.isValid() || file2 instanceof LightVirtualFile ? null : (line >= 0 ? (FileBookmark)new LineBookmarkImpl(this, file2, line) : (FileBookmark)new FileBookmarkImpl(this, file2));
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, VirtualFile virtualFile2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(virtualFile2, n);
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull Editor editor2, @Nullable Integer line) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        Integer n = line;
        return this.createBookmark(file2, n != null ? n : editor2.getCaretModel().getLogicalPosition().line);
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, Editor editor2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return lineBookmarkProvider.createBookmark(editor2, n);
    }

    private final Bookmark createBookmark(String url, int line) {
        FileBookmark fileBookmark = this.createValidBookmark(url, line);
        return fileBookmark != null ? (Bookmark)fileBookmark : (Bookmark)this.createInvalidBookmark(url, line);
    }

    static /* synthetic */ Bookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(string2, n);
    }

    private final FileBookmark createValidBookmark(String url, int line) {
        FileBookmark fileBookmark;
        VirtualFile virtualFile2 = this.getVFM().findFileByUrl(url);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            fileBookmark = this.createBookmark(it, line);
        } else {
            fileBookmark = null;
        }
        return fileBookmark;
    }

    static /* synthetic */ FileBookmark createValidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createValidBookmark(string2, n);
    }

    private final InvalidBookmark createInvalidBookmark(String url, int line) {
        return new InvalidBookmark(this, url, line);
    }

    static /* synthetic */ InvalidBookmark createInvalidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createInvalidBookmark(string2, n);
    }

    private final FileBookmark createBookmark(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            FileBookmark fileBookmark;
            VirtualFile virtualFile2 = ((PsiFileSystemItem)element).getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                fileBookmark = LineBookmarkProvider.createBookmark$default(this, it, 0, 2, null);
            } else {
                fileBookmark = null;
            }
            return fileBookmark;
        }
        if (element instanceof PsiCompiledElement) {
            return null;
        }
        VirtualFile virtualFile3 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile3;
        if (file2 instanceof LightVirtualFile) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int offset2 = element.getTextOffset();
        return (0 <= offset2 ? offset2 <= document2.getTextLength() : false) ? this.createBookmark(file2, document2.getLineNumber(offset2)) : null;
    }

    private final FileBookmark createBookmark(TreePath path2) {
        VirtualFile virtualFile2 = this.getAsVirtualFile(path2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        Serializable serializable = path2.getParentPath();
        if (serializable == null || (serializable = this.getAsVirtualFile((TreePath)serializable)) == null) {
            return null;
        }
        Serializable parent2 = serializable;
        return !((VirtualFile)parent2).isDirectory() || !Intrinsics.areEqual((Object)file2.getParent(), (Object)parent2) ? null : LineBookmarkProvider.createBookmark$default(this, file2, 0, 2, null);
    }

    private final VirtualFile getAsVirtualFile(TreePath $this$asVirtualFile) {
        ProjectViewNode projectViewNode = (ProjectViewNode)((Object)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)$this$asVirtualFile));
        return projectViewNode != null ? projectViewNode.getVirtualFile() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(EditorMouseEvent $this$isUnexpected) {
        if ($this$isUnexpected.isConsumed()) return true;
        if (!Intrinsics.areEqual((Object)$this$isUnexpected.getArea(), (Object)EditorMouseEventArea.LINE_MARKERS_AREA)) return true;
        MouseEvent mouseEvent = $this$isUnexpected.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"mouseEvent");
        if (!this.isUnexpected(mouseEvent)) return false;
        return true;
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isUnexpected(event)) {
            return;
        }
        Project project2 = event.getEditor().getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)this.project)) {
                return;
            }
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.project);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.editor");
        FileBookmark fileBookmark = this.createBookmark(editor2, (Integer)event.getLogicalPosition().line);
        if (fileBookmark == null) {
            return;
        }
        FileBookmark bookmark = fileBookmark;
        BookmarkType bookmarkType = manager.getType(bookmark);
        if (bookmarkType != null) {
            BookmarkType it = bookmarkType;
            boolean bl = false;
            manager.remove(bookmark);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            manager.add(bookmark, BookmarkType.DEFAULT);
        }
        event.consume();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void afterDocumentChange(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        v0 = FileDocumentManager.getInstance().getFile(document);
        if (v0 == null) {
            return;
        }
        file = v0;
        if (file instanceof LightVirtualFile) {
            return;
        }
        v1 = BookmarksManager.getInstance(this.project);
        if (v1 == null) {
            return;
        }
        manager = v1;
        map = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LineBookmarkImpl it = (LineBookmarkImpl)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getLine());
                it = (LineBookmarkImpl)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
            }
        }, (Pair[])new Pair[0]);
        set = new LinkedHashSet<E>();
        for (Bookmark bookmark : manager.getBookmarks()) {
            if (!(bookmark instanceof LineBookmarkImpl) || !Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file)) continue;
            v2 = manager instanceof BookmarksManagerImpl != false ? (BookmarksManagerImpl)manager : null;
            rangeMarker = v2 != null && (v2 = v2.findLineHighlighter$intellij_platform_lang_impl(bookmark)) != null ? (RangeMarker)v2 : ((LineBookmarkImpl)bookmark).getDescriptor().getRangeMarker();
            v3 = rangeMarker;
            if (v3 == null) ** GOTO lbl-1000
            it = v3;
            $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1 = false;
            v4 = it.isValid() ? Integer.valueOf(it.getDocument().getLineNumber(it.getStartOffset())) : null;
            v3 = v4;
            if (v4 != null) {
                v5 = v3.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = line = -1;
            }
            if (((LineBookmarkImpl)bookmark).getLine() == line) {
                set.add(line);
                continue;
            }
            $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1 = line;
            ((Map)map).put(bookmark, $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1);
        }
        if (map.isEmpty()) {
            return;
        }
        bookmarks = new LinkedHashMap<K, V>();
        $this$forEach$iv = map;
        $i$f$forEach = false;
        var9_11 = $this$forEach$iv.entrySet().iterator();
        while (var9_11.hasNext()) {
            var11_18 = element$iv = var9_11.next();
            $i$a$-forEach-LineBookmarkProvider$afterDocumentChange$1 = false;
            bookmark = (LineBookmarkImpl)var11_18.getKey();
            line = (Integer)var11_18.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            if (line < 0 || set.contains(line)) {
                v6 = null;
            } else {
                set.add(line);
                v6 = this.createBookmark(file, (int)line);
            }
            bookmarks.put(bookmark, v6);
        }
        manager.update(bookmarks);
    }

    @Override
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        boolean update2;
        block4: {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VFileEvent it = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (!(it instanceof VFileCreateEvent || it instanceof VFileDeleteEvent)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = update2 = false;
            }
        }
        if (update2) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.validateAlarm, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final void validateAndUpdate() {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.project);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Map bookmarks = new LinkedHashMap();
        List<Bookmark> list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.bookmarks");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark $this$validateAndUpdate_u24lambda_u2418_u24lambda_u2417;
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.validate(it) == null) continue;
            boolean bl2 = false;
            bookmarks.put(it, $this$validateAndUpdate_u24lambda_u2418_u24lambda_u2417);
        }
        manager.update(bookmarks);
    }

    private final Bookmark validate(Bookmark bookmark) {
        Bookmark bookmark2;
        Bookmark bookmark3 = bookmark;
        if (bookmark3 instanceof InvalidBookmark) {
            bookmark2 = this.createValidBookmark(((InvalidBookmark)bookmark).getUrl(), ((InvalidBookmark)bookmark).getLine());
        } else if (bookmark3 instanceof FileBookmarkImpl) {
            VirtualFile $this$validate_u24lambda_u2419 = ((FileBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$validate_u24lambda_u2419.isValid()) {
                bookmark2 = null;
            } else {
                String string2 = $this$validate_u24lambda_u2419.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
                bookmark2 = LineBookmarkProvider.createBookmark$default(this, string2, 0, 2, null);
            }
        } else if (bookmark3 instanceof LineBookmarkImpl) {
            VirtualFile $this$validate_u24lambda_u2420 = ((LineBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$validate_u24lambda_u2420.isValid()) {
                bookmark2 = null;
            } else {
                String string3 = $this$validate_u24lambda_u2420.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url");
                bookmark2 = this.createBookmark(string3, ((LineBookmarkImpl)bookmark).getLine());
            }
        } else {
            bookmark2 = null;
        }
        return bookmark2;
    }

    private final boolean isNodeVisible(AbstractTreeNode<?> node2) {
        boolean bl;
        Object object = node2.getValue();
        InvalidBookmark invalidBookmark = object instanceof InvalidBookmark ? (InvalidBookmark)object : null;
        if (invalidBookmark != null) {
            InvalidBookmark $this$isNodeVisible_u24lambda_u2421 = invalidBookmark;
            boolean bl2 = false;
            bl = $this$isNodeVisible_u24lambda_u2421.getLine() < 0;
        } else {
            bl = true;
        }
        return bl;
    }

    private final VirtualFileManager getVFM() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        return virtualFileManager;
    }

    @JvmStatic
    @Nullable
    public static final LineBookmarkProvider find(@NotNull Project project2) {
        return Companion.find(project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider$Companion;", "", "()V", "find", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "readLineText", "", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nLineBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LineBookmarkProvider find(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return project2.isDisposed() ? null : BookmarkProvider.EP.findExtension(LineBookmarkProvider.class, project2);
        }

        @Nullable
        public final String readLineText(@Nullable LineBookmark bookmark) {
            String string2;
            LineBookmark lineBookmark = bookmark;
            if (lineBookmark != null) {
                LineBookmark it = lineBookmark;
                boolean bl = false;
                string2 = Companion.readLineText(it.getFile(), it.getLine());
            } else {
                string2 = null;
            }
            return string2;
        }

        private final String readLineText(VirtualFile file2, int line) {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            if (line < 0 || document2.getLineCount() <= line) {
                return null;
            }
            int start = document2.getLineStartOffset(line);
            if (start < 0) {
                return null;
            }
            int end = document2.getLineEndOffset(line);
            if (end < start) {
                return null;
            }
            return document2.getText(TextRange.create(start, end));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

