/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.ModuleBookmarkProvider;
import com.intellij.ide.bookmark.providers.ModuleNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/ide/bookmark/providers/ModuleBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;", "name", "", "Lorg/jetbrains/annotations/Nls;", "isGroup", "", "(Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;Ljava/lang/String;Z)V", "attributes", "", "getAttributes", "()Ljava/util/Map;", "()Z", "getName", "()Ljava/lang/String;", "getProvider", "()Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;", "canNavigate", "canNavigateToSource", "createNode", "Lcom/intellij/ide/bookmark/providers/ModuleNode;", "equals", "other", "", "hashCode", "", "navigate", "", "requestFocus", "toString", "intellij.platform.lang.impl"})
public final class ModuleBookmark
implements Bookmark {
    @NotNull
    private final ModuleBookmarkProvider provider;
    @NotNull
    private final String name;
    private final boolean isGroup;

    public ModuleBookmark(@NotNull ModuleBookmarkProvider provider2, @NotNull String name, boolean isGroup) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.provider = provider2;
        this.name = name;
        this.isGroup = isGroup;
    }

    @Override
    @NotNull
    public ModuleBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isGroup() {
        return this.isGroup;
    }

    @Override
    @NotNull
    public Map<String, String> getAttributes() {
        return this.isGroup ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"group", (Object)this.name)) : MapsKt.mapOf((Pair)TuplesKt.to((Object)"module", (Object)this.name));
    }

    @NotNull
    public ModuleNode createNode() {
        return new ModuleNode(this.getProvider().getProject(), this);
    }

    @Override
    public boolean canNavigate() {
        return this.getProvider().getProjectSettingsService$intellij_platform_lang_impl() != null && this.getProvider().getModuleManager$intellij_platform_lang_impl() != null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        ProjectSettingsService projectSettingsService = this.getProvider().getProjectSettingsService$intellij_platform_lang_impl();
        if (projectSettingsService == null) {
            return;
        }
        ProjectSettingsService service2 = projectSettingsService;
        ModuleManager moduleManager = this.getProvider().getModuleManager$intellij_platform_lang_impl();
        Module module2 = moduleManager != null ? moduleManager.findModuleByName(this.name) : null;
        if (module2 != null && service2.canOpenModuleSettings()) {
            service2.openModuleSettings(module2);
        } else {
            service2.openProjectSettings();
        }
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.name, this.isGroup};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof ModuleBookmark && Intrinsics.areEqual((Object)((ModuleBookmark)other).getProvider(), (Object)this.getProvider()) && ((ModuleBookmark)other).isGroup == this.isGroup && Intrinsics.areEqual((Object)((ModuleBookmark)other).name, (Object)this.name);
    }

    @NotNull
    public String toString() {
        return this.isGroup ? "ModuleBookmark(group=" + this.name + ",provider=" + this.getProvider() + ")" : "ModuleBookmark(module=" + this.name + ",provider=" + this.getProvider() + ")";
    }
}

