/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.RootTypeBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0016J\u000f\u0010\u0011\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/bookmark/providers/RootTypeNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class RootTypeNode
extends BookmarkNode<RootTypeBookmark> {
    public RootTypeNode(@NotNull Project project2, @NotNull RootTypeBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project2, (Bookmark)bookmark);
    }

    @Override
    public boolean canRepresent(@Nullable Object element) {
        VirtualFile virtualFile2 = this.getVirtualFile();
        return virtualFile2 != null ? virtualFile2.equals(element) : false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = (RootTypeBookmark)this.getValue();
        return object != null && (object = ((RootTypeBookmark)object).getType()) != null ? ((RootType)object).containsFile(file2) : false;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        RootTypeBookmark rootTypeBookmark = (RootTypeBookmark)this.getValue();
        return rootTypeBookmark != null ? rootTypeBookmark.getFile() : null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return ExtensionsKt.computeDirectoryChildren(this);
    }

    @Override
    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        presentation2.setIcon(this.wrapIcon(AllIcons.Nodes.Folder));
        BookmarkNode bookmarkNode = this;
        Object object = (RootTypeBookmark)this.getValue();
        if (object == null || (object = ((RootTypeBookmark)object).getType()) == null || (object = ((RootType)object).getDisplayName()) == null) {
            object = "";
        }
        BookmarkNode.addTextTo$default(bookmarkNode, presentation2, (String)object, ScratchesNamedScope.scratchesAndConsoles(), 0, 8, null);
    }
}

