/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.execution.Location;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.ContextMenuActionGroup;
import com.intellij.ide.bookmark.ui.DragAndDropHandler;
import com.intellij.ide.bookmark.ui.ExtensionsKt;
import com.intellij.ide.bookmark.ui.GroupBookmarkVisitor;
import com.intellij.ide.bookmark.ui.IdeViewForBookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarksTreeStructure;
import com.intellij.ide.bookmark.ui.tree.FolderNodeComparator;
import com.intellij.ide.bookmark.ui.tree.FolderNodeUpdater;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.actionSystem.impl.PopupMenuPreloader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.preview.DescriptorPreview;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 n2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002noB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0012J\b\u0010G\u001a\u00020EH\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020KH\u0016J\u0012\u0010L\u001a\f0K\u00a2\u0006\u0002\bM\u00a2\u0006\u0002\bNH\u0016J\u0012\u0010O\u001a\f0K\u00a2\u0006\u0002\bM\u00a2\u0006\u0002\bNH\u0016J&\u0010P\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020K2\u0012\u0010Q\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0018\u000102H\u0003J\u0012\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020\u001fH\u0002J\n\u0010U\u001a\u0004\u0018\u00010SH\u0016J\n\u0010V\u001a\u0004\u0018\u00010SH\u0016J\b\u0010W\u001a\u00020\bH\u0016J\b\u0010X\u001a\u00020\bH\u0016J\b\u0010Y\u001a\u00020EH\u0014J\u0010\u0010Z\u001a\u00020E2\u0006\u0010[\u001a\u00020\bH\u0002J\b\u0010\\\u001a\u00020EH\u0014J!\u0010]\u001a\u0015\u0012\f\u0012\n `*\u0004\u0018\u00010_0_0^\u00a2\u0006\u0002\bN2\u0006\u0010a\u001a\u00020bJ)\u0010]\u001a\u0015\u0012\f\u0012\n `*\u0004\u0018\u00010_0_0^\u00a2\u0006\u0002\bN2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dJ\u000e\u0010]\u001a\u00020E2\u0006\u0010e\u001a\u00020fJ+\u0010]\u001a\u0015\u0012\f\u0012\n `*\u0004\u0018\u00010_0_0^\u00a2\u0006\u0002\bN2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020\bH\u0002J\u0012\u0010j\u001a\u00020E2\b\b\u0002\u0010k\u001a\u00020\bH\u0002J\u0010\u0010l\u001a\u00020E2\u0006\u0010m\u001a\u00020\bH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\r\u0012\u0002\b\u0003\u0018\u00010-\u00a2\u0006\u0002\b.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\"\u00101\u001a\u0013\u0012\r\u0012\u000b\u0012\u0002\b\u00030-\u00a2\u0006\u0002\b.\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\rR\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ui/OnePixelSplitter;", "project", "Lcom/intellij/openapi/project/Project;", "showToolbar", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)V", "autoScrollFromSource", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getAutoScrollFromSource", "()Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "autoScrollToSource", "getAutoScrollToSource", "editSourceListeners", "", "Lcom/intellij/ide/bookmark/ui/BookmarksView$EditSourceListener;", "groupLineBookmarks", "getGroupLineBookmarks", "ideView", "Lcom/intellij/ide/bookmark/ui/IdeViewForBookmarksView;", "isPopup", "()Z", "model", "Lcom/intellij/ui/tree/StructureTreeModel;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarksTreeStructure;", "getModel", "()Lcom/intellij/ui/tree/StructureTreeModel;", "nextOccurrence", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getNextOccurrence", "()Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "openInPreviewTab", "getOpenInPreviewTab", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "preview", "Lcom/intellij/ui/preview/DescriptorPreview;", "previousOccurrence", "getPreviousOccurrence", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectedNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lorg/jetbrains/annotations/Nullable;", "getSelectedNode", "()Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "selectedNodes", "", "getSelectedNodes", "()Ljava/util/List;", "selectionAlarm", "Lcom/intellij/util/SingleAlarm;", "showPreview", "getShowPreview", "state", "Lcom/intellij/ide/bookmark/ui/BookmarksViewState;", "structure", "tree", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "getTree", "()Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "updater", "Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "addEditSourceListener", "", "listener", "dispose", "getData", "", "dataId", "", "getNextOccurenceActionName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getPreviousOccurenceActionName", "getSlowData", "selection", "go", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "occurrence", "goNextOccurence", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "loadProportion", "navigateToSource", "requestFocus", "saveProportion", "select", "Lorg/jetbrains/concurrency/Promise;", "Ljavax/swing/tree/TreePath;", "kotlin.jvm.PlatformType", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitor", "Lcom/intellij/ui/tree/TreeVisitor;", "centered", "selectionChanged", "autoScroll", "setOrientation", "vertical", "Companion", "EditSourceListener", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarksView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksView.kt\ncom/intellij/ide/bookmark/ui/BookmarksView\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,303:1\n11653#2,9:304\n13579#2:313\n13580#2:315\n11662#2:316\n1#3:314\n1#3:317\n1#3:329\n1#3:332\n26#4:318\n1603#5,9:319\n1855#5:328\n1856#5:330\n1612#5:331\n1855#5,2:335\n37#6,2:333\n*S KotlinDebug\n*F\n+ 1 BookmarksView.kt\ncom/intellij/ide/bookmark/ui/BookmarksView\n*L\n75#1:304,9\n75#1:313\n75#1:315\n75#1:316\n75#1:314\n108#1:329\n96#1:318\n108#1:319,9\n108#1:328\n108#1:330\n108#1:331\n247#1:335,2\n108#1:333,2\n*E\n"})
public final class BookmarksView
extends OnePixelSplitter
implements Disposable,
DataProvider,
OccurenceNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean isPopup;
    @NotNull
    private final List<EditSourceListener> editSourceListeners;
    @NotNull
    private final BookmarksViewState state;
    @NotNull
    private final DescriptorPreview preview;
    @NotNull
    private final SingleAlarm selectionAlarm;
    @NotNull
    private final BookmarksTreeStructure structure;
    @NotNull
    private final StructureTreeModel<BookmarksTreeStructure> model;
    @NotNull
    private final DnDAwareTree tree;
    @NotNull
    private final DefaultTreeExpander treeExpander;
    @NotNull
    private final BorderLayoutPanel panel;
    @NotNull
    private final FolderNodeUpdater updater;
    @NotNull
    private final IdeViewForBookmarksView ideView;
    @NotNull
    private final ToggleOptionAction.Option groupLineBookmarks;
    @NotNull
    private final ToggleOptionAction.Option autoScrollFromSource;
    @NotNull
    private final ToggleOptionAction.Option autoScrollToSource;
    @NotNull
    private final ToggleOptionAction.Option openInPreviewTab;
    @NotNull
    private final ToggleOptionAction.Option showPreview;
    @NotNull
    private static final DataKey<BookmarksView> BOOKMARKS_VIEW;

    public BookmarksView(@NotNull Project project2, @Nullable Boolean showToolbar) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(false, 0.3f, 0.1f, 0.9f);
        this.project = project2;
        this.isPopup = showToolbar == null;
        this.editSourceListeners = new ArrayList();
        this.state = BookmarksViewState.Companion.getInstance(this.project);
        this.preview = new DescriptorPreview((Splitter)((Object)this), false, null);
        this.selectionAlarm = new SingleAlarm(() -> BookmarksView.selectionChanged$default(this, false, 1, null), 50, (Disposable)this, Alarm.ThreadToUse.SWING_THREAD, ModalityState.stateForComponent((Component)((Object)this)));
        this.structure = new BookmarksTreeStructure(this);
        this.model = new StructureTreeModel((AbstractTreeStructure)this.structure, (Comparator)new FolderNodeComparator(this.project), (Disposable)this);
        this.tree = new DnDAwareTree((TreeModel)new AsyncTreeModel((TreeModel)this.model, (Disposable)this));
        this.treeExpander = new DefaultTreeExpander((JTree)this.tree);
        this.panel = new BorderLayoutPanel();
        this.updater = new FolderNodeUpdater(this);
        this.ideView = new IdeViewForBookmarksView(this);
        this.groupLineBookmarks = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return !this.this$0.isPopup();
            }

            public boolean isSelected() {
                return this.isEnabled() && BookmarksView.access$getState$p(this.this$0).getGroupLineBookmarks();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setGroupLineBookmarks(selected);
                this.this$0.getModel().invalidateAsync();
            }
        };
        this.autoScrollFromSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return false;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollFromSource();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollFromSource(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.autoScrollToSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return this.this$0.getOpenInPreviewTab().isEnabled();
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollToSource();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollToSource(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.openInPreviewTab = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return this.this$0.isVertical() || !BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public boolean isSelected() {
                return UISettings.Companion.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected) {
                UISettings.Companion.getInstance().setOpenInPreviewTabIfPossible(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.showPreview = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isAlwaysVisible() {
                return !this.this$0.isVertical();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isEnabled() {
                if (this.this$0.isVertical()) return false;
                AbstractTreeNode<?> abstractTreeNode = this.this$0.getSelectedNode();
                if (abstractTreeNode == null) return false;
                boolean bl = abstractTreeNode.canNavigateToSource();
                if (!bl) return false;
                return true;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setShowPreview(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.panel.addToCenter(ScrollPaneFactory.createScrollPane((Component)((Component)this.tree), (boolean)true));
        this.panel.putClientProperty(FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, true);
        this.setFirstComponent(this.panel);
        this.tree.setHorizontalAutoScrollingEnabled(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (!this.isPopup) {
            DragAndDropHandler handler2 = new DragAndDropHandler(this);
            DnDSupport.createBuilder((JComponent)((JComponent)this.tree)).setDisposableParent((Disposable)this).setBeanProvider(arg_0 -> BookmarksView._init_$lambda$12((Function1)new Function1<DnDActionInfo, DnDDragStartBean>((Object)handler2){

                @Nullable
                public final DnDDragStartBean invoke(@NotNull DnDActionInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DragAndDropHandler)this.receiver).createBean(p0);
                }
            }, arg_0)).setDropHandlerWithResult((DnDDropHandler.WithResult)handler2).setTargetChecker((DnDTargetChecker)handler2).enableAsNativeTarget().install();
        }
        StatusText statusText = this.tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"tree.emptyText");
        ExtensionsKt.initialize(statusText, (Component)this.tree);
        this.tree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.tree.addTreeSelectionListener(arg_0 -> BookmarksView._init_$lambda$13(this, arg_0));
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(@Nullable FocusEvent event) {
            }

            @Override
            public void focusGained(@Nullable FocusEvent event) {
                SingleAlarm.cancelAndRequest$default((SingleAlarm)selectionAlarm, (boolean)false, (int)1, null);
            }
        });
        new TreeSpeedSearch((JTree)this.tree);
        TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.tree));
        com.intellij.ide.bookmark.actions.ExtensionsKt.registerNavigateOnEnterAction((JTree)this.tree, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Iterable $this$forEach$iv = editSourceListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditSourceListener it = (EditSourceListener)element$iv;
                    boolean bl = false;
                    it.onEditSource();
                }
            }
        }));
        EditSourceOnDoubleClickHandler.install((JTree)((JTree)this.tree), () -> BookmarksView._init_$lambda$15(this));
        ContextMenuActionGroup group2 = new ContextMenuActionGroup((JTree)this.tree);
        PopupHandler popupHandler = PopupHandler.installPopupMenu((JComponent)((JComponent)this.tree), (ActionGroup)group2, (String)"BookmarksPopup");
        Intrinsics.checkNotNullExpressionValue((Object)popupHandler, (String)"installPopupMenu(tree, g\u2026ces.BOOKMARKS_VIEW_POPUP)");
        PopupHandler handler3 = popupHandler;
        PopupMenuPreloader.install((JComponent)((JComponent)this.tree), (String)"BookmarksPopup", (PopupHandler)handler3, () -> BookmarksView._init_$lambda$16(group2));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
        Topic<BookmarksListener> topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, new BookmarksListener(){

            @Override
            public void groupsSorted() {
                this.getModel().invalidateAsync();
            }

            @Override
            public void groupAdded(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidateAsync();
            }

            @Override
            public void groupRemoved(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidateAsync();
            }

            @Override
            public void groupRenamed(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidateAsync();
            }

            @Override
            public void bookmarksSorted(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidateAsync();
            }

            @Override
            public void bookmarkAdded(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidateAsync();
            }

            @Override
            public void bookmarkRemoved(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidateAsync();
            }

            @Override
            public void bookmarkChanged(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidateAsync();
            }

            @Override
            public void bookmarkTypeChanged(@NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidateAsync();
            }

            @Override
            public void defaultGroupChanged(@Nullable BookmarkGroup oldGroup, @Nullable BookmarkGroup newGroup) {
                this.getModel().invalidateAsync();
            }

            @Override
            public void structureChanged(@Nullable Object node2) {
                if (node2 == null) {
                    this.getModel().invalidateAsync();
                } else {
                    this.getModel().invalidateAsync(node2, true);
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isPopup() {
        return this.isPopup;
    }

    @NotNull
    public final StructureTreeModel<BookmarksTreeStructure> getModel() {
        return this.model;
    }

    @NotNull
    public final DnDAwareTree getTree() {
        return this.tree;
    }

    @Nullable
    public final AbstractTreeNode<?> getSelectedNode() {
        return TreeUtil.getAbstractTreeNode((TreePath)TreeUtil.getSelectedPathIfOne((JTree)((JTree)this.tree)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<AbstractTreeNode<?>> getSelectedNodes() {
        List list2;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            TreePath[] $this$mapNotNull$iv = treePathArray;
            boolean $i$f$mapNotNull = false;
            TreePath[] treePathArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                AbstractTreeNode it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (TreeUtil.getAbstractTreeNode((TreePath)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection2;
            }
            list2 = (List)collection;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final BookmarkOccurrence getPreviousOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.lastLineBookmark(this.project) : occurrence.previousLineBookmark();
    }

    private final BookmarkOccurrence getNextOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.firstLineBookmark(this.project) : occurrence.nextLineBookmark();
    }

    @Override
    public void dispose() {
        this.preview.close();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (BOOKMARKS_VIEW.is(dataId)) {
            object = this;
        } else if (LangDataKeys.IDE_VIEW.is(dataId)) {
            object = this.ideView;
        } else if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            object = this.treeExpander;
        } else if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            List<AbstractTreeNode<?>> list2 = this.getSelectedNodes();
            if (list2 != null) {
                boolean $i$f$emptyArray = false;
                object = UtilKt.toArray((Collection)list2, new Object[0]);
            } else {
                object = null;
            }
        } else if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            List<AbstractTreeNode<?>> list3 = this.getSelectedNodes();
            object = list3 != null ? (AbstractTreeNode)CollectionsKt.firstOrNull(list3) : null;
        } else if (PlatformDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            List<AbstractTreeNode<?>> selectedNodes = this.getSelectedNodes();
            object = arg_0 -> BookmarksView.getData$lambda$2(this, selectedNodes, arg_0);
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresBackgroundThread
    private final Object getSlowData(String dataId, List<? extends AbstractTreeNode<?>> selection) {
        VirtualFile[] virtualFileArray;
        if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            AbstractTreeNode abstractTreeNode2 = selection;
            abstractTreeNode2 = abstractTreeNode2;
            if (abstractTreeNode == null) return null;
            AbstractTreeNode abstractTreeNode2 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)abstractTreeNode2);
            abstractTreeNode2 = abstractTreeNode2;
            if (abstractTreeNode3 == null) return null;
            virtualFileArray = ExtensionsKt.getAsVirtualFile(abstractTreeNode2);
            return virtualFileArray;
        } else if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            AbstractTreeNode abstractTreeNode = selection;
            Object object = abstractTreeNode;
            if (abstractTreeNode == null) return null;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
                boolean bl2 = false;
                if (ExtensionsKt.getAsVirtualFile(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection $i$f$mapNotNull22 = (List)destination$iv$iv;
            if ($i$f$mapNotNull22.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = $i$f$mapNotNull22;
            }
            List list2 = (List)collection;
            object = list2;
            if (list2 == null) return null;
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
            return virtualFileArray;
        } else if (PlatformCoreDataKeys.MODULE.is(dataId)) {
            AbstractTreeNode abstractTreeNode4 = selection;
            abstractTreeNode4 = abstractTreeNode4;
            if (abstractTreeNode == null) return null;
            AbstractTreeNode abstractTreeNode4 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)abstractTreeNode4);
            abstractTreeNode4 = abstractTreeNode4;
            if (abstractTreeNode5 == null) return null;
            virtualFileArray = ExtensionsKt.getModule(abstractTreeNode4);
            return virtualFileArray;
        } else {
            if (!Location.DATA_KEY.is(dataId)) return null;
            AbstractTreeNode abstractTreeNode6 = selection;
            abstractTreeNode6 = abstractTreeNode6;
            if (abstractTreeNode == null) return null;
            AbstractTreeNode abstractTreeNode6 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)abstractTreeNode6);
            abstractTreeNode6 = abstractTreeNode6;
            if (abstractTreeNode7 == null) return null;
            virtualFileArray = ExtensionsKt.getLocation(abstractTreeNode6);
        }
        return virtualFileArray;
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string2 = BookmarkBundle.message("bookmark.go.to.next.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.go.to.\u2026t.occurence.action.text\")");
        return string2;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string2 = BookmarkBundle.message("bookmark.go.to.previous.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.go.to.\u2026s.occurence.action.text\")");
        return string2;
    }

    public boolean hasNextOccurence() {
        return this.getNextOccurrence() != null;
    }

    public boolean hasPreviousOccurence() {
        return this.getPreviousOccurrence() != null;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getNextOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence it = bookmarkOccurrence;
            boolean bl = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getPreviousOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence it = bookmarkOccurrence;
            boolean bl = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    private final OccurenceNavigator.OccurenceInfo go(BookmarkOccurrence occurrence) {
        this.select(occurrence.getGroup(), occurrence.getBookmark()).onSuccess(arg_0 -> BookmarksView.go$lambda$7((Function1)new Function1<TreePath, Unit>(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(TreePath it) {
                BookmarksView.access$navigateToSource(this.this$0, true);
            }
        }, arg_0));
        return null;
    }

    public final void select(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updater.updateImmediately(() -> BookmarksView.select$lambda$8(this, file2));
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return this.select(new GroupBookmarkVisitor(group2, null, 2, null), true);
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return this.select(new GroupBookmarkVisitor(group2, bookmark), false);
    }

    private final Promise<TreePath> select(TreeVisitor visitor2, boolean centered) {
        Promise<Object> promise = TreeUtil.promiseMakeVisible((JTree)((JTree)this.tree), (TreeVisitor)visitor2).onSuccess(arg_0 -> BookmarksView.select$lambda$9((Function1)new Function1<TreePath, Unit>(this, centered){
            final /* synthetic */ BookmarksView this$0;
            final /* synthetic */ boolean $centered;
            {
                this.this$0 = $receiver;
                this.$centered = $centered;
                super(1);
            }

            public final void invoke(TreePath it) {
                this.this$0.getTree().setSelectionPath(it);
                TreeUtil.scrollToVisible((JTree)((JTree)this.this$0.getTree()), (TreePath)it, (boolean)this.$centered);
                if (!this.this$0.getTree().hasFocus()) {
                    BookmarksView.selectionChanged$default(this.this$0, false, 1, null);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(promise, (String)"private fun select(visit\u2026)) selectionChanged()\n  }");
        return promise;
    }

    protected void saveProportion() {
        if (this.isPopup) {
            BookmarksViewState bookmarksViewState = this.state;
            if (bookmarksViewState != null) {
                bookmarksViewState.setProportionPopup(this.getProportion());
            }
        } else {
            BookmarksViewState bookmarksViewState = this.state;
            if (bookmarksViewState != null) {
                bookmarksViewState.setProportionView(this.getProportion());
            }
        }
    }

    protected void loadProportion() {
        if (this.isPopup) {
            this.setProportion(this.state.getProportionPopup());
        } else {
            this.setProportion(this.state.getProportionView());
        }
    }

    public void setOrientation(boolean vertical) {
        super.setOrientation(vertical);
        this.selectionChanged(false);
    }

    @NotNull
    public final ToggleOptionAction.Option getGroupLineBookmarks() {
        return this.groupLineBookmarks;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollFromSource() {
        return this.autoScrollFromSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollToSource() {
        return this.autoScrollToSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getOpenInPreviewTab() {
        return this.openInPreviewTab;
    }

    @NotNull
    public final ToggleOptionAction.Option getShowPreview() {
        return this.showPreview;
    }

    private final void selectionChanged(boolean autoScroll) {
        if (this.isPopup || !this.openInPreviewTab.isEnabled()) {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            this.preview.open(abstractTreeNode != null ? ExtensionsKt.getAsDescriptor(abstractTreeNode) : null);
        } else {
            this.preview.close();
            if (autoScroll && (this.autoScrollToSource.isSelected() || this.openInPreviewTab.isSelected())) {
                this.navigateToSource(false);
            }
        }
    }

    static /* synthetic */ void selectionChanged$default(BookmarksView bookmarksView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bookmarksView.tree.hasFocus();
        }
        bookmarksView.selectionChanged(bl);
    }

    private final void navigateToSource(boolean requestFocus) {
        block1: {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            if (abstractTreeNode == null) {
                return;
            }
            AbstractTreeNode<?> node2 = abstractTreeNode;
            Runnable task2 = () -> BookmarksView.navigateToSource$lambda$10(requestFocus, node2);
            Application application = ApplicationManager.getApplication();
            if (application == null) break block1;
            application.invokeLater(task2, ModalityState.stateForComponent((Component)this.tree), arg_0 -> BookmarksView.navigateToSource$lambda$11(this, arg_0));
        }
    }

    public final void addEditSourceListener(@NotNull EditSourceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.editSourceListeners.add(listener2);
    }

    private static final Object getData$lambda$2(BookmarksView this$0, List $selectedNodes, String slowDataId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)slowDataId, (String)"slowDataId");
        return this$0.getSlowData(slowDataId, $selectedNodes);
    }

    private static final void go$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void select$lambda$8(BookmarksView this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        this$0.select(new VirtualFileVisitor($file, null), true);
    }

    private static final void select$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void navigateToSource$lambda$10(boolean $requestFocus, AbstractTreeNode $node) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        OpenSourceUtil.navigateToSource((boolean)$requestFocus, (boolean)false, (Navigatable)((Navigatable)$node));
    }

    private static final boolean navigateToSource$lambda$11(BookmarksView this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.isDisposed();
    }

    private static final DnDDragStartBean _init_$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DnDDragStartBean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$13(BookmarksView this$0, TreeSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.tree.hasFocus()) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this$0.selectionAlarm, (boolean)false, (int)1, null);
        }
    }

    private static final void _init_$lambda$15(BookmarksView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.editSourceListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditSourceListener it = (EditSourceListener)element$iv;
            boolean bl = false;
            it.onEditSource();
        }
    }

    private static final ActionGroup _init_$lambda$16(ContextMenuActionGroup $group) {
        Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
        return $group;
    }

    public static final /* synthetic */ void access$navigateToSource(BookmarksView $this, boolean requestFocus) {
        $this.navigateToSource(requestFocus);
    }

    public static final /* synthetic */ BookmarksViewState access$getState$p(BookmarksView $this) {
        return $this.state;
    }

    static {
        DataKey dataKey = DataKey.create((String)"BOOKMARKS_VIEW");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(\"BOOKMARKS_VIEW\")");
        BOOKMARKS_VIEW = dataKey;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView$EditSourceListener;", "", "onEditSource", "", "intellij.platform.lang.impl"})
    public static interface EditSourceListener {
        public void onEditSource();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView$Companion;", "", "()V", "BOOKMARKS_VIEW", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBOOKMARKS_VIEW", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<BookmarksView> getBOOKMARKS_VIEW() {
            return BOOKMARKS_VIEW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

