/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.ExtensionsKt;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "Lcom/intellij/ide/dnd/DnDTargetChecker;", "Lcom/intellij/ide/dnd/DnDDropHandler$WithResult;", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "(Lcom/intellij/ide/bookmark/ui/BookmarksView;)V", "getView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "createBean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "info", "Lcom/intellij/ide/dnd/DnDActionInfo;", "setHighlighting", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "bounds", "Ljava/awt/Rectangle;", "setLineHighlighting", "above", "tryDrop", "updateOnly", "update", "AttachedBookmarkGroups", "AttachedBookmarks", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDragAndDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragAndDropHandler.kt\ncom/intellij/ide/bookmark/ui/DragAndDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1603#2,9:133\n1855#2:142\n1856#2:144\n1612#2:145\n1774#2,4:146\n1855#2,2:150\n1855#2,2:152\n766#2:154\n857#2,2:155\n1603#2,9:157\n1855#2:166\n1856#2:168\n1612#2:169\n1#3:143\n1#3:167\n*S KotlinDebug\n*F\n+ 1 DragAndDropHandler.kt\ncom/intellij/ide/bookmark/ui/DragAndDropHandler\n*L\n22#1:133,9\n22#1:142\n22#1:144\n22#1:145\n26#1:146,4\n29#1:150,2\n31#1:152,2\n33#1:154\n33#1:155,2\n40#1:157,9\n40#1:166\n40#1:168\n40#1:169\n22#1:143\n40#1:167\n*E\n"})
public final class DragAndDropHandler
implements DnDNativeTarget,
DnDTargetChecker,
DnDDropHandler.WithResult {
    @NotNull
    private final BookmarksView view;

    public DragAndDropHandler(@NotNull BookmarksView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    @NotNull
    public final BookmarksView getView() {
        return this.view;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DnDDragStartBean createBean(@NotNull DnDActionInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        List<AbstractTreeNode<?>> list2 = this.view.getSelectedNodes();
        if (list2 == null) {
            return null;
        }
        List<AbstractTreeNode<?>> nodes2 = list2;
        if (info2.isMove()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = nodes2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BookmarkOccurrence it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (ExtensionsKt.getBookmarkOccurrence(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List bookmarks = (List)destination$iv$iv;
            if (!((Collection)bookmarks).isEmpty()) {
                if (bookmarks.size() != nodes2.size()) {
                    return null;
                }
                if (this.view.getGroupLineBookmarks().isSelected()) {
                    int count2;
                    Iterable $this$count$iv = bookmarks;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        v1 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                            boolean bl = false;
                            if (!(it.getBookmark() instanceof LineBookmarkImpl) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v1 = count2 = count$iv;
                    }
                    if (count2 > 0) {
                        Set set2 = new LinkedHashSet();
                        Iterable $this$forEach$iv = bookmarks;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                            boolean bl = false;
                            if (!(it.getBookmark() instanceof LineBookmarkImpl)) continue;
                            set2.add(((LineBookmarkImpl)it.getBookmark()).getFile());
                        }
                        if (count2 < bookmarks.size()) {
                            void $this$filterTo$iv$iv;
                            $this$forEach$iv = bookmarks;
                            $i$f$forEach2 = false;
                            for (Object element$iv : $this$forEach$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                boolean bl = false;
                                if (!(it.getBookmark() instanceof FileBookmarkImpl)) continue;
                                set2.remove(((FileBookmarkImpl)it.getBookmark()).getFile());
                            }
                            if (set2.size() != 0) {
                                return null;
                            }
                            Iterable $this$filter$iv = bookmarks;
                            boolean $i$f$filter = false;
                            Iterable $i$f$mapNotNullTo2 = $this$filter$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv$iv;
                                boolean bl = false;
                                if (!(!(it.getBookmark() instanceof LineBookmarkImpl))) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            List list3 = (List)destination$iv$iv2;
                            AttachedBookmarks attachedBookmarks = new AttachedBookmarks(list3);
                            return new DnDDragStartBean((Object)attachedBookmarks);
                        }
                        if (set2.size() != 1) {
                            return null;
                        }
                    }
                }
                return new DnDDragStartBean((Object)new AttachedBookmarks(bookmarks));
            }
            Iterable $this$mapNotNull$iv2 = nodes2;
            boolean $i$f$mapNotNull2 = false;
            Iterable $i$f$filter = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                BookmarkGroup it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
                boolean bl4 = false;
                Object object = it.getValue();
                if ((object instanceof BookmarkGroup ? (BookmarkGroup)object : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List groups2 = (List)destination$iv$iv3;
            if (!((Collection)groups2).isEmpty()) {
                if (groups2.size() != nodes2.size()) {
                    return null;
                }
                return new DnDDragStartBean((Object)new AttachedBookmarkGroups(groups2));
            }
        }
        return null;
    }

    public boolean update(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean possible = this.tryDrop(event, true);
        if (!possible) {
            event.hideHighlighter();
        }
        event.setDropPossible(possible);
        return true;
    }

    public boolean tryDrop(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.tryDrop(event, false);
    }

    private final boolean tryDrop(DnDEvent event, boolean updateOnly) {
        BookmarkGroup group2;
        Point point = event.getPoint();
        if (point == null) {
            return false;
        }
        Point point2 = point;
        if (!Intrinsics.areEqual((Object)event.getHandlerComponent(), (Object)this.view.getTree()) || !this.view.getTree().isShowing()) {
            return false;
        }
        TreePath treePath = this.view.getTree().getClosestPathForLocation(point2.x, point2.y);
        if (treePath == null) {
            return false;
        }
        TreePath path2 = treePath;
        AbstractTreeNode abstractTreeNode = TreeUtil.getAbstractTreeNode((TreePath)path2);
        if (abstractTreeNode == null) {
            return false;
        }
        AbstractTreeNode node2 = abstractTreeNode;
        Rectangle rectangle = this.view.getTree().getPathBounds(path2);
        if (rectangle == null) {
            return false;
        }
        Rectangle bounds = rectangle;
        boolean strict = bounds.y <= point2.y && (double)point2.y < bounds.getMaxY();
        boolean above = (double)point2.y < bounds.getCenterY();
        Object attached = event.getAttachedObject();
        if (attached instanceof AttachedBookmarks) {
            BookmarkGroup group3;
            Object object = BookmarksManager.getInstance(this.view.getProject());
            BookmarksManagerImpl bookmarksManagerImpl = object instanceof BookmarksManagerImpl ? (BookmarksManagerImpl)object : null;
            if (bookmarksManagerImpl == null) {
                return false;
            }
            BookmarksManagerImpl manager = bookmarksManagerImpl;
            object = node2.getValue();
            BookmarkGroup bookmarkGroup = group3 = object instanceof BookmarkGroup ? (BookmarkGroup)object : null;
            if (group3 != null && strict) {
                return !updateOnly ? manager.dragInto(group3, ((AttachedBookmarks)attached).getOccurrences()) : (!manager.canDragInto(group3, ((AttachedBookmarks)attached).getOccurrences()) ? false : this.setHighlighting(event, bounds));
            }
            BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence(node2);
            if (bookmarkOccurrence == null) {
                return false;
            }
            BookmarkOccurrence occurrence = bookmarkOccurrence;
            return !updateOnly ? manager.drag(above, occurrence, ((AttachedBookmarks)attached).getOccurrences()) : (!manager.canDrag(above, occurrence, ((AttachedBookmarks)attached).getOccurrences()) ? false : this.setLineHighlighting(event, bounds, above));
        }
        if (attached instanceof AttachedBookmarkGroups) {
            BookmarksManager occurrence = BookmarksManager.getInstance(this.view.getProject());
            BookmarksManagerImpl bookmarksManagerImpl = occurrence instanceof BookmarksManagerImpl ? (BookmarksManagerImpl)occurrence : null;
            if (bookmarksManagerImpl == null) {
                return false;
            }
            BookmarksManagerImpl manager = bookmarksManagerImpl;
            Object object = node2.getValue();
            BookmarkGroup bookmarkGroup = object instanceof BookmarkGroup ? (BookmarkGroup)object : null;
            if (bookmarkGroup == null) {
                return false;
            }
            BookmarkGroup group4 = bookmarkGroup;
            return !updateOnly ? manager.drag(above, group4, ((AttachedBookmarkGroups)attached).getGroups()) : (!manager.canDrag(above, group4, ((AttachedBookmarkGroups)attached).getGroups()) ? false : this.setLineHighlighting(event, bounds, above));
        }
        List list2 = FileCopyPasteUtil.getFileListFromAttachedObject((Object)attached);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFileListFromAttachedObject(attached)");
        List files2 = list2;
        if (files2.isEmpty()) {
            if (!SystemInfo.isMac || !(attached instanceof DnDNativeTarget.EventInfo)) {
                return false;
            }
            if (!FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event)) {
                return false;
            }
            this.setHighlighting(event, bounds);
            return true;
        }
        Object object = BookmarksManager.getInstance(this.view.getProject());
        BookmarksManagerImpl bookmarksManagerImpl = object instanceof BookmarksManagerImpl ? (BookmarksManagerImpl)object : null;
        if (bookmarksManagerImpl == null) {
            return false;
        }
        BookmarksManagerImpl manager = bookmarksManagerImpl;
        object = node2.getValue();
        BookmarkGroup bookmarkGroup = group2 = object instanceof BookmarkGroup ? (BookmarkGroup)object : null;
        if (group2 != null && strict) {
            return !updateOnly ? manager.dragAddInto(group2, files2) : (!manager.canDragAddInto(group2, files2) ? false : this.setHighlighting(event, bounds));
        }
        AbstractTreeNode abstractTreeNode2 = node2.getParent();
        if (!((abstractTreeNode2 != null ? abstractTreeNode2.getValue() : null) instanceof BookmarkGroup)) {
            return false;
        }
        BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence(node2);
        if (bookmarkOccurrence == null) {
            return false;
        }
        BookmarkOccurrence occurrence = bookmarkOccurrence;
        return !updateOnly ? manager.dragAdd(above, occurrence, files2) : (!manager.canDragAddInto(occurrence.getGroup(), files2) ? false : this.setLineHighlighting(event, bounds, above));
    }

    private final boolean setHighlighting(DnDEvent event, Rectangle bounds) {
        event.setHighlighting(new RelativeRectangle((Component)this.view.getTree(), bounds), 1);
        return true;
    }

    private final boolean setLineHighlighting(DnDEvent event, Rectangle bounds, boolean above) {
        if (!above) {
            bounds.y += bounds.height;
        }
        --bounds.y;
        bounds.height = 2;
        event.setHighlighting(new RelativeRectangle((Component)this.view.getTree(), bounds), 2);
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler$AttachedBookmarks;", "", "occurrences", "", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "(Ljava/util/List;)V", "getOccurrences", "()Ljava/util/List;", "intellij.platform.lang.impl"})
    private static final class AttachedBookmarks {
        @NotNull
        private final List<BookmarkOccurrence> occurrences;

        public AttachedBookmarks(@NotNull List<BookmarkOccurrence> occurrences) {
            Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
            this.occurrences = occurrences;
        }

        @NotNull
        public final List<BookmarkOccurrence> getOccurrences() {
            return this.occurrences;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler$AttachedBookmarkGroups;", "", "groups", "", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "(Ljava/util/List;)V", "getGroups", "()Ljava/util/List;", "intellij.platform.lang.impl"})
    private static final class AttachedBookmarkGroups {
        @NotNull
        private final List<BookmarkGroup> groups;

        public AttachedBookmarkGroups(@NotNull List<? extends BookmarkGroup> groups2) {
            Intrinsics.checkNotNullParameter(groups2, (String)"groups");
            this.groups = groups2;
        }

        @NotNull
        public final List<BookmarkGroup> getGroups() {
            return this.groups;
        }
    }
}

