/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListProviderService;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FolderNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\"#\u0010\u0000\u001a\r\u0012\u0002\b\u0003\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"#\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0002*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001f\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0002*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\"\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"asAbstractTreeNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lorg/jetbrains/annotations/Nullable;", "Ljavax/swing/tree/TreePath;", "getAsAbstractTreeNode", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "asDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getAsDescriptor", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAsVirtualFile", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/openapi/vfs/VirtualFile;", "bookmarkOccurrence", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getBookmarkOccurrence", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "findFolderNode", "Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "getFindFolderNode", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "location", "Lcom/intellij/execution/Location;", "getLocation", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/execution/Location;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/openapi/module/Module;", "initialize", "", "Lcom/intellij/util/ui/StatusText;", "owner", "Ljava/awt/Component;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final AbstractTreeNode<?> getAsAbstractTreeNode(@NotNull TreePath $this$asAbstractTreeNode) {
        Intrinsics.checkNotNullParameter((Object)$this$asAbstractTreeNode, (String)"<this>");
        return TreeUtil.getAbstractTreeNode((TreePath)$this$asAbstractTreeNode);
    }

    @Nullable
    public static final FolderNode getFindFolderNode(@NotNull TreePath $this$findFolderNode) {
        Intrinsics.checkNotNullParameter((Object)$this$findFolderNode, (String)"<this>");
        return (FolderNode)TreeUtil.findObjectInPath((TreePath)$this$findFolderNode, FolderNode.class);
    }

    @Nullable
    public static final BookmarkOccurrence getBookmarkOccurrence(@NotNull AbstractTreeNode<?> $this$bookmarkOccurrence) {
        BookmarkOccurrence bookmarkOccurrence;
        Intrinsics.checkNotNullParameter($this$bookmarkOccurrence, (String)"<this>");
        BookmarkNode bookmarkNode = $this$bookmarkOccurrence instanceof BookmarkNode ? (BookmarkNode)$this$bookmarkOccurrence : null;
        if (bookmarkNode != null) {
            BookmarkNode $this$_get_bookmarkOccurrence__u24lambda_u241 = bookmarkNode;
            boolean bl = false;
            BookmarkGroup bookmarkGroup = $this$_get_bookmarkOccurrence__u24lambda_u241.getBookmarkGroup();
            if (bookmarkGroup != null) {
                BookmarkGroup it = bookmarkGroup;
                boolean bl2 = false;
                Object object = $this$_get_bookmarkOccurrence__u24lambda_u241.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
                bookmarkOccurrence = new BookmarkOccurrence(it, (Bookmark)object);
            } else {
                bookmarkOccurrence = null;
            }
        } else {
            bookmarkOccurrence = null;
        }
        return bookmarkOccurrence;
    }

    @Nullable
    public static final OpenFileDescriptor getAsDescriptor(@NotNull AbstractTreeNode<?> $this$asDescriptor) {
        Object descriptor2;
        Object object;
        Object object2;
        Project project2;
        block6: {
            Intrinsics.checkNotNullParameter($this$asDescriptor, (String)"<this>");
            Project project3 = $this$asDescriptor.getProject();
            if (project3 == null) {
                return null;
            }
            project2 = project3;
            if (!$this$asDescriptor.canNavigateToSource()) {
                return null;
            }
            for (Object it : (Iterable)BookmarksListProviderService.Companion.getProviders(project2)) {
                boolean bl = false;
                if ((it = it.getDescriptor($this$asDescriptor)) == null) continue;
                object2 = it;
                break block6;
            }
            object2 = null;
        }
        if ((object = (descriptor2 = object2)) == null) {
            VirtualFile virtualFile2 = ExtensionsKt.getAsVirtualFile($this$asDescriptor);
            if (virtualFile2 != null) {
                Object it;
                it = virtualFile2;
                boolean bl = false;
                object = new OpenFileDescriptor(project2, (VirtualFile)it);
            } else {
                object = null;
            }
        }
        return object;
    }

    @Nullable
    public static final VirtualFile getAsVirtualFile(@NotNull AbstractTreeNode<?> $this$asVirtualFile) {
        Intrinsics.checkNotNullParameter($this$asVirtualFile, (String)"<this>");
        ProjectViewNode projectViewNode = $this$asVirtualFile instanceof ProjectViewNode ? (ProjectViewNode)$this$asVirtualFile : null;
        return projectViewNode != null ? projectViewNode.getVirtualFile() : null;
    }

    @Nullable
    public static final Module getModule(@NotNull AbstractTreeNode<?> $this$module) {
        Module module2;
        Intrinsics.checkNotNullParameter($this$module, (String)"<this>");
        VirtualFile virtualFile2 = ExtensionsKt.getAsVirtualFile($this$module);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            module2 = ModuleUtilCore.findModuleForFile(it, $this$module.getProject());
        } else {
            module2 = null;
        }
        return module2;
    }

    @Nullable
    public static final Location<?> getLocation(@NotNull AbstractTreeNode<?> $this$location) {
        int offset2;
        int length;
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter($this$location, (String)"<this>");
        BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence($this$location);
        Bookmark bookmark2 = bookmark = bookmarkOccurrence != null ? bookmarkOccurrence.getBookmark() : null;
        if (bookmark instanceof FileBookmark && ((FileBookmark)bookmark).getFile().isDirectory()) {
            Location location2;
            VirtualFile virtualFile2 = ExtensionsKt.getAsVirtualFile($this$location);
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                location2 = PsiLocation.fromPsiElement((Project)$this$location.getProject(), (PsiElement)PsiUtilBase.findFileSystemItem($this$location.getProject(), it));
            } else {
                location2 = null;
            }
            return location2;
        }
        if (!(bookmark instanceof LineBookmark)) {
            return null;
        }
        int lineNum = ((LineBookmark)bookmark).getLine();
        VirtualFile virtualFile3 = ((LineBookmark)bookmark).getFile();
        PsiFile psiFile = PsiManager.getInstance($this$location.getProject()).findFile(virtualFile3);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance($this$location.getProject()).getDocument(psiFile2);
        if (document == null) {
            return null;
        }
        Document doc = document;
        if (lineNum <= 0 || lineNum > doc.getLineCount()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile2);
        }
        int endOffset = doc.getLineEndOffset(lineNum);
        Ref.ObjectRef elementAtLine = new Ref.ObjectRef();
        for (offset2 = doc.getLineStartOffset(lineNum); offset2 <= endOffset; offset2 += (length = ((PsiWhiteSpace)elementAtLine.element).getTextLength()) > 1 ? length - 1 : 1) {
            elementAtLine.element = psiFile2.findElementAt(offset2);
            if (!(elementAtLine.element instanceof PsiWhiteSpace)) break;
        }
        if (elementAtLine.element instanceof PsiPlainText && offset2 > 0) {
            int offsetInPlainTextFile = offset2;
            Project project2 = $this$location.getProject();
            return (Location)new PsiLocation<PsiPlainText>((Ref.ObjectRef<PsiElement>)elementAtLine, virtualFile3, offsetInPlainTextFile, project2){
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ int $offsetInPlainTextFile;
                {
                    this.$virtualFile = $virtualFile;
                    this.$offsetInPlainTextFile = $offsetInPlainTextFile;
                    super($super_call_param$1, (PsiElement)$elementAtLine.element);
                }

                @NotNull
                public OpenFileDescriptor getOpenFileDescriptor() {
                    return new OpenFileDescriptor(this.getProject(), this.$virtualFile, this.$offsetInPlainTextFile);
                }
            };
        }
        Project project3 = $this$location.getProject();
        PsiElement psiElement = (PsiElement)elementAtLine.element;
        if (psiElement == null) {
            psiElement = psiFile2;
        }
        return PsiLocation.fromPsiElement((Project)project3, (PsiElement)psiElement);
    }

    public static final void initialize(@NotNull StatusText $this$initialize, @NotNull Component owner) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$initialize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        $this$initialize.setText(BookmarkBundle.message("status.text.no.bookmarks.added", new Object[0]));
        String string3 = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFirstKeyboardShortcutText(\"ToggleBookmark\")");
        String shortcut = string3;
        if (StringsKt.isBlank((CharSequence)shortcut)) {
            string2 = BookmarkBundle.message("status.text.add.bookmark", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{shortcut};
            string2 = BookmarkBundle.message("status.text.add.bookmark.with.shortcut", objectArray);
        }
        $this$initialize.appendLine(string2);
        $this$initialize.appendLine(BookmarkBundle.message("status.text.add.bookmark.next.line", new Object[0]));
        AnAction anAction = ActionUtil.getAction((String)"BookmarksView.Create");
        if (anAction != null) {
            AnAction action2 = anAction;
            boolean bl = false;
            $this$initialize.appendLine(BookmarkBundle.message("bookmark.group.create.action.text", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> ExtensionsKt.initialize$lambda$7$lambda$6(action2, owner, arg_0));
        }
        $this$initialize.appendLine("");
        $this$initialize.appendLine(AllIcons.General.ContextHelp, BookmarkBundle.message("status.text.context.help", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ExtensionsKt::initialize$lambda$8);
    }

    private static final void initialize$lambda$7$lambda$6(AnAction $action, Component $owner, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        ActionUtil.invokeAction((AnAction)$action, (Component)$owner, (String)"BookmarksView", null, null);
    }

    private static final void initialize$lambda$8(ActionEvent it) {
        HelpManager.getInstance().invokeHelp("bookmarks.tool.window.help");
    }
}

