/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J5\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/bookmark/ui/GroupInputValidator;", "Lcom/intellij/openapi/ui/InputValidatorEx;", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "(Lcom/intellij/ide/bookmark/BookmarksManager;Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "(Lcom/intellij/ide/bookmark/BookmarksManager;)V", "groups", "", "(Lcom/intellij/ide/bookmark/BookmarksManager;Ljava/util/Collection;)V", "getGroups", "()Ljava/util/Collection;", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "findValidName", "", "name", "findValidName$intellij_platform_lang_impl", "getErrorText", "Lorg/jetbrains/annotations/Nls;", "install", "Lcom/intellij/openapi/ui/ComponentValidator;", "kotlin.jvm.PlatformType", "parent", "Lcom/intellij/openapi/Disposable;", "component", "Ljavax/swing/JComponent;", "text", "Lkotlin/Function0;", "install$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nGroupInputValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupInputValidator.kt\ncom/intellij/ide/bookmark/ui/GroupInputValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class GroupInputValidator
implements InputValidatorEx {
    @NotNull
    private final BookmarksManager manager;
    @NotNull
    private final Collection<BookmarkGroup> groups;

    public GroupInputValidator(@NotNull BookmarksManager manager, @NotNull Collection<? extends BookmarkGroup> groups2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        this.manager = manager;
        this.groups = groups2;
    }

    @NotNull
    public final BookmarksManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Collection<BookmarkGroup> getGroups() {
        return this.groups;
    }

    public GroupInputValidator(@NotNull BookmarksManager manager, @NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this(manager, CollectionsKt.listOf((Object)group2));
    }

    public GroupInputValidator(@NotNull BookmarksManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this(manager, SetsKt.emptySet());
    }

    @Override
    @Nullable
    public String getErrorText(@Nullable String name) {
        String string2;
        CharSequence charSequence = name;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string2 = "";
        } else {
            BookmarkGroup it = this.manager.getGroup(((Object)StringsKt.trim((CharSequence)name)).toString());
            boolean bl = false;
            string2 = it == null || this.groups.contains(it) ? null : BookmarkBundle.message("dialog.name.exists.error", new Object[0]);
        }
        return string2;
    }

    @NotNull
    public final String findValidName$intellij_platform_lang_impl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String initial = ((Object)StringsKt.trim((CharSequence)name)).toString();
        if (this.checkInput(initial)) {
            return initial;
        }
        for (int index2 = 1; index2 < 100; ++index2) {
            String indexed = initial + " (" + index2 + ")";
            if (!this.checkInput(indexed)) continue;
            return indexed;
        }
        return initial;
    }

    public final ComponentValidator install$intellij_platform_lang_impl(@NotNull Disposable parent2, @NotNull JComponent component2, @NotNull Function0<String> text2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        return new ComponentValidator(parent2).withValidator(() -> GroupInputValidator.install$lambda$2(this, text2, component2)).installOn(component2);
    }

    private static final ValidationInfo install$lambda$2(GroupInputValidator this$0, Function0 $text, JComponent $component) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        String string2 = this$0.getErrorText((String)$text.invoke());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = new ValidationInfo(it, $component);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }
}

