/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0012\u0010\u0014\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/BookmarkListProvider;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canDelete", "", "selection", "", "canEdit", "", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getDeleteActionText", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "node", "getEditActionText", "getProject", "getWeight", "", "performDelete", "", "parent", "Ljavax/swing/JComponent;", "performEdit", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarkListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/BookmarkListProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1726#2,3:58\n1855#2,2:61\n1855#2,2:63\n1#3:65\n*S KotlinDebug\n*F\n+ 1 BookmarkListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/BookmarkListProvider\n*L\n50#1:58,3\n51#1:61,2\n53#1:63,2\n*E\n"})
public final class BookmarkListProvider
implements BookmarksListProvider {
    @NotNull
    private final Project project;

    public BookmarkListProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public AbstractTreeNode<?> createNode() {
        return null;
    }

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor(@NotNull AbstractTreeNode<?> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object value = node2.getEqualityObject();
        return value instanceof LineBookmarkImpl ? ((LineBookmarkImpl)value).getDescriptor() : (value instanceof FileBookmarkImpl ? ((FileBookmarkImpl)value).getDescriptor() : (value instanceof LineBookmark ? new OpenFileDescriptor(this.project, ((LineBookmark)value).getFile(), ((LineBookmark)value).getLine()) : (value instanceof FileBookmark ? new OpenFileDescriptor(this.project, ((FileBookmark)value).getFile()) : null)));
    }

    @Override
    @NotNull
    public String getEditActionText() {
        String string2 = BookmarkBundle.message("bookmark.edit.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.edit.action.text\")");
        return string2;
    }

    @Override
    public boolean canEdit(@NotNull Object selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return selection instanceof BookmarkNode;
    }

    @Override
    public void performEdit(@NotNull Object selection, @NotNull JComponent parent2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            BookmarkNode bookmarkNode = selection instanceof BookmarkNode ? (BookmarkNode)selection : null;
            if (bookmarkNode == null) {
                return;
            }
            BookmarkNode node2 = bookmarkNode;
            Bookmark bookmark = (Bookmark)node2.getValue();
            if (bookmark == null) {
                return;
            }
            Bookmark bookmark2 = bookmark;
            BookmarkGroup bookmarkGroup = node2.getBookmarkGroup();
            if (bookmarkGroup == null) {
                return;
            }
            BookmarkGroup group2 = bookmarkGroup;
            String description = group2.getDescription(bookmark2);
            String string2 = Messages.showInputDialog((Component)parent2, (String)BookmarkBundle.message("action.bookmark.edit.description.dialog.message", new Object[0]), (String)BookmarkBundle.message("action.bookmark.edit.description.dialog.title", new Object[0]), null, (String)description, null);
            if (string2 == null) break block5;
            String it = string2;
            boolean bl = false;
            if (description != null) {
                group2.setDescription(bookmark2, it);
            } else {
                group2.add(bookmark2, BookmarkType.DEFAULT, it);
            }
        }
    }

    @Override
    @NotNull
    public String getDeleteActionText() {
        String string2 = BookmarkBundle.message("bookmark.delete.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"bookmark.delete.action.text\")");
        return string2;
    }

    @Override
    public boolean canDelete(@NotNull List<?> selection) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Iterable $this$all$iv = selection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it instanceof BookmarkNode) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent2) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Iterable $this$forEach$iv = selection;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.performDelete(it);
        }
    }

    private final void performDelete(Object node2) {
        block4: {
            if (node2 instanceof FileNode) {
                Iterable $this$forEach$iv = ((FileNode)node2).getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractTreeNode it = (AbstractTreeNode)element$iv;
                    boolean bl = false;
                    this.performDelete(it);
                }
            }
            if (!(node2 instanceof BookmarkNode)) break block4;
            Bookmark bookmark = (Bookmark)((BookmarkNode)node2).getValue();
            if (bookmark != null) {
                Bookmark it = bookmark;
                boolean bl = false;
                BookmarkGroup bookmarkGroup = ((BookmarkNode)node2).getBookmarkGroup();
                if (bookmarkGroup != null) {
                    bookmarkGroup.remove(it);
                }
            }
        }
    }
}

