/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.RootNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.presentation.FilePresentationService;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010!\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000f\b\u0002\u0010\"\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\b\b\u0002\u0010#\u001a\u00020$H\u0004J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010#\u001a\u00020$H\u0004J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0012\u0010*\u001a\u00020(2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u000f\u0010-\u001a\t\u0018\u00010.\u00a2\u0006\u0002\b\u0016H\u0014J\u0011\u0010/\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0096\u0002J\u0017\u00100\u001a\t\u0018\u00010.\u00a2\u0006\u0002\b\u00162\u0006\u00101\u001a\u00020$H\u0016J\u0017\u00102\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020(H\u0016J\u0010\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000107H\u0004R\u0018\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00069"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "B", "Lcom/intellij/ide/bookmark/Bookmark;", "Lcom/intellij/ui/BackgroundSupplier;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/Bookmark;)V", "bookmarkDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "getBookmarkDescription", "()Ljava/lang/String;", "bookmarkGroup", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "getBookmarkGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "setBookmarkGroup", "(Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "bookmarkType", "Lcom/intellij/ide/bookmark/BookmarkType;", "Lorg/jetbrains/annotations/Nullable;", "getBookmarkType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "bookmarksView", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBookmarksView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "addTextTo", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "name", "location", "line", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canNavigate", "", "canNavigateToSource", "canRepresent", "element", "", "computeBackgroundColor", "Ljava/awt/Color;", "contains", "getElementBackground", "row", "getRelativePath", "navigate", "requestFocus", "update", "wrapIcon", "Ljavax/swing/Icon;", "icon", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nBookmarkNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkNode.kt\ncom/intellij/ide/bookmark/ui/tree/BookmarkNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public abstract class BookmarkNode<B extends Bookmark>
extends ProjectViewNode<B>
implements BackgroundSupplier {
    @Nullable
    private BookmarkGroup bookmarkGroup;

    public BookmarkNode(@NotNull Project project2, @NotNull B bookmark) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(bookmark, (String)"bookmark");
        super(project2, bookmark, ProjectViewSettings.Immutable.DEFAULT);
    }

    @Nullable
    public final BookmarksView getBookmarksView() {
        RootNode rootNode = ExtensionsKt.getParentRootNode(this);
        return rootNode != null ? (BookmarksView)rootNode.getValue() : null;
    }

    private final BookmarkType getBookmarkType() {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(this);
        return bookmarksManager != null ? bookmarksManager.getType((Bookmark)this.getValue()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getBookmarkDescription() {
        CharSequence charSequence;
        BookmarkGroup bookmarkGroup = this.bookmarkGroup;
        Object object = bookmarkGroup;
        if (bookmarkGroup == null) return null;
        Object object2 = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value");
        String string2 = object.getDescription((Bookmark)object2);
        object = string2;
        if (string2 == null) return null;
        CharSequence charSequence2 = (CharSequence)object;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String string3 = (String)charSequence;
        return string3;
    }

    @Nullable
    public final BookmarkGroup getBookmarkGroup() {
        return this.bookmarkGroup;
    }

    public final void setBookmarkGroup(@Nullable BookmarkGroup bookmarkGroup) {
        this.bookmarkGroup = bookmarkGroup;
    }

    public boolean canRepresent(@Nullable Object element) {
        VirtualFile virtualFile2 = this.getVirtualFile();
        return virtualFile2 != null ? virtualFile2.equals(element) : false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            bl = VfsUtil.isAncestor(it, file2, true);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canNavigate() {
        return ((Bookmark)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Bookmark)this.getValue()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        ((Bookmark)this.getValue()).navigate(requestFocus);
    }

    @Override
    @Nullable
    protected Color computeBackgroundColor() {
        return FilePresentationService.getFileBackgroundColor((Project)this.getProject(), (VirtualFile)this.getVirtualFile());
    }

    @Override
    @Nullable
    public Color getElementBackground(int row) {
        return this.getPresentation().getBackground();
    }

    @NotNull
    protected final Icon wrapIcon(@Nullable Icon icon2) {
        Icon icon3;
        BookmarkType bookmarkType = this.getBookmarkType();
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        BookmarkType type = bookmarkType;
        if (icon2 == null) {
            icon3 = type.getIcon();
        } else if (type == BookmarkType.DEFAULT) {
            icon3 = icon2;
        } else {
            Icon[] iconArray = new Icon[]{type.getIcon(), icon2};
            RowIcon rowIcon = IconManager.getInstance().createRowIcon(iconArray);
            Intrinsics.checkNotNullExpressionValue((Object)rowIcon, (String)"getInstance().createRowIcon(type.icon, icon)");
            icon3 = rowIcon;
        }
        return icon3;
    }

    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        presentation2.setIcon(this.wrapIcon(ExtensionsKt.findFileIcon(this)));
        BookmarkNode.addTextTo$default(this, presentation2, file2, 0, 4, null);
    }

    protected final void addTextTo(@NotNull PresentationData presentation2, @NotNull VirtualFile file2, int line) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string3 = file2.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.presentableName");
        String name = string3;
        VirtualFile virtualFile2 = file2.getParent();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            string2 = this.getRelativePath(it);
        } else {
            string2 = null;
        }
        String location2 = string2;
        this.addTextTo(presentation2, name, location2, line);
    }

    public static /* synthetic */ void addTextTo$default(BookmarkNode bookmarkNode, PresentationData presentationData, VirtualFile virtualFile2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTextTo");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        bookmarkNode.addTextTo(presentationData, virtualFile2, n);
    }

    protected final void addTextTo(@NotNull PresentationData presentation2, @NotNull String name, @Nullable String location2, int line) {
        block3: {
            String description;
            block2: {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                description = this.getBookmarkDescription();
                if (description != null) break block2;
                presentation2.setPresentableText(name);
                presentation2.addText(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (line > 0) {
                    presentation2.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                String string2 = location2;
                if (string2 == null) break block3;
                String it = string2;
                boolean bl = false;
                presentation2.addText("  " + it, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                break block3;
            }
            presentation2.setPresentableText(description + " " + name);
            presentation2.addText(description + "  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation2.addText(name, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            if (line > 0) {
                presentation2.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            String string3 = location2;
            if (string3 == null) break block3;
            String it = string3;
            boolean bl = false;
            presentation2.addText("  (" + it + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public static /* synthetic */ void addTextTo$default(BookmarkNode bookmarkNode, PresentationData presentationData, String string2, String string3, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTextTo");
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        bookmarkNode.addTextTo(presentationData, string2, string3, n);
    }

    private final String getRelativePath(VirtualFile file2) {
        VirtualFile parent2;
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        if (project3.isDisposed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project3);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project)");
        ProjectFileIndex index2 = projectFileIndex;
        if (index2.getModuleForFile(file2, false) == null) {
            return ExtensionsKt.computeExternalLocation(this, file2);
        }
        VirtualFile root = file2;
        while (root.getParent() != null && index2.getModuleForFile(parent2, false) != null) {
            root = parent2;
        }
        return Intrinsics.areEqual((Object)file2, (Object)root) ? null : VfsUtil.getRelativePath(file2, root);
    }
}

