/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.tree.ExternalFolderNode;
import com.intellij.ide.bookmark.ui.tree.FolderNode;
import com.intellij.ide.bookmark.ui.tree.RootNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchTreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0013*\u0006\u0012\u0002\b\u00030\u0014\u001a\u001f\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a-\u0010\u001a\u001a\u0017\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0017\u0010\u001d\u001a\t\u0018\u00010\u001c\u00a2\u0006\u0002\b\u0007*\u0006\u0012\u0002\b\u00030\u0014H\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"#\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"asAbstractTreeNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "getAsAbstractTreeNode", "(Ljava/lang/Object;)Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "bookmarksManager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "Lorg/jetbrains/annotations/Nullable;", "getBookmarksManager", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/BookmarksManager;", "parentFolderNode", "Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "getParentFolderNode", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "parentRootNode", "Lcom/intellij/ide/bookmark/ui/tree/RootNode;", "getParentRootNode", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/ui/tree/RootNode;", "computeDirectoryChildren", "", "Lcom/intellij/ide/projectView/ProjectViewNode;", "computeExternalLocation", "", "Lcom/intellij/openapi/util/NlsSafe;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeScratchPresentation", "Lkotlin/Pair;", "Ljavax/swing/Icon;", "findFileIcon", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/tree/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n1#2:90\n13579#3,2:91\n*S KotlinDebug\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/tree/ExtensionsKt\n*L\n62#1:91,2\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final AbstractTreeNode<?> getAsAbstractTreeNode(@NotNull Object $this$asAbstractTreeNode) {
        Intrinsics.checkNotNullParameter((Object)$this$asAbstractTreeNode, (String)"<this>");
        return $this$asAbstractTreeNode instanceof AbstractTreeNode ? (AbstractTreeNode)$this$asAbstractTreeNode : null;
    }

    @Nullable
    public static final BookmarksManager getBookmarksManager(@NotNull AbstractTreeNode<?> $this$bookmarksManager) {
        Intrinsics.checkNotNullParameter($this$bookmarksManager, (String)"<this>");
        return BookmarksManager.getInstance($this$bookmarksManager.getProject());
    }

    @Nullable
    public static final RootNode getParentRootNode(@NotNull AbstractTreeNode<?> $this$parentRootNode) {
        Intrinsics.checkNotNullParameter($this$parentRootNode, (String)"<this>");
        RootNode rootNode = $this$parentRootNode instanceof RootNode ? (RootNode)$this$parentRootNode : null;
        if (rootNode == null) {
            AbstractTreeNode abstractTreeNode = $this$parentRootNode.getParent();
            rootNode = abstractTreeNode != null ? ExtensionsKt.getParentRootNode(abstractTreeNode) : null;
        }
        return rootNode;
    }

    @Nullable
    public static final FolderNode getParentFolderNode(@NotNull AbstractTreeNode<?> $this$parentFolderNode) {
        Intrinsics.checkNotNullParameter($this$parentFolderNode, (String)"<this>");
        FolderNode folderNode = $this$parentFolderNode instanceof FolderNode ? (FolderNode)$this$parentFolderNode : null;
        if (folderNode == null) {
            AbstractTreeNode abstractTreeNode = $this$parentFolderNode.getParent();
            folderNode = abstractTreeNode != null ? ExtensionsKt.getParentFolderNode(abstractTreeNode) : null;
        }
        return folderNode;
    }

    @Nullable
    public static final Icon findFileIcon(@NotNull ProjectViewNode<?> $this$findFileIcon) {
        Intrinsics.checkNotNullParameter($this$findFileIcon, (String)"<this>");
        return CompoundIconProvider.findIcon(PsiUtilCore.findFileSystemItem($this$findFileIcon.getProject(), $this$findFileIcon.getVirtualFile()), 0);
    }

    @Nullable
    public static final String computeExternalLocation(@NotNull ProjectViewNode<?> $this$computeExternalLocation, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter($this$computeExternalLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = ExtensionsKt.computeScratchPresentation($this$computeExternalLocation, file2);
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
        }
        return object;
    }

    @Nullable
    public static final Pair<String, Icon> computeScratchPresentation(@NotNull ProjectViewNode<?> $this$computeScratchPresentation, @NotNull VirtualFile file2) {
        Pair pair;
        Intrinsics.checkNotNullParameter($this$computeScratchPresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        RootType rootType = ScratchFileService.findRootType(file2);
        if (rootType == null) {
            return null;
        }
        RootType type = rootType;
        VirtualFile virtualFile2 = ScratchTreeStructureProvider.getVirtualFile(type);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile root = virtualFile2;
        VirtualFile virtualFile3 = root;
        if (Intrinsics.areEqual((Object)virtualFile3, (Object)file2)) {
            String string2 = type.getDisplayName();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)AllIcons.Nodes.Folder);
            } else {
                pair = null;
            }
        } else if (Intrinsics.areEqual((Object)virtualFile3, (Object)file2.getParent())) {
            String string3 = type.substituteName($this$computeScratchPresentation.getProject(), file2);
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)type.substituteIcon($this$computeScratchPresentation.getProject(), file2));
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public static final Collection<AbstractTreeNode<?>> computeDirectoryChildren(@NotNull ProjectViewNode<?> $this$computeDirectoryChildren) {
        List list2;
        Intrinsics.checkNotNullParameter($this$computeDirectoryChildren, (String)"<this>");
        PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem($this$computeDirectoryChildren.getProject(), $this$computeDirectoryChildren.getVirtualFile());
        PsiDirectory psiDirectory = psiFileSystemItem instanceof PsiDirectory ? (PsiDirectory)psiFileSystemItem : null;
        if (psiDirectory == null) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory directory = psiDirectory;
        if (ProjectFileIndex.getInstance(directory.getProject()).getModuleForFile(directory.getVirtualFile(), false) != null) {
            Collection<AbstractTreeNode<?>> collection = ProjectViewDirectoryHelper.getInstance(directory.getProject()).getDirectoryChildren(directory, $this$computeDirectoryChildren.getSettings(), true);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getInstance(directory.pr\u2026irectory, settings, true)");
            return collection;
        }
        VirtualFile[] virtualFileArray = directory.getVirtualFile().getChildren();
        if (virtualFileArray == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] children2 = virtualFileArray;
        RootType type = RootType.forFile(directory.getVirtualFile());
        List $this$computeDirectoryChildren_u24lambda_u243 = list2 = (List)new ArrayList();
        boolean bl = false;
        VirtualFile[] $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile element$iv;
            VirtualFile it = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            if (type != null && type.isIgnored(directory.getProject(), directory.getVirtualFile())) continue;
            PsiFileSystemItem item = PsiUtilCore.findFileSystemItem(directory.getProject(), it);
            if (item instanceof PsiDirectory) {
                $this$computeDirectoryChildren_u24lambda_u243.add(new ExternalFolderNode((PsiDirectory)item, $this$computeDirectoryChildren.getSettings()));
                continue;
            }
            if (!(item instanceof PsiFile)) continue;
            $this$computeDirectoryChildren_u24lambda_u243.add(new PsiFileNode(((PsiFile)item).getProject(), (PsiFile)item, $this$computeDirectoryChildren.getSettings()));
        }
        return list2;
    }
}

