/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/ide/bookmark/FileBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/FileBookmark;)V", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class FolderNode
extends BookmarkNode<FileBookmark> {
    public FolderNode(@NotNull Project project2, @NotNull FileBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project2, (Bookmark)bookmark);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        FileBookmark fileBookmark = (FileBookmark)this.getValue();
        return fileBookmark != null ? fileBookmark.getFile() : null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return ExtensionsKt.computeDirectoryChildren(this);
    }

    @Override
    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        Pair<String, Icon> scratch = ExtensionsKt.computeScratchPresentation(this, file2);
        if (scratch == null) {
            super.update(presentation2);
        } else {
            Icon icon2 = (Icon)scratch.getSecond();
            if (icon2 == null) {
                icon2 = ExtensionsKt.findFileIcon(this);
            }
            presentation2.setIcon(this.wrapIcon(icon2));
            BookmarkNode.addTextTo$default(this, presentation2, (String)scratch.getFirst(), null, 0, 12, null);
        }
    }
}

