/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "Lcom/intellij/ui/tree/project/ProjectFileNodeUpdater;", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "(Lcom/intellij/ide/bookmark/ui/BookmarksView;)V", "getView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "forEachTreePath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Ljavax/swing/tree/TreePath;", "invalidate", "structure", "", "updateStructure", "fromRoot", "updatedFiles", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFolderNodeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FolderNodeUpdater.kt\ncom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1611#2:51\n1855#2:52\n1856#2:54\n1612#2:55\n1855#2,2:56\n1#3:53\n*S KotlinDebug\n*F\n+ 1 FolderNodeUpdater.kt\ncom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater\n*L\n20#1:51\n20#1:52\n20#1:54\n20#1:55\n37#1:56,2\n20#1:53\n*E\n"})
public final class FolderNodeUpdater
extends ProjectFileNodeUpdater {
    @NotNull
    private final BookmarksView view;

    public FolderNodeUpdater(@NotNull BookmarksView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view.getProject(), view.getModel().getInvoker());
        this.view = view;
    }

    @NotNull
    public final BookmarksView getView() {
        return this.view;
    }

    protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
        Intrinsics.checkNotNullParameter(updatedFiles, (String)"updatedFiles");
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.view.getProject());
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Set bookmarkedFiles = new LinkedHashSet();
        List<Bookmark> list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.bookmarks");
        Iterable $this$mapNotNullTo$iv = list2;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv;
            Object t;
            Object element$iv = t = iterator2.next();
            boolean bl = false;
            Bookmark it = (Bookmark)element$iv;
            boolean bl2 = false;
            if ((it instanceof FileBookmark && ((FileBookmark)it).getFile().isValid() ? ((FileBookmark)it).getFile() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            ((Collection)bookmarkedFiles).add(it$iv);
        }
        if (bookmarkedFiles.isEmpty()) {
            return;
        }
        Set roots2 = new LinkedHashSet();
        for (VirtualFile bookmarkedFile : bookmarkedFiles) {
            TreeCollector collector2;
            if (fromRoot || updatedFiles.contains(bookmarkedFile)) {
                roots2.add(bookmarkedFile);
                continue;
            }
            if (!bookmarkedFile.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)TreeCollector.VirtualFileRoots.create(), (String)"create()");
            for (VirtualFile virtualFile2 : updatedFiles) {
                VirtualFile root;
                VirtualFile virtualFile3;
                if (virtualFile2.isDirectory()) {
                    virtualFile3 = virtualFile2;
                } else {
                    virtualFile3 = virtualFile2.getParent();
                    if (virtualFile3 == null) continue;
                }
                if (!VfsUtilCore.isAncestor(bookmarkedFile, root = virtualFile3, false)) continue;
                collector2.add((Object)virtualFile2);
            }
            List list3 = collector2.get();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"collector.get()");
            roots2.addAll(list3);
        }
        Iterable $this$forEach$iv = roots2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile virtualFile4 = (VirtualFile)element$iv;
            boolean bl = false;
            this.invalidate(virtualFile4, true);
        }
    }

    public final void invalidate(@NotNull VirtualFile file2, boolean structure) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.forEachTreePath(file2, (Function1<? super TreePath, Unit>)((Function1)new Function1<TreePath, Unit>(this, structure){
            final /* synthetic */ FolderNodeUpdater this$0;
            final /* synthetic */ boolean $structure;
            {
                this.this$0 = $receiver;
                this.$structure = $structure;
                super(1);
            }

            public final void invoke(@NotNull TreePath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getView().getModel().invalidate(it, this.$structure);
            }
        }));
    }

    private final void forEachTreePath(VirtualFile file2, Function1<? super TreePath, Unit> action2) {
        TreeModel treeModel = this.view.getTree().getModel();
        AsyncTreeModel asyncTreeModel = treeModel instanceof AsyncTreeModel ? (AsyncTreeModel)treeModel : null;
        if (asyncTreeModel == null) {
            return;
        }
        AsyncTreeModel model2 = asyncTreeModel;
        List paths2 = new ArrayList();
        model2.accept((TreeVisitor)new VirtualFileVisitor(file2, paths2), false).onSuccess(arg_0 -> FolderNodeUpdater.forEachTreePath$lambda$2((Function1)new Function1<TreePath, Unit>((List<TreePath>)paths2, action2){
            final /* synthetic */ List<TreePath> $paths;
            final /* synthetic */ Function1<TreePath, Unit> $action;
            {
                this.$paths = $paths;
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(TreePath it) {
                void $this$forEach$iv;
                Iterable iterable = this.$paths;
                Function1<TreePath, Unit> action$iv = this.$action;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    action$iv.invoke(element$iv);
                }
            }
        }, arg_0));
    }

    private static final void forEachTreePath$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

